/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtilKmpKt;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J&\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\r\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J0\u0010\u0010\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u000bH\u0007J&\u0010\u0016\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007J\u001c\u0010\u001a\u001a\u00020\u000b*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001c\u0010\u001a\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010\u001a\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001c\u0010\u001e\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001c\u0010\u001f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010 \u001a\u00020\t*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0007H\u0007J\u001c\u0010 \u001a\u00020\t*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0007H\u0007J$\u0010 \u001a\u00020\t*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0007H\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/util/text/CharArrayUtilKmp;", "", "<init>", "()V", "fromSequenceWithoutCopying", "", "seq", "", "containLineBreaks", "", "fromOffset", "", "endOffset", "fromSequence", "start", "end", "getChars", "", "dst", "srcOffset", "dstOffset", "len", "shiftForward", "chars", "", "startOffset", "shiftBackward", "offset", "minOffset", "maxOffset", "shiftForwardUntil", "shiftBackwardUntil", "regionMatches", "s", "intellij.platform.util.base.multiplatform"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCharArrayUtilKmp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharArrayUtilKmp.kt\ncom/intellij/util/text/CharArrayUtilKmp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1761#2,3:269\n1740#2,3:272\n1740#2,3:275\n*S KotlinDebug\n*F\n+ 1 CharArrayUtilKmp.kt\ncom/intellij/util/text/CharArrayUtilKmp\n*L\n28#1:269,3\n244#1:272,3\n251#1:275,3\n*E\n"})
public final class CharArrayUtilKmp {
    @NotNull
    public static final CharArrayUtilKmp INSTANCE = new CharArrayUtilKmp();

    private CharArrayUtilKmp() {
    }

    @JvmStatic
    @Nullable
    public static final char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        return CharArrayUtilKmpKt.fromSequenceWithoutCopyingPlatformSpecific(seq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        boolean bl;
        if (seq == null) return false;
        Iterable $this$any$iv = RangesKt.until(fromOffset, endOffset);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return false;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            char c = seq.charAt(i);
            if (c == '\n') return true;
            if (c == '\r') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static /* synthetic */ boolean containLineBreaks$default(CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            CharSequence charSequence2 = charSequence;
            n2 = charSequence2 != null ? charSequence2.length() : 0;
        }
        return CharArrayUtilKmp.containLineBreaks(charSequence, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final char[] fromSequence(@NotNull CharSequence seq) {
        char[] cArray;
        block3: {
            block2: {
                char[] underlying;
                Intrinsics.checkNotNullParameter(seq, "seq");
                cArray = underlying = CharArrayUtilKmp.fromSequenceWithoutCopying(seq);
                if (underlying == null) break block2;
                char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
                Intrinsics.checkNotNullExpressionValue(cArray2, "copyOf(...)");
                cArray = cArray2;
                if (cArray2 != null) break block3;
            }
            cArray = CharArrayUtilKmp.fromSequence(seq, 0, seq.length());
        }
        return cArray;
    }

    @JvmStatic
    @NotNull
    public static final char[] fromSequence(@NotNull CharSequence $this$fromSequence, int start, int end) {
        Intrinsics.checkNotNullParameter($this$fromSequence, "<this>");
        char[] result = new char[end - start];
        CharArrayUtilKmp.getChars($this$fromSequence, result, start, 0, end - start);
        return result;
    }

    @JvmStatic
    @JvmOverloads
    public static final void getChars(@NotNull CharSequence $this$getChars, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        Intrinsics.checkNotNullParameter($this$getChars, "<this>");
        Intrinsics.checkNotNullParameter(dst, "dst");
        if ($this$getChars instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)$this$getChars).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if ($this$getChars instanceof String) {
                String string = (String)$this$getChars;
                int n = srcOffset + len;
                string.getChars(srcOffset, n, dst, dstOffset);
                return;
            }
            if ($this$getChars instanceof CharSequenceBackedByArray) {
                CharSequence charSequence = $this$getChars.subSequence(srcOffset, srcOffset + len);
                Intrinsics.checkNotNull(charSequence, "null cannot be cast to non-null type com.intellij.util.text.CharSequenceBackedByArray");
                ((CharSequenceBackedByArray)charSequence).getChars(dst, dstOffset);
                return;
            }
            if ($this$getChars instanceof StringBuilder) {
                StringBuilder stringBuilder = (StringBuilder)$this$getChars;
                int n = srcOffset + len;
                stringBuilder.getChars(srcOffset, n, dst, dstOffset);
                return;
            }
            if (CharArrayUtilKmpKt.getCharsPlatformSpecific($this$getChars, srcOffset, dst, dstOffset, len)) {
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = $this$getChars.charAt(j);
        }
    }

    public static /* synthetic */ void getChars$default(CharSequence charSequence, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = charSequence.length() - n;
        }
        CharArrayUtilKmp.getChars(charSequence, cArray, n, n2, n3);
    }

    @JvmStatic
    @JvmOverloads
    public static final int shiftForward(@NotNull CharSequence $this$shiftForward, @NotNull String chars, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter($this$shiftForward, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        int limit = Math.min(endOffset, $this$shiftForward.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = $this$shiftForward.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static /* synthetic */ int shiftForward$default(CharSequence charSequence, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharArrayUtilKmp.shiftForward(charSequence, string, n, n2);
    }

    @JvmStatic
    public static final int shiftBackward(@NotNull char[] $this$shiftBackward, int offset, @NotNull String chars) {
        Intrinsics.checkNotNullParameter($this$shiftBackward, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        return CharArrayUtilKmp.shiftBackward(new CharArrayCharSequence(Arrays.copyOf($this$shiftBackward, $this$shiftBackward.length)), offset, chars);
    }

    @JvmStatic
    public static final int shiftBackward(@NotNull CharSequence $this$shiftBackward, int offset, @NotNull String chars) {
        Intrinsics.checkNotNullParameter($this$shiftBackward, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        return CharArrayUtilKmp.shiftBackward($this$shiftBackward, 0, offset, chars);
    }

    @JvmStatic
    public static final int shiftBackward(@NotNull CharSequence $this$shiftBackward, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        Intrinsics.checkNotNullParameter($this$shiftBackward, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        if (maxOffset >= $this$shiftBackward.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = $this$shiftBackward.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    @JvmStatic
    public static final int shiftForwardUntil(@NotNull CharSequence $this$shiftForwardUntil, int offset, @NotNull String chars) {
        int offset2;
        Intrinsics.checkNotNullParameter($this$shiftForwardUntil, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        for (offset2 = offset; offset2 < $this$shiftForwardUntil.length(); ++offset2) {
            int i;
            char c = $this$shiftForwardUntil.charAt(offset2);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
        }
        return offset2;
    }

    @JvmStatic
    public static final int shiftBackwardUntil(@NotNull CharSequence $this$shiftBackwardUntil, int offset, @NotNull String chars) {
        int offset2;
        Intrinsics.checkNotNullParameter($this$shiftBackwardUntil, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        if (offset2 >= $this$shiftBackwardUntil.length()) {
            return offset2;
        }
        for (offset2 = offset; offset2 >= 0; --offset2) {
            int i;
            char c = $this$shiftBackwardUntil.charAt(offset2);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
        }
        return offset2;
    }

    @JvmStatic
    public static final boolean regionMatches(@NotNull char[] $this$regionMatches, int start, int end, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter($this$regionMatches, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        int len = s.length();
        if (start + len > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if ($this$regionMatches[start + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean regionMatches(@NotNull CharSequence $this$regionMatches, int offset, @NotNull CharSequence s) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$regionMatches, "<this>");
            Intrinsics.checkNotNullParameter(s, "s");
            if (offset < 0 || offset + s.length() > $this$regionMatches.length()) {
                return false;
            }
            Iterable $this$all$iv = RangesKt.until(0, s.length());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if ($this$regionMatches.charAt(offset + i) == s.charAt(i)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final boolean regionMatches(@NotNull CharSequence $this$regionMatches, int start, int end, @NotNull CharSequence s) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$regionMatches, "<this>");
            Intrinsics.checkNotNullParameter(s, "s");
            int len = s.length();
            if (start < 0 || start + len > end) {
                return false;
            }
            Iterable $this$all$iv = RangesKt.until(0, len);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if ($this$regionMatches.charAt(start + i) == s.charAt(i)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset) {
        return CharArrayUtilKmp.containLineBreaks$default(seq, fromOffset, 0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean containLineBreaks(@Nullable CharSequence seq) {
        return CharArrayUtilKmp.containLineBreaks$default(seq, 0, 0, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getChars(@NotNull CharSequence $this$getChars, @NotNull char[] dst, int srcOffset, int dstOffset) {
        Intrinsics.checkNotNullParameter($this$getChars, "<this>");
        Intrinsics.checkNotNullParameter(dst, "dst");
        CharArrayUtilKmp.getChars$default($this$getChars, dst, srcOffset, dstOffset, 0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getChars(@NotNull CharSequence $this$getChars, @NotNull char[] dst, int dstOffset) {
        Intrinsics.checkNotNullParameter($this$getChars, "<this>");
        Intrinsics.checkNotNullParameter(dst, "dst");
        CharArrayUtilKmp.getChars$default($this$getChars, dst, 0, dstOffset, 0, 10, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int shiftForward(@NotNull CharSequence $this$shiftForward, @NotNull String chars, int startOffset) {
        Intrinsics.checkNotNullParameter($this$shiftForward, "<this>");
        Intrinsics.checkNotNullParameter(chars, "chars");
        return CharArrayUtilKmp.shiftForward$default($this$shiftForward, chars, startOffset, 0, 4, null);
    }
}

