/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ModalityUiUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import git4idea.GitActivity;
import git4idea.GitBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.merge.MergeChangeCollector;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateSessionKt;
import git4idea.update.GitUpdatedRanges;
import git4idea.update.HashRange;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitMergeAction
extends GitRepositoryAction {
    GitMergeAction() {
    }

    @Nullable
    protected abstract DialogState displayDialog(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    protected abstract String getNotificationErrorDisplayId();

    @Override
    protected final void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        DialogState dialogState;
        if (project == null) {
            GitMergeAction.$$$reportNull$$$0(0);
        }
        if (gitRoots == null) {
            GitMergeAction.$$$reportNull$$$0(1);
        }
        if (defaultRoot == null) {
            GitMergeAction.$$$reportNull$$$0(2);
        }
        if ((dialogState = this.displayDialog(project, gitRoots, defaultRoot)) == null) {
            return;
        }
        this.perform(dialogState, project);
    }

    protected void perform(final @NotNull DialogState dialogState, final @NotNull Project project) {
        if (dialogState == null) {
            GitMergeAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GitMergeAction.$$$reportNull$$$0(4);
        }
        final VirtualFile selectedRoot = dialogState.selectedRoot;
        final Supplier<GitLineHandler> handlerProvider = dialogState.handlerProvider;
        final Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, GitBundle.message("merge.action.before.update.label", new Object[0]));
        final GitBranch selectedBranch = dialogState.selectedBranch;
        new Task.Backgroundable(project, dialogState.progressTitle, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                Git git = Git.getInstance();
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(selectedRoot, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(selectedRoot);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitRepository repository2 = (GitRepository)repositoryManager.getRepositoryForRoot(selectedRoot);
                assert (repository2 != null) : "Repository can't be null for root " + String.valueOf(selectedRoot);
                GitUpdatedRanges updatedRanges = null;
                if (repository2.getCurrentBranch() != null) {
                    GitBranchPair refPair = new GitBranchPair(repository2.getCurrentBranch(), selectedBranch);
                    updatedRanges = GitUpdatedRanges.calcInitialPositions(project, Collections.singletonMap(repository2, refPair));
                }
                String beforeRevision = repository2.getCurrentRevision();
                boolean setupRebaseEditor = GitMergeAction.this.shouldSetupRebaseEditor(project, selectedRoot);
                Ref rebaseEditorManager = Ref.create();
                try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.merge", new Object[0]), (ActivityId)GitActivity.Merge);){
                    GitCommandResult result2 = git.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> 1.lambda$run$0((Supplier)handlerProvider, setupRebaseEditor, rebaseEditorManager, project, selectedRoot, localChangesDetector, untrackedFilesDetector, mergeConflict)));
                    if (beforeRevision != null) {
                        GitRevisionNumber currentRev = new GitRevisionNumber(beforeRevision);
                        GitMergeAction.this.handleResult(result2, project, mergeConflict, localChangesDetector, untrackedFilesDetector, repository2, currentRev, beforeLabel, updatedRanges, dialogState.commitAfterMerge);
                    }
                }
                finally {
                    if (!rebaseEditorManager.isNull()) {
                        ((GitHandlerRebaseEditorManager)rebaseEditorManager.get()).close();
                    }
                }
            }

            private static /* synthetic */ GitLineHandler lambda$run$0(Supplier handlerProvider2, boolean setupRebaseEditor, Ref rebaseEditorManager, Project project2, VirtualFile selectedRoot2, GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, GitSimpleEventDetector mergeConflict) {
                GitLineHandler handler = (GitLineHandler)handlerProvider2.get();
                if (setupRebaseEditor) {
                    if (!rebaseEditorManager.isNull()) {
                        ((GitHandlerRebaseEditorManager)rebaseEditorManager.get()).close();
                    }
                    GitInteractiveRebaseEditorHandler editor2 = new GitInteractiveRebaseEditorHandler(project2, selectedRoot2);
                    rebaseEditorManager.set((Object)GitHandlerRebaseEditorManager.prepareEditor(handler, editor2));
                    handler.addConfigParameters(GitImpl.REBASE_CONFIG_PARAMS);
                }
                handler.addLineListener(localChangesDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(mergeConflict);
                return handler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitMergeAction$1", "run"));
            }
        }.queue();
    }

    protected boolean shouldSetupRebaseEditor(@NotNull Project project, VirtualFile selectedRoot) {
        if (project == null) {
            GitMergeAction.$$$reportNull$$$0(5);
        }
        return false;
    }

    private void handleResult(@NotNull GitCommandResult result2, final @NotNull Project project, @NotNull GitSimpleEventDetector mergeConflictDetector, @NotNull GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, @NotNull GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, @NotNull GitRepository repository2, @NotNull GitRevisionNumber currentRev, @NotNull Label beforeLabel, @Nullable GitUpdatedRanges updatedRanges, final boolean commitAfterMerge) {
        if (result2 == null) {
            GitMergeAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GitMergeAction.$$$reportNull$$$0(7);
        }
        if (mergeConflictDetector == null) {
            GitMergeAction.$$$reportNull$$$0(8);
        }
        if (localChangesDetector == null) {
            GitMergeAction.$$$reportNull$$$0(9);
        }
        if (untrackedFilesDetector == null) {
            GitMergeAction.$$$reportNull$$$0(10);
        }
        if (repository2 == null) {
            GitMergeAction.$$$reportNull$$$0(11);
        }
        if (currentRev == null) {
            GitMergeAction.$$$reportNull$$$0(12);
        }
        if (beforeLabel == null) {
            GitMergeAction.$$$reportNull$$$0(13);
        }
        final VirtualFile root = repository2.getRoot();
        if (mergeConflictDetector.isDetected()) {
            new GitConflictResolver(this, project, Collections.singletonList(root), new GitConflictResolver.Params(project)){

                @Override
                protected boolean proceedAfterAllMerged() throws VcsException {
                    if (commitAfterMerge) {
                        new GitMerger(project).mergeCommit(root);
                    }
                    return true;
                }
            }.merge();
        }
        if (result2.success() || mergeConflictDetector.isDetected()) {
            GitUtil.refreshVfsInRoot(root);
            repository2.update();
            if (updatedRanges != null && AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(project))) && commitAfterMerge) {
                Notification notification;
                Map<GitRepository, HashRange> ranges = updatedRanges.calcCurrentPositions();
                GitUpdateInfoAsLog.NotificationData notificationData = new GitUpdateInfoAsLog(project, ranges).calculateDataAndCreateLogTab();
                if (notificationData != null) {
                    String title = GitUpdateSessionKt.getTitleForUpdateNotification(notificationData.getUpdatedFilesCount(), notificationData.getReceivedCommitsCount());
                    String content = GitUpdateSessionKt.getBodyForUpdateNotification(notificationData.getFilteredCommitsCount());
                    notification = VcsNotifier.standardNotification().createNotification(title, content, NotificationType.INFORMATION).setDisplayId("git.files.updated.after.merge").addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("action.NotificationAction.GitMergeAction.text.view.commits", new Object[0]), (Runnable)notificationData.getViewCommitAction()));
                } else {
                    notification = VcsNotifier.standardNotification().createNotification(VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]), NotificationType.INFORMATION).setDisplayId("git.all.files.are.up.to.date");
                }
                VcsNotifier.getInstance((Project)project).notify(notification);
            } else {
                GitMergeAction.showUpdates(project, repository2, currentRev, beforeLabel, this.getActionName());
            }
        } else if (localChangesDetector.isDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, "git.merge.local.changes.detected", repository2.getRoot(), this.getActionName(), localChangesDetector.getRelativeFilePaths());
        } else if (untrackedFilesDetector.isDetected()) {
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, untrackedFilesDetector.getRelativeFilePaths(), this.getActionName(), null);
        } else {
            VcsNotifier.getInstance((Project)project).notifyError(this.getNotificationErrorDisplayId(), GitBundle.message("merge.action.operation.failed", this.getActionName()), result2.getErrorOutputAsHtmlString());
            repository2.update();
        }
    }

    private static void showUpdates(@NotNull Project project, @NotNull GitRepository repository2, @NotNull GitRevisionNumber currentRev, @NotNull Label beforeLabel, @NlsActions.ActionText @NotNull String actionName) {
        if (project == null) {
            GitMergeAction.$$$reportNull$$$0(14);
        }
        if (repository2 == null) {
            GitMergeAction.$$$reportNull$$$0(15);
        }
        if (currentRev == null) {
            GitMergeAction.$$$reportNull$$$0(16);
        }
        if (beforeLabel == null) {
            GitMergeAction.$$$reportNull$$$0(17);
        }
        if (actionName == null) {
            GitMergeAction.$$$reportNull$$$0(18);
        }
        try {
            UpdatedFiles files = UpdatedFiles.create();
            MergeChangeCollector collector = new MergeChangeCollector(project, repository2, currentRev);
            collector.collect(files);
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                ProjectLevelVcsManagerEx manager2 = (ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)project);
                UpdateInfoTree tree = manager2.showUpdateProjectInfo(files, actionName, ActionInfo.UPDATE, false);
                if (tree != null) {
                    tree.setBefore(beforeLabel);
                    tree.setAfter(LocalHistory.getInstance().putSystemLabel(project, GitBundle.message("merge.action.after.update.label", new Object[0])));
                    ViewUpdateInfoNotification.focusUpdateInfoTree((Project)project, (UpdateInfoTree)tree);
                }
            });
        }
        catch (VcsException e) {
            GitVcs.getInstance(project).showErrors(Collections.singletonList(e), actionName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeConflictDetector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesDetector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedFilesDetector";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRev";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLabel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        objectArray2[1] = "git4idea/actions/GitMergeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSetupRebaseEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "handleResult";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "showUpdates";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class DialogState {
        final VirtualFile selectedRoot;
        final @NlsContexts.ProgressTitle String progressTitle;
        final Supplier<GitLineHandler> handlerProvider;
        @NotNull
        final GitBranch selectedBranch;
        final boolean commitAfterMerge;
        @NotNull
        final List<String> selectedOptions;

        DialogState(@NotNull VirtualFile root, @NlsContexts.ProgressTitle @NotNull String title, @NotNull Supplier<GitLineHandler> provider, @NotNull GitBranch selectedBranch, boolean commitAfterMerge, @NotNull List<String> selectedOptions) {
            if (root == null) {
                DialogState.$$$reportNull$$$0(0);
            }
            if (title == null) {
                DialogState.$$$reportNull$$$0(1);
            }
            if (provider == null) {
                DialogState.$$$reportNull$$$0(2);
            }
            if (selectedBranch == null) {
                DialogState.$$$reportNull$$$0(3);
            }
            if (selectedOptions == null) {
                DialogState.$$$reportNull$$$0(4);
            }
            this.selectedRoot = root;
            this.progressTitle = title;
            this.handlerProvider = provider;
            this.selectedBranch = selectedBranch;
            this.selectedOptions = selectedOptions;
            this.commitAfterMerge = commitAfterMerge;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedBranch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedOptions";
                    break;
                }
            }
            objectArray[1] = "git4idea/actions/GitMergeAction$DialogState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

