/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "noticemenu.h"
#include "realizenotice.h"
#include <QDebug>
#include <QVBoxLayout>
#include <QDesktopWidget>
#include <QApplication>
#include "fixlabel.h"

NoticeMenu::NoticeMenu(QWidget *parent) :
    QMenu(parent)
{
    setFixedSize(380, 380);
    initUi();
    setConnect();
}

void NoticeMenu::initStaus(bool voiceEnable, bool detailEnable, bool showEnable, int id)
{
    mVoiceBtn->blockSignals(true);
    mShowBtn->blockSignals(true);
    mDetailBtn->blockSignals(true);
    mStyleGrounp->blockSignals(true);

    mVoiceBtn->setChecked(voiceEnable);
    mDetailBtn->setChecked(detailEnable);
    mShowBtn->setChecked(showEnable);
    mStyleGrounp->button(id)->setChecked(true);

    mVoiceBtn->blockSignals(false);
    mShowBtn->blockSignals(false);
    mDetailBtn->blockSignals(false);
    mStyleGrounp->blockSignals(false);
}

void NoticeMenu::initUi()
{
    QVBoxLayout *menuLyt = new QVBoxLayout(this);
    menuLyt->setSpacing(0);
    menuLyt->setContentsMargins(8, 0, 8, 0);

    QFrame *voiceFrame = new QFrame(this);
    mVoiceBtn = new KSwitchButton;
    setFrame(voiceFrame, tr("Beep sound when notified"), mVoiceBtn);

    QFrame *line_1 = setLine();

    QFrame *detailFrame = new QFrame(this);
    mDetailBtn = new KSwitchButton;
    setFrame(detailFrame, tr("Show message  on screenlock"), mDetailBtn);

    QFrame *line_2 = setLine();

    QFrame *showFrame = new QFrame(this);
    mShowBtn = new KSwitchButton;
    setFrame(showFrame, tr("Show noticfication  on screenlock"), mShowBtn);

    QFrame *line_3 = setLine();

    QLabel *styletitleLabel = new QLabel(tr("Notification Style"), this);
    styletitleLabel->setContentsMargins(24, 0, 0, 0);

    mStyleGrounp = new QButtonGroup(this);

    QFrame *mutativeFrame = new QFrame(this);
    mMutativeBtn = new QRadioButton;
    mStyleGrounp->addButton(mMutativeBtn, 0);
    setFrame(mutativeFrame, tr("Banner: Appears in the upper right corner of the screen, and disappears automatically"), mMutativeBtn);

    QFrame *alwaysFrame = new QFrame(this);
    mAlwaysBtn = new QRadioButton;
    mStyleGrounp->addButton(mAlwaysBtn, 1);
    setFrame(alwaysFrame, tr("Tip:It will be kept on the screen until it is closed"), mAlwaysBtn);

    QFrame *noneFrame = new QFrame(this);
    mNoneBtn = new QRadioButton;
    mStyleGrounp->addButton(mNoneBtn, 2);
    setFrame(noneFrame, tr("None:Notifications will not be displayed on the screen, but will go to the notification center"), mNoneBtn);

    menuLyt->addWidget(voiceFrame);
    menuLyt->addWidget(line_1);
    menuLyt->addWidget(detailFrame);
    menuLyt->addWidget(line_2);
    menuLyt->addWidget(showFrame);
    menuLyt->addWidget(line_3);
    menuLyt->addSpacing(16);
    menuLyt->addWidget(styletitleLabel);
    menuLyt->addWidget(mutativeFrame);
    menuLyt->addWidget(alwaysFrame);
    menuLyt->addWidget(noneFrame);
    menuLyt->addStretch();

}

void NoticeMenu::setFrame(QFrame *frame, QString str, KSwitchButton *btn)
{
    frame->setFixedHeight(60);
    frame->setFrameShape(QFrame::NoFrame);
    QHBoxLayout *hLyt = new QHBoxLayout(frame);
    hLyt->setContentsMargins(24, 0, 24, 0);
    hLyt->setSpacing(8);
    FixLabel *label = new FixLabel(str, frame);
    label->setFixedWidth(250);
    hLyt->addWidget(label);
    hLyt->addStretch();
    hLyt->addWidget(btn);
}

void NoticeMenu::setFrame(QFrame *frame, QString str, QRadioButton *btn)
{
    frame->setFixedHeight(48);
    frame->setFrameShape(QFrame::NoFrame);
    QHBoxLayout *hLyt = new QHBoxLayout(frame);
    hLyt->setContentsMargins(24, 0, 24, 0);
    FixLabel *label = new FixLabel(str, frame);
    label->setFixedWidth(288);
    hLyt->addWidget(btn);
    hLyt->addWidget(label);
    hLyt->addStretch();
}

QFrame *NoticeMenu::setLine()
{
    QFrame *line = new QFrame();
    line->setMinimumSize(QSize(0, 1));
    line->setMaximumSize(QSize(16777215, 1));
    line->setLineWidth(0);
    line->setFrameShape(QFrame::HLine);
    line->setFrameShadow(QFrame::Sunken);
    return line;
}

void NoticeMenu::setConnect()
{
    connect(mVoiceBtn, &KSwitchButton::stateChanged, this, &NoticeMenu::voiceSignals);
    connect(mDetailBtn, &KSwitchButton::stateChanged, this, &NoticeMenu::detailSignals);
    connect(mShowBtn, &KSwitchButton::stateChanged, this, &NoticeMenu::showSignals);
    connect(mStyleGrounp, QOverload<int>::of(&QButtonGroup::buttonClicked), this, &NoticeMenu::styleBtnSignals);
}

void NoticeMenu::showEvent(QShowEvent *event)
{
    int menuXpos = this->pos().x();
    int menuYpos = this->pos().y();
    QRect deskRect = QApplication::desktop()->screenGeometry(QApplication::desktop()->screenNumber(QCursor::pos()));
    int deskRectWidth = deskRect.width();
    int deskRectHeight = deskRect.height();

    if (menuXpos + this->width() > deskRectWidth)
        menuXpos = deskRectWidth - this->width();
    if (menuYpos + this->height() > deskRectHeight)
        menuYpos = menuYpos - this->height() - this->parentWidget()->height();

    this->move(menuXpos, menuYpos);
    QMenu::showEvent(event);
}
