/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [scn_gen.h]                Scanner Generator                             */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef scn_gen_INCL
#define scn_gen_INCL


#include "scn_io.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
  <p>The module [scn_gen] supports the construction of regular sets and
  produces the scanner definitions as base for the
  <a href="scn_base.htm">scan streams</a>.
  <p>The complexity of the scanner is linear. A consequence of this design-goal
  is its restriction to a one-character-lookahead.
  <p>The construction of regular sets is reentrant.
  There also exists a reentrant version of the scanner production.<br>
*/

/* ------------------------- Type of regular sets ------------------------- */

AbstractType(RegSet_T); /* Regular Set */

/* -------------------------- Disposing ----------------------------------- */

void RegSet_Free(RegSet_T g);          /* frees regular set 'g'             */

/* -------------------------- RegSet Constructors ------------------------- */

/* 
  <p>The resulting regular sets when applying one of the following functions
     have to be released.
*/

RegSet_T RegSet_Epsilon(void);                 /* epsilon ""                */
RegSet_T RegSet_Empty(void);                   /* empty set ''              */

RegSet_T RegSet_Range(wc_char dfa_lower, wc_char dfa_upper)
/* character range L .. U */
;

RegSet_T RegSet_Char(wc_char c);               /* character 'c'             */
RegSet_T RegSet_Copy(RegSet_T a);              /* copies regular set 'a'    */
RegSet_T RegSet_Union(RegSet_T a, RegSet_T b); /* union a | b               */
RegSet_T RegSet_Intersection(RegSet_T a, RegSet_T b); /* intersection a ^ b */
RegSet_T RegSet_Difference(RegSet_T a, RegSet_T b);   /* difference a - b   */
RegSet_T RegSet_Concat(RegSet_T a, RegSet_T b);       /* concatenation a b  */
RegSet_T RegSet_Star(RegSet_T a);                     /* iteration { a }    */
RegSet_T RegSet_CsetN(wc_string s,int len); /* character set '...'[0:len)   */
RegSet_T RegSet_Cset(wc_string s);          /* character set '...'          */

RegSet_T RegSet_StringN(wc_string s,int len)
/* character sequence / string "..."[0:len) */
;

RegSet_T RegSet_String(wc_string s);   /* character sequence / string "..." */
RegSet_T RegSet_Option(RegSet_T a);    /* option [ a ]                      */
RegSet_T RegSet_Plus(RegSet_T a);      /* iteration a +                     */

RegSet_T RegSet_Plus_ntimes(RegSet_T a, int n)
/* iteration { a } n-times, n >= 0 */
;

RegSet_T RegSet_Plus_range(RegSet_T a, int lwr, int upr)
/* iteration { a } lwr-times .. upr-times, lwr >= 0, upr >= 0 */
;

c_bool   RegSet_isChar(RegSet_T a);    /* a = 'x' ?                         */
wc_char  RegSet_charVal(RegSet_T a);   /* x; assertion: a = 'x'             */

/* ----------------------- Scanner production ----------------------------- */

AbstractType(ScnDfn_T) /* Scanner production handle */
;

void Scn_dfnBegin(c_string name)
/* begins a scanner definition;
   uses 'name' as identifier
*/
;

ScnDfn_T Scn_dfnBegin_reentrant(c_string name)
/* reentrant version of Scn_dfnBegin */
;

void Scn_setMsgFun(void (*prMsg)(c_string msg))
/* defines 'prMsg' as default message function */
;

void Scn_setMsgFun_reentrant(ScnDfn_T curdfn, void (*prMsg)(c_string msg))
/* reentrant version of Scn_setMsgFun */
;

void Scn_dfnToken(c_string name, c_byte tok_flags, RegSet_T value)
/* adds a new token to the scanner under production
   'name' : identifier
   'flags': attributes ( see [scn_base] )
   'value': regular set
*/
;

void Scn_dfnToken_reentrant
     (
       ScnDfn_T curdfn, c_string name, c_byte tok_flags, RegSet_T value
     )
/* reentrant version of Scn_dfnToken */
;

void Scn_dfnDyckToken
     (
       c_string name, c_byte tok_flags,
       RegSet_T left, Scn_T dyck
     )
/* adds a new dyck token to the scanner under production;
   consumes 'dyck'
   'name' : identifier
   'flags': attributes ( see [scn_base] )
   'left' : regular set for left paranthesis
   'dyck' : dyck scanner ( left, inner and right token )
*/
;

void Scn_dfnDyckToken_reentrant
     (
       ScnDfn_T curdfn, c_string name, c_byte tok_flags,
       RegSet_T left, Scn_T dyck
     )
/* reentrant version of Scn_dfnToken */
;

void RegSet_Print(RegSet_T x)
/* prints regular set to stdout; for debugging */
;

void RegSet_Print_reentrant(ScnDfn_T curdfn, RegSet_T x)
/* reentrant version of RegSet_Print */
;

Scn_T Scn_dfnEnd(c_bool diagnose)
/* completes and creates scanner definition
   diagnose --> prints scanner definiton
*/
;

Scn_T Scn_dfnEnd_reentrant(ScnDfn_T curdfn, c_bool diagnose)
/* reentrant version of Scn_dfnEnd;
   consumes 'curdfn'
*/
;


/* ----------------------- Scanner group production ------------------------ */

Scn_T ScnGrp_dfnBegin(c_string name)
/* begins a scanner group definition;
   uses 'name' as identifier
*/
;

void ScnGrp_dfnScanner(Scn_T group, Scn_T scanner)
/* adds 'scanner' to 'group'; consumes 'scanner' */
;

void ScnGrp_dfnSwitch(Scn_T group, c_string from, c_string token, c_string to)
/* adds context switch information for 'group';
   'token' in scanner 'from' switches to scanner 'to'
*/
;

int ScnGrp_dfnEnd(Scn_T group)
/* completes definition for 'group';
   returns number of unreachable scanners
*/
;



#ifdef __cplusplus
}
#endif

#endif
