A private type or trait was used in a public associated type signature.

Erroneous code example:

```compile_fail,E0446
struct Bar;

pub trait PubTr {
    type Alias;
}

impl PubTr for u8 {
    type Alias = Bar; // error private type in public interface
}

fn main() {}
```

There are two ways to solve this error. The first is to make the public type
signature only public to a module that also has access to the private type.
This is done by using pub(crate) or pub(in crate::my_mod::etc)
Example:

```
struct Bar;

pub(crate) trait PubTr { // only public to crate root
    type Alias;
}

impl PubTr for u8 {
    type Alias = Bar;
}

fn main() {}
```

The other way to solve this error is to make the private type public.
Example:

```

pub struct Bar; // we set the Bar trait public

pub trait PubTr {
    type Alias;
}

impl PubTr for u8 {
    type Alias = Bar;
}

fn main() {}
```
