/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 3166 countries & UN M.49 regions

   Written by Moritz Bunkus <mo@bunkus.online>.
*/

// ------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso3166_list" rake target.
// ------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso3166.h"

namespace mtx::iso3166 {

std::vector<region_t> g_regions;

struct region_init_t {
  char const *alpha_2_code, *alpha_3_code;
  unsigned int number;
  char const *name, *official_name;
  bool is_deprecated;
};

static region_init_t const s_regions_init[] = {
  { "",   "",      2, "Africa",                                               "",                                                                            false },
  { "",   "",     19, "Americas",                                             "",                                                                            false },
  { "",   "",    142, "Asia",                                                 "",                                                                            false },
  { "",   "",     53, "Australia and New Zealand",                            "",                                                                            false },
  { "",   "",     29, "Caribbean",                                            "",                                                                            false },
  { "",   "",     13, "Central America",                                      "",                                                                            false },
  { "",   "",    143, "Central Asia",                                         "",                                                                            false },
  { "",   "",     14, "Eastern Africa",                                       "",                                                                            false },
  { "",   "",     30, "Eastern Asia",                                         "",                                                                            false },
  { "",   "",    151, "Eastern Europe",                                       "",                                                                            false },
  { "",   "",    150, "Europe",                                               "",                                                                            false },
  { "",   "",    419, "Latin America and the Caribbean",                      "",                                                                            false },
  { "",   "",     54, "Melanesia",                                            "",                                                                            false },
  { "",   "",     57, "Micronesia",                                           "",                                                                            false },
  { "",   "",     17, "Middle Africa",                                        "",                                                                            false },
  { "",   "",      3, "North America",                                        "",                                                                            false },
  { "",   "",     15, "Northern Africa",                                      "",                                                                            false },
  { "",   "",     21, "Northern America",                                     "",                                                                            false },
  { "",   "",    154, "Northern Europe",                                      "",                                                                            false },
  { "",   "",      9, "Oceania",                                              "",                                                                            false },
  { "",   "",     61, "Polynesia",                                            "",                                                                            false },
  { "",   "",      5, "South America",                                        "",                                                                            false },
  { "",   "",     35, "South-eastern Asia",                                   "",                                                                            false },
  { "",   "",     18, "Southern Africa",                                      "",                                                                            false },
  { "",   "",     34, "Southern Asia",                                        "",                                                                            false },
  { "",   "",     39, "Southern Europe",                                      "",                                                                            false },
  { "",   "",    202, "Sub-Saharan Africa",                                   "",                                                                            false },
  { "",   "",     11, "Western Africa",                                       "",                                                                            false },
  { "",   "",    145, "Western Asia",                                         "",                                                                            false },
  { "",   "",    155, "Western Europe",                                       "",                                                                            false },
  { "",   "",      1, "World",                                                "",                                                                            false },
  { "AA", "",      0, "User-assigned",                                        "",                                                                            false },
  { "AC", "",      0, "Ascension Island",                                     "",                                                                            false },
  { "AD", "AND",  20, "Andorra",                                              "the Principality of Andorra",                                                 false },
  { "AE", "ARE", 784, "United Arab Emirates",                                 "the United Arab Emirates",                                                    false },
  { "AF", "AFG",   4, "Afghanistan",                                          "the Islamic Republic of Afghanistan",                                         false },
  { "AG", "ATG",  28, "Antigua and Barbuda",                                  "",                                                                            false },
  { "AI", "AIA", 660, "Anguilla",                                             "",                                                                            false },
  { "AL", "ALB",   8, "Albania",                                              "the Republic of Albania",                                                     false },
  { "AM", "ARM",  51, "Armenia",                                              "the Republic of Armenia",                                                     false },
  { "AN", "",      0, "Netherlands Antilles",                                 "",                                                                            true  },
  { "AO", "AGO",  24, "Angola",                                               "the Republic of Angola",                                                      false },
  { "AQ", "ATA",  10, "Antarctica",                                           "",                                                                            false },
  { "AR", "ARG",  32, "Argentina",                                            "the Argentine Republic",                                                      false },
  { "AS", "ASM",  16, "American Samoa",                                       "",                                                                            false },
  { "AT", "AUT",  40, "Austria",                                              "the Republic of Austria",                                                     false },
  { "AU", "AUS",  36, "Australia",                                            "the Commonwealth of Australia",                                               false },
  { "AW", "ABW", 533, "Aruba",                                                "the Country of Aruba",                                                        false },
  { "AX", "ALA", 248, "Åland Islands",                                        "Åland",                                                                       false },
  { "AZ", "AZE",  31, "Azerbaijan",                                           "the Republic of Azerbaijan",                                                  false },
  { "BA", "BIH",  70, "Bosnia and Herzegovina",                               "",                                                                            false },
  { "BB", "BRB",  52, "Barbados",                                             "",                                                                            false },
  { "BD", "BGD",  50, "Bangladesh",                                           "the People's Republic of Bangladesh",                                         false },
  { "BE", "BEL",  56, "Belgium",                                              "the Kingdom of Belgium",                                                      false },
  { "BF", "BFA", 854, "Burkina Faso",                                         "",                                                                            false },
  { "BG", "BGR", 100, "Bulgaria",                                             "the Republic of Bulgaria",                                                    false },
  { "BH", "BHR",  48, "Bahrain",                                              "the Kingdom of Bahrain",                                                      false },
  { "BI", "BDI", 108, "Burundi",                                              "the Republic of Burundi",                                                     false },
  { "BJ", "BEN", 204, "Benin",                                                "the Republic of Benin",                                                       false },
  { "BL", "BLM", 652, "Saint Barthélemy",                                     "the Collectivity of Saint-Barthélemy",                                        false },
  { "BM", "BMU",  60, "Bermuda",                                              "",                                                                            false },
  { "BN", "BRN",  96, "Brunei Darussalam",                                    "",                                                                            false },
  { "BO", "BOL",  68, "Bolivia (Plurinational State of)",                     "the Plurinational State of Bolivia",                                          false },
  { "BQ", "BES", 535, "Bonaire, Sint Eustatius and Saba",                     "",                                                                            false },
  { "BR", "BRA",  76, "Brazil",                                               "the Federative Republic of Brazil",                                           false },
  { "BS", "BHS",  44, "Bahamas",                                              "the Commonwealth of The Bahamas",                                             false },
  { "BT", "BTN",  64, "Bhutan",                                               "the Kingdom of Bhutan",                                                       false },
  { "BU", "",      0, "Burma",                                                "",                                                                            true  },
  { "BV", "BVT",  74, "Bouvet Island",                                        "",                                                                            false },
  { "BW", "BWA",  72, "Botswana",                                             "the Republic of Botswana",                                                    false },
  { "BY", "BLR", 112, "Belarus",                                              "the Republic of Belarus",                                                     false },
  { "BZ", "BLZ",  84, "Belize",                                               "",                                                                            false },
  { "CA", "CAN", 124, "Canada",                                               "",                                                                            false },
  { "CC", "CCK", 166, "Cocos (Keeling) Islands",                              "the Territory of Cocos (Keeling) Islands",                                    false },
  { "CD", "COD", 180, "Congo (the Democratic Republic of the)",               "the Democratic Republic of the Congo",                                        false },
  { "CF", "CAF", 140, "Central African Republic",                             "the Central African Republic",                                                false },
  { "CG", "COG", 178, "Congo",                                                "the Republic of the Congo",                                                   false },
  { "CH", "CHE", 756, "Switzerland",                                          "the Swiss Confederation",                                                     false },
  { "CI", "CIV", 384, "Côte d'Ivoire",                                        "the Republic of Côte d'Ivoire",                                               false },
  { "CK", "COK", 184, "Cook Islands",                                         "the Cook Islands",                                                            false },
  { "CL", "CHL", 152, "Chile",                                                "the Republic of Chile",                                                       false },
  { "CM", "CMR", 120, "Cameroon",                                             "the Republic of Cameroon",                                                    false },
  { "CN", "CHN", 156, "China",                                                "the People's Republic of China",                                              false },
  { "CO", "COL", 170, "Colombia",                                             "the Republic of Colombia",                                                    false },
  { "CP", "",      0, "Clipperton Island",                                    "",                                                                            false },
  { "CQ", "",      0, "Sark",                                                 "",                                                                            false },
  { "CR", "CRI", 188, "Costa Rica",                                           "the Republic of Costa Rica",                                                  false },
  { "CS", "",      0, "Serbia and Montenegro",                                "",                                                                            true  },
  { "CU", "CUB", 192, "Cuba",                                                 "the Republic of Cuba",                                                        false },
  { "CV", "CPV", 132, "Cabo Verde",                                           "the Republic of Cabo Verde",                                                  false },
  { "CW", "CUW", 531, "Curaçao",                                              "the Country of Curaçao",                                                      false },
  { "CX", "CXR", 162, "Christmas Island",                                     "the Territory of Christmas Island",                                           false },
  { "CY", "CYP", 196, "Cyprus",                                               "the Republic of Cyprus",                                                      false },
  { "CZ", "CZE", 203, "Czechia",                                              "the Czech Republic",                                                          false },
  { "DD", "",      0, "German Democratic Republic",                           "",                                                                            true  },
  { "DE", "DEU", 276, "Germany",                                              "the Federal Republic of Germany",                                             false },
  { "DG", "",      0, "Diego Garcia",                                         "",                                                                            false },
  { "DJ", "DJI", 262, "Djibouti",                                             "the Republic of Djibouti",                                                    false },
  { "DK", "DNK", 208, "Denmark",                                              "the Kingdom of Denmark",                                                      false },
  { "DM", "DMA", 212, "Dominica",                                             "the Commonwealth of Dominica",                                                false },
  { "DO", "DOM", 214, "Dominican Republic",                                   "the Dominican Republic",                                                      false },
  { "DZ", "DZA",  12, "Algeria",                                              "the People's Democratic Republic of Algeria",                                 false },
  { "EA", "",      0, "Ceuta, Melilla",                                       "",                                                                            false },
  { "EC", "ECU", 218, "Ecuador",                                              "the Republic of Ecuador",                                                     false },
  { "EE", "EST", 233, "Estonia",                                              "the Republic of Estonia",                                                     false },
  { "EG", "EGY", 818, "Egypt",                                                "the Arab Republic of Egypt",                                                  false },
  { "EH", "ESH", 732, "Western Sahara",                                       "the Sahrawi Arab Democratic Republic",                                        false },
  { "ER", "ERI", 232, "Eritrea",                                              "the State of Eritrea",                                                        false },
  { "ES", "ESP", 724, "Spain",                                                "the Kingdom of Spain",                                                        false },
  { "ET", "ETH", 231, "Ethiopia",                                             "the Federal Democratic Republic of Ethiopia",                                 false },
  { "EU", "",      0, "European Union",                                       "",                                                                            false },
  { "EZ", "",      0, "Eurozone",                                             "",                                                                            false },
  { "FI", "FIN", 246, "Finland",                                              "the Republic of Finland",                                                     false },
  { "FJ", "FJI", 242, "Fiji",                                                 "the Republic of Fiji",                                                        false },
  { "FK", "FLK", 238, "Falkland Islands",                                     "the Falkland Islands",                                                        false },
  { "FM", "FSM", 583, "Micronesia (Federated States of)",                     "the Federated States of Micronesia",                                          false },
  { "FO", "FRO", 234, "Faroe Islands",                                        "the Faroe Islands",                                                           false },
  { "FR", "FRA", 250, "France",                                               "the French Republic",                                                         false },
  { "FX", "",      0, "Metropolitan France",                                  "",                                                                            true  },
  { "GA", "GAB", 266, "Gabon",                                                "the Gabonese Republic",                                                       false },
  { "GB", "GBR", 826, "United Kingdom of Great Britain and Northern Ireland", "the United Kingdom of Great Britain and Northern Ireland",                    false },
  { "GD", "GRD", 308, "Grenada",                                              "",                                                                            false },
  { "GE", "GEO", 268, "Georgia",                                              "",                                                                            false },
  { "GF", "GUF", 254, "French Guiana",                                        "Guyane",                                                                      false },
  { "GG", "GGY", 831, "Guernsey",                                             "the Bailiwick of Guernsey",                                                   false },
  { "GH", "GHA", 288, "Ghana",                                                "the Republic of Ghana",                                                       false },
  { "GI", "GIB", 292, "Gibraltar",                                            "",                                                                            false },
  { "GL", "GRL", 304, "Greenland",                                            "",                                                                            false },
  { "GM", "GMB", 270, "Gambia",                                               "the Republic of The Gambia",                                                  false },
  { "GN", "GIN", 324, "Guinea",                                               "the Republic of Guinea",                                                      false },
  { "GP", "GLP", 312, "Guadeloupe",                                           "",                                                                            false },
  { "GQ", "GNQ", 226, "Equatorial Guinea",                                    "the Republic of Equatorial Guinea",                                           false },
  { "GR", "GRC", 300, "Greece",                                               "the Hellenic Republic",                                                       false },
  { "GS", "SGS", 239, "South Georgia and the South Sandwich Islands",         "",                                                                            false },
  { "GT", "GTM", 320, "Guatemala",                                            "the Republic of Guatemala",                                                   false },
  { "GU", "GUM", 316, "Guam",                                                 "",                                                                            false },
  { "GW", "GNB", 624, "Guinea-Bissau",                                        "the Republic of Guinea-Bissau",                                               false },
  { "GY", "GUY", 328, "Guyana",                                               "the Co-operative Republic of Guyana",                                         false },
  { "HK", "HKG", 344, "Hong Kong",                                            "the Hong Kong Special Administrative Region of China",                        false },
  { "HM", "HMD", 334, "Heard Island and McDonald Islands",                    "the Territory of Heard Island and McDonald Islands",                          false },
  { "HN", "HND", 340, "Honduras",                                             "the Republic of Honduras",                                                    false },
  { "HR", "HRV", 191, "Croatia",                                              "the Republic of Croatia",                                                     false },
  { "HT", "HTI", 332, "Haiti",                                                "the Republic of Haiti",                                                       false },
  { "HU", "HUN", 348, "Hungary",                                              "",                                                                            false },
  { "IC", "",      0, "Canary Islands",                                       "",                                                                            false },
  { "ID", "IDN", 360, "Indonesia",                                            "the Republic of Indonesia",                                                   false },
  { "IE", "IRL", 372, "Ireland",                                              "",                                                                            false },
  { "IL", "ISR", 376, "Israel",                                               "the State of Israel",                                                         false },
  { "IM", "IMN", 833, "Isle of Man",                                          "the Isle of Man",                                                             false },
  { "IN", "IND", 356, "India",                                                "the Republic of India",                                                       false },
  { "IO", "IOT",  86, "British Indian Ocean Territory",                       "the British Indian Ocean Territory",                                          false },
  { "IQ", "IRQ", 368, "Iraq",                                                 "the Republic of Iraq",                                                        false },
  { "IR", "IRN", 364, "Iran (Islamic Republic of)",                           "the Islamic Republic of Iran",                                                false },
  { "IS", "ISL", 352, "Iceland",                                              "",                                                                            false },
  { "IT", "ITA", 380, "Italy",                                                "the Italian Republic",                                                        false },
  { "JE", "JEY", 832, "Jersey",                                               "the Bailiwick of Jersey",                                                     false },
  { "JM", "JAM", 388, "Jamaica",                                              "",                                                                            false },
  { "JO", "JOR", 400, "Jordan",                                               "the Hashemite Kingdom of Jordan",                                             false },
  { "JP", "JPN", 392, "Japan",                                                "",                                                                            false },
  { "KE", "KEN", 404, "Kenya",                                                "the Republic of Kenya",                                                       false },
  { "KG", "KGZ", 417, "Kyrgyzstan",                                           "the Kyrgyz Republic",                                                         false },
  { "KH", "KHM", 116, "Cambodia",                                             "the Kingdom of Cambodia",                                                     false },
  { "KI", "KIR", 296, "Kiribati",                                             "the Republic of Kiribati",                                                    false },
  { "KM", "COM", 174, "Comoros",                                              "the Union of the Comoros",                                                    false },
  { "KN", "KNA", 659, "Saint Kitts and Nevis",                                "the Federation of Saint Kitts and Nevis",                                     false },
  { "KP", "PRK", 408, "Korea (the Democratic People's Republic of)",          "the Democratic People's Republic of Korea",                                   false },
  { "KR", "KOR", 410, "Korea (the Republic of)",                              "the Republic of Korea",                                                       false },
  { "KW", "KWT", 414, "Kuwait",                                               "the State of Kuwait",                                                         false },
  { "KY", "CYM", 136, "Cayman Islands",                                       "the Cayman Islands",                                                          false },
  { "KZ", "KAZ", 398, "Kazakhstan",                                           "the Republic of Kazakhstan",                                                  false },
  { "LA", "LAO", 418, "Lao People's Democratic Republic",                     "the Lao People's Democratic Republic",                                        false },
  { "LB", "LBN", 422, "Lebanon",                                              "the Lebanese Republic",                                                       false },
  { "LC", "LCA", 662, "Saint Lucia",                                          "",                                                                            false },
  { "LI", "LIE", 438, "Liechtenstein",                                        "the Principality of Liechtenstein",                                           false },
  { "LK", "LKA", 144, "Sri Lanka",                                            "the Democratic Socialist Republic of Sri Lanka",                              false },
  { "LR", "LBR", 430, "Liberia",                                              "the Republic of Liberia",                                                     false },
  { "LS", "LSO", 426, "Lesotho",                                              "the Kingdom of Lesotho",                                                      false },
  { "LT", "LTU", 440, "Lithuania",                                            "the Republic of Lithuania",                                                   false },
  { "LU", "LUX", 442, "Luxembourg",                                           "the Grand Duchy of Luxembourg",                                               false },
  { "LV", "LVA", 428, "Latvia",                                               "the Republic of Latvia",                                                      false },
  { "LY", "LBY", 434, "Libya",                                                "the State of Libya",                                                          false },
  { "MA", "MAR", 504, "Morocco",                                              "the Kingdom of Morocco",                                                      false },
  { "MC", "MCO", 492, "Monaco",                                               "the Principality of Monaco",                                                  false },
  { "MD", "MDA", 498, "Moldova (the Republic of)",                            "the Republic of Moldova",                                                     false },
  { "ME", "MNE", 499, "Montenegro",                                           "",                                                                            false },
  { "MF", "MAF", 663, "Saint Martin (French part)",                           "the Collectivity of Saint-Martin",                                            false },
  { "MG", "MDG", 450, "Madagascar",                                           "the Republic of Madagascar",                                                  false },
  { "MH", "MHL", 584, "Marshall Islands",                                     "the Republic of the Marshall Islands",                                        false },
  { "MK", "MKD", 807, "North Macedonia",                                      "the Republic of North Macedonia",                                             false },
  { "ML", "MLI", 466, "Mali",                                                 "the Republic of Mali",                                                        false },
  { "MM", "MMR", 104, "Myanmar",                                              "the Republic of the Union of Myanmar",                                        false },
  { "MN", "MNG", 496, "Mongolia",                                             "",                                                                            false },
  { "MO", "MAC", 446, "Macao",                                                "the Macao Special Administrative Region of China",                            false },
  { "MP", "MNP", 580, "Northern Mariana Islands",                             "the Commonwealth of the Northern Mariana Islands",                            false },
  { "MQ", "MTQ", 474, "Martinique",                                           "",                                                                            false },
  { "MR", "MRT", 478, "Mauritania",                                           "the Islamic Republic of Mauritania",                                          false },
  { "MS", "MSR", 500, "Montserrat",                                           "",                                                                            false },
  { "MT", "MLT", 470, "Malta",                                                "the Republic of Malta",                                                       false },
  { "MU", "MUS", 480, "Mauritius",                                            "the Republic of Mauritius",                                                   false },
  { "MV", "MDV", 462, "Maldives",                                             "the Republic of Maldives",                                                    false },
  { "MW", "MWI", 454, "Malawi",                                               "the Republic of Malawi",                                                      false },
  { "MX", "MEX", 484, "Mexico",                                               "the United Mexican States",                                                   false },
  { "MY", "MYS", 458, "Malaysia",                                             "",                                                                            false },
  { "MZ", "MOZ", 508, "Mozambique",                                           "the Republic of Mozambique",                                                  false },
  { "NA", "NAM", 516, "Namibia",                                              "the Republic of Namibia",                                                     false },
  { "NC", "NCL", 540, "New Caledonia",                                        "",                                                                            false },
  { "NE", "NER", 562, "Niger",                                                "the Republic of the Niger",                                                   false },
  { "NF", "NFK", 574, "Norfolk Island",                                       "the Territory of Norfolk Island",                                             false },
  { "NG", "NGA", 566, "Nigeria",                                              "the Federal Republic of Nigeria",                                             false },
  { "NI", "NIC", 558, "Nicaragua",                                            "the Republic of Nicaragua",                                                   false },
  { "NL", "NLD", 528, "Netherlands (Kingdom of the)",                         "the Kingdom of the Netherlands",                                              false },
  { "NO", "NOR", 578, "Norway",                                               "the Kingdom of Norway",                                                       false },
  { "NP", "NPL", 524, "Nepal",                                                "the Federal Democratic Republic of Nepal",                                    false },
  { "NR", "NRU", 520, "Nauru",                                                "the Republic of Nauru",                                                       false },
  { "NT", "",      0, "Neutral Zone",                                         "",                                                                            true  },
  { "NU", "NIU", 570, "Niue",                                                 "",                                                                            false },
  { "NZ", "NZL", 554, "New Zealand",                                          "",                                                                            false },
  { "OM", "OMN", 512, "Oman",                                                 "the Sultanate of Oman",                                                       false },
  { "PA", "PAN", 591, "Panama",                                               "the Republic of Panama",                                                      false },
  { "PE", "PER", 604, "Peru",                                                 "the Republic of Peru",                                                        false },
  { "PF", "PYF", 258, "French Polynesia",                                     "Overseas Lands of French Polynesia",                                          false },
  { "PG", "PNG", 598, "Papua New Guinea",                                     "the Independent State of Papua New Guinea",                                   false },
  { "PH", "PHL", 608, "Philippines",                                          "the Republic of the Philippines",                                             false },
  { "PK", "PAK", 586, "Pakistan",                                             "the Islamic Republic of Pakistan",                                            false },
  { "PL", "POL", 616, "Poland",                                               "the Republic of Poland",                                                      false },
  { "PM", "SPM", 666, "Saint Pierre and Miquelon",                            "the Overseas Collectivity of Saint-Pierre and Miquelon",                      false },
  { "PN", "PCN", 612, "Pitcairn",                                             "the Pitcairn, Henderson, Ducie and Oeno Islands",                             false },
  { "PR", "PRI", 630, "Puerto Rico",                                          "the Commonwealth of Puerto Rico",                                             false },
  { "PS", "PSE", 275, "Palestine, State of",                                  "the State of Palestine",                                                      false },
  { "PT", "PRT", 620, "Portugal",                                             "the Portuguese Republic",                                                     false },
  { "PW", "PLW", 585, "Palau",                                                "the Republic of Palau",                                                       false },
  { "PY", "PRY", 600, "Paraguay",                                             "the Republic of Paraguay",                                                    false },
  { "QA", "QAT", 634, "Qatar",                                                "the State of Qatar",                                                          false },
  { "QM", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QN", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QO", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QP", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QQ", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QR", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QS", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QT", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QU", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QV", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QW", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QX", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QY", "",      0, "User-assigned",                                        "",                                                                            false },
  { "QZ", "",      0, "User-assigned",                                        "",                                                                            false },
  { "RE", "REU", 638, "Réunion",                                              "",                                                                            false },
  { "RO", "ROU", 642, "Romania",                                              "",                                                                            false },
  { "RS", "SRB", 688, "Serbia",                                               "the Republic of Serbia",                                                      false },
  { "RU", "RUS", 643, "Russian Federation",                                   "the Russian Federation",                                                      false },
  { "RW", "RWA", 646, "Rwanda",                                               "the Republic of Rwanda",                                                      false },
  { "SA", "SAU", 682, "Saudi Arabia",                                         "the Kingdom of Saudi Arabia",                                                 false },
  { "SB", "SLB",  90, "Solomon Islands",                                      "the Solomon Islands",                                                         false },
  { "SC", "SYC", 690, "Seychelles",                                           "the Republic of Seychelles",                                                  false },
  { "SD", "SDN", 729, "Sudan",                                                "the Republic of the Sudan",                                                   false },
  { "SE", "SWE", 752, "Sweden",                                               "the Kingdom of Sweden",                                                       false },
  { "SG", "SGP", 702, "Singapore",                                            "the Republic of Singapore",                                                   false },
  { "SH", "SHN", 654, "Saint Helena, Ascension Island and Tristan da Cunha",  "Saint Helena, Ascension and Tristan da Cunha",                                false },
  { "SI", "SVN", 705, "Slovenia",                                             "the Republic of Slovenia",                                                    false },
  { "SJ", "SJM", 744, "Svalbard, Jan Mayen",                                  "Svalbard and Jan Mayen",                                                      false },
  { "SK", "SVK", 703, "Slovakia",                                             "the Slovak Republic",                                                         false },
  { "SL", "SLE", 694, "Sierra Leone",                                         "the Republic of Sierra Leone",                                                false },
  { "SM", "SMR", 674, "San Marino",                                           "the Republic of San Marino",                                                  false },
  { "SN", "SEN", 686, "Senegal",                                              "the Republic of Senegal",                                                     false },
  { "SO", "SOM", 706, "Somalia",                                              "the Federal Republic of Somalia",                                             false },
  { "SR", "SUR", 740, "Suriname",                                             "the Republic of Suriname",                                                    false },
  { "SS", "SSD", 728, "South Sudan",                                          "the Republic of South Sudan",                                                 false },
  { "ST", "STP", 678, "Sao Tome and Principe",                                "the Democratic Republic of São Tomé and Príncipe",                            false },
  { "SU", "",      0, "Union of Soviet Socialist Republics",                  "",                                                                            true  },
  { "SV", "SLV", 222, "El Salvador",                                          "the Republic of El Salvador",                                                 false },
  { "SX", "SXM", 534, "Sint Maarten (Dutch part)",                            "Sint Maarten",                                                                false },
  { "SY", "SYR", 760, "Syrian Arab Republic",                                 "the Syrian Arab Republic",                                                    false },
  { "SZ", "SWZ", 748, "Eswatini",                                             "the Kingdom of Eswatini",                                                     false },
  { "TA", "",      0, "Tristan da Cunha",                                     "",                                                                            false },
  { "TC", "TCA", 796, "Turks and Caicos Islands",                             "the Turks and Caicos Islands",                                                false },
  { "TD", "TCD", 148, "Chad",                                                 "the Republic of Chad",                                                        false },
  { "TF", "ATF", 260, "French Southern Territories",                          "the French Southern and Antarctic Lands",                                     false },
  { "TG", "TGO", 768, "Togo",                                                 "the Togolese Republic",                                                       false },
  { "TH", "THA", 764, "Thailand",                                             "the Kingdom of Thailand",                                                     false },
  { "TJ", "TJK", 762, "Tajikistan",                                           "the Republic of Tajikistan",                                                  false },
  { "TK", "TKL", 772, "Tokelau",                                              "",                                                                            false },
  { "TL", "TLS", 626, "Timor-Leste",                                          "the Democratic Republic of Timor-Leste",                                      false },
  { "TM", "TKM", 795, "Turkmenistan",                                         "",                                                                            false },
  { "TN", "TUN", 788, "Tunisia",                                              "the Republic of Tunisia",                                                     false },
  { "TO", "TON", 776, "Tonga",                                                "the Kingdom of Tonga",                                                        false },
  { "TP", "",      0, "East Timor",                                           "",                                                                            true  },
  { "TR", "TUR", 792, "Türkiye",                                              "the Republic of Türkiye",                                                     false },
  { "TT", "TTO", 780, "Trinidad and Tobago",                                  "the Republic of Trinidad and Tobago",                                         false },
  { "TV", "TUV", 798, "Tuvalu",                                               "",                                                                            false },
  { "TW", "TWN", 158, "Taiwan (Province of China)",                           "the Republic of China",                                                       false },
  { "TZ", "TZA", 834, "Tanzania, the United Republic of",                     "the United Republic of Tanzania",                                             false },
  { "UA", "UKR", 804, "Ukraine",                                              "",                                                                            false },
  { "UG", "UGA", 800, "Uganda",                                               "the Republic of Uganda",                                                      false },
  { "UM", "UMI", 581, "United States Minor Outlying Islands",                 "United States Pacific Island Wildlife Refuges,NavassaIsland, and WakeIsland", false },
  { "UN", "",      0, "United Nations",                                       "",                                                                            false },
  { "US", "USA", 840, "United States of America",                             "the United States of America",                                                false },
  { "UY", "URY", 858, "Uruguay",                                              "the Oriental Republic of Uruguay",                                            false },
  { "UZ", "UZB", 860, "Uzbekistan",                                           "the Republic of Uzbekistan",                                                  false },
  { "VA", "VAT", 336, "Holy See",                                             "the Holy See",                                                                false },
  { "VC", "VCT", 670, "Saint Vincent and the Grenadines",                     "",                                                                            false },
  { "VE", "VEN", 862, "Venezuela (Bolivarian Republic of)",                   "the Bolivarian Republic of Venezuela",                                        false },
  { "VG", "VGB",  92, "Virgin Islands (British)",                             "the Virgin Islands",                                                          false },
  { "VI", "VIR", 850, "Virgin Islands (U.S.)",                                "the Virgin Islands of the United States",                                     false },
  { "VN", "VNM", 704, "Viet Nam",                                             "the Socialist Republic of Viet Nam",                                          false },
  { "VU", "VUT", 548, "Vanuatu",                                              "the Republic of Vanuatu",                                                     false },
  { "WF", "WLF", 876, "Wallis and Futuna",                                    "the Territory of the Wallis and Futuna Islands",                              false },
  { "WS", "WSM", 882, "Samoa",                                                "the Independent State of Samoa",                                              false },
  { "XA", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XB", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XC", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XD", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XE", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XF", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XG", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XH", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XI", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XJ", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XK", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XL", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XM", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XN", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XO", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XP", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XQ", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XR", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XS", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XT", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XU", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XV", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XW", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XX", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XY", "",      0, "User-assigned",                                        "",                                                                            false },
  { "XZ", "",      0, "User-assigned",                                        "",                                                                            false },
  { "YD", "",      0, "Democratic Yemen",                                     "",                                                                            true  },
  { "YE", "YEM", 887, "Yemen",                                                "the Republic of Yemen",                                                       false },
  { "YT", "MYT", 175, "Mayotte",                                              "the Department of Mayotte",                                                   false },
  { "YU", "",      0, "Yugoslavia",                                           "",                                                                            true  },
  { "ZA", "ZAF", 710, "South Africa",                                         "the Republic of South Africa",                                                false },
  { "ZM", "ZMB", 894, "Zambia",                                               "the Republic of Zambia",                                                      false },
  { "ZR", "",      0, "Zaire",                                                "",                                                                            true  },
  { "ZW", "ZWE", 716, "Zimbabwe",                                             "the Republic of Zimbabwe",                                                    false },
  { "ZZ", "",      0, "User-assigned",                                        "",                                                                            false },
};

void
init() {
  g_regions.reserve(343);

  for (region_init_t const *region = s_regions_init, *end = region + 343; region < end; ++region)
    g_regions.emplace_back(region->alpha_2_code, region->alpha_3_code, region->number, region->name, region->official_name, region->is_deprecated);
}

} // namespace mtx::iso3166
