/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "icons.h"

#include "pixmaps/champagne.xpm"
#include "pixmaps/groundhog.xpm"
#include "pixmaps/highscore.xpm"
#include "pixmaps/new.xpm"
#include "pixmaps/tube_left.xpm"
#include "pixmaps/tube_right.xpm"

#include "pixmaps/left_blue.xpm"
#include "pixmaps/left_green.xpm"
#include "pixmaps/left_red.xpm"
#include "pixmaps/left_yellow.xpm"
#include "pixmaps/lower_blue.xpm"
#include "pixmaps/lower_green.xpm"
#include "pixmaps/lower_red.xpm"
#include "pixmaps/lower_yellow.xpm"
#include "pixmaps/right_blue.xpm"
#include "pixmaps/right_green.xpm"
#include "pixmaps/right_red.xpm"
#include "pixmaps/right_yellow.xpm"
#include "pixmaps/upper_blue.xpm"
#include "pixmaps/upper_green.xpm"
#include "pixmaps/upper_red.xpm"
#include "pixmaps/upper_yellow.xpm"

GtkIconSize Icons::_size = GTK_ICON_SIZE_INVALID;

void
Icons::Add(const gchar *stock_id, const char **xpm_data)
{
   GdkPixbuf  *pixbuf = gdk_pixbuf_new_from_xpm_data(xpm_data);
   GtkIconSet *icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);

   gtk_icon_factory_add(_factory, stock_id, icon_set);
   g_object_unref(G_OBJECT(pixbuf));
   gtk_icon_set_unref(icon_set);
}

Icons::Icons()
{
   _factory = gtk_icon_factory_new();
}

void
Icons::Init()
{
   Add(GROUNDHOG_STOCK_ABOUT, (const char**) groundhog_xpm);
   Add(GROUNDHOG_STOCK_CHAMPAGNE, (const char**) champagne_xpm);
   Add(GROUNDHOG_STOCK_HIGHSCORE, (const char**) highscore_xpm);
   Add(GROUNDHOG_STOCK_NEW, (const char**) new_xpm);
   Add(GROUNDHOG_STOCK_TUBE_LEFT, (const char**) tube_left_xpm);
   Add(GROUNDHOG_STOCK_TUBE_RIGHT, (const char**) tube_right_xpm);
   Add(GROUNDHOG_STOCK_LEFT_BLUE, (const char**) left_blue_xpm);
   Add(GROUNDHOG_STOCK_LEFT_GREEN, (const char**) left_green_xpm);
   Add(GROUNDHOG_STOCK_LEFT_RED, (const char**) left_red_xpm);
   Add(GROUNDHOG_STOCK_LEFT_YELLOW, (const char**) left_yellow_xpm);
   Add(GROUNDHOG_STOCK_LOWER_BLUE, (const char**) lower_blue_xpm);
   Add(GROUNDHOG_STOCK_LOWER_GREEN, (const char**) lower_green_xpm);
   Add(GROUNDHOG_STOCK_LOWER_RED, (const char**) lower_red_xpm);
   Add(GROUNDHOG_STOCK_LOWER_YELLOW, (const char**) lower_yellow_xpm);
   Add(GROUNDHOG_STOCK_RIGHT_BLUE, (const char**) right_blue_xpm);
   Add(GROUNDHOG_STOCK_RIGHT_GREEN, (const char**) right_green_xpm);
   Add(GROUNDHOG_STOCK_RIGHT_RED, (const char**) right_red_xpm);
   Add(GROUNDHOG_STOCK_RIGHT_YELLOW, (const char**) right_yellow_xpm);
   Add(GROUNDHOG_STOCK_UPPER_BLUE, (const char**) upper_blue_xpm);
   Add(GROUNDHOG_STOCK_UPPER_GREEN, (const char**) upper_green_xpm);
   Add(GROUNDHOG_STOCK_UPPER_RED, (const char**) upper_red_xpm);
   Add(GROUNDHOG_STOCK_UPPER_YELLOW, (const char**) upper_yellow_xpm);

   gtk_icon_factory_add_default(_factory);   
   _size = gtk_icon_size_register(GROUNDHOG_SIZE, 32, 32);
}
