/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sse2_double kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/legacyheaders/types/simple.h"
#include "gromacs/math/vec.h"
#include "gromacs/legacyheaders/nrnb.h"

#include "gromacs/simd/math_x86_sse2_double.h"
#include "kernelutil_x86_sse2_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecGB_VdwNone_GeomP1P1_VF_sse2_double
 * Electrostatics interaction: GeneralizedBorn
 * VdW interaction:            None
 * Geometry:                   Particle-Particle
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecGB_VdwNone_GeomP1P1_VF_sse2_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          gbitab;
    __m128d          vgb,fgb,vgbsum,dvdasum,gbscale,gbtabscale,isaprod,gbqqfactor,gbinvepsdiff,dvdaj,gbeps,dvdatmp;
    __m128d          minushalf = _mm_set1_pd(-0.5);
    real             *invsqrta,*dvda,*gbtab;
    __m128i          vfitab;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m128d          rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    invsqrta         = fr->invsqrta;
    dvda             = fr->dvda;
    gbtabscale       = _mm_set1_pd(fr->gbtab.scale);
    gbtab            = fr->gbtab.data;
    gbinvepsdiff     = _mm_set1_pd((1.0/fr->epsilon_r) - (1.0/fr->gb_epsilon_solvent));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_1rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,&ix0,&iy0,&iz0);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();

        /* Load parameters for i particles */
        iq0              = _mm_mul_pd(facel,_mm_load1_pd(charge+inr+0));
        isai0            = _mm_load1_pd(invsqrta+inr+0);

        /* Reset potential sums */
        velecsum         = _mm_setzero_pd();
        vgbsum           = _mm_setzero_pd();
        dvdasum          = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);

            /* Load parameters for j particles */
            jq0              = gmx_mm_load_2real_swizzle_pd(charge+jnrA+0,charge+jnrB+0);
            isaj0            = gmx_mm_load_2real_swizzle_pd(invsqrta+jnrA+0,invsqrta+jnrB+0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm_mul_pd(iq0,jq0);

            /* GENERALIZED BORN AND COULOMB ELECTROSTATICS */
            isaprod          = _mm_mul_pd(isai0,isaj0);
            gbqqfactor       = _mm_xor_pd(signbit,_mm_mul_pd(qq00,_mm_mul_pd(isaprod,gbinvepsdiff)));
            gbscale          = _mm_mul_pd(isaprod,gbtabscale);

            /* Calculate generalized born table index - this is a separate table from the normal one,
             * but we use the same procedure by multiplying r with scale and truncating to integer.
             */
            rt               = _mm_mul_pd(r00,gbscale);
            gbitab           = _mm_cvttpd_epi32(rt);
            gbeps            = _mm_sub_pd(rt,_mm_cvtepi32_pd(gbitab));
            gbitab           = _mm_slli_epi32(gbitab,2);

            Y                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) );
            F                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,1) );
            GMX_MM_TRANSPOSE2_PD(Y,F);
            G                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) +2);
            H                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(G,H);
            Heps             = _mm_mul_pd(gbeps,H);
            Fp               = _mm_add_pd(F,_mm_mul_pd(gbeps,_mm_add_pd(G,Heps)));
            VV               = _mm_add_pd(Y,_mm_mul_pd(gbeps,Fp));
            vgb              = _mm_mul_pd(gbqqfactor,VV);

            FF               = _mm_add_pd(Fp,_mm_mul_pd(gbeps,_mm_add_pd(G,_mm_add_pd(Heps,Heps))));
            fgb              = _mm_mul_pd(gbqqfactor,_mm_mul_pd(FF,gbscale));
            dvdatmp          = _mm_mul_pd(minushalf,_mm_add_pd(vgb,_mm_mul_pd(fgb,r00)));
            dvdasum          = _mm_add_pd(dvdasum,dvdatmp);
            gmx_mm_increment_2real_swizzle_pd(dvda+jnrA,dvda+jnrB,_mm_mul_pd(dvdatmp,_mm_mul_pd(isaj0,isaj0)));
            velec            = _mm_mul_pd(qq00,rinv00);
            felec            = _mm_mul_pd(_mm_sub_pd(_mm_mul_pd(velec,rinv00),fgb),rinv00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);
            vgbsum           = _mm_add_pd(vgbsum,vgb);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            gmx_mm_decrement_1rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,tx,ty,tz);

            /* Inner loop uses 58 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);

            /* Load parameters for j particles */
            jq0              = _mm_load_sd(charge+jnrA+0);
            isaj0            = _mm_load_sd(invsqrta+jnrA+0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm_mul_pd(iq0,jq0);

            /* GENERALIZED BORN AND COULOMB ELECTROSTATICS */
            isaprod          = _mm_mul_pd(isai0,isaj0);
            gbqqfactor       = _mm_xor_pd(signbit,_mm_mul_pd(qq00,_mm_mul_pd(isaprod,gbinvepsdiff)));
            gbscale          = _mm_mul_pd(isaprod,gbtabscale);

            /* Calculate generalized born table index - this is a separate table from the normal one,
             * but we use the same procedure by multiplying r with scale and truncating to integer.
             */
            rt               = _mm_mul_pd(r00,gbscale);
            gbitab           = _mm_cvttpd_epi32(rt);
            gbeps            = _mm_sub_pd(rt,_mm_cvtepi32_pd(gbitab));
            gbitab           = _mm_slli_epi32(gbitab,2);

            Y                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) );
            F                = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(Y,F);
            G                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) +2);
            H                = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(G,H);
            Heps             = _mm_mul_pd(gbeps,H);
            Fp               = _mm_add_pd(F,_mm_mul_pd(gbeps,_mm_add_pd(G,Heps)));
            VV               = _mm_add_pd(Y,_mm_mul_pd(gbeps,Fp));
            vgb              = _mm_mul_pd(gbqqfactor,VV);

            FF               = _mm_add_pd(Fp,_mm_mul_pd(gbeps,_mm_add_pd(G,_mm_add_pd(Heps,Heps))));
            fgb              = _mm_mul_pd(gbqqfactor,_mm_mul_pd(FF,gbscale));
            dvdatmp          = _mm_mul_pd(minushalf,_mm_add_pd(vgb,_mm_mul_pd(fgb,r00)));
            dvdatmp          = _mm_unpacklo_pd(dvdatmp,_mm_setzero_pd());
            dvdasum          = _mm_add_pd(dvdasum,dvdatmp);
            gmx_mm_increment_1real_pd(dvda+jnrA,_mm_mul_pd(dvdatmp,_mm_mul_pd(isaj0,isaj0)));
            velec            = _mm_mul_pd(qq00,rinv00);
            felec            = _mm_mul_pd(_mm_sub_pd(_mm_mul_pd(velec,rinv00),fgb),rinv00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);
            vgb              = _mm_unpacklo_pd(vgb,_mm_setzero_pd());
            vgbsum           = _mm_add_pd(vgbsum,vgb);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            gmx_mm_decrement_1rvec_1ptr_swizzle_pd(f+j_coord_offsetA,tx,ty,tz);

            /* Inner loop uses 58 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_1atom_swizzle_pd(fix0,fiy0,fiz0,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm_update_1pot_pd(vgbsum,kernel_data->energygrp_polarization+ggid);
        dvdasum = _mm_mul_pd(dvdasum, _mm_mul_pd(isai0,isai0));
        gmx_mm_update_1pot_pd(dvdasum,dvda+inr);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 9 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VF,outeriter*9 + inneriter*58);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecGB_VdwNone_GeomP1P1_F_sse2_double
 * Electrostatics interaction: GeneralizedBorn
 * VdW interaction:            None
 * Geometry:                   Particle-Particle
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecGB_VdwNone_GeomP1P1_F_sse2_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          gbitab;
    __m128d          vgb,fgb,vgbsum,dvdasum,gbscale,gbtabscale,isaprod,gbqqfactor,gbinvepsdiff,dvdaj,gbeps,dvdatmp;
    __m128d          minushalf = _mm_set1_pd(-0.5);
    real             *invsqrta,*dvda,*gbtab;
    __m128i          vfitab;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m128d          rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    invsqrta         = fr->invsqrta;
    dvda             = fr->dvda;
    gbtabscale       = _mm_set1_pd(fr->gbtab.scale);
    gbtab            = fr->gbtab.data;
    gbinvepsdiff     = _mm_set1_pd((1.0/fr->epsilon_r) - (1.0/fr->gb_epsilon_solvent));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_1rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,&ix0,&iy0,&iz0);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();

        /* Load parameters for i particles */
        iq0              = _mm_mul_pd(facel,_mm_load1_pd(charge+inr+0));
        isai0            = _mm_load1_pd(invsqrta+inr+0);

        dvdasum          = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);

            /* Load parameters for j particles */
            jq0              = gmx_mm_load_2real_swizzle_pd(charge+jnrA+0,charge+jnrB+0);
            isaj0            = gmx_mm_load_2real_swizzle_pd(invsqrta+jnrA+0,invsqrta+jnrB+0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm_mul_pd(iq0,jq0);

            /* GENERALIZED BORN AND COULOMB ELECTROSTATICS */
            isaprod          = _mm_mul_pd(isai0,isaj0);
            gbqqfactor       = _mm_xor_pd(signbit,_mm_mul_pd(qq00,_mm_mul_pd(isaprod,gbinvepsdiff)));
            gbscale          = _mm_mul_pd(isaprod,gbtabscale);

            /* Calculate generalized born table index - this is a separate table from the normal one,
             * but we use the same procedure by multiplying r with scale and truncating to integer.
             */
            rt               = _mm_mul_pd(r00,gbscale);
            gbitab           = _mm_cvttpd_epi32(rt);
            gbeps            = _mm_sub_pd(rt,_mm_cvtepi32_pd(gbitab));
            gbitab           = _mm_slli_epi32(gbitab,2);

            Y                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) );
            F                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,1) );
            GMX_MM_TRANSPOSE2_PD(Y,F);
            G                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) +2);
            H                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(G,H);
            Heps             = _mm_mul_pd(gbeps,H);
            Fp               = _mm_add_pd(F,_mm_mul_pd(gbeps,_mm_add_pd(G,Heps)));
            VV               = _mm_add_pd(Y,_mm_mul_pd(gbeps,Fp));
            vgb              = _mm_mul_pd(gbqqfactor,VV);

            FF               = _mm_add_pd(Fp,_mm_mul_pd(gbeps,_mm_add_pd(G,_mm_add_pd(Heps,Heps))));
            fgb              = _mm_mul_pd(gbqqfactor,_mm_mul_pd(FF,gbscale));
            dvdatmp          = _mm_mul_pd(minushalf,_mm_add_pd(vgb,_mm_mul_pd(fgb,r00)));
            dvdasum          = _mm_add_pd(dvdasum,dvdatmp);
            gmx_mm_increment_2real_swizzle_pd(dvda+jnrA,dvda+jnrB,_mm_mul_pd(dvdatmp,_mm_mul_pd(isaj0,isaj0)));
            velec            = _mm_mul_pd(qq00,rinv00);
            felec            = _mm_mul_pd(_mm_sub_pd(_mm_mul_pd(velec,rinv00),fgb),rinv00);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            gmx_mm_decrement_1rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,tx,ty,tz);

            /* Inner loop uses 56 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);

            /* Load parameters for j particles */
            jq0              = _mm_load_sd(charge+jnrA+0);
            isaj0            = _mm_load_sd(invsqrta+jnrA+0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm_mul_pd(iq0,jq0);

            /* GENERALIZED BORN AND COULOMB ELECTROSTATICS */
            isaprod          = _mm_mul_pd(isai0,isaj0);
            gbqqfactor       = _mm_xor_pd(signbit,_mm_mul_pd(qq00,_mm_mul_pd(isaprod,gbinvepsdiff)));
            gbscale          = _mm_mul_pd(isaprod,gbtabscale);

            /* Calculate generalized born table index - this is a separate table from the normal one,
             * but we use the same procedure by multiplying r with scale and truncating to integer.
             */
            rt               = _mm_mul_pd(r00,gbscale);
            gbitab           = _mm_cvttpd_epi32(rt);
            gbeps            = _mm_sub_pd(rt,_mm_cvtepi32_pd(gbitab));
            gbitab           = _mm_slli_epi32(gbitab,2);

            Y                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) );
            F                = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(Y,F);
            G                = _mm_load_pd( gbtab + gmx_mm_extract_epi32(gbitab,0) +2);
            H                = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(G,H);
            Heps             = _mm_mul_pd(gbeps,H);
            Fp               = _mm_add_pd(F,_mm_mul_pd(gbeps,_mm_add_pd(G,Heps)));
            VV               = _mm_add_pd(Y,_mm_mul_pd(gbeps,Fp));
            vgb              = _mm_mul_pd(gbqqfactor,VV);

            FF               = _mm_add_pd(Fp,_mm_mul_pd(gbeps,_mm_add_pd(G,_mm_add_pd(Heps,Heps))));
            fgb              = _mm_mul_pd(gbqqfactor,_mm_mul_pd(FF,gbscale));
            dvdatmp          = _mm_mul_pd(minushalf,_mm_add_pd(vgb,_mm_mul_pd(fgb,r00)));
            dvdatmp          = _mm_unpacklo_pd(dvdatmp,_mm_setzero_pd());
            dvdasum          = _mm_add_pd(dvdasum,dvdatmp);
            gmx_mm_increment_1real_pd(dvda+jnrA,_mm_mul_pd(dvdatmp,_mm_mul_pd(isaj0,isaj0)));
            velec            = _mm_mul_pd(qq00,rinv00);
            felec            = _mm_mul_pd(_mm_sub_pd(_mm_mul_pd(velec,rinv00),fgb),rinv00);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            gmx_mm_decrement_1rvec_1ptr_swizzle_pd(f+j_coord_offsetA,tx,ty,tz);

            /* Inner loop uses 56 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_1atom_swizzle_pd(fix0,fiy0,fiz0,
                                              f+i_coord_offset,fshift+i_shift_offset);

        dvdasum = _mm_mul_pd(dvdasum, _mm_mul_pd(isai0,isai0));
        gmx_mm_update_1pot_pd(dvdasum,dvda+inr);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 7 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_F,outeriter*7 + inneriter*56);
}
