// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/billing_setup_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [BillingSetupService.GetBillingSetup][google.ads.googleads.v1.services.BillingSetupService.GetBillingSetup].
type GetBillingSetupRequest struct {
	// Required. The resource name of the billing setup to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBillingSetupRequest) Reset()         { *m = GetBillingSetupRequest{} }
func (m *GetBillingSetupRequest) String() string { return proto.CompactTextString(m) }
func (*GetBillingSetupRequest) ProtoMessage()    {}
func (*GetBillingSetupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a012b9d34a4d410, []int{0}
}

func (m *GetBillingSetupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBillingSetupRequest.Unmarshal(m, b)
}
func (m *GetBillingSetupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBillingSetupRequest.Marshal(b, m, deterministic)
}
func (m *GetBillingSetupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBillingSetupRequest.Merge(m, src)
}
func (m *GetBillingSetupRequest) XXX_Size() int {
	return xxx_messageInfo_GetBillingSetupRequest.Size(m)
}
func (m *GetBillingSetupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBillingSetupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBillingSetupRequest proto.InternalMessageInfo

func (m *GetBillingSetupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for billing setup mutate operations.
type MutateBillingSetupRequest struct {
	// Required. Id of the customer to apply the billing setup mutate operation to.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The operation to perform.
	Operation            *BillingSetupOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MutateBillingSetupRequest) Reset()         { *m = MutateBillingSetupRequest{} }
func (m *MutateBillingSetupRequest) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupRequest) ProtoMessage()    {}
func (*MutateBillingSetupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a012b9d34a4d410, []int{1}
}

func (m *MutateBillingSetupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupRequest.Unmarshal(m, b)
}
func (m *MutateBillingSetupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupRequest.Marshal(b, m, deterministic)
}
func (m *MutateBillingSetupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupRequest.Merge(m, src)
}
func (m *MutateBillingSetupRequest) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupRequest.Size(m)
}
func (m *MutateBillingSetupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupRequest proto.InternalMessageInfo

func (m *MutateBillingSetupRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateBillingSetupRequest) GetOperation() *BillingSetupOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// A single operation on a billing setup, which describes the cancellation of an
// existing billing setup.
type BillingSetupOperation struct {
	// Only one of these operations can be set. "Update" operations are not
	// supported.
	//
	// Types that are valid to be assigned to Operation:
	//	*BillingSetupOperation_Create
	//	*BillingSetupOperation_Remove
	Operation            isBillingSetupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *BillingSetupOperation) Reset()         { *m = BillingSetupOperation{} }
func (m *BillingSetupOperation) String() string { return proto.CompactTextString(m) }
func (*BillingSetupOperation) ProtoMessage()    {}
func (*BillingSetupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a012b9d34a4d410, []int{2}
}

func (m *BillingSetupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BillingSetupOperation.Unmarshal(m, b)
}
func (m *BillingSetupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BillingSetupOperation.Marshal(b, m, deterministic)
}
func (m *BillingSetupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BillingSetupOperation.Merge(m, src)
}
func (m *BillingSetupOperation) XXX_Size() int {
	return xxx_messageInfo_BillingSetupOperation.Size(m)
}
func (m *BillingSetupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_BillingSetupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_BillingSetupOperation proto.InternalMessageInfo

type isBillingSetupOperation_Operation interface {
	isBillingSetupOperation_Operation()
}

type BillingSetupOperation_Create struct {
	Create *resources.BillingSetup `protobuf:"bytes,2,opt,name=create,proto3,oneof"`
}

type BillingSetupOperation_Remove struct {
	Remove string `protobuf:"bytes,1,opt,name=remove,proto3,oneof"`
}

func (*BillingSetupOperation_Create) isBillingSetupOperation_Operation() {}

func (*BillingSetupOperation_Remove) isBillingSetupOperation_Operation() {}

func (m *BillingSetupOperation) GetOperation() isBillingSetupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *BillingSetupOperation) GetCreate() *resources.BillingSetup {
	if x, ok := m.GetOperation().(*BillingSetupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *BillingSetupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*BillingSetupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BillingSetupOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BillingSetupOperation_Create)(nil),
		(*BillingSetupOperation_Remove)(nil),
	}
}

// Response message for a billing setup operation.
type MutateBillingSetupResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Result               *MutateBillingSetupResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *MutateBillingSetupResponse) Reset()         { *m = MutateBillingSetupResponse{} }
func (m *MutateBillingSetupResponse) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupResponse) ProtoMessage()    {}
func (*MutateBillingSetupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a012b9d34a4d410, []int{3}
}

func (m *MutateBillingSetupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupResponse.Unmarshal(m, b)
}
func (m *MutateBillingSetupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupResponse.Marshal(b, m, deterministic)
}
func (m *MutateBillingSetupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupResponse.Merge(m, src)
}
func (m *MutateBillingSetupResponse) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupResponse.Size(m)
}
func (m *MutateBillingSetupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupResponse proto.InternalMessageInfo

func (m *MutateBillingSetupResponse) GetResult() *MutateBillingSetupResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// Result for a single billing setup mutate.
type MutateBillingSetupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateBillingSetupResult) Reset()         { *m = MutateBillingSetupResult{} }
func (m *MutateBillingSetupResult) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupResult) ProtoMessage()    {}
func (*MutateBillingSetupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a012b9d34a4d410, []int{4}
}

func (m *MutateBillingSetupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupResult.Unmarshal(m, b)
}
func (m *MutateBillingSetupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupResult.Marshal(b, m, deterministic)
}
func (m *MutateBillingSetupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupResult.Merge(m, src)
}
func (m *MutateBillingSetupResult) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupResult.Size(m)
}
func (m *MutateBillingSetupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupResult proto.InternalMessageInfo

func (m *MutateBillingSetupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetBillingSetupRequest)(nil), "google.ads.googleads.v1.services.GetBillingSetupRequest")
	proto.RegisterType((*MutateBillingSetupRequest)(nil), "google.ads.googleads.v1.services.MutateBillingSetupRequest")
	proto.RegisterType((*BillingSetupOperation)(nil), "google.ads.googleads.v1.services.BillingSetupOperation")
	proto.RegisterType((*MutateBillingSetupResponse)(nil), "google.ads.googleads.v1.services.MutateBillingSetupResponse")
	proto.RegisterType((*MutateBillingSetupResult)(nil), "google.ads.googleads.v1.services.MutateBillingSetupResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/billing_setup_service.proto", fileDescriptor_0a012b9d34a4d410)
}

var fileDescriptor_0a012b9d34a4d410 = []byte{
	// 627 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x4f, 0x6b, 0xd4, 0x4e,
	0x18, 0xfe, 0x25, 0x85, 0x42, 0x67, 0x7f, 0x22, 0x8c, 0x54, 0xd3, 0x55, 0x70, 0x89, 0x15, 0xcb,
	0xa2, 0x19, 0xb2, 0x22, 0x95, 0xb4, 0x45, 0xb2, 0x97, 0x6d, 0x0f, 0x6a, 0x49, 0x71, 0x0f, 0x65,
	0x61, 0xc9, 0x26, 0x63, 0x0c, 0x24, 0x99, 0x98, 0x99, 0xec, 0xa5, 0xf4, 0xe2, 0xcd, 0xb3, 0x67,
	0x2f, 0x1e, 0xfd, 0x1e, 0x5e, 0x7a, 0xf5, 0xd6, 0x53, 0x41, 0xf1, 0xe0, 0x47, 0xf0, 0xa2, 0x24,
	0x33, 0xb3, 0x9b, 0xd8, 0x2c, 0x8b, 0xbd, 0xbd, 0xc9, 0xfb, 0xbc, 0xcf, 0xf3, 0xfe, 0x1d, 0xb0,
	0x1b, 0x10, 0x12, 0x44, 0x18, 0xb9, 0x3e, 0x45, 0xdc, 0x2c, 0xac, 0xa9, 0x89, 0x28, 0xce, 0xa6,
	0xa1, 0x87, 0x29, 0x9a, 0x84, 0x51, 0x14, 0x26, 0xc1, 0x98, 0x62, 0x96, 0xa7, 0x63, 0xf1, 0xdb,
	0x48, 0x33, 0xc2, 0x08, 0xec, 0xf0, 0x10, 0xc3, 0xf5, 0xa9, 0x31, 0x8b, 0x36, 0xa6, 0xa6, 0x21,
	0xa3, 0xdb, 0x4f, 0x16, 0xf1, 0x67, 0x98, 0x92, 0x3c, 0xbb, 0x24, 0xc0, 0x89, 0xdb, 0x77, 0x64,
	0x58, 0x1a, 0x22, 0x37, 0x49, 0x08, 0x73, 0x59, 0x48, 0x12, 0x2a, 0xbc, 0xb7, 0x2a, 0x5e, 0x2f,
	0x0a, 0x71, 0xc2, 0x84, 0xe3, 0x6e, 0xc5, 0xf1, 0x3a, 0xc4, 0x91, 0x3f, 0x9e, 0xe0, 0x37, 0xee,
	0x34, 0x24, 0x99, 0x00, 0x6c, 0x54, 0x00, 0x32, 0x03, 0xee, 0xd2, 0x23, 0x70, 0x73, 0x80, 0x59,
	0x9f, 0x27, 0x73, 0x54, 0xe4, 0xe2, 0xe0, 0xb7, 0x39, 0xa6, 0x0c, 0x3a, 0xe0, 0x9a, 0xc4, 0x8e,
	0x13, 0x37, 0xc6, 0x9a, 0xd2, 0x51, 0xb6, 0xd6, 0xfa, 0x8f, 0x2e, 0x6c, 0xf5, 0x97, 0xfd, 0x00,
	0xdc, 0x9f, 0x57, 0x2e, 0xac, 0x34, 0xa4, 0x86, 0x47, 0x62, 0x54, 0x23, 0xfb, 0x5f, 0x72, 0xbc,
	0x70, 0x63, 0xac, 0x7f, 0x54, 0xc0, 0xc6, 0xf3, 0x9c, 0xb9, 0x0c, 0x37, 0x29, 0x6e, 0x82, 0x96,
	0x97, 0x53, 0x46, 0x62, 0x9c, 0x8d, 0x43, 0x5f, 0xe8, 0xad, 0x5c, 0xd8, 0xaa, 0x03, 0xe4, 0xff,
	0x03, 0x1f, 0x1e, 0x83, 0x35, 0x92, 0xe2, 0xac, 0x6c, 0x8d, 0xa6, 0x76, 0x94, 0xad, 0x56, 0x6f,
	0xdb, 0x58, 0x36, 0x11, 0xa3, 0xaa, 0xf7, 0x52, 0x86, 0x73, 0xf2, 0x39, 0x9d, 0xfe, 0x5e, 0x01,
	0xeb, 0x8d, 0x48, 0x78, 0x00, 0x56, 0xbd, 0x0c, 0xbb, 0x0c, 0x0b, 0x49, 0xb4, 0x50, 0x72, 0x36,
	0xe2, 0x9a, 0xe6, 0xfe, 0x7f, 0x8e, 0x20, 0x80, 0x1a, 0x58, 0xcd, 0x70, 0x4c, 0xa6, 0xa2, 0xa3,
	0x85, 0x87, 0x7f, 0xf7, 0x5b, 0x95, 0xd2, 0xf4, 0x14, 0xb4, 0x9b, 0x5a, 0x45, 0x53, 0x92, 0x50,
	0x0c, 0x9d, 0x82, 0x84, 0xe6, 0x11, 0x2b, 0x49, 0x5a, 0x3d, 0x6b, 0x79, 0x0b, 0x1a, 0xd9, 0xf2,
	0x88, 0x39, 0x82, 0x49, 0x7f, 0x06, 0xb4, 0x45, 0x18, 0x78, 0xaf, 0x71, 0x1b, 0xea, 0xe3, 0xed,
	0x7d, 0x5b, 0x01, 0x37, 0xaa, 0xb1, 0x47, 0x5c, 0x1a, 0x7e, 0x51, 0xc0, 0xf5, 0xbf, 0xb6, 0x0c,
	0x3e, 0x5d, 0x9e, 0x70, 0xf3, 0x62, 0xb6, 0xff, 0xb5, 0xf5, 0xfa, 0xe0, 0xdc, 0xae, 0x27, 0xff,
	0xee, 0xeb, 0xf7, 0x0f, 0xaa, 0x09, 0x51, 0x71, 0x91, 0x27, 0x35, 0xcf, 0x9e, 0x5c, 0x34, 0x8a,
	0xba, 0xf2, 0x44, 0x4b, 0x12, 0x8a, 0xba, 0xa7, 0xf0, 0x87, 0x02, 0xe0, 0xe5, 0x0e, 0xc1, 0x9d,
	0xab, 0xf5, 0x9e, 0x57, 0xb3, 0x7b, 0xc5, 0xc1, 0x95, 0x6b, 0xa0, 0xbf, 0x3a, 0xb7, 0xd7, 0x2b,
	0x37, 0xf3, 0x70, 0xb6, 0x3e, 0x65, 0x89, 0xdb, 0x7a, 0xaf, 0x28, 0x71, 0x5e, 0xd3, 0x49, 0x05,
	0xbb, 0xd7, 0x3d, 0xad, 0x57, 0x68, 0xc5, 0xa5, 0x8e, 0xa5, 0x74, 0xdb, 0xb7, 0xcf, 0x6c, 0x6d,
	0xd1, 0x7d, 0xf7, 0x7f, 0x2b, 0x60, 0xd3, 0x23, 0xf1, 0xd2, 0xbc, 0xfb, 0x5a, 0xc3, 0x2e, 0x1c,
	0x16, 0xaf, 0xce, 0xa1, 0x72, 0xbc, 0x2f, 0xa2, 0x03, 0x12, 0xb9, 0x49, 0x60, 0x90, 0x2c, 0x40,
	0x01, 0x4e, 0xca, 0x37, 0x09, 0xcd, 0xf5, 0x16, 0x3f, 0xd0, 0x3b, 0xd2, 0xf8, 0xa4, 0xae, 0x0c,
	0x6c, 0xfb, 0xb3, 0xda, 0x19, 0x70, 0x42, 0xdb, 0xa7, 0x06, 0x37, 0x0b, 0x6b, 0x68, 0x1a, 0x42,
	0x98, 0x9e, 0x49, 0xc8, 0xc8, 0xf6, 0xe9, 0x68, 0x06, 0x19, 0x0d, 0xcd, 0x91, 0x84, 0xfc, 0x54,
	0x37, 0xf9, 0x7f, 0xcb, 0xb2, 0x7d, 0x6a, 0x59, 0x33, 0x90, 0x65, 0x0d, 0x4d, 0xcb, 0x92, 0xb0,
	0xc9, 0x6a, 0x99, 0xe7, 0xe3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc1, 0xdd, 0x3a, 0x5d, 0x47,
	0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BillingSetupServiceClient is the client API for BillingSetupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BillingSetupServiceClient interface {
	// Returns a billing setup.
	GetBillingSetup(ctx context.Context, in *GetBillingSetupRequest, opts ...grpc.CallOption) (*resources.BillingSetup, error)
	// Creates a billing setup, or cancels an existing billing setup.
	MutateBillingSetup(ctx context.Context, in *MutateBillingSetupRequest, opts ...grpc.CallOption) (*MutateBillingSetupResponse, error)
}

type billingSetupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBillingSetupServiceClient(cc grpc.ClientConnInterface) BillingSetupServiceClient {
	return &billingSetupServiceClient{cc}
}

func (c *billingSetupServiceClient) GetBillingSetup(ctx context.Context, in *GetBillingSetupRequest, opts ...grpc.CallOption) (*resources.BillingSetup, error) {
	out := new(resources.BillingSetup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.BillingSetupService/GetBillingSetup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingSetupServiceClient) MutateBillingSetup(ctx context.Context, in *MutateBillingSetupRequest, opts ...grpc.CallOption) (*MutateBillingSetupResponse, error) {
	out := new(MutateBillingSetupResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.BillingSetupService/MutateBillingSetup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BillingSetupServiceServer is the server API for BillingSetupService service.
type BillingSetupServiceServer interface {
	// Returns a billing setup.
	GetBillingSetup(context.Context, *GetBillingSetupRequest) (*resources.BillingSetup, error)
	// Creates a billing setup, or cancels an existing billing setup.
	MutateBillingSetup(context.Context, *MutateBillingSetupRequest) (*MutateBillingSetupResponse, error)
}

// UnimplementedBillingSetupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBillingSetupServiceServer struct {
}

func (*UnimplementedBillingSetupServiceServer) GetBillingSetup(ctx context.Context, req *GetBillingSetupRequest) (*resources.BillingSetup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBillingSetup not implemented")
}
func (*UnimplementedBillingSetupServiceServer) MutateBillingSetup(ctx context.Context, req *MutateBillingSetupRequest) (*MutateBillingSetupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateBillingSetup not implemented")
}

func RegisterBillingSetupServiceServer(s *grpc.Server, srv BillingSetupServiceServer) {
	s.RegisterService(&_BillingSetupService_serviceDesc, srv)
}

func _BillingSetupService_GetBillingSetup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBillingSetupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingSetupServiceServer).GetBillingSetup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.BillingSetupService/GetBillingSetup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingSetupServiceServer).GetBillingSetup(ctx, req.(*GetBillingSetupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingSetupService_MutateBillingSetup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateBillingSetupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingSetupServiceServer).MutateBillingSetup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.BillingSetupService/MutateBillingSetup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingSetupServiceServer).MutateBillingSetup(ctx, req.(*MutateBillingSetupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BillingSetupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.BillingSetupService",
	HandlerType: (*BillingSetupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingSetup",
			Handler:    _BillingSetupService_GetBillingSetup_Handler,
		},
		{
			MethodName: "MutateBillingSetup",
			Handler:    _BillingSetupService_MutateBillingSetup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/billing_setup_service.proto",
}
