// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package logic

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/logic/mgmt/2018-07-01-preview/logic"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AgreementType = original.AgreementType

const (
	AS2          AgreementType = original.AS2
	Edifact      AgreementType = original.Edifact
	NotSpecified AgreementType = original.NotSpecified
	X12          AgreementType = original.X12
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type DaysOfWeek = original.DaysOfWeek

const (
	DaysOfWeekFriday    DaysOfWeek = original.DaysOfWeekFriday
	DaysOfWeekMonday    DaysOfWeek = original.DaysOfWeekMonday
	DaysOfWeekSaturday  DaysOfWeek = original.DaysOfWeekSaturday
	DaysOfWeekSunday    DaysOfWeek = original.DaysOfWeekSunday
	DaysOfWeekThursday  DaysOfWeek = original.DaysOfWeekThursday
	DaysOfWeekTuesday   DaysOfWeek = original.DaysOfWeekTuesday
	DaysOfWeekWednesday DaysOfWeek = original.DaysOfWeekWednesday
)

type EdifactCharacterSet = original.EdifactCharacterSet

const (
	EdifactCharacterSetKECA         EdifactCharacterSet = original.EdifactCharacterSetKECA
	EdifactCharacterSetNotSpecified EdifactCharacterSet = original.EdifactCharacterSetNotSpecified
	EdifactCharacterSetUNOA         EdifactCharacterSet = original.EdifactCharacterSetUNOA
	EdifactCharacterSetUNOB         EdifactCharacterSet = original.EdifactCharacterSetUNOB
	EdifactCharacterSetUNOC         EdifactCharacterSet = original.EdifactCharacterSetUNOC
	EdifactCharacterSetUNOD         EdifactCharacterSet = original.EdifactCharacterSetUNOD
	EdifactCharacterSetUNOE         EdifactCharacterSet = original.EdifactCharacterSetUNOE
	EdifactCharacterSetUNOF         EdifactCharacterSet = original.EdifactCharacterSetUNOF
	EdifactCharacterSetUNOG         EdifactCharacterSet = original.EdifactCharacterSetUNOG
	EdifactCharacterSetUNOH         EdifactCharacterSet = original.EdifactCharacterSetUNOH
	EdifactCharacterSetUNOI         EdifactCharacterSet = original.EdifactCharacterSetUNOI
	EdifactCharacterSetUNOJ         EdifactCharacterSet = original.EdifactCharacterSetUNOJ
	EdifactCharacterSetUNOK         EdifactCharacterSet = original.EdifactCharacterSetUNOK
	EdifactCharacterSetUNOX         EdifactCharacterSet = original.EdifactCharacterSetUNOX
	EdifactCharacterSetUNOY         EdifactCharacterSet = original.EdifactCharacterSetUNOY
)

type EdifactDecimalIndicator = original.EdifactDecimalIndicator

const (
	EdifactDecimalIndicatorComma        EdifactDecimalIndicator = original.EdifactDecimalIndicatorComma
	EdifactDecimalIndicatorDecimal      EdifactDecimalIndicator = original.EdifactDecimalIndicatorDecimal
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = original.EdifactDecimalIndicatorNotSpecified
)

type EncryptionAlgorithm = original.EncryptionAlgorithm

const (
	EncryptionAlgorithmAES128       EncryptionAlgorithm = original.EncryptionAlgorithmAES128
	EncryptionAlgorithmAES192       EncryptionAlgorithm = original.EncryptionAlgorithmAES192
	EncryptionAlgorithmAES256       EncryptionAlgorithm = original.EncryptionAlgorithmAES256
	EncryptionAlgorithmDES3         EncryptionAlgorithm = original.EncryptionAlgorithmDES3
	EncryptionAlgorithmNone         EncryptionAlgorithm = original.EncryptionAlgorithmNone
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = original.EncryptionAlgorithmNotSpecified
	EncryptionAlgorithmRC2          EncryptionAlgorithm = original.EncryptionAlgorithmRC2
)

type EventLevel = original.EventLevel

const (
	Critical      EventLevel = original.Critical
	Error         EventLevel = original.Error
	Informational EventLevel = original.Informational
	LogAlways     EventLevel = original.LogAlways
	Verbose       EventLevel = original.Verbose
	Warning       EventLevel = original.Warning
)

type HashingAlgorithm = original.HashingAlgorithm

const (
	HashingAlgorithmMD5          HashingAlgorithm = original.HashingAlgorithmMD5
	HashingAlgorithmNone         HashingAlgorithm = original.HashingAlgorithmNone
	HashingAlgorithmNotSpecified HashingAlgorithm = original.HashingAlgorithmNotSpecified
	HashingAlgorithmSHA1         HashingAlgorithm = original.HashingAlgorithmSHA1
	HashingAlgorithmSHA2256      HashingAlgorithm = original.HashingAlgorithmSHA2256
	HashingAlgorithmSHA2384      HashingAlgorithm = original.HashingAlgorithmSHA2384
	HashingAlgorithmSHA2512      HashingAlgorithm = original.HashingAlgorithmSHA2512
)

type IntegrationAccountSkuName = original.IntegrationAccountSkuName

const (
	IntegrationAccountSkuNameBasic        IntegrationAccountSkuName = original.IntegrationAccountSkuNameBasic
	IntegrationAccountSkuNameFree         IntegrationAccountSkuName = original.IntegrationAccountSkuNameFree
	IntegrationAccountSkuNameNotSpecified IntegrationAccountSkuName = original.IntegrationAccountSkuNameNotSpecified
	IntegrationAccountSkuNameStandard     IntegrationAccountSkuName = original.IntegrationAccountSkuNameStandard
)

type KeyType = original.KeyType

const (
	KeyTypeNotSpecified KeyType = original.KeyTypeNotSpecified
	KeyTypePrimary      KeyType = original.KeyTypePrimary
	KeyTypeSecondary    KeyType = original.KeyTypeSecondary
)

type MapType = original.MapType

const (
	MapTypeLiquid       MapType = original.MapTypeLiquid
	MapTypeNotSpecified MapType = original.MapTypeNotSpecified
	MapTypeXslt         MapType = original.MapTypeXslt
	MapTypeXslt20       MapType = original.MapTypeXslt20
	MapTypeXslt30       MapType = original.MapTypeXslt30
)

type MessageFilterType = original.MessageFilterType

const (
	MessageFilterTypeExclude      MessageFilterType = original.MessageFilterTypeExclude
	MessageFilterTypeInclude      MessageFilterType = original.MessageFilterTypeInclude
	MessageFilterTypeNotSpecified MessageFilterType = original.MessageFilterTypeNotSpecified
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray        ParameterType = original.ParameterTypeArray
	ParameterTypeBool         ParameterType = original.ParameterTypeBool
	ParameterTypeFloat        ParameterType = original.ParameterTypeFloat
	ParameterTypeInt          ParameterType = original.ParameterTypeInt
	ParameterTypeNotSpecified ParameterType = original.ParameterTypeNotSpecified
	ParameterTypeObject       ParameterType = original.ParameterTypeObject
	ParameterTypeSecureObject ParameterType = original.ParameterTypeSecureObject
	ParameterTypeSecureString ParameterType = original.ParameterTypeSecureString
	ParameterTypeString       ParameterType = original.ParameterTypeString
)

type PartnerType = original.PartnerType

const (
	PartnerTypeB2B          PartnerType = original.PartnerTypeB2B
	PartnerTypeNotSpecified PartnerType = original.PartnerTypeNotSpecified
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	RecurrenceFrequencyDay          RecurrenceFrequency = original.RecurrenceFrequencyDay
	RecurrenceFrequencyHour         RecurrenceFrequency = original.RecurrenceFrequencyHour
	RecurrenceFrequencyMinute       RecurrenceFrequency = original.RecurrenceFrequencyMinute
	RecurrenceFrequencyMonth        RecurrenceFrequency = original.RecurrenceFrequencyMonth
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = original.RecurrenceFrequencyNotSpecified
	RecurrenceFrequencySecond       RecurrenceFrequency = original.RecurrenceFrequencySecond
	RecurrenceFrequencyWeek         RecurrenceFrequency = original.RecurrenceFrequencyWeek
	RecurrenceFrequencyYear         RecurrenceFrequency = original.RecurrenceFrequencyYear
)

type SchemaType = original.SchemaType

const (
	SchemaTypeNotSpecified SchemaType = original.SchemaTypeNotSpecified
	SchemaTypeXML          SchemaType = original.SchemaTypeXML
)

type SegmentTerminatorSuffix = original.SegmentTerminatorSuffix

const (
	SegmentTerminatorSuffixCR           SegmentTerminatorSuffix = original.SegmentTerminatorSuffixCR
	SegmentTerminatorSuffixCRLF         SegmentTerminatorSuffix = original.SegmentTerminatorSuffixCRLF
	SegmentTerminatorSuffixLF           SegmentTerminatorSuffix = original.SegmentTerminatorSuffixLF
	SegmentTerminatorSuffixNone         SegmentTerminatorSuffix = original.SegmentTerminatorSuffixNone
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = original.SegmentTerminatorSuffixNotSpecified
)

type SigningAlgorithm = original.SigningAlgorithm

const (
	SigningAlgorithmDefault      SigningAlgorithm = original.SigningAlgorithmDefault
	SigningAlgorithmNotSpecified SigningAlgorithm = original.SigningAlgorithmNotSpecified
	SigningAlgorithmSHA1         SigningAlgorithm = original.SigningAlgorithmSHA1
	SigningAlgorithmSHA2256      SigningAlgorithm = original.SigningAlgorithmSHA2256
	SigningAlgorithmSHA2384      SigningAlgorithm = original.SigningAlgorithmSHA2384
	SigningAlgorithmSHA2512      SigningAlgorithm = original.SigningAlgorithmSHA2512
)

type SkuName = original.SkuName

const (
	SkuNameBasic        SkuName = original.SkuNameBasic
	SkuNameFree         SkuName = original.SkuNameFree
	SkuNameNotSpecified SkuName = original.SkuNameNotSpecified
	SkuNamePremium      SkuName = original.SkuNamePremium
	SkuNameShared       SkuName = original.SkuNameShared
	SkuNameStandard     SkuName = original.SkuNameStandard
)

type TrackEventsOperationOptions = original.TrackEventsOperationOptions

const (
	DisableSourceInfoEnrich TrackEventsOperationOptions = original.DisableSourceInfoEnrich
	None                    TrackEventsOperationOptions = original.None
)

type TrackingRecordType = original.TrackingRecordType

const (
	TrackingRecordTypeAS2MDN                               TrackingRecordType = original.TrackingRecordTypeAS2MDN
	TrackingRecordTypeAS2Message                           TrackingRecordType = original.TrackingRecordTypeAS2Message
	TrackingRecordTypeCustom                               TrackingRecordType = original.TrackingRecordTypeCustom
	TrackingRecordTypeEdifactFunctionalGroup               TrackingRecordType = original.TrackingRecordTypeEdifactFunctionalGroup
	TrackingRecordTypeEdifactFunctionalGroupAcknowledgment TrackingRecordType = original.TrackingRecordTypeEdifactFunctionalGroupAcknowledgment
	TrackingRecordTypeEdifactInterchange                   TrackingRecordType = original.TrackingRecordTypeEdifactInterchange
	TrackingRecordTypeEdifactInterchangeAcknowledgment     TrackingRecordType = original.TrackingRecordTypeEdifactInterchangeAcknowledgment
	TrackingRecordTypeEdifactTransactionSet                TrackingRecordType = original.TrackingRecordTypeEdifactTransactionSet
	TrackingRecordTypeEdifactTransactionSetAcknowledgment  TrackingRecordType = original.TrackingRecordTypeEdifactTransactionSetAcknowledgment
	TrackingRecordTypeNotSpecified                         TrackingRecordType = original.TrackingRecordTypeNotSpecified
	TrackingRecordTypeX12FunctionalGroup                   TrackingRecordType = original.TrackingRecordTypeX12FunctionalGroup
	TrackingRecordTypeX12FunctionalGroupAcknowledgment     TrackingRecordType = original.TrackingRecordTypeX12FunctionalGroupAcknowledgment
	TrackingRecordTypeX12Interchange                       TrackingRecordType = original.TrackingRecordTypeX12Interchange
	TrackingRecordTypeX12InterchangeAcknowledgment         TrackingRecordType = original.TrackingRecordTypeX12InterchangeAcknowledgment
	TrackingRecordTypeX12TransactionSet                    TrackingRecordType = original.TrackingRecordTypeX12TransactionSet
	TrackingRecordTypeX12TransactionSetAcknowledgment      TrackingRecordType = original.TrackingRecordTypeX12TransactionSetAcknowledgment
)

type TrailingSeparatorPolicy = original.TrailingSeparatorPolicy

const (
	TrailingSeparatorPolicyMandatory    TrailingSeparatorPolicy = original.TrailingSeparatorPolicyMandatory
	TrailingSeparatorPolicyNotAllowed   TrailingSeparatorPolicy = original.TrailingSeparatorPolicyNotAllowed
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = original.TrailingSeparatorPolicyNotSpecified
	TrailingSeparatorPolicyOptional     TrailingSeparatorPolicy = original.TrailingSeparatorPolicyOptional
)

type UsageIndicator = original.UsageIndicator

const (
	UsageIndicatorInformation  UsageIndicator = original.UsageIndicatorInformation
	UsageIndicatorNotSpecified UsageIndicator = original.UsageIndicatorNotSpecified
	UsageIndicatorProduction   UsageIndicator = original.UsageIndicatorProduction
	UsageIndicatorTest         UsageIndicator = original.UsageIndicatorTest
)

type WorkflowProvisioningState = original.WorkflowProvisioningState

const (
	WorkflowProvisioningStateAccepted      WorkflowProvisioningState = original.WorkflowProvisioningStateAccepted
	WorkflowProvisioningStateCanceled      WorkflowProvisioningState = original.WorkflowProvisioningStateCanceled
	WorkflowProvisioningStateCompleted     WorkflowProvisioningState = original.WorkflowProvisioningStateCompleted
	WorkflowProvisioningStateCreated       WorkflowProvisioningState = original.WorkflowProvisioningStateCreated
	WorkflowProvisioningStateCreating      WorkflowProvisioningState = original.WorkflowProvisioningStateCreating
	WorkflowProvisioningStateDeleted       WorkflowProvisioningState = original.WorkflowProvisioningStateDeleted
	WorkflowProvisioningStateDeleting      WorkflowProvisioningState = original.WorkflowProvisioningStateDeleting
	WorkflowProvisioningStateFailed        WorkflowProvisioningState = original.WorkflowProvisioningStateFailed
	WorkflowProvisioningStateMoving        WorkflowProvisioningState = original.WorkflowProvisioningStateMoving
	WorkflowProvisioningStateNotSpecified  WorkflowProvisioningState = original.WorkflowProvisioningStateNotSpecified
	WorkflowProvisioningStateReady         WorkflowProvisioningState = original.WorkflowProvisioningStateReady
	WorkflowProvisioningStateRegistered    WorkflowProvisioningState = original.WorkflowProvisioningStateRegistered
	WorkflowProvisioningStateRegistering   WorkflowProvisioningState = original.WorkflowProvisioningStateRegistering
	WorkflowProvisioningStateRunning       WorkflowProvisioningState = original.WorkflowProvisioningStateRunning
	WorkflowProvisioningStateSucceeded     WorkflowProvisioningState = original.WorkflowProvisioningStateSucceeded
	WorkflowProvisioningStateUnregistered  WorkflowProvisioningState = original.WorkflowProvisioningStateUnregistered
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = original.WorkflowProvisioningStateUnregistering
	WorkflowProvisioningStateUpdating      WorkflowProvisioningState = original.WorkflowProvisioningStateUpdating
)

type WorkflowState = original.WorkflowState

const (
	WorkflowStateCompleted    WorkflowState = original.WorkflowStateCompleted
	WorkflowStateDeleted      WorkflowState = original.WorkflowStateDeleted
	WorkflowStateDisabled     WorkflowState = original.WorkflowStateDisabled
	WorkflowStateEnabled      WorkflowState = original.WorkflowStateEnabled
	WorkflowStateNotSpecified WorkflowState = original.WorkflowStateNotSpecified
	WorkflowStateSuspended    WorkflowState = original.WorkflowStateSuspended
)

type WorkflowStatus = original.WorkflowStatus

const (
	WorkflowStatusAborted      WorkflowStatus = original.WorkflowStatusAborted
	WorkflowStatusCancelled    WorkflowStatus = original.WorkflowStatusCancelled
	WorkflowStatusFailed       WorkflowStatus = original.WorkflowStatusFailed
	WorkflowStatusFaulted      WorkflowStatus = original.WorkflowStatusFaulted
	WorkflowStatusIgnored      WorkflowStatus = original.WorkflowStatusIgnored
	WorkflowStatusNotSpecified WorkflowStatus = original.WorkflowStatusNotSpecified
	WorkflowStatusPaused       WorkflowStatus = original.WorkflowStatusPaused
	WorkflowStatusRunning      WorkflowStatus = original.WorkflowStatusRunning
	WorkflowStatusSkipped      WorkflowStatus = original.WorkflowStatusSkipped
	WorkflowStatusSucceeded    WorkflowStatus = original.WorkflowStatusSucceeded
	WorkflowStatusSuspended    WorkflowStatus = original.WorkflowStatusSuspended
	WorkflowStatusTimedOut     WorkflowStatus = original.WorkflowStatusTimedOut
	WorkflowStatusWaiting      WorkflowStatus = original.WorkflowStatusWaiting
)

type WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningState

const (
	WorkflowTriggerProvisioningStateAccepted      WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateAccepted
	WorkflowTriggerProvisioningStateCanceled      WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateCanceled
	WorkflowTriggerProvisioningStateCompleted     WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateCompleted
	WorkflowTriggerProvisioningStateCreated       WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateCreated
	WorkflowTriggerProvisioningStateCreating      WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateCreating
	WorkflowTriggerProvisioningStateDeleted       WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateDeleted
	WorkflowTriggerProvisioningStateDeleting      WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateDeleting
	WorkflowTriggerProvisioningStateFailed        WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateFailed
	WorkflowTriggerProvisioningStateMoving        WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateMoving
	WorkflowTriggerProvisioningStateNotSpecified  WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateNotSpecified
	WorkflowTriggerProvisioningStateReady         WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateReady
	WorkflowTriggerProvisioningStateRegistered    WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateRegistered
	WorkflowTriggerProvisioningStateRegistering   WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateRegistering
	WorkflowTriggerProvisioningStateRunning       WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateRunning
	WorkflowTriggerProvisioningStateSucceeded     WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateSucceeded
	WorkflowTriggerProvisioningStateUnregistered  WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateUnregistered
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateUnregistering
	WorkflowTriggerProvisioningStateUpdating      WorkflowTriggerProvisioningState = original.WorkflowTriggerProvisioningStateUpdating
)

type X12CharacterSet = original.X12CharacterSet

const (
	X12CharacterSetBasic        X12CharacterSet = original.X12CharacterSetBasic
	X12CharacterSetExtended     X12CharacterSet = original.X12CharacterSetExtended
	X12CharacterSetNotSpecified X12CharacterSet = original.X12CharacterSetNotSpecified
	X12CharacterSetUTF8         X12CharacterSet = original.X12CharacterSetUTF8
)

type X12DateFormat = original.X12DateFormat

const (
	X12DateFormatCCYYMMDD     X12DateFormat = original.X12DateFormatCCYYMMDD
	X12DateFormatNotSpecified X12DateFormat = original.X12DateFormatNotSpecified
	X12DateFormatYYMMDD       X12DateFormat = original.X12DateFormatYYMMDD
)

type X12TimeFormat = original.X12TimeFormat

const (
	X12TimeFormatHHMM         X12TimeFormat = original.X12TimeFormatHHMM
	X12TimeFormatHHMMSS       X12TimeFormat = original.X12TimeFormatHHMMSS
	X12TimeFormatHHMMSSd      X12TimeFormat = original.X12TimeFormatHHMMSSd
	X12TimeFormatHHMMSSdd     X12TimeFormat = original.X12TimeFormatHHMMSSdd
	X12TimeFormatNotSpecified X12TimeFormat = original.X12TimeFormatNotSpecified
)

type AS2AcknowledgementConnectionSettings = original.AS2AcknowledgementConnectionSettings
type AS2AgreementContent = original.AS2AgreementContent
type AS2EnvelopeSettings = original.AS2EnvelopeSettings
type AS2ErrorSettings = original.AS2ErrorSettings
type AS2MdnSettings = original.AS2MdnSettings
type AS2MessageConnectionSettings = original.AS2MessageConnectionSettings
type AS2OneWayAgreement = original.AS2OneWayAgreement
type AS2ProtocolSettings = original.AS2ProtocolSettings
type AS2SecuritySettings = original.AS2SecuritySettings
type AS2ValidationSettings = original.AS2ValidationSettings
type AgreementContent = original.AgreementContent
type ArtifactContentPropertiesDefinition = original.ArtifactContentPropertiesDefinition
type ArtifactProperties = original.ArtifactProperties
type AssemblyCollection = original.AssemblyCollection
type AssemblyDefinition = original.AssemblyDefinition
type AssemblyProperties = original.AssemblyProperties
type AzureResourceErrorInfo = original.AzureResourceErrorInfo
type B2BPartnerContent = original.B2BPartnerContent
type BaseClient = original.BaseClient
type BatchConfiguration = original.BatchConfiguration
type BatchConfigurationCollection = original.BatchConfigurationCollection
type BatchConfigurationProperties = original.BatchConfigurationProperties
type BatchReleaseCriteria = original.BatchReleaseCriteria
type BusinessIdentity = original.BusinessIdentity
type CallbackURL = original.CallbackURL
type ContentHash = original.ContentHash
type ContentLink = original.ContentLink
type Correlation = original.Correlation
type EdifactAcknowledgementSettings = original.EdifactAcknowledgementSettings
type EdifactAgreementContent = original.EdifactAgreementContent
type EdifactDelimiterOverride = original.EdifactDelimiterOverride
type EdifactEnvelopeOverride = original.EdifactEnvelopeOverride
type EdifactEnvelopeSettings = original.EdifactEnvelopeSettings
type EdifactFramingSettings = original.EdifactFramingSettings
type EdifactMessageFilter = original.EdifactMessageFilter
type EdifactMessageIdentifier = original.EdifactMessageIdentifier
type EdifactOneWayAgreement = original.EdifactOneWayAgreement
type EdifactProcessingSettings = original.EdifactProcessingSettings
type EdifactProtocolSettings = original.EdifactProtocolSettings
type EdifactSchemaReference = original.EdifactSchemaReference
type EdifactValidationOverride = original.EdifactValidationOverride
type EdifactValidationSettings = original.EdifactValidationSettings
type ErrorInfo = original.ErrorInfo
type ErrorProperties = original.ErrorProperties
type ErrorResponse = original.ErrorResponse
type Expression = original.Expression
type ExpressionRoot = original.ExpressionRoot
type ExpressionTraces = original.ExpressionTraces
type GenerateUpgradedDefinitionParameters = original.GenerateUpgradedDefinitionParameters
type GetCallbackURLParameters = original.GetCallbackURLParameters
type IntegrationAccount = original.IntegrationAccount
type IntegrationAccountAgreement = original.IntegrationAccountAgreement
type IntegrationAccountAgreementFilter = original.IntegrationAccountAgreementFilter
type IntegrationAccountAgreementListResult = original.IntegrationAccountAgreementListResult
type IntegrationAccountAgreementListResultIterator = original.IntegrationAccountAgreementListResultIterator
type IntegrationAccountAgreementListResultPage = original.IntegrationAccountAgreementListResultPage
type IntegrationAccountAgreementProperties = original.IntegrationAccountAgreementProperties
type IntegrationAccountAgreementsClient = original.IntegrationAccountAgreementsClient
type IntegrationAccountAssembliesClient = original.IntegrationAccountAssembliesClient
type IntegrationAccountBatchConfigurationsClient = original.IntegrationAccountBatchConfigurationsClient
type IntegrationAccountCertificate = original.IntegrationAccountCertificate
type IntegrationAccountCertificateListResult = original.IntegrationAccountCertificateListResult
type IntegrationAccountCertificateListResultIterator = original.IntegrationAccountCertificateListResultIterator
type IntegrationAccountCertificateListResultPage = original.IntegrationAccountCertificateListResultPage
type IntegrationAccountCertificateProperties = original.IntegrationAccountCertificateProperties
type IntegrationAccountCertificatesClient = original.IntegrationAccountCertificatesClient
type IntegrationAccountListResult = original.IntegrationAccountListResult
type IntegrationAccountListResultIterator = original.IntegrationAccountListResultIterator
type IntegrationAccountListResultPage = original.IntegrationAccountListResultPage
type IntegrationAccountMap = original.IntegrationAccountMap
type IntegrationAccountMapFilter = original.IntegrationAccountMapFilter
type IntegrationAccountMapListResult = original.IntegrationAccountMapListResult
type IntegrationAccountMapListResultIterator = original.IntegrationAccountMapListResultIterator
type IntegrationAccountMapListResultPage = original.IntegrationAccountMapListResultPage
type IntegrationAccountMapProperties = original.IntegrationAccountMapProperties
type IntegrationAccountMapPropertiesParametersSchema = original.IntegrationAccountMapPropertiesParametersSchema
type IntegrationAccountMapsClient = original.IntegrationAccountMapsClient
type IntegrationAccountPartner = original.IntegrationAccountPartner
type IntegrationAccountPartnerFilter = original.IntegrationAccountPartnerFilter
type IntegrationAccountPartnerListResult = original.IntegrationAccountPartnerListResult
type IntegrationAccountPartnerListResultIterator = original.IntegrationAccountPartnerListResultIterator
type IntegrationAccountPartnerListResultPage = original.IntegrationAccountPartnerListResultPage
type IntegrationAccountPartnerProperties = original.IntegrationAccountPartnerProperties
type IntegrationAccountPartnersClient = original.IntegrationAccountPartnersClient
type IntegrationAccountSchema = original.IntegrationAccountSchema
type IntegrationAccountSchemaFilter = original.IntegrationAccountSchemaFilter
type IntegrationAccountSchemaListResult = original.IntegrationAccountSchemaListResult
type IntegrationAccountSchemaListResultIterator = original.IntegrationAccountSchemaListResultIterator
type IntegrationAccountSchemaListResultPage = original.IntegrationAccountSchemaListResultPage
type IntegrationAccountSchemaProperties = original.IntegrationAccountSchemaProperties
type IntegrationAccountSchemasClient = original.IntegrationAccountSchemasClient
type IntegrationAccountSession = original.IntegrationAccountSession
type IntegrationAccountSessionFilter = original.IntegrationAccountSessionFilter
type IntegrationAccountSessionListResult = original.IntegrationAccountSessionListResult
type IntegrationAccountSessionListResultIterator = original.IntegrationAccountSessionListResultIterator
type IntegrationAccountSessionListResultPage = original.IntegrationAccountSessionListResultPage
type IntegrationAccountSessionProperties = original.IntegrationAccountSessionProperties
type IntegrationAccountSessionsClient = original.IntegrationAccountSessionsClient
type IntegrationAccountSku = original.IntegrationAccountSku
type IntegrationAccountsClient = original.IntegrationAccountsClient
type JSONSchema = original.JSONSchema
type KeyVaultKey = original.KeyVaultKey
type KeyVaultKeyAttributes = original.KeyVaultKeyAttributes
type KeyVaultKeyCollection = original.KeyVaultKeyCollection
type KeyVaultKeyReference = original.KeyVaultKeyReference
type KeyVaultKeyReferenceKeyVault = original.KeyVaultKeyReferenceKeyVault
type KeyVaultReference = original.KeyVaultReference
type ListKeyVaultKeysDefinition = original.ListKeyVaultKeysDefinition
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResult = original.OperationResult
type OperationResultProperties = original.OperationResultProperties
type OperationsClient = original.OperationsClient
type PartnerContent = original.PartnerContent
type RecurrenceSchedule = original.RecurrenceSchedule
type RecurrenceScheduleOccurrence = original.RecurrenceScheduleOccurrence
type RegenerateActionParameter = original.RegenerateActionParameter
type RepetitionIndex = original.RepetitionIndex
type Request = original.Request
type RequestHistory = original.RequestHistory
type RequestHistoryListResult = original.RequestHistoryListResult
type RequestHistoryListResultIterator = original.RequestHistoryListResultIterator
type RequestHistoryListResultPage = original.RequestHistoryListResultPage
type RequestHistoryProperties = original.RequestHistoryProperties
type Resource = original.Resource
type ResourceReference = original.ResourceReference
type Response = original.Response
type RetryHistory = original.RetryHistory
type RunActionCorrelation = original.RunActionCorrelation
type RunCorrelation = original.RunCorrelation
type SetObject = original.SetObject
type SetTriggerStateActionDefinition = original.SetTriggerStateActionDefinition
type Sku = original.Sku
type SubResource = original.SubResource
type TrackingEvent = original.TrackingEvent
type TrackingEventErrorInfo = original.TrackingEventErrorInfo
type TrackingEventsDefinition = original.TrackingEventsDefinition
type Workflow = original.Workflow
type WorkflowFilter = original.WorkflowFilter
type WorkflowListResult = original.WorkflowListResult
type WorkflowListResultIterator = original.WorkflowListResultIterator
type WorkflowListResultPage = original.WorkflowListResultPage
type WorkflowOutputParameter = original.WorkflowOutputParameter
type WorkflowParameter = original.WorkflowParameter
type WorkflowProperties = original.WorkflowProperties
type WorkflowRun = original.WorkflowRun
type WorkflowRunAction = original.WorkflowRunAction
type WorkflowRunActionFilter = original.WorkflowRunActionFilter
type WorkflowRunActionListResult = original.WorkflowRunActionListResult
type WorkflowRunActionListResultIterator = original.WorkflowRunActionListResultIterator
type WorkflowRunActionListResultPage = original.WorkflowRunActionListResultPage
type WorkflowRunActionProperties = original.WorkflowRunActionProperties
type WorkflowRunActionRepetitionDefinition = original.WorkflowRunActionRepetitionDefinition
type WorkflowRunActionRepetitionDefinitionCollection = original.WorkflowRunActionRepetitionDefinitionCollection
type WorkflowRunActionRepetitionProperties = original.WorkflowRunActionRepetitionProperties
type WorkflowRunActionRepetitionsClient = original.WorkflowRunActionRepetitionsClient
type WorkflowRunActionRepetitionsRequestHistoriesClient = original.WorkflowRunActionRepetitionsRequestHistoriesClient
type WorkflowRunActionRequestHistoriesClient = original.WorkflowRunActionRequestHistoriesClient
type WorkflowRunActionScopeRepetitionsClient = original.WorkflowRunActionScopeRepetitionsClient
type WorkflowRunActionsClient = original.WorkflowRunActionsClient
type WorkflowRunFilter = original.WorkflowRunFilter
type WorkflowRunListResult = original.WorkflowRunListResult
type WorkflowRunListResultIterator = original.WorkflowRunListResultIterator
type WorkflowRunListResultPage = original.WorkflowRunListResultPage
type WorkflowRunOperationsClient = original.WorkflowRunOperationsClient
type WorkflowRunProperties = original.WorkflowRunProperties
type WorkflowRunTrigger = original.WorkflowRunTrigger
type WorkflowRunsClient = original.WorkflowRunsClient
type WorkflowTrigger = original.WorkflowTrigger
type WorkflowTriggerCallbackURL = original.WorkflowTriggerCallbackURL
type WorkflowTriggerFilter = original.WorkflowTriggerFilter
type WorkflowTriggerHistoriesClient = original.WorkflowTriggerHistoriesClient
type WorkflowTriggerHistory = original.WorkflowTriggerHistory
type WorkflowTriggerHistoryFilter = original.WorkflowTriggerHistoryFilter
type WorkflowTriggerHistoryListResult = original.WorkflowTriggerHistoryListResult
type WorkflowTriggerHistoryListResultIterator = original.WorkflowTriggerHistoryListResultIterator
type WorkflowTriggerHistoryListResultPage = original.WorkflowTriggerHistoryListResultPage
type WorkflowTriggerHistoryProperties = original.WorkflowTriggerHistoryProperties
type WorkflowTriggerListCallbackURLQueries = original.WorkflowTriggerListCallbackURLQueries
type WorkflowTriggerListResult = original.WorkflowTriggerListResult
type WorkflowTriggerListResultIterator = original.WorkflowTriggerListResultIterator
type WorkflowTriggerListResultPage = original.WorkflowTriggerListResultPage
type WorkflowTriggerProperties = original.WorkflowTriggerProperties
type WorkflowTriggerRecurrence = original.WorkflowTriggerRecurrence
type WorkflowTriggersClient = original.WorkflowTriggersClient
type WorkflowVersion = original.WorkflowVersion
type WorkflowVersionListResult = original.WorkflowVersionListResult
type WorkflowVersionListResultIterator = original.WorkflowVersionListResultIterator
type WorkflowVersionListResultPage = original.WorkflowVersionListResultPage
type WorkflowVersionProperties = original.WorkflowVersionProperties
type WorkflowVersionTriggersClient = original.WorkflowVersionTriggersClient
type WorkflowVersionsClient = original.WorkflowVersionsClient
type WorkflowsClient = original.WorkflowsClient
type X12AcknowledgementSettings = original.X12AcknowledgementSettings
type X12AgreementContent = original.X12AgreementContent
type X12DelimiterOverrides = original.X12DelimiterOverrides
type X12EnvelopeOverride = original.X12EnvelopeOverride
type X12EnvelopeSettings = original.X12EnvelopeSettings
type X12FramingSettings = original.X12FramingSettings
type X12MessageFilter = original.X12MessageFilter
type X12MessageIdentifier = original.X12MessageIdentifier
type X12OneWayAgreement = original.X12OneWayAgreement
type X12ProcessingSettings = original.X12ProcessingSettings
type X12ProtocolSettings = original.X12ProtocolSettings
type X12SchemaReference = original.X12SchemaReference
type X12SecuritySettings = original.X12SecuritySettings
type X12ValidationOverride = original.X12ValidationOverride
type X12ValidationSettings = original.X12ValidationSettings

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewIntegrationAccountAgreementListResultIterator(page IntegrationAccountAgreementListResultPage) IntegrationAccountAgreementListResultIterator {
	return original.NewIntegrationAccountAgreementListResultIterator(page)
}
func NewIntegrationAccountAgreementListResultPage(getNextPage func(context.Context, IntegrationAccountAgreementListResult) (IntegrationAccountAgreementListResult, error)) IntegrationAccountAgreementListResultPage {
	return original.NewIntegrationAccountAgreementListResultPage(getNextPage)
}
func NewIntegrationAccountAgreementsClient(subscriptionID string) IntegrationAccountAgreementsClient {
	return original.NewIntegrationAccountAgreementsClient(subscriptionID)
}
func NewIntegrationAccountAgreementsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountAgreementsClient {
	return original.NewIntegrationAccountAgreementsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountAssembliesClient(subscriptionID string) IntegrationAccountAssembliesClient {
	return original.NewIntegrationAccountAssembliesClient(subscriptionID)
}
func NewIntegrationAccountAssembliesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountAssembliesClient {
	return original.NewIntegrationAccountAssembliesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountBatchConfigurationsClient(subscriptionID string) IntegrationAccountBatchConfigurationsClient {
	return original.NewIntegrationAccountBatchConfigurationsClient(subscriptionID)
}
func NewIntegrationAccountBatchConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountBatchConfigurationsClient {
	return original.NewIntegrationAccountBatchConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountCertificateListResultIterator(page IntegrationAccountCertificateListResultPage) IntegrationAccountCertificateListResultIterator {
	return original.NewIntegrationAccountCertificateListResultIterator(page)
}
func NewIntegrationAccountCertificateListResultPage(getNextPage func(context.Context, IntegrationAccountCertificateListResult) (IntegrationAccountCertificateListResult, error)) IntegrationAccountCertificateListResultPage {
	return original.NewIntegrationAccountCertificateListResultPage(getNextPage)
}
func NewIntegrationAccountCertificatesClient(subscriptionID string) IntegrationAccountCertificatesClient {
	return original.NewIntegrationAccountCertificatesClient(subscriptionID)
}
func NewIntegrationAccountCertificatesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountCertificatesClient {
	return original.NewIntegrationAccountCertificatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountListResultIterator(page IntegrationAccountListResultPage) IntegrationAccountListResultIterator {
	return original.NewIntegrationAccountListResultIterator(page)
}
func NewIntegrationAccountListResultPage(getNextPage func(context.Context, IntegrationAccountListResult) (IntegrationAccountListResult, error)) IntegrationAccountListResultPage {
	return original.NewIntegrationAccountListResultPage(getNextPage)
}
func NewIntegrationAccountMapListResultIterator(page IntegrationAccountMapListResultPage) IntegrationAccountMapListResultIterator {
	return original.NewIntegrationAccountMapListResultIterator(page)
}
func NewIntegrationAccountMapListResultPage(getNextPage func(context.Context, IntegrationAccountMapListResult) (IntegrationAccountMapListResult, error)) IntegrationAccountMapListResultPage {
	return original.NewIntegrationAccountMapListResultPage(getNextPage)
}
func NewIntegrationAccountMapsClient(subscriptionID string) IntegrationAccountMapsClient {
	return original.NewIntegrationAccountMapsClient(subscriptionID)
}
func NewIntegrationAccountMapsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountMapsClient {
	return original.NewIntegrationAccountMapsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountPartnerListResultIterator(page IntegrationAccountPartnerListResultPage) IntegrationAccountPartnerListResultIterator {
	return original.NewIntegrationAccountPartnerListResultIterator(page)
}
func NewIntegrationAccountPartnerListResultPage(getNextPage func(context.Context, IntegrationAccountPartnerListResult) (IntegrationAccountPartnerListResult, error)) IntegrationAccountPartnerListResultPage {
	return original.NewIntegrationAccountPartnerListResultPage(getNextPage)
}
func NewIntegrationAccountPartnersClient(subscriptionID string) IntegrationAccountPartnersClient {
	return original.NewIntegrationAccountPartnersClient(subscriptionID)
}
func NewIntegrationAccountPartnersClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountPartnersClient {
	return original.NewIntegrationAccountPartnersClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountSchemaListResultIterator(page IntegrationAccountSchemaListResultPage) IntegrationAccountSchemaListResultIterator {
	return original.NewIntegrationAccountSchemaListResultIterator(page)
}
func NewIntegrationAccountSchemaListResultPage(getNextPage func(context.Context, IntegrationAccountSchemaListResult) (IntegrationAccountSchemaListResult, error)) IntegrationAccountSchemaListResultPage {
	return original.NewIntegrationAccountSchemaListResultPage(getNextPage)
}
func NewIntegrationAccountSchemasClient(subscriptionID string) IntegrationAccountSchemasClient {
	return original.NewIntegrationAccountSchemasClient(subscriptionID)
}
func NewIntegrationAccountSchemasClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountSchemasClient {
	return original.NewIntegrationAccountSchemasClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountSessionListResultIterator(page IntegrationAccountSessionListResultPage) IntegrationAccountSessionListResultIterator {
	return original.NewIntegrationAccountSessionListResultIterator(page)
}
func NewIntegrationAccountSessionListResultPage(getNextPage func(context.Context, IntegrationAccountSessionListResult) (IntegrationAccountSessionListResult, error)) IntegrationAccountSessionListResultPage {
	return original.NewIntegrationAccountSessionListResultPage(getNextPage)
}
func NewIntegrationAccountSessionsClient(subscriptionID string) IntegrationAccountSessionsClient {
	return original.NewIntegrationAccountSessionsClient(subscriptionID)
}
func NewIntegrationAccountSessionsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountSessionsClient {
	return original.NewIntegrationAccountSessionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationAccountsClient(subscriptionID string) IntegrationAccountsClient {
	return original.NewIntegrationAccountsClient(subscriptionID)
}
func NewIntegrationAccountsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountsClient {
	return original.NewIntegrationAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRequestHistoryListResultIterator(page RequestHistoryListResultPage) RequestHistoryListResultIterator {
	return original.NewRequestHistoryListResultIterator(page)
}
func NewRequestHistoryListResultPage(getNextPage func(context.Context, RequestHistoryListResult) (RequestHistoryListResult, error)) RequestHistoryListResultPage {
	return original.NewRequestHistoryListResultPage(getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowListResultIterator(page WorkflowListResultPage) WorkflowListResultIterator {
	return original.NewWorkflowListResultIterator(page)
}
func NewWorkflowListResultPage(getNextPage func(context.Context, WorkflowListResult) (WorkflowListResult, error)) WorkflowListResultPage {
	return original.NewWorkflowListResultPage(getNextPage)
}
func NewWorkflowRunActionListResultIterator(page WorkflowRunActionListResultPage) WorkflowRunActionListResultIterator {
	return original.NewWorkflowRunActionListResultIterator(page)
}
func NewWorkflowRunActionListResultPage(getNextPage func(context.Context, WorkflowRunActionListResult) (WorkflowRunActionListResult, error)) WorkflowRunActionListResultPage {
	return original.NewWorkflowRunActionListResultPage(getNextPage)
}
func NewWorkflowRunActionRepetitionsClient(subscriptionID string) WorkflowRunActionRepetitionsClient {
	return original.NewWorkflowRunActionRepetitionsClient(subscriptionID)
}
func NewWorkflowRunActionRepetitionsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunActionRepetitionsClient {
	return original.NewWorkflowRunActionRepetitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunActionRepetitionsRequestHistoriesClient(subscriptionID string) WorkflowRunActionRepetitionsRequestHistoriesClient {
	return original.NewWorkflowRunActionRepetitionsRequestHistoriesClient(subscriptionID)
}
func NewWorkflowRunActionRepetitionsRequestHistoriesClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunActionRepetitionsRequestHistoriesClient {
	return original.NewWorkflowRunActionRepetitionsRequestHistoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunActionRequestHistoriesClient(subscriptionID string) WorkflowRunActionRequestHistoriesClient {
	return original.NewWorkflowRunActionRequestHistoriesClient(subscriptionID)
}
func NewWorkflowRunActionRequestHistoriesClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunActionRequestHistoriesClient {
	return original.NewWorkflowRunActionRequestHistoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunActionScopeRepetitionsClient(subscriptionID string) WorkflowRunActionScopeRepetitionsClient {
	return original.NewWorkflowRunActionScopeRepetitionsClient(subscriptionID)
}
func NewWorkflowRunActionScopeRepetitionsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunActionScopeRepetitionsClient {
	return original.NewWorkflowRunActionScopeRepetitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunActionsClient(subscriptionID string) WorkflowRunActionsClient {
	return original.NewWorkflowRunActionsClient(subscriptionID)
}
func NewWorkflowRunActionsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunActionsClient {
	return original.NewWorkflowRunActionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunListResultIterator(page WorkflowRunListResultPage) WorkflowRunListResultIterator {
	return original.NewWorkflowRunListResultIterator(page)
}
func NewWorkflowRunListResultPage(getNextPage func(context.Context, WorkflowRunListResult) (WorkflowRunListResult, error)) WorkflowRunListResultPage {
	return original.NewWorkflowRunListResultPage(getNextPage)
}
func NewWorkflowRunOperationsClient(subscriptionID string) WorkflowRunOperationsClient {
	return original.NewWorkflowRunOperationsClient(subscriptionID)
}
func NewWorkflowRunOperationsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunOperationsClient {
	return original.NewWorkflowRunOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowRunsClient(subscriptionID string) WorkflowRunsClient {
	return original.NewWorkflowRunsClient(subscriptionID)
}
func NewWorkflowRunsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowRunsClient {
	return original.NewWorkflowRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowTriggerHistoriesClient(subscriptionID string) WorkflowTriggerHistoriesClient {
	return original.NewWorkflowTriggerHistoriesClient(subscriptionID)
}
func NewWorkflowTriggerHistoriesClientWithBaseURI(baseURI string, subscriptionID string) WorkflowTriggerHistoriesClient {
	return original.NewWorkflowTriggerHistoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowTriggerHistoryListResultIterator(page WorkflowTriggerHistoryListResultPage) WorkflowTriggerHistoryListResultIterator {
	return original.NewWorkflowTriggerHistoryListResultIterator(page)
}
func NewWorkflowTriggerHistoryListResultPage(getNextPage func(context.Context, WorkflowTriggerHistoryListResult) (WorkflowTriggerHistoryListResult, error)) WorkflowTriggerHistoryListResultPage {
	return original.NewWorkflowTriggerHistoryListResultPage(getNextPage)
}
func NewWorkflowTriggerListResultIterator(page WorkflowTriggerListResultPage) WorkflowTriggerListResultIterator {
	return original.NewWorkflowTriggerListResultIterator(page)
}
func NewWorkflowTriggerListResultPage(getNextPage func(context.Context, WorkflowTriggerListResult) (WorkflowTriggerListResult, error)) WorkflowTriggerListResultPage {
	return original.NewWorkflowTriggerListResultPage(getNextPage)
}
func NewWorkflowTriggersClient(subscriptionID string) WorkflowTriggersClient {
	return original.NewWorkflowTriggersClient(subscriptionID)
}
func NewWorkflowTriggersClientWithBaseURI(baseURI string, subscriptionID string) WorkflowTriggersClient {
	return original.NewWorkflowTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowVersionListResultIterator(page WorkflowVersionListResultPage) WorkflowVersionListResultIterator {
	return original.NewWorkflowVersionListResultIterator(page)
}
func NewWorkflowVersionListResultPage(getNextPage func(context.Context, WorkflowVersionListResult) (WorkflowVersionListResult, error)) WorkflowVersionListResultPage {
	return original.NewWorkflowVersionListResultPage(getNextPage)
}
func NewWorkflowVersionTriggersClient(subscriptionID string) WorkflowVersionTriggersClient {
	return original.NewWorkflowVersionTriggersClient(subscriptionID)
}
func NewWorkflowVersionTriggersClientWithBaseURI(baseURI string, subscriptionID string) WorkflowVersionTriggersClient {
	return original.NewWorkflowVersionTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowVersionsClient(subscriptionID string) WorkflowVersionsClient {
	return original.NewWorkflowVersionsClient(subscriptionID)
}
func NewWorkflowVersionsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowVersionsClient {
	return original.NewWorkflowVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkflowsClient(subscriptionID string) WorkflowsClient {
	return original.NewWorkflowsClient(subscriptionID)
}
func NewWorkflowsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowsClient {
	return original.NewWorkflowsClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAgreementTypeValues() []AgreementType {
	return original.PossibleAgreementTypeValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return original.PossibleDaysOfWeekValues()
}
func PossibleEdifactCharacterSetValues() []EdifactCharacterSet {
	return original.PossibleEdifactCharacterSetValues()
}
func PossibleEdifactDecimalIndicatorValues() []EdifactDecimalIndicator {
	return original.PossibleEdifactDecimalIndicatorValues()
}
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return original.PossibleEncryptionAlgorithmValues()
}
func PossibleEventLevelValues() []EventLevel {
	return original.PossibleEventLevelValues()
}
func PossibleHashingAlgorithmValues() []HashingAlgorithm {
	return original.PossibleHashingAlgorithmValues()
}
func PossibleIntegrationAccountSkuNameValues() []IntegrationAccountSkuName {
	return original.PossibleIntegrationAccountSkuNameValues()
}
func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}
func PossibleMapTypeValues() []MapType {
	return original.PossibleMapTypeValues()
}
func PossibleMessageFilterTypeValues() []MessageFilterType {
	return original.PossibleMessageFilterTypeValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossiblePartnerTypeValues() []PartnerType {
	return original.PossiblePartnerTypeValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleSchemaTypeValues() []SchemaType {
	return original.PossibleSchemaTypeValues()
}
func PossibleSegmentTerminatorSuffixValues() []SegmentTerminatorSuffix {
	return original.PossibleSegmentTerminatorSuffixValues()
}
func PossibleSigningAlgorithmValues() []SigningAlgorithm {
	return original.PossibleSigningAlgorithmValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleTrackEventsOperationOptionsValues() []TrackEventsOperationOptions {
	return original.PossibleTrackEventsOperationOptionsValues()
}
func PossibleTrackingRecordTypeValues() []TrackingRecordType {
	return original.PossibleTrackingRecordTypeValues()
}
func PossibleTrailingSeparatorPolicyValues() []TrailingSeparatorPolicy {
	return original.PossibleTrailingSeparatorPolicyValues()
}
func PossibleUsageIndicatorValues() []UsageIndicator {
	return original.PossibleUsageIndicatorValues()
}
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return original.PossibleWorkflowProvisioningStateValues()
}
func PossibleWorkflowStateValues() []WorkflowState {
	return original.PossibleWorkflowStateValues()
}
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return original.PossibleWorkflowStatusValues()
}
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return original.PossibleWorkflowTriggerProvisioningStateValues()
}
func PossibleX12CharacterSetValues() []X12CharacterSet {
	return original.PossibleX12CharacterSetValues()
}
func PossibleX12DateFormatValues() []X12DateFormat {
	return original.PossibleX12DateFormatValues()
}
func PossibleX12TimeFormatValues() []X12TimeFormat {
	return original.PossibleX12TimeFormatValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
