// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53domains provides a client for Amazon Route 53 Domains.
package route53domains

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCheckDomainAvailability = "CheckDomainAvailability"

// CheckDomainAvailabilityRequest generates a request for the CheckDomainAvailability operation.
func (c *Route53Domains) CheckDomainAvailabilityRequest(input *CheckDomainAvailabilityInput) (req *request.Request, output *CheckDomainAvailabilityOutput) {
	op := &request.Operation{
		Name:       opCheckDomainAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckDomainAvailabilityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CheckDomainAvailabilityOutput{}
	req.Data = output
	return
}

// This operation checks the availability of one domain name. You can access
// this API without authenticating. Note that if the availability status of
// a domain is pending, you must submit another request to determine the availability
// of the domain name.
func (c *Route53Domains) CheckDomainAvailability(input *CheckDomainAvailabilityInput) (*CheckDomainAvailabilityOutput, error) {
	req, out := c.CheckDomainAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTagsForDomain = "DeleteTagsForDomain"

// DeleteTagsForDomainRequest generates a request for the DeleteTagsForDomain operation.
func (c *Route53Domains) DeleteTagsForDomainRequest(input *DeleteTagsForDomainInput) (req *request.Request, output *DeleteTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTagsForDomainOutput{}
	req.Data = output
	return
}

// This operation deletes the specified tags for a domain.
//
// All tag operations are eventually consistent; subsequent operations may
// not immediately represent all issued operations.
func (c *Route53Domains) DeleteTagsForDomain(input *DeleteTagsForDomainInput) (*DeleteTagsForDomainOutput, error) {
	req, out := c.DeleteTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDisableDomainAutoRenew = "DisableDomainAutoRenew"

// DisableDomainAutoRenewRequest generates a request for the DisableDomainAutoRenew operation.
func (c *Route53Domains) DisableDomainAutoRenewRequest(input *DisableDomainAutoRenewInput) (req *request.Request, output *DisableDomainAutoRenewOutput) {
	op := &request.Operation{
		Name:       opDisableDomainAutoRenew,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableDomainAutoRenewInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableDomainAutoRenewOutput{}
	req.Data = output
	return
}

// This operation disables automatic renewal of domain registration for the
// specified domain.
//
// Caution! Amazon Route 53 doesn't have a manual renewal process, so if you
// disable automatic renewal, registration for the domain will not be renewed
// when the expiration date passes, and you will lose control of the domain
// name.
func (c *Route53Domains) DisableDomainAutoRenew(input *DisableDomainAutoRenewInput) (*DisableDomainAutoRenewOutput, error) {
	req, out := c.DisableDomainAutoRenewRequest(input)
	err := req.Send()
	return out, err
}

const opDisableDomainTransferLock = "DisableDomainTransferLock"

// DisableDomainTransferLockRequest generates a request for the DisableDomainTransferLock operation.
func (c *Route53Domains) DisableDomainTransferLockRequest(input *DisableDomainTransferLockInput) (req *request.Request, output *DisableDomainTransferLockOutput) {
	op := &request.Operation{
		Name:       opDisableDomainTransferLock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableDomainTransferLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableDomainTransferLockOutput{}
	req.Data = output
	return
}

// This operation removes the transfer lock on the domain (specifically the
// clientTransferProhibited status) to allow domain transfers. We recommend
// you refrain from performing this action unless you intend to transfer the
// domain to a different registrar. Successful submission returns an operation
// ID that you can use to track the progress and completion of the action. If
// the request is not completed successfully, the domain registrant will be
// notified by email.
func (c *Route53Domains) DisableDomainTransferLock(input *DisableDomainTransferLockInput) (*DisableDomainTransferLockOutput, error) {
	req, out := c.DisableDomainTransferLockRequest(input)
	err := req.Send()
	return out, err
}

const opEnableDomainAutoRenew = "EnableDomainAutoRenew"

// EnableDomainAutoRenewRequest generates a request for the EnableDomainAutoRenew operation.
func (c *Route53Domains) EnableDomainAutoRenewRequest(input *EnableDomainAutoRenewInput) (req *request.Request, output *EnableDomainAutoRenewOutput) {
	op := &request.Operation{
		Name:       opEnableDomainAutoRenew,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableDomainAutoRenewInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableDomainAutoRenewOutput{}
	req.Data = output
	return
}

// This operation configures Amazon Route 53 to automatically renew the specified
// domain before the domain registration expires. The cost of renewing your
// domain registration is billed to your AWS account.
//
// The period during which you can renew a domain name varies by TLD. For a
// list of TLDs and their renewal policies, see "Renewal, restoration, and deletion
// times" (http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times)
// on the website for our registrar partner, Gandi. Route 53 requires that you
// renew before the end of the renewal period that is listed on the Gandi website
// so we can complete processing before the deadline.
func (c *Route53Domains) EnableDomainAutoRenew(input *EnableDomainAutoRenewInput) (*EnableDomainAutoRenewOutput, error) {
	req, out := c.EnableDomainAutoRenewRequest(input)
	err := req.Send()
	return out, err
}

const opEnableDomainTransferLock = "EnableDomainTransferLock"

// EnableDomainTransferLockRequest generates a request for the EnableDomainTransferLock operation.
func (c *Route53Domains) EnableDomainTransferLockRequest(input *EnableDomainTransferLockInput) (req *request.Request, output *EnableDomainTransferLockOutput) {
	op := &request.Operation{
		Name:       opEnableDomainTransferLock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableDomainTransferLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableDomainTransferLockOutput{}
	req.Data = output
	return
}

// This operation sets the transfer lock on the domain (specifically the clientTransferProhibited
// status) to prevent domain transfers. Successful submission returns an operation
// ID that you can use to track the progress and completion of the action. If
// the request is not completed successfully, the domain registrant will be
// notified by email.
func (c *Route53Domains) EnableDomainTransferLock(input *EnableDomainTransferLockInput) (*EnableDomainTransferLockOutput, error) {
	req, out := c.EnableDomainTransferLockRequest(input)
	err := req.Send()
	return out, err
}

const opGetDomainDetail = "GetDomainDetail"

// GetDomainDetailRequest generates a request for the GetDomainDetail operation.
func (c *Route53Domains) GetDomainDetailRequest(input *GetDomainDetailInput) (req *request.Request, output *GetDomainDetailOutput) {
	op := &request.Operation{
		Name:       opGetDomainDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainDetailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDomainDetailOutput{}
	req.Data = output
	return
}

// This operation returns detailed information about the domain. The domain's
// contact information is also returned as part of the output.
func (c *Route53Domains) GetDomainDetail(input *GetDomainDetailInput) (*GetDomainDetailOutput, error) {
	req, out := c.GetDomainDetailRequest(input)
	err := req.Send()
	return out, err
}

const opGetOperationDetail = "GetOperationDetail"

// GetOperationDetailRequest generates a request for the GetOperationDetail operation.
func (c *Route53Domains) GetOperationDetailRequest(input *GetOperationDetailInput) (req *request.Request, output *GetOperationDetailOutput) {
	op := &request.Operation{
		Name:       opGetOperationDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationDetailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOperationDetailOutput{}
	req.Data = output
	return
}

// This operation returns the current status of an operation that is not completed.
func (c *Route53Domains) GetOperationDetail(input *GetOperationDetailInput) (*GetOperationDetailOutput, error) {
	req, out := c.GetOperationDetailRequest(input)
	err := req.Send()
	return out, err
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a request for the ListDomains operation.
func (c *Route53Domains) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextPageMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDomainsOutput{}
	req.Data = output
	return
}

// This operation returns all the domain names registered with Amazon Route
// 53 for the current AWS account.
func (c *Route53Domains) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53Domains) ListDomainsPages(input *ListDomainsInput, fn func(p *ListDomainsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDomainsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDomainsOutput), lastPage)
	})
}

const opListOperations = "ListOperations"

// ListOperationsRequest generates a request for the ListOperations operation.
func (c *Route53Domains) ListOperationsRequest(input *ListOperationsInput) (req *request.Request, output *ListOperationsOutput) {
	op := &request.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextPageMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListOperationsOutput{}
	req.Data = output
	return
}

// This operation returns the operation IDs of operations that are not yet complete.
func (c *Route53Domains) ListOperations(input *ListOperationsInput) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53Domains) ListOperationsPages(input *ListOperationsInput, fn func(p *ListOperationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListOperationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListOperationsOutput), lastPage)
	})
}

const opListTagsForDomain = "ListTagsForDomain"

// ListTagsForDomainRequest generates a request for the ListTagsForDomain operation.
func (c *Route53Domains) ListTagsForDomainRequest(input *ListTagsForDomainInput) (req *request.Request, output *ListTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opListTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForDomainOutput{}
	req.Data = output
	return
}

// This operation returns all of the tags that are associated with the specified
// domain.
//
// All tag operations are eventually consistent; subsequent operations may
// not immediately represent all issued operations.
func (c *Route53Domains) ListTagsForDomain(input *ListTagsForDomainInput) (*ListTagsForDomainOutput, error) {
	req, out := c.ListTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterDomain = "RegisterDomain"

// RegisterDomainRequest generates a request for the RegisterDomain operation.
func (c *Route53Domains) RegisterDomainRequest(input *RegisterDomainInput) (req *request.Request, output *RegisterDomainOutput) {
	op := &request.Operation{
		Name:       opRegisterDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterDomainOutput{}
	req.Data = output
	return
}

// This operation registers a domain. Domains are registered by the AWS registrar
// partner, Gandi. For some top-level domains (TLDs), this operation requires
// extra parameters.
//
// When you register a domain, Amazon Route 53 does the following:
//
//  Creates a Amazon Route 53 hosted zone that has the same name as the domain.
// Amazon Route 53 assigns four name servers to your hosted zone and automatically
// updates your domain registration with the names of these name servers. Enables
// autorenew, so your domain registration will renew automatically each year.
// We'll notify you in advance of the renewal date so you can choose whether
// to renew the registration. Optionally enables privacy protection, so WHOIS
// queries return contact information for our registrar partner, Gandi, instead
// of the information you entered for registrant, admin, and tech contacts.
// If registration is successful, returns an operation ID that you can use to
// track the progress and completion of the action. If the request is not completed
// successfully, the domain registrant is notified by email. Charges your AWS
// account an amount based on the top-level domain. For more information, see
// Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
func (c *Route53Domains) RegisterDomain(input *RegisterDomainInput) (*RegisterDomainOutput, error) {
	req, out := c.RegisterDomainRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveDomainAuthCode = "RetrieveDomainAuthCode"

// RetrieveDomainAuthCodeRequest generates a request for the RetrieveDomainAuthCode operation.
func (c *Route53Domains) RetrieveDomainAuthCodeRequest(input *RetrieveDomainAuthCodeInput) (req *request.Request, output *RetrieveDomainAuthCodeOutput) {
	op := &request.Operation{
		Name:       opRetrieveDomainAuthCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveDomainAuthCodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveDomainAuthCodeOutput{}
	req.Data = output
	return
}

// This operation returns the AuthCode for the domain. To transfer a domain
// to another registrar, you provide this value to the new registrar.
func (c *Route53Domains) RetrieveDomainAuthCode(input *RetrieveDomainAuthCodeInput) (*RetrieveDomainAuthCodeOutput, error) {
	req, out := c.RetrieveDomainAuthCodeRequest(input)
	err := req.Send()
	return out, err
}

const opTransferDomain = "TransferDomain"

// TransferDomainRequest generates a request for the TransferDomain operation.
func (c *Route53Domains) TransferDomainRequest(input *TransferDomainInput) (req *request.Request, output *TransferDomainOutput) {
	op := &request.Operation{
		Name:       opTransferDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransferDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TransferDomainOutput{}
	req.Data = output
	return
}

// This operation transfers a domain from another registrar to Amazon Route
// 53. When the transfer is complete, the domain is registered with the AWS
// registrar partner, Gandi.
//
// For transfer requirements, a detailed procedure, and information about viewing
// the status of a domain transfer, see Transferring Registration for a Domain
// to Amazon Route 53 (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html)
// in the Amazon Route 53 Developer Guide.
//
// If the registrar for your domain is also the DNS service provider for the
// domain, we highly recommend that you consider transferring your DNS service
// to Amazon Route 53 or to another DNS service provider before you transfer
// your registration. Some registrars provide free DNS service when you purchase
// a domain registration. When you transfer the registration, the previous registrar
// will not renew your domain registration and could end your DNS service at
// any time.
//
// Caution! If the registrar for your domain is also the DNS service provider
// for the domain and you don't transfer DNS service to another provider, your
// website, email, and the web applications associated with the domain might
// become unavailable. If the transfer is successful, this method returns an
// operation ID that you can use to track the progress and completion of the
// action. If the transfer doesn't complete successfully, the domain registrant
// will be notified by email.
func (c *Route53Domains) TransferDomain(input *TransferDomainInput) (*TransferDomainOutput, error) {
	req, out := c.TransferDomainRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainContact = "UpdateDomainContact"

// UpdateDomainContactRequest generates a request for the UpdateDomainContact operation.
func (c *Route53Domains) UpdateDomainContactRequest(input *UpdateDomainContactInput) (req *request.Request, output *UpdateDomainContactOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainContactInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainContactOutput{}
	req.Data = output
	return
}

// This operation updates the contact information for a particular domain. Information
// for at least one contact (registrant, administrator, or technical) must be
// supplied for update.
//
// If the update is successful, this method returns an operation ID that you
// can use to track the progress and completion of the action. If the request
// is not completed successfully, the domain registrant will be notified by
// email.
func (c *Route53Domains) UpdateDomainContact(input *UpdateDomainContactInput) (*UpdateDomainContactOutput, error) {
	req, out := c.UpdateDomainContactRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainContactPrivacy = "UpdateDomainContactPrivacy"

// UpdateDomainContactPrivacyRequest generates a request for the UpdateDomainContactPrivacy operation.
func (c *Route53Domains) UpdateDomainContactPrivacyRequest(input *UpdateDomainContactPrivacyInput) (req *request.Request, output *UpdateDomainContactPrivacyOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainContactPrivacy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainContactPrivacyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainContactPrivacyOutput{}
	req.Data = output
	return
}

// This operation updates the specified domain contact's privacy setting. When
// the privacy option is enabled, personal information such as postal or email
// address is hidden from the results of a public WHOIS query. The privacy services
// are provided by the AWS registrar, Gandi. For more information, see the Gandi
// privacy features (http://www.gandi.net/domain/whois/?currency=USD&amp;lang=en).
//
// This operation only affects the privacy of the specified contact type (registrant,
// administrator, or tech). Successful acceptance returns an operation ID that
// you can use with GetOperationDetail to track the progress and completion
// of the action. If the request is not completed successfully, the domain registrant
// will be notified by email.
func (c *Route53Domains) UpdateDomainContactPrivacy(input *UpdateDomainContactPrivacyInput) (*UpdateDomainContactPrivacyOutput, error) {
	req, out := c.UpdateDomainContactPrivacyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainNameservers = "UpdateDomainNameservers"

// UpdateDomainNameserversRequest generates a request for the UpdateDomainNameservers operation.
func (c *Route53Domains) UpdateDomainNameserversRequest(input *UpdateDomainNameserversInput) (req *request.Request, output *UpdateDomainNameserversOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainNameservers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainNameserversInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainNameserversOutput{}
	req.Data = output
	return
}

// This operation replaces the current set of name servers for the domain with
// the specified set of name servers. If you use Amazon Route 53 as your DNS
// service, specify the four name servers in the delegation set for the hosted
// zone for the domain.
//
// If successful, this operation returns an operation ID that you can use to
// track the progress and completion of the action. If the request is not completed
// successfully, the domain registrant will be notified by email.
func (c *Route53Domains) UpdateDomainNameservers(input *UpdateDomainNameserversInput) (*UpdateDomainNameserversOutput, error) {
	req, out := c.UpdateDomainNameserversRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTagsForDomain = "UpdateTagsForDomain"

// UpdateTagsForDomainRequest generates a request for the UpdateTagsForDomain operation.
func (c *Route53Domains) UpdateTagsForDomainRequest(input *UpdateTagsForDomainInput) (req *request.Request, output *UpdateTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTagsForDomainOutput{}
	req.Data = output
	return
}

// This operation adds or updates tags for a specified domain.
//
// All tag operations are eventually consistent; subsequent operations may
// not immediately represent all issued operations.
func (c *Route53Domains) UpdateTagsForDomain(input *UpdateTagsForDomainInput) (*UpdateTagsForDomainOutput, error) {
	req, out := c.UpdateTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

// The CheckDomainAvailability request contains the following elements.
type CheckDomainAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`
}

// String returns the string representation
func (s CheckDomainAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDomainAvailabilityInput) GoString() string {
	return s.String()
}

// The CheckDomainAvailability response includes the following elements.
type CheckDomainAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Whether the domain name is available for registering.
	//
	//  You can only register domains designated as AVAILABLE.
	//
	//  Type: String
	//
	// Valid values:
	//
	//   AVAILABLE – The domain name is available.  AVAILABLE_RESERVED – The domain
	// name is reserved under specific conditions.  AVAILABLE_PREORDER – The domain
	// name is available and can be preordered.  UNAVAILABLE – The domain name is
	// not available.  UNAVAILABLE_PREMIUM – The domain name is not available.
	// UNAVAILABLE_RESTRICTED – The domain name is forbidden.  RESERVED – The domain
	// name has been reserved for another person or organization.  DONT_KNOW – The
	// TLD registry didn't reply with a definitive answer about whether the domain
	// name is available. Amazon Route 53 can return this response for a variety
	// of reasons, for example, the registry is performing maintenance. Try again
	// later.
	Availability *string `type:"string" required:"true" enum:"DomainAvailability"`
}

// String returns the string representation
func (s CheckDomainAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDomainAvailabilityOutput) GoString() string {
	return s.String()
}

// ContactDetail includes the following elements.
type ContactDetail struct {
	_ struct{} `type:"structure"`

	// First line of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	AddressLine1 *string `type:"string"`

	// Second line of contact's address, if any.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	AddressLine2 *string `type:"string"`

	// The city of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	City *string `type:"string"`

	// Indicates whether the contact is a person, company, association, or public
	// organization. If you choose an option other than PERSON, you must enter an
	// organization name, and you can't enable privacy protection for the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Valid values: PERSON | COMPANY | ASSOCIATION | PUBLIC_BODY
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	ContactType *string `type:"string" enum:"ContactType"`

	// Code for the country of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	CountryCode *string `type:"string" enum:"CountryCode"`

	// Email address of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 254 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	Email *string `type:"string"`

	// A list of name-value pairs for parameters required by certain top-level domains.
	//
	// Type: Complex
	//
	// Default: None
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Children: Name, Value
	//
	// Required: No
	ExtraParams []*ExtraParam `type:"list"`

	// Fax number of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Phone number must be specified in the format "+[country dialing
	// code].[number including any area code]". For example, a US phone number might
	// appear as "+1.1234567890".
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	Fax *string `type:"string"`

	// First name of contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	FirstName *string `type:"string"`

	// Last name of contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	LastName *string `type:"string"`

	// Name of the organization for contact types other than PERSON.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters. Contact type must not be PERSON.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	OrganizationName *string `type:"string"`

	// The phone number of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Phone number must be specified in the format "+[country dialing
	// code].[number including any area code>]". For example, a US phone number
	// might appear as "+1.1234567890".
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	PhoneNumber *string `type:"string"`

	// The state or province of the contact's city.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	State *string `type:"string"`

	// The zip or postal code of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s ContactDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactDetail) GoString() string {
	return s.String()
}

// The DeleteTagsForDomainRequest includes the following elements.
type DeleteTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to delete one or more tags.
	//
	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Hyphens are allowed only when theyaposre
	// surrounded by letters, numbers, or other hyphens. You canapost specify a
	// hyphen at the beginning or end of a label. To specify an Internationalized
	// Domain Name, you must convert the name to Punycode.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// A list of tag keys to delete.
	//
	// Type: A list that contains the keys of the tags that you want to delete.
	//
	// Default: None
	//
	// Required: No
	//
	// '>
	TagsToDelete []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsForDomainInput) GoString() string {
	return s.String()
}

type DeleteTagsForDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsForDomainOutput) GoString() string {
	return s.String()
}

type DisableDomainAutoRenewInput struct {
	_ struct{} `type:"structure"`

	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainAutoRenewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainAutoRenewInput) GoString() string {
	return s.String()
}

type DisableDomainAutoRenewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableDomainAutoRenewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainAutoRenewOutput) GoString() string {
	return s.String()
}

// The DisableDomainTransferLock request includes the following element.
type DisableDomainTransferLockInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainTransferLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainTransferLockInput) GoString() string {
	return s.String()
}

// The DisableDomainTransferLock response includes the following element.
type DisableDomainTransferLockOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainTransferLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainTransferLockOutput) GoString() string {
	return s.String()
}

type DomainSummary struct {
	_ struct{} `type:"structure"`

	// Indicates whether the domain is automatically renewed upon expiration.
	//
	// Type: Boolean
	//
	// Valid values: True | False
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	DomainName *string `type:"string" required:"true"`

	// Expiration date of the domain in Coordinated Universal Time (UTC).
	//
	// Type: Long
	Expiry *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Indicates whether a domain is locked from unauthorized transfer to another
	// party.
	//
	// Type: Boolean
	//
	// Valid values: True | False
	TransferLock *bool `type:"boolean"`
}

// String returns the string representation
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainSummary) GoString() string {
	return s.String()
}

type EnableDomainAutoRenewInput struct {
	_ struct{} `type:"structure"`

	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainAutoRenewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainAutoRenewInput) GoString() string {
	return s.String()
}

type EnableDomainAutoRenewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableDomainAutoRenewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainAutoRenewOutput) GoString() string {
	return s.String()
}

// The EnableDomainTransferLock request includes the following element.
type EnableDomainTransferLockInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainTransferLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainTransferLockInput) GoString() string {
	return s.String()
}

// The EnableDomainTransferLock response includes the following elements.
type EnableDomainTransferLockOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainTransferLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainTransferLockOutput) GoString() string {
	return s.String()
}

// ExtraParam includes the following elements.
type ExtraParam struct {
	_ struct{} `type:"structure"`

	// Name of the additional parameter required by the top-level domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: DUNS_NUMBER | BRAND_NUMBER | BIRTH_DEPARTMENT | BIRTH_DATE_IN_YYYY_MM_DD
	// | BIRTH_COUNTRY | BIRTH_CITY | DOCUMENT_NUMBER | AU_ID_NUMBER | AU_ID_TYPE
	// | CA_LEGAL_TYPE | ES_IDENTIFICATION | ES_IDENTIFICATION_TYPE | ES_LEGAL_FORM
	// | FI_BUSINESS_NUMBER | FI_ID_NUMBER | IT_PIN | RU_PASSPORT_DATA | SE_ID_NUMBER
	// | SG_ID_NUMBER | VAT_NUMBER
	//
	// Parent: ExtraParams
	//
	// Required: Yes
	Name *string `type:"string" required:"true" enum:"ExtraParamName"`

	// Values corresponding to the additional parameter names required by some top-level
	// domains.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 2048 characters.
	//
	// Parent: ExtraParams
	//
	// Required: Yes
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExtraParam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtraParam) GoString() string {
	return s.String()
}

// The GetDomainDetail request includes the following element.
type GetDomainDetailInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDetailInput) GoString() string {
	return s.String()
}

// The GetDomainDetail response includes the following elements.
type GetDomainDetailOutput struct {
	_ struct{} `type:"structure"`

	// Email address to contact to report incorrect contact information for a domain,
	// to report that the domain is being used to send spam, to report that someone
	// is cybersquatting on a domain name, or report some other type of abuse.
	//
	// Type: String
	AbuseContactEmail *string `type:"string"`

	// Phone number for reporting abuse.
	//
	// Type: String
	AbuseContactPhone *string `type:"string"`

	// Provides details about the domain administrative contact.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the admin contact is concealed
	// from WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	AdminPrivacy *bool `type:"boolean"`

	// Specifies whether the domain registration is set to renew automatically.
	//
	// Type: Boolean
	AutoRenew *bool `type:"boolean"`

	// The date when the domain was created as found in the response to a WHOIS
	// query. The date format is Unix time.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Reserved for future use.
	DnsSec *string `type:"string"`

	// The name of a domain.
	//
	// Type: String
	DomainName *string `type:"string" required:"true"`

	// The date when the registration for the domain is set to expire. The date
	// format is Unix time.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the domain.
	//
	// Type: String
	Nameservers []*Nameserver `type:"list" required:"true"`

	// Provides details about the domain registrant.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the registrant contact is concealed
	// from WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	RegistrantPrivacy *bool `type:"boolean"`

	// Name of the registrar of the domain as identified in the registry. Amazon
	// Route 53 domains are registered by registrar Gandi. The value is "GANDI SAS".
	//
	// Type: String
	RegistrarName *string `type:"string"`

	// Web address of the registrar.
	//
	// Type: String
	RegistrarUrl *string `type:"string"`

	// Reserved for future use.
	RegistryDomainId *string `type:"string"`

	// Reseller of the domain. Domains registered or transferred using Amazon Route
	// 53 domains will have "Amazon" as the reseller.
	//
	// Type: String
	Reseller *string `type:"string"`

	// An array of domain name status codes, also known as Extensible Provisioning
	// Protocol (EPP) status codes.
	//
	// ICANN, the organization that maintains a central database of domain names,
	// has developed a set of domain name status codes that tell you the status
	// of a variety of operations on a domain name, for example, registering a domain
	// name, transferring a domain name to another registrar, renewing the registration
	// for a domain name, and so on. All registrars use this same set of status
	// codes.
	//
	// For a current list of domain name status codes and an explanation of what
	// each code means, go to the ICANN website (https://www.icann.org/) and search
	// for epp status codes. (Search on the ICANN website; web searches sometimes
	// return an old version of the document.)
	//
	// Type: Array of String
	StatusList []*string `type:"list"`

	// Provides details about the domain technical contact.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	TechContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the tech contact is concealed from
	// WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	TechPrivacy *bool `type:"boolean"`

	// The last updated date of the domain as found in the response to a WHOIS query.
	// The date format is Unix time.
	UpdatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully qualified name of the WHOIS server that can answer the WHOIS query
	// for the domain.
	//
	// Type: String
	WhoIsServer *string `type:"string"`
}

// String returns the string representation
func (s GetDomainDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDetailOutput) GoString() string {
	return s.String()
}

// The GetOperationDetail request includes the following element.
type GetOperationDetailInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the operation for which you want to get the status. Amazon
	// Route 53 returned the identifier in the response to the original request.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationDetailInput) GoString() string {
	return s.String()
}

// The GetOperationDetail response includes the following elements.
type GetOperationDetailOutput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	DomainName *string `type:"string"`

	// Detailed information on the status including possible errors.
	//
	// Type: String
	Message *string `type:"string"`

	// The identifier for the operation.
	//
	// Type: String
	OperationId *string `type:"string"`

	// The current status of the requested operation in the system.
	//
	// Type: String
	Status *string `type:"string" enum:"OperationStatus"`

	// The date when the request was submitted.
	SubmittedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The type of operation that was requested.
	//
	// Type: String
	Type *string `type:"string" enum:"OperationType"`
}

// String returns the string representation
func (s GetOperationDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationDetailOutput) GoString() string {
	return s.String()
}

// The ListDomains request includes the following elements.
type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// For an initial request for a list of domains, omit this element. If the number
	// of domains that are associated with the current AWS account is greater than
	// the value that you specified for MaxItems, you can use Marker to return additional
	// domains. Get the value of NextPageMarker from the previous response, and
	// submit another request that includes the value of NextPageMarker in the Marker
	// element.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The marker must match the value specified in the previous request.
	//
	// Required: No
	Marker *string `type:"string"`

	// Number of domains to be returned.
	//
	// Type: Integer
	//
	// Default: 20
	//
	// Constraints: A numeral between 1 and 100.
	//
	// Required: No
	MaxItems *int64 `type:"integer"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// The ListDomains response includes the following elements.
type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of domains.
	//
	// Type: Complex type containing a list of domain summaries.
	//
	// Children: AutoRenew, DomainName, Expiry, TransferLock
	Domains []*DomainSummary `type:"list" required:"true"`

	// If there are more domains than you specified for MaxItems in the request,
	// submit another request and include the value of NextPageMarker in the value
	// of Marker.
	//
	// Type: String
	//
	// Parent: Operations
	NextPageMarker *string `type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// The ListOperations request includes the following elements.
type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// For an initial request for a list of operations, omit this element. If the
	// number of operations that are not yet complete is greater than the value
	// that you specified for MaxItems, you can use Marker to return additional
	// operations. Get the value of NextPageMarker from the previous response, and
	// submit another request that includes the value of NextPageMarker in the Marker
	// element.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: No
	Marker *string `type:"string"`

	// Number of domains to be returned.
	//
	// Type: Integer
	//
	// Default: 20
	//
	// Constraints: A value between 1 and 100.
	//
	// Required: No
	MaxItems *int64 `type:"integer"`
}

// String returns the string representation
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsInput) GoString() string {
	return s.String()
}

// The ListOperations response includes the following elements.
type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more operations than you specified for MaxItems in the request,
	// submit another request and include the value of NextPageMarker in the value
	// of Marker.
	//
	// Type: String
	//
	// Parent: Operations
	NextPageMarker *string `type:"string"`

	// Lists summaries of the operations.
	//
	// Type: Complex type containing a list of operation summaries
	//
	// Children: OperationId, Status, SubmittedDate, Type
	Operations []*OperationSummary `type:"list" required:"true"`
}

// String returns the string representation
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsOutput) GoString() string {
	return s.String()
}

// The ListTagsForDomainRequest includes the following elements.
type ListTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to get a list of tags.
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForDomainInput) GoString() string {
	return s.String()
}

// The ListTagsForDomain response includes the following elements.
type ListTagsForDomainOutput struct {
	_ struct{} `type:"structure"`

	// A list of the tags that are associated with the specified domain.
	//
	// Type: A complex type containing a list of tags
	//
	// Each tag includes the following elements.
	//
	//   Key
	//
	// The key (name) of a tag.
	//
	// Type: String
	//
	//   Value
	//
	// The value of a tag.
	//
	// Type: String
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForDomainOutput) GoString() string {
	return s.String()
}

// Nameserver includes the following elements.
type Nameserver struct {
	_ struct{} `type:"structure"`

	// Glue IP address of a name server entry. Glue IP addresses are required only
	// when the name of the name server is a subdomain of the domain. For example,
	// if your domain is example.com and the name server for the domain is ns.example.com,
	// you need to specify the IP address for ns.example.com.
	//
	// Type: List of IP addresses.
	//
	// Constraints: The list can contain only one IPv4 and one IPv6 address.
	//
	// Parent: Nameservers
	GlueIps []*string `type:"list"`

	// The fully qualified host name of the name server.
	//
	// Type: String
	//
	// Constraint: Maximum 255 characterss
	//
	// Parent: Nameservers
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Nameserver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Nameserver) GoString() string {
	return s.String()
}

// OperationSummary includes the following elements.
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// Identifier returned to track the requested action.
	//
	// Type: String
	OperationId *string `type:"string" required:"true"`

	// The current status of the requested operation in the system.
	//
	// Type: String
	Status *string `type:"string" required:"true" enum:"OperationStatus"`

	// The date when the request was submitted.
	SubmittedDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Type of the action requested.
	//
	// Type: String
	//
	// Valid values: REGISTER_DOMAIN | DELETE_DOMAIN | TRANSFER_IN_DOMAIN | UPDATE_DOMAIN_CONTACT
	// | UPDATE_NAMESERVER | CHANGE_PRIVACY_PROTECTION | DOMAIN_LOCK
	Type *string `type:"string" required:"true" enum:"OperationType"`
}

// String returns the string representation
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationSummary) GoString() string {
	return s.String()
}

// The RegisterDomain request includes the following elements.
type RegisterDomainInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// Indicates whether the domain will be automatically renewed (true) or not
	// (false). Autorenewal only takes effect after the account is charged.
	//
	// Type: Boolean
	//
	// Valid values: true | false
	//
	// Default: true
	//
	// Required: No
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// The number of years the domain will be registered. Domains are registered
	// for a minimum of one year. The maximum period depends on the top-level domain.
	//
	// Type: Integer
	//
	// Default: 1
	//
	// Valid values: Integer from 1 to 10
	//
	// Required: Yes
	DurationInYears *int64 `min:"1" type:"integer" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectAdminContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectRegistrantContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectTechContact *bool `type:"boolean"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	TechContact *ContactDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainInput) GoString() string {
	return s.String()
}

// The RegisterDomain response includes the following element.
type RegisterDomainOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainOutput) GoString() string {
	return s.String()
}

// The RetrieveDomainAuthCode request includes the following element.
type RetrieveDomainAuthCodeInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveDomainAuthCodeInput) GoString() string {
	return s.String()
}

// The RetrieveDomainAuthCode response includes the following element.
type RetrieveDomainAuthCodeOutput struct {
	_ struct{} `type:"structure"`

	// The authorization code for the domain.
	//
	// Type: String
	AuthCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveDomainAuthCodeOutput) GoString() string {
	return s.String()
}

// Each tag includes the following elements.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key (name) of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"
	//
	// Constraints: Each key can be 1-128 characters long.
	//
	// Required: Yes
	Key *string `type:"string"`

	// The value of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"
	//
	// Constraints: Each value can be 0-256 characters long.
	//
	// Required: Yes
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The TransferDomain request includes the following elements.
type TransferDomainInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// The authorization code for the domain. You get this value from the current
	// registrar.
	//
	// Type: String
	//
	// Required: Yes
	AuthCode *string `type:"string"`

	// Indicates whether the domain will be automatically renewed (true) or not
	// (false). Autorenewal only takes effect after the account is charged.
	//
	// Type: Boolean
	//
	// Valid values: true | false
	//
	// Default: true
	//
	// Required: No
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// The number of years the domain will be registered. Domains are registered
	// for a minimum of one year. The maximum period depends on the top-level domain.
	//
	// Type: Integer
	//
	// Default: 1
	//
	// Valid values: Integer from 1 to 10
	//
	// Required: Yes
	DurationInYears *int64 `min:"1" type:"integer" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`

	// Contains details for the host and glue IP addresses.
	//
	// Type: Complex
	//
	// Children: GlueIps, Name
	//
	// Required: No
	Nameservers []*Nameserver `type:"list"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectAdminContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectRegistrantContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectTechContact *bool `type:"boolean"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	TechContact *ContactDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransferDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferDomainInput) GoString() string {
	return s.String()
}

// The TranserDomain response includes the following element.
type TransferDomainOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransferDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferDomainOutput) GoString() string {
	return s.String()
}

// The UpdateDomainContact request includes the following elements.
type UpdateDomainContactInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	AdminContact *ContactDetail `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	RegistrantContact *ContactDetail `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	TechContact *ContactDetail `type:"structure"`
}

// String returns the string representation
func (s UpdateDomainContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactInput) GoString() string {
	return s.String()
}

// The UpdateDomainContact response includes the following element.
type UpdateDomainContactOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactOutput) GoString() string {
	return s.String()
}

// The UpdateDomainContactPrivacy request includes the following elements.
type UpdateDomainContactPrivacyInput struct {
	_ struct{} `type:"structure"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	AdminPrivacy *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	RegistrantPrivacy *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	TechPrivacy *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateDomainContactPrivacyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactPrivacyInput) GoString() string {
	return s.String()
}

// The UpdateDomainContactPrivacy response includes the following element.
type UpdateDomainContactPrivacyOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainContactPrivacyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactPrivacyOutput) GoString() string {
	return s.String()
}

// The UpdateDomainNameserver request includes the following elements.
type UpdateDomainNameserversInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// The authorization key for .fi domains
	FIAuthKey *string `type:"string"`

	// A list of new name servers for the domain.
	//
	// Type: Complex
	//
	// Children: Name, GlueIps
	//
	// Required: Yes
	Nameservers []*Nameserver `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDomainNameserversInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameserversInput) GoString() string {
	return s.String()
}

// The UpdateDomainNameservers response includes the following element.
type UpdateDomainNameserversOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainNameserversOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameserversOutput) GoString() string {
	return s.String()
}

// The UpdateTagsForDomainRequest includes the following elements.
type UpdateTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to add or update tags.
	//
	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Hyphens are allowed only when theyaposre
	// surrounded by letters, numbers, or other hyphens. You canapost specify a
	// hyphen at the beginning or end of a label. To specify an Internationalized
	// Domain Name, you must convert the name to Punycode.
	//
	// Required: Yes
	DomainName *string `type:"string" required:"true"`

	// A list of the tag keys and values that you want to add or update. If you
	// specify a key that already exists, the corresponding value will be replaced.
	//
	// Type: A complex type containing a list of tags
	//
	// Default: None
	//
	// Required: No
	//
	// '> Each tag includes the following elements:
	//
	//   Key
	//
	// The key (name) of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: Unicode characters including alphanumeric, space, and ".:/=+\-@"
	//
	// Constraints: Each key can be 1-128 characters long.
	//
	// Required: Yes
	//
	//   Value
	//
	// The value of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: Unicode characters including alphanumeric, space, and ".:/=+\-@"
	//
	// Constraints: Each value can be 0-256 characters long.
	//
	// Required: Yes
	TagsToUpdate []*Tag `type:"list"`
}

// String returns the string representation
func (s UpdateTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForDomainInput) GoString() string {
	return s.String()
}

type UpdateTagsForDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForDomainOutput) GoString() string {
	return s.String()
}

const (
	// @enum ContactType
	ContactTypePerson = "PERSON"
	// @enum ContactType
	ContactTypeCompany = "COMPANY"
	// @enum ContactType
	ContactTypeAssociation = "ASSOCIATION"
	// @enum ContactType
	ContactTypePublicBody = "PUBLIC_BODY"
	// @enum ContactType
	ContactTypeReseller = "RESELLER"
)

const (
	// @enum CountryCode
	CountryCodeAd = "AD"
	// @enum CountryCode
	CountryCodeAe = "AE"
	// @enum CountryCode
	CountryCodeAf = "AF"
	// @enum CountryCode
	CountryCodeAg = "AG"
	// @enum CountryCode
	CountryCodeAi = "AI"
	// @enum CountryCode
	CountryCodeAl = "AL"
	// @enum CountryCode
	CountryCodeAm = "AM"
	// @enum CountryCode
	CountryCodeAn = "AN"
	// @enum CountryCode
	CountryCodeAo = "AO"
	// @enum CountryCode
	CountryCodeAq = "AQ"
	// @enum CountryCode
	CountryCodeAr = "AR"
	// @enum CountryCode
	CountryCodeAs = "AS"
	// @enum CountryCode
	CountryCodeAt = "AT"
	// @enum CountryCode
	CountryCodeAu = "AU"
	// @enum CountryCode
	CountryCodeAw = "AW"
	// @enum CountryCode
	CountryCodeAz = "AZ"
	// @enum CountryCode
	CountryCodeBa = "BA"
	// @enum CountryCode
	CountryCodeBb = "BB"
	// @enum CountryCode
	CountryCodeBd = "BD"
	// @enum CountryCode
	CountryCodeBe = "BE"
	// @enum CountryCode
	CountryCodeBf = "BF"
	// @enum CountryCode
	CountryCodeBg = "BG"
	// @enum CountryCode
	CountryCodeBh = "BH"
	// @enum CountryCode
	CountryCodeBi = "BI"
	// @enum CountryCode
	CountryCodeBj = "BJ"
	// @enum CountryCode
	CountryCodeBl = "BL"
	// @enum CountryCode
	CountryCodeBm = "BM"
	// @enum CountryCode
	CountryCodeBn = "BN"
	// @enum CountryCode
	CountryCodeBo = "BO"
	// @enum CountryCode
	CountryCodeBr = "BR"
	// @enum CountryCode
	CountryCodeBs = "BS"
	// @enum CountryCode
	CountryCodeBt = "BT"
	// @enum CountryCode
	CountryCodeBw = "BW"
	// @enum CountryCode
	CountryCodeBy = "BY"
	// @enum CountryCode
	CountryCodeBz = "BZ"
	// @enum CountryCode
	CountryCodeCa = "CA"
	// @enum CountryCode
	CountryCodeCc = "CC"
	// @enum CountryCode
	CountryCodeCd = "CD"
	// @enum CountryCode
	CountryCodeCf = "CF"
	// @enum CountryCode
	CountryCodeCg = "CG"
	// @enum CountryCode
	CountryCodeCh = "CH"
	// @enum CountryCode
	CountryCodeCi = "CI"
	// @enum CountryCode
	CountryCodeCk = "CK"
	// @enum CountryCode
	CountryCodeCl = "CL"
	// @enum CountryCode
	CountryCodeCm = "CM"
	// @enum CountryCode
	CountryCodeCn = "CN"
	// @enum CountryCode
	CountryCodeCo = "CO"
	// @enum CountryCode
	CountryCodeCr = "CR"
	// @enum CountryCode
	CountryCodeCu = "CU"
	// @enum CountryCode
	CountryCodeCv = "CV"
	// @enum CountryCode
	CountryCodeCx = "CX"
	// @enum CountryCode
	CountryCodeCy = "CY"
	// @enum CountryCode
	CountryCodeCz = "CZ"
	// @enum CountryCode
	CountryCodeDe = "DE"
	// @enum CountryCode
	CountryCodeDj = "DJ"
	// @enum CountryCode
	CountryCodeDk = "DK"
	// @enum CountryCode
	CountryCodeDm = "DM"
	// @enum CountryCode
	CountryCodeDo = "DO"
	// @enum CountryCode
	CountryCodeDz = "DZ"
	// @enum CountryCode
	CountryCodeEc = "EC"
	// @enum CountryCode
	CountryCodeEe = "EE"
	// @enum CountryCode
	CountryCodeEg = "EG"
	// @enum CountryCode
	CountryCodeEr = "ER"
	// @enum CountryCode
	CountryCodeEs = "ES"
	// @enum CountryCode
	CountryCodeEt = "ET"
	// @enum CountryCode
	CountryCodeFi = "FI"
	// @enum CountryCode
	CountryCodeFj = "FJ"
	// @enum CountryCode
	CountryCodeFk = "FK"
	// @enum CountryCode
	CountryCodeFm = "FM"
	// @enum CountryCode
	CountryCodeFo = "FO"
	// @enum CountryCode
	CountryCodeFr = "FR"
	// @enum CountryCode
	CountryCodeGa = "GA"
	// @enum CountryCode
	CountryCodeGb = "GB"
	// @enum CountryCode
	CountryCodeGd = "GD"
	// @enum CountryCode
	CountryCodeGe = "GE"
	// @enum CountryCode
	CountryCodeGh = "GH"
	// @enum CountryCode
	CountryCodeGi = "GI"
	// @enum CountryCode
	CountryCodeGl = "GL"
	// @enum CountryCode
	CountryCodeGm = "GM"
	// @enum CountryCode
	CountryCodeGn = "GN"
	// @enum CountryCode
	CountryCodeGq = "GQ"
	// @enum CountryCode
	CountryCodeGr = "GR"
	// @enum CountryCode
	CountryCodeGt = "GT"
	// @enum CountryCode
	CountryCodeGu = "GU"
	// @enum CountryCode
	CountryCodeGw = "GW"
	// @enum CountryCode
	CountryCodeGy = "GY"
	// @enum CountryCode
	CountryCodeHk = "HK"
	// @enum CountryCode
	CountryCodeHn = "HN"
	// @enum CountryCode
	CountryCodeHr = "HR"
	// @enum CountryCode
	CountryCodeHt = "HT"
	// @enum CountryCode
	CountryCodeHu = "HU"
	// @enum CountryCode
	CountryCodeId = "ID"
	// @enum CountryCode
	CountryCodeIe = "IE"
	// @enum CountryCode
	CountryCodeIl = "IL"
	// @enum CountryCode
	CountryCodeIm = "IM"
	// @enum CountryCode
	CountryCodeIn = "IN"
	// @enum CountryCode
	CountryCodeIq = "IQ"
	// @enum CountryCode
	CountryCodeIr = "IR"
	// @enum CountryCode
	CountryCodeIs = "IS"
	// @enum CountryCode
	CountryCodeIt = "IT"
	// @enum CountryCode
	CountryCodeJm = "JM"
	// @enum CountryCode
	CountryCodeJo = "JO"
	// @enum CountryCode
	CountryCodeJp = "JP"
	// @enum CountryCode
	CountryCodeKe = "KE"
	// @enum CountryCode
	CountryCodeKg = "KG"
	// @enum CountryCode
	CountryCodeKh = "KH"
	// @enum CountryCode
	CountryCodeKi = "KI"
	// @enum CountryCode
	CountryCodeKm = "KM"
	// @enum CountryCode
	CountryCodeKn = "KN"
	// @enum CountryCode
	CountryCodeKp = "KP"
	// @enum CountryCode
	CountryCodeKr = "KR"
	// @enum CountryCode
	CountryCodeKw = "KW"
	// @enum CountryCode
	CountryCodeKy = "KY"
	// @enum CountryCode
	CountryCodeKz = "KZ"
	// @enum CountryCode
	CountryCodeLa = "LA"
	// @enum CountryCode
	CountryCodeLb = "LB"
	// @enum CountryCode
	CountryCodeLc = "LC"
	// @enum CountryCode
	CountryCodeLi = "LI"
	// @enum CountryCode
	CountryCodeLk = "LK"
	// @enum CountryCode
	CountryCodeLr = "LR"
	// @enum CountryCode
	CountryCodeLs = "LS"
	// @enum CountryCode
	CountryCodeLt = "LT"
	// @enum CountryCode
	CountryCodeLu = "LU"
	// @enum CountryCode
	CountryCodeLv = "LV"
	// @enum CountryCode
	CountryCodeLy = "LY"
	// @enum CountryCode
	CountryCodeMa = "MA"
	// @enum CountryCode
	CountryCodeMc = "MC"
	// @enum CountryCode
	CountryCodeMd = "MD"
	// @enum CountryCode
	CountryCodeMe = "ME"
	// @enum CountryCode
	CountryCodeMf = "MF"
	// @enum CountryCode
	CountryCodeMg = "MG"
	// @enum CountryCode
	CountryCodeMh = "MH"
	// @enum CountryCode
	CountryCodeMk = "MK"
	// @enum CountryCode
	CountryCodeMl = "ML"
	// @enum CountryCode
	CountryCodeMm = "MM"
	// @enum CountryCode
	CountryCodeMn = "MN"
	// @enum CountryCode
	CountryCodeMo = "MO"
	// @enum CountryCode
	CountryCodeMp = "MP"
	// @enum CountryCode
	CountryCodeMr = "MR"
	// @enum CountryCode
	CountryCodeMs = "MS"
	// @enum CountryCode
	CountryCodeMt = "MT"
	// @enum CountryCode
	CountryCodeMu = "MU"
	// @enum CountryCode
	CountryCodeMv = "MV"
	// @enum CountryCode
	CountryCodeMw = "MW"
	// @enum CountryCode
	CountryCodeMx = "MX"
	// @enum CountryCode
	CountryCodeMy = "MY"
	// @enum CountryCode
	CountryCodeMz = "MZ"
	// @enum CountryCode
	CountryCodeNa = "NA"
	// @enum CountryCode
	CountryCodeNc = "NC"
	// @enum CountryCode
	CountryCodeNe = "NE"
	// @enum CountryCode
	CountryCodeNg = "NG"
	// @enum CountryCode
	CountryCodeNi = "NI"
	// @enum CountryCode
	CountryCodeNl = "NL"
	// @enum CountryCode
	CountryCodeNo = "NO"
	// @enum CountryCode
	CountryCodeNp = "NP"
	// @enum CountryCode
	CountryCodeNr = "NR"
	// @enum CountryCode
	CountryCodeNu = "NU"
	// @enum CountryCode
	CountryCodeNz = "NZ"
	// @enum CountryCode
	CountryCodeOm = "OM"
	// @enum CountryCode
	CountryCodePa = "PA"
	// @enum CountryCode
	CountryCodePe = "PE"
	// @enum CountryCode
	CountryCodePf = "PF"
	// @enum CountryCode
	CountryCodePg = "PG"
	// @enum CountryCode
	CountryCodePh = "PH"
	// @enum CountryCode
	CountryCodePk = "PK"
	// @enum CountryCode
	CountryCodePl = "PL"
	// @enum CountryCode
	CountryCodePm = "PM"
	// @enum CountryCode
	CountryCodePn = "PN"
	// @enum CountryCode
	CountryCodePr = "PR"
	// @enum CountryCode
	CountryCodePt = "PT"
	// @enum CountryCode
	CountryCodePw = "PW"
	// @enum CountryCode
	CountryCodePy = "PY"
	// @enum CountryCode
	CountryCodeQa = "QA"
	// @enum CountryCode
	CountryCodeRo = "RO"
	// @enum CountryCode
	CountryCodeRs = "RS"
	// @enum CountryCode
	CountryCodeRu = "RU"
	// @enum CountryCode
	CountryCodeRw = "RW"
	// @enum CountryCode
	CountryCodeSa = "SA"
	// @enum CountryCode
	CountryCodeSb = "SB"
	// @enum CountryCode
	CountryCodeSc = "SC"
	// @enum CountryCode
	CountryCodeSd = "SD"
	// @enum CountryCode
	CountryCodeSe = "SE"
	// @enum CountryCode
	CountryCodeSg = "SG"
	// @enum CountryCode
	CountryCodeSh = "SH"
	// @enum CountryCode
	CountryCodeSi = "SI"
	// @enum CountryCode
	CountryCodeSk = "SK"
	// @enum CountryCode
	CountryCodeSl = "SL"
	// @enum CountryCode
	CountryCodeSm = "SM"
	// @enum CountryCode
	CountryCodeSn = "SN"
	// @enum CountryCode
	CountryCodeSo = "SO"
	// @enum CountryCode
	CountryCodeSr = "SR"
	// @enum CountryCode
	CountryCodeSt = "ST"
	// @enum CountryCode
	CountryCodeSv = "SV"
	// @enum CountryCode
	CountryCodeSy = "SY"
	// @enum CountryCode
	CountryCodeSz = "SZ"
	// @enum CountryCode
	CountryCodeTc = "TC"
	// @enum CountryCode
	CountryCodeTd = "TD"
	// @enum CountryCode
	CountryCodeTg = "TG"
	// @enum CountryCode
	CountryCodeTh = "TH"
	// @enum CountryCode
	CountryCodeTj = "TJ"
	// @enum CountryCode
	CountryCodeTk = "TK"
	// @enum CountryCode
	CountryCodeTl = "TL"
	// @enum CountryCode
	CountryCodeTm = "TM"
	// @enum CountryCode
	CountryCodeTn = "TN"
	// @enum CountryCode
	CountryCodeTo = "TO"
	// @enum CountryCode
	CountryCodeTr = "TR"
	// @enum CountryCode
	CountryCodeTt = "TT"
	// @enum CountryCode
	CountryCodeTv = "TV"
	// @enum CountryCode
	CountryCodeTw = "TW"
	// @enum CountryCode
	CountryCodeTz = "TZ"
	// @enum CountryCode
	CountryCodeUa = "UA"
	// @enum CountryCode
	CountryCodeUg = "UG"
	// @enum CountryCode
	CountryCodeUs = "US"
	// @enum CountryCode
	CountryCodeUy = "UY"
	// @enum CountryCode
	CountryCodeUz = "UZ"
	// @enum CountryCode
	CountryCodeVa = "VA"
	// @enum CountryCode
	CountryCodeVc = "VC"
	// @enum CountryCode
	CountryCodeVe = "VE"
	// @enum CountryCode
	CountryCodeVg = "VG"
	// @enum CountryCode
	CountryCodeVi = "VI"
	// @enum CountryCode
	CountryCodeVn = "VN"
	// @enum CountryCode
	CountryCodeVu = "VU"
	// @enum CountryCode
	CountryCodeWf = "WF"
	// @enum CountryCode
	CountryCodeWs = "WS"
	// @enum CountryCode
	CountryCodeYe = "YE"
	// @enum CountryCode
	CountryCodeYt = "YT"
	// @enum CountryCode
	CountryCodeZa = "ZA"
	// @enum CountryCode
	CountryCodeZm = "ZM"
	// @enum CountryCode
	CountryCodeZw = "ZW"
)

const (
	// @enum DomainAvailability
	DomainAvailabilityAvailable = "AVAILABLE"
	// @enum DomainAvailability
	DomainAvailabilityAvailableReserved = "AVAILABLE_RESERVED"
	// @enum DomainAvailability
	DomainAvailabilityAvailablePreorder = "AVAILABLE_PREORDER"
	// @enum DomainAvailability
	DomainAvailabilityUnavailable = "UNAVAILABLE"
	// @enum DomainAvailability
	DomainAvailabilityUnavailablePremium = "UNAVAILABLE_PREMIUM"
	// @enum DomainAvailability
	DomainAvailabilityUnavailableRestricted = "UNAVAILABLE_RESTRICTED"
	// @enum DomainAvailability
	DomainAvailabilityReserved = "RESERVED"
	// @enum DomainAvailability
	DomainAvailabilityDontKnow = "DONT_KNOW"
)

const (
	// @enum ExtraParamName
	ExtraParamNameDunsNumber = "DUNS_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameBrandNumber = "BRAND_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameBirthDepartment = "BIRTH_DEPARTMENT"
	// @enum ExtraParamName
	ExtraParamNameBirthDateInYyyyMmDd = "BIRTH_DATE_IN_YYYY_MM_DD"
	// @enum ExtraParamName
	ExtraParamNameBirthCountry = "BIRTH_COUNTRY"
	// @enum ExtraParamName
	ExtraParamNameBirthCity = "BIRTH_CITY"
	// @enum ExtraParamName
	ExtraParamNameDocumentNumber = "DOCUMENT_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameAuIdNumber = "AU_ID_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameAuIdType = "AU_ID_TYPE"
	// @enum ExtraParamName
	ExtraParamNameCaLegalType = "CA_LEGAL_TYPE"
	// @enum ExtraParamName
	ExtraParamNameEsIdentification = "ES_IDENTIFICATION"
	// @enum ExtraParamName
	ExtraParamNameEsIdentificationType = "ES_IDENTIFICATION_TYPE"
	// @enum ExtraParamName
	ExtraParamNameEsLegalForm = "ES_LEGAL_FORM"
	// @enum ExtraParamName
	ExtraParamNameFiBusinessNumber = "FI_BUSINESS_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameFiIdNumber = "FI_ID_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameItPin = "IT_PIN"
	// @enum ExtraParamName
	ExtraParamNameRuPassportData = "RU_PASSPORT_DATA"
	// @enum ExtraParamName
	ExtraParamNameSeIdNumber = "SE_ID_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameSgIdNumber = "SG_ID_NUMBER"
	// @enum ExtraParamName
	ExtraParamNameVatNumber = "VAT_NUMBER"
)

const (
	// @enum OperationStatus
	OperationStatusSubmitted = "SUBMITTED"
	// @enum OperationStatus
	OperationStatusInProgress = "IN_PROGRESS"
	// @enum OperationStatus
	OperationStatusError = "ERROR"
	// @enum OperationStatus
	OperationStatusSuccessful = "SUCCESSFUL"
	// @enum OperationStatus
	OperationStatusFailed = "FAILED"
)

const (
	// @enum OperationType
	OperationTypeRegisterDomain = "REGISTER_DOMAIN"
	// @enum OperationType
	OperationTypeDeleteDomain = "DELETE_DOMAIN"
	// @enum OperationType
	OperationTypeTransferInDomain = "TRANSFER_IN_DOMAIN"
	// @enum OperationType
	OperationTypeUpdateDomainContact = "UPDATE_DOMAIN_CONTACT"
	// @enum OperationType
	OperationTypeUpdateNameserver = "UPDATE_NAMESERVER"
	// @enum OperationType
	OperationTypeChangePrivacyProtection = "CHANGE_PRIVACY_PROTECTION"
	// @enum OperationType
	OperationTypeDomainLock = "DOMAIN_LOCK"
)
