// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationshipinfo"
	"entgo.io/ent/schema/field"
)

// RelationshipInfoCreate is the builder for creating a RelationshipInfo entity.
type RelationshipInfoCreate struct {
	config
	mutation *RelationshipInfoMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetText sets the "text" field.
func (ric *RelationshipInfoCreate) SetText(s string) *RelationshipInfoCreate {
	ric.mutation.SetText(s)
	return ric
}

// Mutation returns the RelationshipInfoMutation object of the builder.
func (ric *RelationshipInfoCreate) Mutation() *RelationshipInfoMutation {
	return ric.mutation
}

// Save creates the RelationshipInfo in the database.
func (ric *RelationshipInfoCreate) Save(ctx context.Context) (*RelationshipInfo, error) {
	var (
		err  error
		node *RelationshipInfo
	)
	if len(ric.hooks) == 0 {
		if err = ric.check(); err != nil {
			return nil, err
		}
		node, err = ric.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*RelationshipInfoMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = ric.check(); err != nil {
				return nil, err
			}
			ric.mutation = mutation
			if node, err = ric.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(ric.hooks) - 1; i >= 0; i-- {
			if ric.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ric.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, ric.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*RelationshipInfo)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from RelationshipInfoMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (ric *RelationshipInfoCreate) SaveX(ctx context.Context) *RelationshipInfo {
	v, err := ric.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ric *RelationshipInfoCreate) Exec(ctx context.Context) error {
	_, err := ric.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ric *RelationshipInfoCreate) ExecX(ctx context.Context) {
	if err := ric.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ric *RelationshipInfoCreate) check() error {
	if _, ok := ric.mutation.Text(); !ok {
		return &ValidationError{Name: "text", err: errors.New(`ent: missing required field "RelationshipInfo.text"`)}
	}
	return nil
}

func (ric *RelationshipInfoCreate) sqlSave(ctx context.Context) (*RelationshipInfo, error) {
	_node, _spec := ric.createSpec()
	if err := sqlgraph.CreateNode(ctx, ric.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (ric *RelationshipInfoCreate) createSpec() (*RelationshipInfo, *sqlgraph.CreateSpec) {
	var (
		_node = &RelationshipInfo{config: ric.config}
		_spec = &sqlgraph.CreateSpec{
			Table: relationshipinfo.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: relationshipinfo.FieldID,
			},
		}
	)
	_spec.OnConflict = ric.conflict
	if value, ok := ric.mutation.Text(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: relationshipinfo.FieldText,
		})
		_node.Text = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.RelationshipInfo.Create().
//		SetText(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.RelationshipInfoUpsert) {
//			SetText(v+v).
//		}).
//		Exec(ctx)
func (ric *RelationshipInfoCreate) OnConflict(opts ...sql.ConflictOption) *RelationshipInfoUpsertOne {
	ric.conflict = opts
	return &RelationshipInfoUpsertOne{
		create: ric,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ric *RelationshipInfoCreate) OnConflictColumns(columns ...string) *RelationshipInfoUpsertOne {
	ric.conflict = append(ric.conflict, sql.ConflictColumns(columns...))
	return &RelationshipInfoUpsertOne{
		create: ric,
	}
}

type (
	// RelationshipInfoUpsertOne is the builder for "upsert"-ing
	//  one RelationshipInfo node.
	RelationshipInfoUpsertOne struct {
		create *RelationshipInfoCreate
	}

	// RelationshipInfoUpsert is the "OnConflict" setter.
	RelationshipInfoUpsert struct {
		*sql.UpdateSet
	}
)

// SetText sets the "text" field.
func (u *RelationshipInfoUpsert) SetText(v string) *RelationshipInfoUpsert {
	u.Set(relationshipinfo.FieldText, v)
	return u
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *RelationshipInfoUpsert) UpdateText() *RelationshipInfoUpsert {
	u.SetExcluded(relationshipinfo.FieldText)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *RelationshipInfoUpsertOne) UpdateNewValues() *RelationshipInfoUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *RelationshipInfoUpsertOne) Ignore() *RelationshipInfoUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *RelationshipInfoUpsertOne) DoNothing() *RelationshipInfoUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the RelationshipInfoCreate.OnConflict
// documentation for more info.
func (u *RelationshipInfoUpsertOne) Update(set func(*RelationshipInfoUpsert)) *RelationshipInfoUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&RelationshipInfoUpsert{UpdateSet: update})
	}))
	return u
}

// SetText sets the "text" field.
func (u *RelationshipInfoUpsertOne) SetText(v string) *RelationshipInfoUpsertOne {
	return u.Update(func(s *RelationshipInfoUpsert) {
		s.SetText(v)
	})
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *RelationshipInfoUpsertOne) UpdateText() *RelationshipInfoUpsertOne {
	return u.Update(func(s *RelationshipInfoUpsert) {
		s.UpdateText()
	})
}

// Exec executes the query.
func (u *RelationshipInfoUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for RelationshipInfoCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *RelationshipInfoUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *RelationshipInfoUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *RelationshipInfoUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// RelationshipInfoCreateBulk is the builder for creating many RelationshipInfo entities in bulk.
type RelationshipInfoCreateBulk struct {
	config
	builders []*RelationshipInfoCreate
	conflict []sql.ConflictOption
}

// Save creates the RelationshipInfo entities in the database.
func (ricb *RelationshipInfoCreateBulk) Save(ctx context.Context) ([]*RelationshipInfo, error) {
	specs := make([]*sqlgraph.CreateSpec, len(ricb.builders))
	nodes := make([]*RelationshipInfo, len(ricb.builders))
	mutators := make([]Mutator, len(ricb.builders))
	for i := range ricb.builders {
		func(i int, root context.Context) {
			builder := ricb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*RelationshipInfoMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ricb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ricb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ricb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ricb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ricb *RelationshipInfoCreateBulk) SaveX(ctx context.Context) []*RelationshipInfo {
	v, err := ricb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ricb *RelationshipInfoCreateBulk) Exec(ctx context.Context) error {
	_, err := ricb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ricb *RelationshipInfoCreateBulk) ExecX(ctx context.Context) {
	if err := ricb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.RelationshipInfo.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.RelationshipInfoUpsert) {
//			SetText(v+v).
//		}).
//		Exec(ctx)
func (ricb *RelationshipInfoCreateBulk) OnConflict(opts ...sql.ConflictOption) *RelationshipInfoUpsertBulk {
	ricb.conflict = opts
	return &RelationshipInfoUpsertBulk{
		create: ricb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ricb *RelationshipInfoCreateBulk) OnConflictColumns(columns ...string) *RelationshipInfoUpsertBulk {
	ricb.conflict = append(ricb.conflict, sql.ConflictColumns(columns...))
	return &RelationshipInfoUpsertBulk{
		create: ricb,
	}
}

// RelationshipInfoUpsertBulk is the builder for "upsert"-ing
// a bulk of RelationshipInfo nodes.
type RelationshipInfoUpsertBulk struct {
	create *RelationshipInfoCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
func (u *RelationshipInfoUpsertBulk) UpdateNewValues() *RelationshipInfoUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.RelationshipInfo.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *RelationshipInfoUpsertBulk) Ignore() *RelationshipInfoUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *RelationshipInfoUpsertBulk) DoNothing() *RelationshipInfoUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the RelationshipInfoCreateBulk.OnConflict
// documentation for more info.
func (u *RelationshipInfoUpsertBulk) Update(set func(*RelationshipInfoUpsert)) *RelationshipInfoUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&RelationshipInfoUpsert{UpdateSet: update})
	}))
	return u
}

// SetText sets the "text" field.
func (u *RelationshipInfoUpsertBulk) SetText(v string) *RelationshipInfoUpsertBulk {
	return u.Update(func(s *RelationshipInfoUpsert) {
		s.SetText(v)
	})
}

// UpdateText sets the "text" field to the value that was provided on create.
func (u *RelationshipInfoUpsertBulk) UpdateText() *RelationshipInfoUpsertBulk {
	return u.Update(func(s *RelationshipInfoUpsert) {
		s.UpdateText()
	})
}

// Exec executes the query.
func (u *RelationshipInfoUpsertBulk) Exec(ctx context.Context) error {
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the RelationshipInfoCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for RelationshipInfoCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *RelationshipInfoUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
