-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/md5.ads,v $
--  Description     : MD5 Driver                                             --
--  Author          : Rolf Ebert                                             --
--  Created On      : 11-07-2002                                             --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2007/01/04 09:30:41 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2002 Rolf Ebert                                            --
--                                                                           --
--  ASCL is free software;  you can redistribute it  and/or modify it under  --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  The implementation of the MD5  hash written in Ada in this file          --
--  is partly based on the reference implementation written in C as          --
--  published    in    http://www.faqs.org/rfcs/rfc1321.html.    It          --
--  therefor can be considered "derived from the RSA Data Security,          --
--  Inc.  MD5 Message-Digest Algorithm".                                     --
--                                                                           --
--  Admittendly I am  far from a native English speaker  nor am I a          --
--  lawer.  Personally, I see  this software as an "implementation"          --
--  of  the  published algorithm;  it  is  not  "derived" from  the          --
--  algorithm.                                                               --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  R.1 -                                                                    --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
-------------------------------------------------------------------------------
with Ada.Streams;				use Ada.Streams;

package MD5 is

   subtype Fingerprint is Ada.Streams.Stream_Element_Array(1 .. 16);
   -- 128 bits

   ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   function Hash(
      Input : Ada.Streams.Stream_Element_Array) return Fingerprint;

end MD5;

