"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""

from gastables.Isentropic import Isentropic
from scipy import arange

def get_allValues_from_M(M, gamma):
    isen = Isentropic(gamma)
    VALUES = {}
    VALUES["M"] = M
    VALUES["M*"] = isen.get_Mstar_from_M(M)
    VALUES["T/To"] = isen.get_T_by_To_from_M(M)
    VALUES["P/Po"] = isen.get_P_by_Po_from_M(M)
    VALUES["A/A*"] = isen.get_A_by_Astar_from_M(M)
    VALUES["r/ro"] = isen.get_rho_by_rhoo_from_M(M)
    VALUES["F/F*"] = isen.get_F_by_Fstar_from_M(M)
    VALUES["AP/A*Po"] = isen.get_AP_by_AstarPo_from_M(M)
    return VALUES

def get_allValues_from_T_by_To(T_by_To, gamma):
    isen = Isentropic(gamma)
    return get_allValues_from_M(isen.get_M_from_T_by_To(T_by_To), gamma)

def get_allValues_from_P_by_Po(P_by_Po, gamma):
    isen = Isentropic(gamma)
    return get_allValues_from_M(isen.get_M_from_P_by_Po(P_by_Po), gamma)

def get_allValues_from_rho_by_rhoo(rho_by_rhoo, gamma):
    isen = Isentropic(gamma)
    return get_allValues_from_M(isen.get_M_from_rho_by_rhoo(rho_by_rhoo), gamma)

def get_allValues_from_A_by_Astar(A_by_Astar, gamma):
    isen = Isentropic(gamma)
    VALUES = {}
    SECOND_VALUES = None
    Mach_Nos = isen.get_M_from_A_by_Astar(A_by_Astar)
    if(type(Mach_Nos) == tuple):
        M1 = Mach_Nos[0]
        M2 = Mach_Nos[1]
        VALUES = get_allValues_from_M(M1, gamma)
        SECOND_VALUES = get_allValues_from_M(M2, gamma)
    else:
        VALUES = get_allValues_from_M(Mach_Nos, gamma)

    return VALUES, SECOND_VALUES


def get_plotData_from_M(gamma):
    MRange = arange(0.1,5.01,0.1)
    VALUES = {"M" : MRange, "M*" : [], "T/To": [], "P/Po" : [], "A/A*" : [], "r/ro" : [], "F/F*" : [], "AP/A*Po" : []}
    isen = Isentropic(gamma)
    
    for M in MRange:
        VALUES["M*"].append(isen.get_Mstar_from_M(M))
        VALUES["T/To"].append(isen.get_T_by_To_from_M(M))
        VALUES["P/Po"].append(isen.get_P_by_Po_from_M(M))
        VALUES["A/A*"].append(isen.get_A_by_Astar_from_M(M))
        VALUES["r/ro"].append(isen.get_rho_by_rhoo_from_M(M))
        VALUES["F/F*"].append(isen.get_F_by_Fstar_from_M(M))
        VALUES["AP/A*Po"].append(isen.get_AP_by_AstarPo_from_M(M))
    return VALUES
