/*
 * Decompiled with CFR 0.152.
 */
package JFlex.gui;

import JFlex.gui.GridPanelConstraint;
import JFlex.gui.Handles;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class GridPanel
extends Panel
implements Handles {
    private int cols;
    private int rows;
    private int hgap;
    private int vgap;
    private Vector constraints = new Vector();
    private Insets insets = new Insets(0, 0, 0, 0);

    public GridPanel(int cols, int rows) {
        this(cols, rows, 0, 0);
    }

    public GridPanel(int cols, int rows, int hgap, int vgap) {
        this.cols = cols;
        this.rows = rows;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void doLayout() {
        Dimension size = this.getSize();
        size.height -= this.insets.top + this.insets.bottom;
        size.width -= this.insets.left + this.insets.right;
        float cellWidth = size.width / this.cols;
        float cellHeight = size.height / this.rows;
        for (int i = 0; i < this.constraints.size(); ++i) {
            float height;
            float width;
            GridPanelConstraint c = (GridPanelConstraint)this.constraints.elementAt(i);
            float x = cellWidth * (float)c.x + (float)this.insets.left + (float)(this.hgap / 2);
            float y = cellHeight * (float)c.y + (float)this.insets.right + (float)(this.vgap / 2);
            if (c.handle == 0) {
                width = (cellWidth - (float)this.hgap) * (float)c.width;
                height = (cellHeight - (float)this.vgap) * (float)c.height;
            } else {
                Dimension d = c.component.getPreferredSize();
                width = d.width;
                height = d.height;
            }
            switch (c.handle) {
                case 2: {
                    x += (cellWidth + width) / 2.0f;
                    break;
                }
                case 3: {
                    x += cellWidth - width;
                    break;
                }
                case 4: {
                    y += (cellHeight + height) / 2.0f;
                    break;
                }
                case 5: {
                    x += (cellWidth + width) / 2.0f;
                    y += (cellHeight + height) / 2.0f;
                    break;
                }
                case 6: {
                    y += (cellHeight + height) / 2.0f;
                    x += cellWidth - width;
                    break;
                }
                case 7: {
                    y += cellHeight - height;
                    break;
                }
                case 8: {
                    x += (cellWidth + width) / 2.0f;
                    y += cellHeight - height;
                    break;
                }
                case 9: {
                    y += cellHeight - height;
                    x += cellWidth - width;
                }
            }
            c.component.setBounds(new Rectangle((int)x, (int)y, (int)width, (int)height));
        }
    }

    public Dimension getPreferredSize() {
        float dy = 0.0f;
        float dx = 0.0f;
        for (int i = 0; i < this.constraints.size(); ++i) {
            GridPanelConstraint c = (GridPanelConstraint)this.constraints.elementAt(i);
            Dimension d = c.component.getPreferredSize();
            dx = Math.max(dx, (float)(d.width / c.width));
            dy = Math.max(dy, (float)(d.height / c.height));
        }
        dx += (float)this.hgap;
        dy += (float)this.vgap;
        dx *= (float)this.cols;
        dy *= (float)this.rows;
        return new Dimension((int)(dx += (float)(this.insets.left + this.insets.right)), (int)(dy += (float)(this.insets.top + this.insets.bottom)));
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void add(int x, int y, Component c) {
        this.add(x, y, 1, 1, 0, c);
    }

    public void add(int x, int y, int handle, Component c) {
        this.add(x, y, 1, 1, handle, c);
    }

    public void add(int x, int y, int dx, int dy, Component c) {
        this.add(x, y, dx, dy, 0, c);
    }

    public void add(int x, int y, int dx, int dy, int handle, Component c) {
        super.add(c);
        this.constraints.addElement(new GridPanelConstraint(x, y, dx, dy, handle, c));
    }
}

