## RS1038: Compiler extensions should be implemented in assemblies with compiler-provided references

Types which implement compiler extension points should not be declared in assemblies that contain references to assemblies which are not provided by all compilation scenarios. Doing so may cause the feature to behave unpredictably.

|Item|Value|
|-|-|
|Category|MicrosoftCodeAnalysisCorrectness|
|Enabled|True|
|Severity|Warning|
|CodeFix|False|
---

This rule helps ensure compiler extensions (e.g. analyzers and source generators) will load correctly in all compilation
scenarios. Depending on the manner in which the compiler is invoked, some assemblies may not be present during a build,
and attempting to reference them will result in exceptions that prevent the compiler extension from loading. RS1038 is
the most strict and best performing validation for this scenario.

RS1038 is enabled by default unless relaxed validation has been manually enabled in **.globalconfig** as described in
[RS1022](RS1022.md).

### Rules for compiler feature references

* Compiler features supporting C# code should only reference the NuGet packages **Microsoft.CodeAnalysis.Common** and/or **Microsoft.CodeAnalysis.CSharp**
* Compiler features supporting Visual Basic code should only reference **Microsoft.CodeAnalysis.Common** and/or **Microsoft.CodeAnalysis.VisualBasic**
* Compiler features supporting both C# and Visual Basic should only reference **Microsoft.CodeAnalysis.Common**
* Compiler features should not be implemented in assemblies containing a reference to **Microsoft.CodeAnalysis.Workspaces.Common**

> **Note**
>
> This analyzer only checks references to the core Roslyn assemblies. Compiler extensions with other dependencies may
> face restrictions and/or packaging requirements outside the scope of this analyzer.

### Compiler extension points

The following compiler extension points are examined by this analyzer:

* `DiagnosticAnalyzer`
* `DiagnosticSuppressor`
* `ISourceGenerator`
* `IIncrementalGenerator`

### Other extension points

Some extension points provided by Roslyn are IDE extensions (e.g. code fixes and completion providers). These features
may ship in the same package as compiler features, but should be implemented in their own assembly since they require a
reference to non-compiler package **Microsoft.CodeAnalysis.Workspaces.Common**.
