page_type: reference
description: TensorFlow Lite Task Library's processor module.

<link rel="stylesheet" href="/site-assets/css/style.css">

<!-- DO NOT EDIT! Automatically generated file. -->


<div itemscope itemtype="http://developers.google.com/ReferenceObject">
<meta itemprop="name" content="tflite_support.task.processor" />
<meta itemprop="path" content="Stable" />
</div>

# Module: tflite_support.task.processor

<!-- Insert buttons and diff -->

<table class="tfo-notebook-buttons tfo-api nocontent" align="left">
<td>
  <a target="_blank" href="https://github.com/tensorflow/tflite-support/blob/v0.4.4/tensorflow_lite_support/python/task/processor/__init__.py">
    <img src="https://www.tensorflow.org/images/GitHub-Mark-32px.png" />
    View source on GitHub
  </a>
</td>
</table>



TensorFlow Lite Task Library's processor module.


This module contains classes related to the pre-processing and post-processing
steps of the Task Library.

## Classes

[`class BertCluAnnotationOptions`](../../tflite_support/task/processor/BertCluAnnotationOptions): Options for Bert CLU Annotator processor.

[`class BoundingBox`](../../tflite_support/task/processor/BoundingBox): An integer bounding box, axis aligned.

[`class CategoricalSlot`](../../tflite_support/task/processor/CategoricalSlot): Represents a categorical slot whose values are within a finite set.

[`class Category`](../../tflite_support/task/processor/Category): A classification category.

[`class ClassificationOptions`](../../tflite_support/task/processor/ClassificationOptions): Options for classification processor.

[`class ClassificationResult`](../../tflite_support/task/processor/ClassificationResult): Contains one set of results per classifier head.

[`class Classifications`](../../tflite_support/task/processor/Classifications): List of predicted classes (aka labels) for a given classifier head.

[`class CluRequest`](../../tflite_support/task/processor/CluRequest): The input to CLU (Conversational Language Understanding).

[`class CluResponse`](../../tflite_support/task/processor/CluResponse): The output of CLU.

[`class ColoredLabel`](../../tflite_support/task/processor/ColoredLabel): Defines a label associated with an RGB color, for display purposes.

[`class ConfidenceMask`](../../tflite_support/task/processor/ConfidenceMask): 2D-array representing the confidence mask in row major order.

[`class Detection`](../../tflite_support/task/processor/Detection): Represents one detected object in the object detector's results.

[`class DetectionOptions`](../../tflite_support/task/processor/DetectionOptions): Options for object detection processor.

[`class DetectionResult`](../../tflite_support/task/processor/DetectionResult): Represents the list of detected objects.

[`class Embedding`](../../tflite_support/task/processor/Embedding): Result produced by one of the embedder model output layers.

[`class EmbeddingOptions`](../../tflite_support/task/processor/EmbeddingOptions): Options for embedding processor.

[`class EmbeddingResult`](../../tflite_support/task/processor/EmbeddingResult): Embeddings produced by the Embedder.

[`class FeatureVector`](../../tflite_support/task/processor/FeatureVector): A dense feature vector.

[`class Mention`](../../tflite_support/task/processor/Mention): A single mention result.

[`class MentionedSlot`](../../tflite_support/task/processor/MentionedSlot): Non-categorical slot whose values are open text extracted from the input text.

[`class NearestNeighbor`](../../tflite_support/task/processor/NearestNeighbor): A single nearest neighbor.

[`class OutputType`](../../tflite_support/task/processor/OutputType): An enumeration.

[`class Pos`](../../tflite_support/task/processor/Pos): Position information of the answer relative to context.

[`class QaAnswer`](../../tflite_support/task/processor/QaAnswer): Represents the Answer to BertQuestionAnswerer.

[`class QuestionAnswererResult`](../../tflite_support/task/processor/QuestionAnswererResult): The list of probable answers generated by BertQuestionAnswerer.

[`class SearchOptions`](../../tflite_support/task/processor/SearchOptions): Options for search processor.

[`class SearchResult`](../../tflite_support/task/processor/SearchResult): Results from a search as a list of nearest neigbors.

[`class Segmentation`](../../tflite_support/task/processor/Segmentation): Represents one Segmentation object in the image segmenter's results.

[`class SegmentationOptions`](../../tflite_support/task/processor/SegmentationOptions): Options for segmentation processor.

[`class SegmentationResult`](../../tflite_support/task/processor/SegmentationResult): Results of performing image segmentation.
