cmake_minimum_required(VERSION 3.25)

# Use dpkg-buildflags for Debian packaging
find_program(DPKG_BUILDFLAGS_EXECUTABLE dpkg-buildflags)
if(DPKG_BUILDFLAGS_EXECUTABLE)
    execute_process(
        COMMAND ${DPKG_BUILDFLAGS_EXECUTABLE} --get CPPFLAGS
        OUTPUT_VARIABLE DPKG_CPPFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    execute_process(
        COMMAND ${DPKG_BUILDFLAGS_EXECUTABLE} --get CXXFLAGS
        OUTPUT_VARIABLE DPKG_CXXFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    execute_process(
        COMMAND ${DPKG_BUILDFLAGS_EXECUTABLE} --get LDFLAGS
        OUTPUT_VARIABLE DPKG_LDFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
    )

    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${DPKG_CXXFLAGS}")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${DPKG_CPPFLAGS}")
    set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${DPKG_LDFLAGS}")
endif()