#!/bin/bash
# Configure build with MemorySanitizer (requires clang)
set -e
cd "$(dirname "$0")/.."

# MSan requires clang
if ! command -v clang++ &> /dev/null; then
    echo "Error: MemorySanitizer requires clang++"
    exit 1
fi

CC=clang CXX=clang++ meson setup builddir-msan \
    --buildtype=debug \
    -Db_sanitize=memory \
    -Db_lundef=false \
    "$@"

echo ""
echo "Build with: meson compile -C builddir-msan"
echo "Run with:   ./builddir-msan/rpi-modcopy ..."
echo ""
echo "Note: MSan may produce false positives when linked against"
echo "uninstrumented libraries (like libkmod)."
