// generated by diplomat-tool
import { DisplayNamesFallback } from "./DisplayNamesFallback.mjs"
import { DisplayNamesStyle } from "./DisplayNamesStyle.mjs"
import { LanguageDisplay } from "./LanguageDisplay.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `DisplayNamesOptions`](https://docs.rs/icu/latest/icu/experimental/displaynames/options/struct.DisplayNamesOptions.html) for more information.
 */


export class DisplayNamesOptions {
    #style;
    get style() {
        return this.#style;
    }
    set style(value){
        this.#style = value;
    }
    #fallback;
    get fallback() {
        return this.#fallback;
    }
    set fallback(value){
        this.#fallback = value;
    }
    #languageDisplay;
    get languageDisplay() {
        return this.#languageDisplay;
    }
    set languageDisplay(value){
        this.#languageDisplay = value;
    }
    /** Create `DisplayNamesOptions` from an object that contains all of `DisplayNamesOptions`s fields.
    * Optional fields do not need to be included in the provided object.
    */
    static fromFields(structObj) {
        return new DisplayNamesOptions(structObj);
    }

    #internalConstructor(structObj) {
        if (typeof structObj !== "object") {
            throw new Error("DisplayNamesOptions's constructor takes an object of DisplayNamesOptions's fields.");
        }

        if ("style" in structObj) {
            this.#style = structObj.style;
        } else {
            this.#style = null;
        }

        if ("fallback" in structObj) {
            this.#fallback = structObj.fallback;
        } else {
            this.#fallback = null;
        }

        if ("languageDisplay" in structObj) {
            this.#languageDisplay = structObj.languageDisplay;
        } else {
            this.#languageDisplay = null;
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [...diplomatRuntime.optionToArgsForCalling(this.#style, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]), ...diplomatRuntime.optionToArgsForCalling(this.#fallback, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]), ...diplomatRuntime.optionToArgsForCalling(this.#languageDisplay, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)])]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof DisplayNamesOptions) {
            return obj;
        }

        return DisplayNamesOptions.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 0, this.#style, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 8, this.#fallback, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 16, this.#languageDisplay, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("DisplayNamesOptions._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const styleDeref = ptr;
        structObj.style = diplomatRuntime.readOption(wasm, styleDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new DisplayNamesStyle(diplomatRuntime.internalConstructor, deref) });
        const fallbackDeref = ptr + 8;
        structObj.fallback = diplomatRuntime.readOption(wasm, fallbackDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new DisplayNamesFallback(diplomatRuntime.internalConstructor, deref) });
        const languageDisplayDeref = ptr + 16;
        structObj.languageDisplay = diplomatRuntime.readOption(wasm, languageDisplayDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new LanguageDisplay(diplomatRuntime.internalConstructor, deref) });

        return new DisplayNamesOptions(structObj);
    }


    constructor(structObj) {
        return this.#internalConstructor(...arguments)
    }
}