// generated by diplomat-tool
import { CollatorOptions } from "./CollatorOptions.mjs"
import { CollatorResolvedOptions } from "./CollatorResolvedOptions.mjs"
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { Locale } from "./Locale.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `Collator`](https://docs.rs/icu/latest/icu/collator/struct.Collator.html) for more information.
 */
const Collator_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_Collator_destroy_mv1(ptr);
});

export class Collator {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("Collator is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            Collator_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Construct a new Collator instance using compiled data.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/collator/struct.Collator.html#method.try_new) for more information.
     */
    static create(locale, options) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Collator_create_v1_mv1(diplomatReceive.buffer, locale.ffiValue, ...CollatorOptions._fromSuppliedValue(diplomatRuntime.internalConstructor, options)._intoFFI(functionCleanupArena, {}));

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new Collator(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Construct a new Collator instance using a particular data source.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/collator/struct.Collator.html#method.try_new) for more information.
     */
    #defaultConstructor(provider, locale, options) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Collator_create_v1_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, ...CollatorOptions._fromSuppliedValue(diplomatRuntime.internalConstructor, options)._intoFFI(functionCleanupArena, {}));

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new Collator(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Compare two strings.
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `compare_utf16`](https://docs.rs/icu/latest/icu/collator/struct.CollatorBorrowed.html#method.compare_utf16) for more information.
     */
    compare(left, right) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const leftSlice = diplomatRuntime.DiplomatBuf.str16(wasm, left);
        const rightSlice = diplomatRuntime.DiplomatBuf.str16(wasm, right);

        const result = wasm.icu4x_Collator_compare_utf16_mv1(this.ffiValue, ...leftSlice.splat(), ...rightSlice.splat());

        try {
            return result;
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * The resolved options showing how the default options, the requested options,
     * and the options from locale data were combined. None of the struct fields
     * will have `Auto` as the value.
     *
     * See the [Rust documentation for `resolved_options`](https://docs.rs/icu/latest/icu/collator/struct.CollatorBorrowed.html#method.resolved_options) for more information.
     */
    get resolvedOptions() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 24, 4, false);


        const result = wasm.icu4x_Collator_resolved_options_v1_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            return CollatorResolvedOptions._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(provider, locale, options) {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}