// Compiled by ClojureScript 0.0-3211 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(){
var G__11022 = arguments.length;
switch (G__11022) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t11023 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t11023 = (function (f,blockable,meta11024){
this.f = f;
this.blockable = blockable;
this.meta11024 = meta11024;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t11023.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11025,meta11024__$1){
var self__ = this;
var _11025__$1 = this;
return (new cljs.core.async.t11023(self__.f,self__.blockable,meta11024__$1));
});

cljs.core.async.t11023.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11025){
var self__ = this;
var _11025__$1 = this;
return self__.meta11024;
});

cljs.core.async.t11023.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t11023.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t11023.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t11023.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t11023.cljs$lang$type = true;

cljs.core.async.t11023.cljs$lang$ctorStr = "cljs.core.async/t11023";

cljs.core.async.t11023.cljs$lang$ctorPrWriter = (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t11023");
});

cljs.core.async.__GT_t11023 = (function cljs$core$async$__GT_t11023(f__$1,blockable__$1,meta11024){
return (new cljs.core.async.t11023(f__$1,blockable__$1,meta11024));
});

}

return (new cljs.core.async.t11023(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__11028 = buff;
if(G__11028){
var bit__4973__auto__ = null;
if(cljs.core.truth_((function (){var or__4299__auto__ = bit__4973__auto__;
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
return G__11028.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__11028.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__11028);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__11028);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__11030 = arguments.length;
switch (G__11030) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 * exception-handler. A promise channel can take exactly one value that consumers
 * will receive. Once full, puts complete but val is dropped (no transfer).
 * Consumers will block until either a value is placed in the channel or the
 * channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(){
var G__11033 = arguments.length;
switch (G__11033) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__11036 = arguments.length;
switch (G__11036) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11038 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11038);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11038,ret){
return (function (){
return fn1.call(null,val_11038);
});})(val_11038,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__11040 = arguments.length;
switch (G__11040) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5184__auto___11042 = n;
var x_11043 = (0);
while(true){
if((x_11043 < n__5184__auto___11042)){
(a[x_11043] = (0));

var G__11044 = (x_11043 + (1));
x_11043 = G__11044;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11045 = (i + (1));
i = G__11045;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t11049 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t11049 = (function (alt_flag,flag,meta11050){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11050 = meta11050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t11049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11051,meta11050__$1){
var self__ = this;
var _11051__$1 = this;
return (new cljs.core.async.t11049(self__.alt_flag,self__.flag,meta11050__$1));
});})(flag))
;

cljs.core.async.t11049.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11051){
var self__ = this;
var _11051__$1 = this;
return self__.meta11050;
});})(flag))
;

cljs.core.async.t11049.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t11049.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t11049.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t11049.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t11049.cljs$lang$type = true;

cljs.core.async.t11049.cljs$lang$ctorStr = "cljs.core.async/t11049";

cljs.core.async.t11049.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t11049");
});})(flag))
;

cljs.core.async.__GT_t11049 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t11049(alt_flag__$1,flag__$1,meta11050){
return (new cljs.core.async.t11049(alt_flag__$1,flag__$1,meta11050));
});})(flag))
;

}

return (new cljs.core.async.t11049(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t11055 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t11055 = (function (alt_handler,flag,cb,meta11056){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11056 = meta11056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t11055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11057,meta11056__$1){
var self__ = this;
var _11057__$1 = this;
return (new cljs.core.async.t11055(self__.alt_handler,self__.flag,self__.cb,meta11056__$1));
});

cljs.core.async.t11055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11057){
var self__ = this;
var _11057__$1 = this;
return self__.meta11056;
});

cljs.core.async.t11055.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t11055.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t11055.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t11055.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t11055.cljs$lang$type = true;

cljs.core.async.t11055.cljs$lang$ctorStr = "cljs.core.async/t11055";

cljs.core.async.t11055.cljs$lang$ctorPrWriter = (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t11055");
});

cljs.core.async.__GT_t11055 = (function cljs$core$async$alt_handler_$___GT_t11055(alt_handler__$1,flag__$1,cb__$1,meta11056){
return (new cljs.core.async.t11055(alt_handler__$1,flag__$1,cb__$1,meta11056));
});

}

return (new cljs.core.async.t11055(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11058_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11058_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11059_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11059_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4299__auto__ = wport;
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11060 = (i + (1));
i = G__11060;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4299__auto__ = ret;
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__4287__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4287__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4287__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5339__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5339__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11063){
var map__11064 = p__11063;
var map__11064__$1 = ((cljs.core.seq_QMARK_.call(null,map__11064))?cljs.core.apply.call(null,cljs.core.hash_map,map__11064):map__11064);
var opts = map__11064__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11061){
var G__11062 = cljs.core.first.call(null,seq11061);
var seq11061__$1 = cljs.core.next.call(null,seq11061);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11062,seq11061__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 * nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 * Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__11066 = arguments.length;
switch (G__11066) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__6803__auto___11115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___11115){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___11115){
return (function (state_11090){
var state_val_11091 = (state_11090[(1)]);
if((state_val_11091 === (7))){
var inst_11086 = (state_11090[(2)]);
var state_11090__$1 = state_11090;
var statearr_11092_11116 = state_11090__$1;
(statearr_11092_11116[(2)] = inst_11086);

(statearr_11092_11116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (1))){
var state_11090__$1 = state_11090;
var statearr_11093_11117 = state_11090__$1;
(statearr_11093_11117[(2)] = null);

(statearr_11093_11117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (4))){
var inst_11069 = (state_11090[(7)]);
var inst_11069__$1 = (state_11090[(2)]);
var inst_11070 = (inst_11069__$1 == null);
var state_11090__$1 = (function (){var statearr_11094 = state_11090;
(statearr_11094[(7)] = inst_11069__$1);

return statearr_11094;
})();
if(cljs.core.truth_(inst_11070)){
var statearr_11095_11118 = state_11090__$1;
(statearr_11095_11118[(1)] = (5));

} else {
var statearr_11096_11119 = state_11090__$1;
(statearr_11096_11119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (13))){
var state_11090__$1 = state_11090;
var statearr_11097_11120 = state_11090__$1;
(statearr_11097_11120[(2)] = null);

(statearr_11097_11120[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (6))){
var inst_11069 = (state_11090[(7)]);
var state_11090__$1 = state_11090;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11090__$1,(11),to,inst_11069);
} else {
if((state_val_11091 === (3))){
var inst_11088 = (state_11090[(2)]);
var state_11090__$1 = state_11090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11090__$1,inst_11088);
} else {
if((state_val_11091 === (12))){
var state_11090__$1 = state_11090;
var statearr_11098_11121 = state_11090__$1;
(statearr_11098_11121[(2)] = null);

(statearr_11098_11121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (2))){
var state_11090__$1 = state_11090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11090__$1,(4),from);
} else {
if((state_val_11091 === (11))){
var inst_11079 = (state_11090[(2)]);
var state_11090__$1 = state_11090;
if(cljs.core.truth_(inst_11079)){
var statearr_11099_11122 = state_11090__$1;
(statearr_11099_11122[(1)] = (12));

} else {
var statearr_11100_11123 = state_11090__$1;
(statearr_11100_11123[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (9))){
var state_11090__$1 = state_11090;
var statearr_11101_11124 = state_11090__$1;
(statearr_11101_11124[(2)] = null);

(statearr_11101_11124[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (5))){
var state_11090__$1 = state_11090;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11102_11125 = state_11090__$1;
(statearr_11102_11125[(1)] = (8));

} else {
var statearr_11103_11126 = state_11090__$1;
(statearr_11103_11126[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (14))){
var inst_11084 = (state_11090[(2)]);
var state_11090__$1 = state_11090;
var statearr_11104_11127 = state_11090__$1;
(statearr_11104_11127[(2)] = inst_11084);

(statearr_11104_11127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (10))){
var inst_11076 = (state_11090[(2)]);
var state_11090__$1 = state_11090;
var statearr_11105_11128 = state_11090__$1;
(statearr_11105_11128[(2)] = inst_11076);

(statearr_11105_11128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11091 === (8))){
var inst_11073 = cljs.core.async.close_BANG_.call(null,to);
var state_11090__$1 = state_11090;
var statearr_11106_11129 = state_11090__$1;
(statearr_11106_11129[(2)] = inst_11073);

(statearr_11106_11129[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___11115))
;
return ((function (switch__6741__auto__,c__6803__auto___11115){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_11110 = [null,null,null,null,null,null,null,null];
(statearr_11110[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_11110[(1)] = (1));

return statearr_11110;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_11090){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11111){if((e11111 instanceof Object)){
var ex__6745__auto__ = e11111;
var statearr_11112_11130 = state_11090;
(statearr_11112_11130[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11111;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11131 = state_11090;
state_11090 = G__11131;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_11090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_11090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___11115))
})();
var state__6805__auto__ = (function (){var statearr_11113 = f__6804__auto__.call(null);
(statearr_11113[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11115);

return statearr_11113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___11115))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11315){
var vec__11316 = p__11315;
var v = cljs.core.nth.call(null,vec__11316,(0),null);
var p = cljs.core.nth.call(null,vec__11316,(1),null);
var job = vec__11316;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__6803__auto___11498 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results){
return (function (state_11321){
var state_val_11322 = (state_11321[(1)]);
if((state_val_11322 === (1))){
var state_11321__$1 = state_11321;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11321__$1,(2),res,v);
} else {
if((state_val_11322 === (2))){
var inst_11318 = (state_11321[(2)]);
var inst_11319 = cljs.core.async.close_BANG_.call(null,res);
var state_11321__$1 = (function (){var statearr_11323 = state_11321;
(statearr_11323[(7)] = inst_11318);

return statearr_11323;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11321__$1,inst_11319);
} else {
return null;
}
}
});})(c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results))
;
return ((function (switch__6741__auto__,c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_11327 = [null,null,null,null,null,null,null,null];
(statearr_11327[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__);

(statearr_11327[(1)] = (1));

return statearr_11327;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1 = (function (state_11321){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11321);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11328){if((e11328 instanceof Object)){
var ex__6745__auto__ = e11328;
var statearr_11329_11499 = state_11321;
(statearr_11329_11499[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11321);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11500 = state_11321;
state_11321 = G__11500;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = function(state_11321){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1.call(this,state_11321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results))
})();
var state__6805__auto__ = (function (){var statearr_11330 = f__6804__auto__.call(null);
(statearr_11330[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11498);

return statearr_11330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___11498,res,vec__11316,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11331){
var vec__11332 = p__11331;
var v = cljs.core.nth.call(null,vec__11332,(0),null);
var p = cljs.core.nth.call(null,vec__11332,(1),null);
var job = vec__11332;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5184__auto___11501 = n;
var __11502 = (0);
while(true){
if((__11502 < n__5184__auto___11501)){
var G__11333_11503 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11333_11503) {
case "compute":
var c__6803__auto___11505 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11502,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (__11502,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function (state_11346){
var state_val_11347 = (state_11346[(1)]);
if((state_val_11347 === (1))){
var state_11346__$1 = state_11346;
var statearr_11348_11506 = state_11346__$1;
(statearr_11348_11506[(2)] = null);

(statearr_11348_11506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11347 === (2))){
var state_11346__$1 = state_11346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11346__$1,(4),jobs);
} else {
if((state_val_11347 === (3))){
var inst_11344 = (state_11346[(2)]);
var state_11346__$1 = state_11346;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11346__$1,inst_11344);
} else {
if((state_val_11347 === (4))){
var inst_11336 = (state_11346[(2)]);
var inst_11337 = process.call(null,inst_11336);
var state_11346__$1 = state_11346;
if(cljs.core.truth_(inst_11337)){
var statearr_11349_11507 = state_11346__$1;
(statearr_11349_11507[(1)] = (5));

} else {
var statearr_11350_11508 = state_11346__$1;
(statearr_11350_11508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11347 === (5))){
var state_11346__$1 = state_11346;
var statearr_11351_11509 = state_11346__$1;
(statearr_11351_11509[(2)] = null);

(statearr_11351_11509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11347 === (6))){
var state_11346__$1 = state_11346;
var statearr_11352_11510 = state_11346__$1;
(statearr_11352_11510[(2)] = null);

(statearr_11352_11510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11347 === (7))){
var inst_11342 = (state_11346[(2)]);
var state_11346__$1 = state_11346;
var statearr_11353_11511 = state_11346__$1;
(statearr_11353_11511[(2)] = inst_11342);

(statearr_11353_11511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11502,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
;
return ((function (__11502,switch__6741__auto__,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_11357 = [null,null,null,null,null,null,null];
(statearr_11357[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__);

(statearr_11357[(1)] = (1));

return statearr_11357;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1 = (function (state_11346){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11358){if((e11358 instanceof Object)){
var ex__6745__auto__ = e11358;
var statearr_11359_11512 = state_11346;
(statearr_11359_11512[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11346);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11358;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11513 = state_11346;
state_11346 = G__11513;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = function(state_11346){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1.call(this,state_11346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__;
})()
;})(__11502,switch__6741__auto__,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
})();
var state__6805__auto__ = (function (){var statearr_11360 = f__6804__auto__.call(null);
(statearr_11360[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11505);

return statearr_11360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(__11502,c__6803__auto___11505,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
);


break;
case "async":
var c__6803__auto___11514 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11502,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (__11502,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function (state_11373){
var state_val_11374 = (state_11373[(1)]);
if((state_val_11374 === (1))){
var state_11373__$1 = state_11373;
var statearr_11375_11515 = state_11373__$1;
(statearr_11375_11515[(2)] = null);

(statearr_11375_11515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11374 === (2))){
var state_11373__$1 = state_11373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11373__$1,(4),jobs);
} else {
if((state_val_11374 === (3))){
var inst_11371 = (state_11373[(2)]);
var state_11373__$1 = state_11373;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11373__$1,inst_11371);
} else {
if((state_val_11374 === (4))){
var inst_11363 = (state_11373[(2)]);
var inst_11364 = async.call(null,inst_11363);
var state_11373__$1 = state_11373;
if(cljs.core.truth_(inst_11364)){
var statearr_11376_11516 = state_11373__$1;
(statearr_11376_11516[(1)] = (5));

} else {
var statearr_11377_11517 = state_11373__$1;
(statearr_11377_11517[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11374 === (5))){
var state_11373__$1 = state_11373;
var statearr_11378_11518 = state_11373__$1;
(statearr_11378_11518[(2)] = null);

(statearr_11378_11518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11374 === (6))){
var state_11373__$1 = state_11373;
var statearr_11379_11519 = state_11373__$1;
(statearr_11379_11519[(2)] = null);

(statearr_11379_11519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11374 === (7))){
var inst_11369 = (state_11373[(2)]);
var state_11373__$1 = state_11373;
var statearr_11380_11520 = state_11373__$1;
(statearr_11380_11520[(2)] = inst_11369);

(statearr_11380_11520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11502,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
;
return ((function (__11502,switch__6741__auto__,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_11384 = [null,null,null,null,null,null,null];
(statearr_11384[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__);

(statearr_11384[(1)] = (1));

return statearr_11384;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1 = (function (state_11373){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11373);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11385){if((e11385 instanceof Object)){
var ex__6745__auto__ = e11385;
var statearr_11386_11521 = state_11373;
(statearr_11386_11521[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11373);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11522 = state_11373;
state_11373 = G__11522;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = function(state_11373){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1.call(this,state_11373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__;
})()
;})(__11502,switch__6741__auto__,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
})();
var state__6805__auto__ = (function (){var statearr_11387 = f__6804__auto__.call(null);
(statearr_11387[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11514);

return statearr_11387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(__11502,c__6803__auto___11514,G__11333_11503,n__5184__auto___11501,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11523 = (__11502 + (1));
__11502 = G__11523;
continue;
} else {
}
break;
}

var c__6803__auto___11524 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___11524,jobs,results,process,async){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___11524,jobs,results,process,async){
return (function (state_11409){
var state_val_11410 = (state_11409[(1)]);
if((state_val_11410 === (1))){
var state_11409__$1 = state_11409;
var statearr_11411_11525 = state_11409__$1;
(statearr_11411_11525[(2)] = null);

(statearr_11411_11525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11410 === (2))){
var state_11409__$1 = state_11409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11409__$1,(4),from);
} else {
if((state_val_11410 === (3))){
var inst_11407 = (state_11409[(2)]);
var state_11409__$1 = state_11409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11409__$1,inst_11407);
} else {
if((state_val_11410 === (4))){
var inst_11390 = (state_11409[(7)]);
var inst_11390__$1 = (state_11409[(2)]);
var inst_11391 = (inst_11390__$1 == null);
var state_11409__$1 = (function (){var statearr_11412 = state_11409;
(statearr_11412[(7)] = inst_11390__$1);

return statearr_11412;
})();
if(cljs.core.truth_(inst_11391)){
var statearr_11413_11526 = state_11409__$1;
(statearr_11413_11526[(1)] = (5));

} else {
var statearr_11414_11527 = state_11409__$1;
(statearr_11414_11527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11410 === (5))){
var inst_11393 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11409__$1 = state_11409;
var statearr_11415_11528 = state_11409__$1;
(statearr_11415_11528[(2)] = inst_11393);

(statearr_11415_11528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11410 === (6))){
var inst_11390 = (state_11409[(7)]);
var inst_11395 = (state_11409[(8)]);
var inst_11395__$1 = cljs.core.async.chan.call(null,(1));
var inst_11396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11397 = [inst_11390,inst_11395__$1];
var inst_11398 = (new cljs.core.PersistentVector(null,2,(5),inst_11396,inst_11397,null));
var state_11409__$1 = (function (){var statearr_11416 = state_11409;
(statearr_11416[(8)] = inst_11395__$1);

return statearr_11416;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11409__$1,(8),jobs,inst_11398);
} else {
if((state_val_11410 === (7))){
var inst_11405 = (state_11409[(2)]);
var state_11409__$1 = state_11409;
var statearr_11417_11529 = state_11409__$1;
(statearr_11417_11529[(2)] = inst_11405);

(statearr_11417_11529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11410 === (8))){
var inst_11395 = (state_11409[(8)]);
var inst_11400 = (state_11409[(2)]);
var state_11409__$1 = (function (){var statearr_11418 = state_11409;
(statearr_11418[(9)] = inst_11400);

return statearr_11418;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11409__$1,(9),results,inst_11395);
} else {
if((state_val_11410 === (9))){
var inst_11402 = (state_11409[(2)]);
var state_11409__$1 = (function (){var statearr_11419 = state_11409;
(statearr_11419[(10)] = inst_11402);

return statearr_11419;
})();
var statearr_11420_11530 = state_11409__$1;
(statearr_11420_11530[(2)] = null);

(statearr_11420_11530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___11524,jobs,results,process,async))
;
return ((function (switch__6741__auto__,c__6803__auto___11524,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_11424 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11424[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__);

(statearr_11424[(1)] = (1));

return statearr_11424;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1 = (function (state_11409){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11425){if((e11425 instanceof Object)){
var ex__6745__auto__ = e11425;
var statearr_11426_11531 = state_11409;
(statearr_11426_11531[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11532 = state_11409;
state_11409 = G__11532;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = function(state_11409){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1.call(this,state_11409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___11524,jobs,results,process,async))
})();
var state__6805__auto__ = (function (){var statearr_11427 = f__6804__auto__.call(null);
(statearr_11427[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11524);

return statearr_11427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___11524,jobs,results,process,async))
);


var c__6803__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto__,jobs,results,process,async){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto__,jobs,results,process,async){
return (function (state_11465){
var state_val_11466 = (state_11465[(1)]);
if((state_val_11466 === (7))){
var inst_11461 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
var statearr_11467_11533 = state_11465__$1;
(statearr_11467_11533[(2)] = inst_11461);

(statearr_11467_11533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (20))){
var state_11465__$1 = state_11465;
var statearr_11468_11534 = state_11465__$1;
(statearr_11468_11534[(2)] = null);

(statearr_11468_11534[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (1))){
var state_11465__$1 = state_11465;
var statearr_11469_11535 = state_11465__$1;
(statearr_11469_11535[(2)] = null);

(statearr_11469_11535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (4))){
var inst_11430 = (state_11465[(7)]);
var inst_11430__$1 = (state_11465[(2)]);
var inst_11431 = (inst_11430__$1 == null);
var state_11465__$1 = (function (){var statearr_11470 = state_11465;
(statearr_11470[(7)] = inst_11430__$1);

return statearr_11470;
})();
if(cljs.core.truth_(inst_11431)){
var statearr_11471_11536 = state_11465__$1;
(statearr_11471_11536[(1)] = (5));

} else {
var statearr_11472_11537 = state_11465__$1;
(statearr_11472_11537[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (15))){
var inst_11443 = (state_11465[(8)]);
var state_11465__$1 = state_11465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11465__$1,(18),to,inst_11443);
} else {
if((state_val_11466 === (21))){
var inst_11456 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
var statearr_11473_11538 = state_11465__$1;
(statearr_11473_11538[(2)] = inst_11456);

(statearr_11473_11538[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (13))){
var inst_11458 = (state_11465[(2)]);
var state_11465__$1 = (function (){var statearr_11474 = state_11465;
(statearr_11474[(9)] = inst_11458);

return statearr_11474;
})();
var statearr_11475_11539 = state_11465__$1;
(statearr_11475_11539[(2)] = null);

(statearr_11475_11539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (6))){
var inst_11430 = (state_11465[(7)]);
var state_11465__$1 = state_11465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11465__$1,(11),inst_11430);
} else {
if((state_val_11466 === (17))){
var inst_11451 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
if(cljs.core.truth_(inst_11451)){
var statearr_11476_11540 = state_11465__$1;
(statearr_11476_11540[(1)] = (19));

} else {
var statearr_11477_11541 = state_11465__$1;
(statearr_11477_11541[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (3))){
var inst_11463 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11465__$1,inst_11463);
} else {
if((state_val_11466 === (12))){
var inst_11440 = (state_11465[(10)]);
var state_11465__$1 = state_11465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11465__$1,(14),inst_11440);
} else {
if((state_val_11466 === (2))){
var state_11465__$1 = state_11465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11465__$1,(4),results);
} else {
if((state_val_11466 === (19))){
var state_11465__$1 = state_11465;
var statearr_11478_11542 = state_11465__$1;
(statearr_11478_11542[(2)] = null);

(statearr_11478_11542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (11))){
var inst_11440 = (state_11465[(2)]);
var state_11465__$1 = (function (){var statearr_11479 = state_11465;
(statearr_11479[(10)] = inst_11440);

return statearr_11479;
})();
var statearr_11480_11543 = state_11465__$1;
(statearr_11480_11543[(2)] = null);

(statearr_11480_11543[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (9))){
var state_11465__$1 = state_11465;
var statearr_11481_11544 = state_11465__$1;
(statearr_11481_11544[(2)] = null);

(statearr_11481_11544[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (5))){
var state_11465__$1 = state_11465;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11482_11545 = state_11465__$1;
(statearr_11482_11545[(1)] = (8));

} else {
var statearr_11483_11546 = state_11465__$1;
(statearr_11483_11546[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (14))){
var inst_11443 = (state_11465[(8)]);
var inst_11445 = (state_11465[(11)]);
var inst_11443__$1 = (state_11465[(2)]);
var inst_11444 = (inst_11443__$1 == null);
var inst_11445__$1 = cljs.core.not.call(null,inst_11444);
var state_11465__$1 = (function (){var statearr_11484 = state_11465;
(statearr_11484[(8)] = inst_11443__$1);

(statearr_11484[(11)] = inst_11445__$1);

return statearr_11484;
})();
if(inst_11445__$1){
var statearr_11485_11547 = state_11465__$1;
(statearr_11485_11547[(1)] = (15));

} else {
var statearr_11486_11548 = state_11465__$1;
(statearr_11486_11548[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (16))){
var inst_11445 = (state_11465[(11)]);
var state_11465__$1 = state_11465;
var statearr_11487_11549 = state_11465__$1;
(statearr_11487_11549[(2)] = inst_11445);

(statearr_11487_11549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (10))){
var inst_11437 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
var statearr_11488_11550 = state_11465__$1;
(statearr_11488_11550[(2)] = inst_11437);

(statearr_11488_11550[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (18))){
var inst_11448 = (state_11465[(2)]);
var state_11465__$1 = state_11465;
var statearr_11489_11551 = state_11465__$1;
(statearr_11489_11551[(2)] = inst_11448);

(statearr_11489_11551[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11466 === (8))){
var inst_11434 = cljs.core.async.close_BANG_.call(null,to);
var state_11465__$1 = state_11465;
var statearr_11490_11552 = state_11465__$1;
(statearr_11490_11552[(2)] = inst_11434);

(statearr_11490_11552[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto__,jobs,results,process,async))
;
return ((function (switch__6741__auto__,c__6803__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_11494 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11494[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__);

(statearr_11494[(1)] = (1));

return statearr_11494;
});
var cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1 = (function (state_11465){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11495){if((e11495 instanceof Object)){
var ex__6745__auto__ = e11495;
var statearr_11496_11553 = state_11465;
(statearr_11496_11553[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11495;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11554 = state_11465;
state_11465 = G__11554;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__ = function(state_11465){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1.call(this,state_11465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto__,jobs,results,process,async))
})();
var state__6805__auto__ = (function (){var statearr_11497 = f__6804__auto__.call(null);
(statearr_11497[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto__);

return statearr_11497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto__,jobs,results,process,async))
);

return c__6803__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__11556 = arguments.length;
switch (G__11556) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__11559 = arguments.length;
switch (G__11559) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__11562 = arguments.length;
switch (G__11562) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__6803__auto___11614 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___11614,tc,fc){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___11614,tc,fc){
return (function (state_11588){
var state_val_11589 = (state_11588[(1)]);
if((state_val_11589 === (7))){
var inst_11584 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11590_11615 = state_11588__$1;
(statearr_11590_11615[(2)] = inst_11584);

(statearr_11590_11615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (1))){
var state_11588__$1 = state_11588;
var statearr_11591_11616 = state_11588__$1;
(statearr_11591_11616[(2)] = null);

(statearr_11591_11616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (4))){
var inst_11565 = (state_11588[(7)]);
var inst_11565__$1 = (state_11588[(2)]);
var inst_11566 = (inst_11565__$1 == null);
var state_11588__$1 = (function (){var statearr_11592 = state_11588;
(statearr_11592[(7)] = inst_11565__$1);

return statearr_11592;
})();
if(cljs.core.truth_(inst_11566)){
var statearr_11593_11617 = state_11588__$1;
(statearr_11593_11617[(1)] = (5));

} else {
var statearr_11594_11618 = state_11588__$1;
(statearr_11594_11618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (13))){
var state_11588__$1 = state_11588;
var statearr_11595_11619 = state_11588__$1;
(statearr_11595_11619[(2)] = null);

(statearr_11595_11619[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (6))){
var inst_11565 = (state_11588[(7)]);
var inst_11571 = p.call(null,inst_11565);
var state_11588__$1 = state_11588;
if(cljs.core.truth_(inst_11571)){
var statearr_11596_11620 = state_11588__$1;
(statearr_11596_11620[(1)] = (9));

} else {
var statearr_11597_11621 = state_11588__$1;
(statearr_11597_11621[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (3))){
var inst_11586 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11588__$1,inst_11586);
} else {
if((state_val_11589 === (12))){
var state_11588__$1 = state_11588;
var statearr_11598_11622 = state_11588__$1;
(statearr_11598_11622[(2)] = null);

(statearr_11598_11622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (2))){
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11588__$1,(4),ch);
} else {
if((state_val_11589 === (11))){
var inst_11565 = (state_11588[(7)]);
var inst_11575 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11588__$1,(8),inst_11575,inst_11565);
} else {
if((state_val_11589 === (9))){
var state_11588__$1 = state_11588;
var statearr_11599_11623 = state_11588__$1;
(statearr_11599_11623[(2)] = tc);

(statearr_11599_11623[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (5))){
var inst_11568 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11569 = cljs.core.async.close_BANG_.call(null,fc);
var state_11588__$1 = (function (){var statearr_11600 = state_11588;
(statearr_11600[(8)] = inst_11568);

return statearr_11600;
})();
var statearr_11601_11624 = state_11588__$1;
(statearr_11601_11624[(2)] = inst_11569);

(statearr_11601_11624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (14))){
var inst_11582 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11602_11625 = state_11588__$1;
(statearr_11602_11625[(2)] = inst_11582);

(statearr_11602_11625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (10))){
var state_11588__$1 = state_11588;
var statearr_11603_11626 = state_11588__$1;
(statearr_11603_11626[(2)] = fc);

(statearr_11603_11626[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (8))){
var inst_11577 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
if(cljs.core.truth_(inst_11577)){
var statearr_11604_11627 = state_11588__$1;
(statearr_11604_11627[(1)] = (12));

} else {
var statearr_11605_11628 = state_11588__$1;
(statearr_11605_11628[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___11614,tc,fc))
;
return ((function (switch__6741__auto__,c__6803__auto___11614,tc,fc){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_11609 = [null,null,null,null,null,null,null,null,null];
(statearr_11609[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_11609[(1)] = (1));

return statearr_11609;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_11588){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11610){if((e11610 instanceof Object)){
var ex__6745__auto__ = e11610;
var statearr_11611_11629 = state_11588;
(statearr_11611_11629[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11610;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11630 = state_11588;
state_11588 = G__11630;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_11588){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_11588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___11614,tc,fc))
})();
var state__6805__auto__ = (function (){var statearr_11612 = f__6804__auto__.call(null);
(statearr_11612[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11614);

return statearr_11612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___11614,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__6803__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto__){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto__){
return (function (state_11694){
var state_val_11695 = (state_11694[(1)]);
if((state_val_11695 === (7))){
var inst_11690 = (state_11694[(2)]);
var state_11694__$1 = state_11694;
var statearr_11696_11717 = state_11694__$1;
(statearr_11696_11717[(2)] = inst_11690);

(statearr_11696_11717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (1))){
var inst_11674 = init;
var state_11694__$1 = (function (){var statearr_11697 = state_11694;
(statearr_11697[(7)] = inst_11674);

return statearr_11697;
})();
var statearr_11698_11718 = state_11694__$1;
(statearr_11698_11718[(2)] = null);

(statearr_11698_11718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (4))){
var inst_11677 = (state_11694[(8)]);
var inst_11677__$1 = (state_11694[(2)]);
var inst_11678 = (inst_11677__$1 == null);
var state_11694__$1 = (function (){var statearr_11699 = state_11694;
(statearr_11699[(8)] = inst_11677__$1);

return statearr_11699;
})();
if(cljs.core.truth_(inst_11678)){
var statearr_11700_11719 = state_11694__$1;
(statearr_11700_11719[(1)] = (5));

} else {
var statearr_11701_11720 = state_11694__$1;
(statearr_11701_11720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (6))){
var inst_11681 = (state_11694[(9)]);
var inst_11677 = (state_11694[(8)]);
var inst_11674 = (state_11694[(7)]);
var inst_11681__$1 = f.call(null,inst_11674,inst_11677);
var inst_11682 = cljs.core.reduced_QMARK_.call(null,inst_11681__$1);
var state_11694__$1 = (function (){var statearr_11702 = state_11694;
(statearr_11702[(9)] = inst_11681__$1);

return statearr_11702;
})();
if(inst_11682){
var statearr_11703_11721 = state_11694__$1;
(statearr_11703_11721[(1)] = (8));

} else {
var statearr_11704_11722 = state_11694__$1;
(statearr_11704_11722[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (3))){
var inst_11692 = (state_11694[(2)]);
var state_11694__$1 = state_11694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11694__$1,inst_11692);
} else {
if((state_val_11695 === (2))){
var state_11694__$1 = state_11694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11694__$1,(4),ch);
} else {
if((state_val_11695 === (9))){
var inst_11681 = (state_11694[(9)]);
var inst_11674 = inst_11681;
var state_11694__$1 = (function (){var statearr_11705 = state_11694;
(statearr_11705[(7)] = inst_11674);

return statearr_11705;
})();
var statearr_11706_11723 = state_11694__$1;
(statearr_11706_11723[(2)] = null);

(statearr_11706_11723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (5))){
var inst_11674 = (state_11694[(7)]);
var state_11694__$1 = state_11694;
var statearr_11707_11724 = state_11694__$1;
(statearr_11707_11724[(2)] = inst_11674);

(statearr_11707_11724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (10))){
var inst_11688 = (state_11694[(2)]);
var state_11694__$1 = state_11694;
var statearr_11708_11725 = state_11694__$1;
(statearr_11708_11725[(2)] = inst_11688);

(statearr_11708_11725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (8))){
var inst_11681 = (state_11694[(9)]);
var inst_11684 = cljs.core.deref.call(null,inst_11681);
var state_11694__$1 = state_11694;
var statearr_11709_11726 = state_11694__$1;
(statearr_11709_11726[(2)] = inst_11684);

(statearr_11709_11726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto__))
;
return ((function (switch__6741__auto__,c__6803__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__6742__auto__ = null;
var cljs$core$async$reduce_$_state_machine__6742__auto____0 = (function (){
var statearr_11713 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11713[(0)] = cljs$core$async$reduce_$_state_machine__6742__auto__);

(statearr_11713[(1)] = (1));

return statearr_11713;
});
var cljs$core$async$reduce_$_state_machine__6742__auto____1 = (function (state_11694){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11714){if((e11714 instanceof Object)){
var ex__6745__auto__ = e11714;
var statearr_11715_11727 = state_11694;
(statearr_11715_11727[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11694);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11728 = state_11694;
state_11694 = G__11728;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__6742__auto__ = function(state_11694){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__6742__auto____1.call(this,state_11694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__6742__auto____0;
cljs$core$async$reduce_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__6742__auto____1;
return cljs$core$async$reduce_$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto__))
})();
var state__6805__auto__ = (function (){var statearr_11716 = f__6804__auto__.call(null);
(statearr_11716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto__);

return statearr_11716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto__))
);

return c__6803__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__11730 = arguments.length;
switch (G__11730) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__6803__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto__){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto__){
return (function (state_11755){
var state_val_11756 = (state_11755[(1)]);
if((state_val_11756 === (7))){
var inst_11737 = (state_11755[(2)]);
var state_11755__$1 = state_11755;
var statearr_11757_11781 = state_11755__$1;
(statearr_11757_11781[(2)] = inst_11737);

(statearr_11757_11781[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (1))){
var inst_11731 = cljs.core.seq.call(null,coll);
var inst_11732 = inst_11731;
var state_11755__$1 = (function (){var statearr_11758 = state_11755;
(statearr_11758[(7)] = inst_11732);

return statearr_11758;
})();
var statearr_11759_11782 = state_11755__$1;
(statearr_11759_11782[(2)] = null);

(statearr_11759_11782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (4))){
var inst_11732 = (state_11755[(7)]);
var inst_11735 = cljs.core.first.call(null,inst_11732);
var state_11755__$1 = state_11755;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11755__$1,(7),ch,inst_11735);
} else {
if((state_val_11756 === (13))){
var inst_11749 = (state_11755[(2)]);
var state_11755__$1 = state_11755;
var statearr_11760_11783 = state_11755__$1;
(statearr_11760_11783[(2)] = inst_11749);

(statearr_11760_11783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (6))){
var inst_11740 = (state_11755[(2)]);
var state_11755__$1 = state_11755;
if(cljs.core.truth_(inst_11740)){
var statearr_11761_11784 = state_11755__$1;
(statearr_11761_11784[(1)] = (8));

} else {
var statearr_11762_11785 = state_11755__$1;
(statearr_11762_11785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (3))){
var inst_11753 = (state_11755[(2)]);
var state_11755__$1 = state_11755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11755__$1,inst_11753);
} else {
if((state_val_11756 === (12))){
var state_11755__$1 = state_11755;
var statearr_11763_11786 = state_11755__$1;
(statearr_11763_11786[(2)] = null);

(statearr_11763_11786[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (2))){
var inst_11732 = (state_11755[(7)]);
var state_11755__$1 = state_11755;
if(cljs.core.truth_(inst_11732)){
var statearr_11764_11787 = state_11755__$1;
(statearr_11764_11787[(1)] = (4));

} else {
var statearr_11765_11788 = state_11755__$1;
(statearr_11765_11788[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (11))){
var inst_11746 = cljs.core.async.close_BANG_.call(null,ch);
var state_11755__$1 = state_11755;
var statearr_11766_11789 = state_11755__$1;
(statearr_11766_11789[(2)] = inst_11746);

(statearr_11766_11789[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (9))){
var state_11755__$1 = state_11755;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11767_11790 = state_11755__$1;
(statearr_11767_11790[(1)] = (11));

} else {
var statearr_11768_11791 = state_11755__$1;
(statearr_11768_11791[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (5))){
var inst_11732 = (state_11755[(7)]);
var state_11755__$1 = state_11755;
var statearr_11769_11792 = state_11755__$1;
(statearr_11769_11792[(2)] = inst_11732);

(statearr_11769_11792[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (10))){
var inst_11751 = (state_11755[(2)]);
var state_11755__$1 = state_11755;
var statearr_11770_11793 = state_11755__$1;
(statearr_11770_11793[(2)] = inst_11751);

(statearr_11770_11793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11756 === (8))){
var inst_11732 = (state_11755[(7)]);
var inst_11742 = cljs.core.next.call(null,inst_11732);
var inst_11732__$1 = inst_11742;
var state_11755__$1 = (function (){var statearr_11771 = state_11755;
(statearr_11771[(7)] = inst_11732__$1);

return statearr_11771;
})();
var statearr_11772_11794 = state_11755__$1;
(statearr_11772_11794[(2)] = null);

(statearr_11772_11794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto__))
;
return ((function (switch__6741__auto__,c__6803__auto__){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_11776 = [null,null,null,null,null,null,null,null];
(statearr_11776[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_11776[(1)] = (1));

return statearr_11776;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_11755){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11777){if((e11777 instanceof Object)){
var ex__6745__auto__ = e11777;
var statearr_11778_11795 = state_11755;
(statearr_11778_11795[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11796 = state_11755;
state_11755 = G__11796;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_11755){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_11755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto__))
})();
var state__6805__auto__ = (function (){var statearr_11779 = f__6804__auto__.call(null);
(statearr_11779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto__);

return statearr_11779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto__))
);

return c__6803__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj11798 = {};
return obj11798;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4287__auto__ = _;
if(and__4287__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4287__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4935__auto__ = (((_ == null))?null:_);
return (function (){var or__4299__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj11800 = {};
return obj11800;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t12022 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12022 = (function (mult,ch,cs,meta12023){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12023 = meta12023;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12022.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12024,meta12023__$1){
var self__ = this;
var _12024__$1 = this;
return (new cljs.core.async.t12022(self__.mult,self__.ch,self__.cs,meta12023__$1));
});})(cs))
;

cljs.core.async.t12022.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12024){
var self__ = this;
var _12024__$1 = this;
return self__.meta12023;
});})(cs))
;

cljs.core.async.t12022.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t12022.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t12022.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t12022.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t12022.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t12022.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t12022.cljs$lang$type = true;

cljs.core.async.t12022.cljs$lang$ctorStr = "cljs.core.async/t12022";

cljs.core.async.t12022.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12022");
});})(cs))
;

cljs.core.async.__GT_t12022 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t12022(mult__$1,ch__$1,cs__$1,meta12023){
return (new cljs.core.async.t12022(mult__$1,ch__$1,cs__$1,meta12023));
});})(cs))
;

}

return (new cljs.core.async.t12022(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__6803__auto___12243 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12243,cs,m,dchan,dctr,done){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12243,cs,m,dchan,dctr,done){
return (function (state_12155){
var state_val_12156 = (state_12155[(1)]);
if((state_val_12156 === (7))){
var inst_12151 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12157_12244 = state_12155__$1;
(statearr_12157_12244[(2)] = inst_12151);

(statearr_12157_12244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (20))){
var inst_12056 = (state_12155[(7)]);
var inst_12066 = cljs.core.first.call(null,inst_12056);
var inst_12067 = cljs.core.nth.call(null,inst_12066,(0),null);
var inst_12068 = cljs.core.nth.call(null,inst_12066,(1),null);
var state_12155__$1 = (function (){var statearr_12158 = state_12155;
(statearr_12158[(8)] = inst_12067);

return statearr_12158;
})();
if(cljs.core.truth_(inst_12068)){
var statearr_12159_12245 = state_12155__$1;
(statearr_12159_12245[(1)] = (22));

} else {
var statearr_12160_12246 = state_12155__$1;
(statearr_12160_12246[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (27))){
var inst_12103 = (state_12155[(9)]);
var inst_12098 = (state_12155[(10)]);
var inst_12096 = (state_12155[(11)]);
var inst_12027 = (state_12155[(12)]);
var inst_12103__$1 = cljs.core._nth.call(null,inst_12096,inst_12098);
var inst_12104 = cljs.core.async.put_BANG_.call(null,inst_12103__$1,inst_12027,done);
var state_12155__$1 = (function (){var statearr_12161 = state_12155;
(statearr_12161[(9)] = inst_12103__$1);

return statearr_12161;
})();
if(cljs.core.truth_(inst_12104)){
var statearr_12162_12247 = state_12155__$1;
(statearr_12162_12247[(1)] = (30));

} else {
var statearr_12163_12248 = state_12155__$1;
(statearr_12163_12248[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (1))){
var state_12155__$1 = state_12155;
var statearr_12164_12249 = state_12155__$1;
(statearr_12164_12249[(2)] = null);

(statearr_12164_12249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (24))){
var inst_12056 = (state_12155[(7)]);
var inst_12073 = (state_12155[(2)]);
var inst_12074 = cljs.core.next.call(null,inst_12056);
var inst_12036 = inst_12074;
var inst_12037 = null;
var inst_12038 = (0);
var inst_12039 = (0);
var state_12155__$1 = (function (){var statearr_12165 = state_12155;
(statearr_12165[(13)] = inst_12036);

(statearr_12165[(14)] = inst_12038);

(statearr_12165[(15)] = inst_12073);

(statearr_12165[(16)] = inst_12039);

(statearr_12165[(17)] = inst_12037);

return statearr_12165;
})();
var statearr_12166_12250 = state_12155__$1;
(statearr_12166_12250[(2)] = null);

(statearr_12166_12250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (39))){
var state_12155__$1 = state_12155;
var statearr_12170_12251 = state_12155__$1;
(statearr_12170_12251[(2)] = null);

(statearr_12170_12251[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (4))){
var inst_12027 = (state_12155[(12)]);
var inst_12027__$1 = (state_12155[(2)]);
var inst_12028 = (inst_12027__$1 == null);
var state_12155__$1 = (function (){var statearr_12171 = state_12155;
(statearr_12171[(12)] = inst_12027__$1);

return statearr_12171;
})();
if(cljs.core.truth_(inst_12028)){
var statearr_12172_12252 = state_12155__$1;
(statearr_12172_12252[(1)] = (5));

} else {
var statearr_12173_12253 = state_12155__$1;
(statearr_12173_12253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (15))){
var inst_12036 = (state_12155[(13)]);
var inst_12038 = (state_12155[(14)]);
var inst_12039 = (state_12155[(16)]);
var inst_12037 = (state_12155[(17)]);
var inst_12052 = (state_12155[(2)]);
var inst_12053 = (inst_12039 + (1));
var tmp12167 = inst_12036;
var tmp12168 = inst_12038;
var tmp12169 = inst_12037;
var inst_12036__$1 = tmp12167;
var inst_12037__$1 = tmp12169;
var inst_12038__$1 = tmp12168;
var inst_12039__$1 = inst_12053;
var state_12155__$1 = (function (){var statearr_12174 = state_12155;
(statearr_12174[(13)] = inst_12036__$1);

(statearr_12174[(14)] = inst_12038__$1);

(statearr_12174[(18)] = inst_12052);

(statearr_12174[(16)] = inst_12039__$1);

(statearr_12174[(17)] = inst_12037__$1);

return statearr_12174;
})();
var statearr_12175_12254 = state_12155__$1;
(statearr_12175_12254[(2)] = null);

(statearr_12175_12254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (21))){
var inst_12077 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12179_12255 = state_12155__$1;
(statearr_12179_12255[(2)] = inst_12077);

(statearr_12179_12255[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (31))){
var inst_12103 = (state_12155[(9)]);
var inst_12107 = done.call(null,null);
var inst_12108 = cljs.core.async.untap_STAR_.call(null,m,inst_12103);
var state_12155__$1 = (function (){var statearr_12180 = state_12155;
(statearr_12180[(19)] = inst_12107);

return statearr_12180;
})();
var statearr_12181_12256 = state_12155__$1;
(statearr_12181_12256[(2)] = inst_12108);

(statearr_12181_12256[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (32))){
var inst_12095 = (state_12155[(20)]);
var inst_12098 = (state_12155[(10)]);
var inst_12097 = (state_12155[(21)]);
var inst_12096 = (state_12155[(11)]);
var inst_12110 = (state_12155[(2)]);
var inst_12111 = (inst_12098 + (1));
var tmp12176 = inst_12095;
var tmp12177 = inst_12097;
var tmp12178 = inst_12096;
var inst_12095__$1 = tmp12176;
var inst_12096__$1 = tmp12178;
var inst_12097__$1 = tmp12177;
var inst_12098__$1 = inst_12111;
var state_12155__$1 = (function (){var statearr_12182 = state_12155;
(statearr_12182[(22)] = inst_12110);

(statearr_12182[(20)] = inst_12095__$1);

(statearr_12182[(10)] = inst_12098__$1);

(statearr_12182[(21)] = inst_12097__$1);

(statearr_12182[(11)] = inst_12096__$1);

return statearr_12182;
})();
var statearr_12183_12257 = state_12155__$1;
(statearr_12183_12257[(2)] = null);

(statearr_12183_12257[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (40))){
var inst_12123 = (state_12155[(23)]);
var inst_12127 = done.call(null,null);
var inst_12128 = cljs.core.async.untap_STAR_.call(null,m,inst_12123);
var state_12155__$1 = (function (){var statearr_12184 = state_12155;
(statearr_12184[(24)] = inst_12127);

return statearr_12184;
})();
var statearr_12185_12258 = state_12155__$1;
(statearr_12185_12258[(2)] = inst_12128);

(statearr_12185_12258[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (33))){
var inst_12114 = (state_12155[(25)]);
var inst_12116 = cljs.core.chunked_seq_QMARK_.call(null,inst_12114);
var state_12155__$1 = state_12155;
if(inst_12116){
var statearr_12186_12259 = state_12155__$1;
(statearr_12186_12259[(1)] = (36));

} else {
var statearr_12187_12260 = state_12155__$1;
(statearr_12187_12260[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (13))){
var inst_12046 = (state_12155[(26)]);
var inst_12049 = cljs.core.async.close_BANG_.call(null,inst_12046);
var state_12155__$1 = state_12155;
var statearr_12188_12261 = state_12155__$1;
(statearr_12188_12261[(2)] = inst_12049);

(statearr_12188_12261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (22))){
var inst_12067 = (state_12155[(8)]);
var inst_12070 = cljs.core.async.close_BANG_.call(null,inst_12067);
var state_12155__$1 = state_12155;
var statearr_12189_12262 = state_12155__$1;
(statearr_12189_12262[(2)] = inst_12070);

(statearr_12189_12262[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (36))){
var inst_12114 = (state_12155[(25)]);
var inst_12118 = cljs.core.chunk_first.call(null,inst_12114);
var inst_12119 = cljs.core.chunk_rest.call(null,inst_12114);
var inst_12120 = cljs.core.count.call(null,inst_12118);
var inst_12095 = inst_12119;
var inst_12096 = inst_12118;
var inst_12097 = inst_12120;
var inst_12098 = (0);
var state_12155__$1 = (function (){var statearr_12190 = state_12155;
(statearr_12190[(20)] = inst_12095);

(statearr_12190[(10)] = inst_12098);

(statearr_12190[(21)] = inst_12097);

(statearr_12190[(11)] = inst_12096);

return statearr_12190;
})();
var statearr_12191_12263 = state_12155__$1;
(statearr_12191_12263[(2)] = null);

(statearr_12191_12263[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (41))){
var inst_12114 = (state_12155[(25)]);
var inst_12130 = (state_12155[(2)]);
var inst_12131 = cljs.core.next.call(null,inst_12114);
var inst_12095 = inst_12131;
var inst_12096 = null;
var inst_12097 = (0);
var inst_12098 = (0);
var state_12155__$1 = (function (){var statearr_12192 = state_12155;
(statearr_12192[(20)] = inst_12095);

(statearr_12192[(10)] = inst_12098);

(statearr_12192[(21)] = inst_12097);

(statearr_12192[(27)] = inst_12130);

(statearr_12192[(11)] = inst_12096);

return statearr_12192;
})();
var statearr_12193_12264 = state_12155__$1;
(statearr_12193_12264[(2)] = null);

(statearr_12193_12264[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (43))){
var state_12155__$1 = state_12155;
var statearr_12194_12265 = state_12155__$1;
(statearr_12194_12265[(2)] = null);

(statearr_12194_12265[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (29))){
var inst_12139 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12195_12266 = state_12155__$1;
(statearr_12195_12266[(2)] = inst_12139);

(statearr_12195_12266[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (44))){
var inst_12148 = (state_12155[(2)]);
var state_12155__$1 = (function (){var statearr_12196 = state_12155;
(statearr_12196[(28)] = inst_12148);

return statearr_12196;
})();
var statearr_12197_12267 = state_12155__$1;
(statearr_12197_12267[(2)] = null);

(statearr_12197_12267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (6))){
var inst_12087 = (state_12155[(29)]);
var inst_12086 = cljs.core.deref.call(null,cs);
var inst_12087__$1 = cljs.core.keys.call(null,inst_12086);
var inst_12088 = cljs.core.count.call(null,inst_12087__$1);
var inst_12089 = cljs.core.reset_BANG_.call(null,dctr,inst_12088);
var inst_12094 = cljs.core.seq.call(null,inst_12087__$1);
var inst_12095 = inst_12094;
var inst_12096 = null;
var inst_12097 = (0);
var inst_12098 = (0);
var state_12155__$1 = (function (){var statearr_12198 = state_12155;
(statearr_12198[(29)] = inst_12087__$1);

(statearr_12198[(20)] = inst_12095);

(statearr_12198[(10)] = inst_12098);

(statearr_12198[(30)] = inst_12089);

(statearr_12198[(21)] = inst_12097);

(statearr_12198[(11)] = inst_12096);

return statearr_12198;
})();
var statearr_12199_12268 = state_12155__$1;
(statearr_12199_12268[(2)] = null);

(statearr_12199_12268[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (28))){
var inst_12114 = (state_12155[(25)]);
var inst_12095 = (state_12155[(20)]);
var inst_12114__$1 = cljs.core.seq.call(null,inst_12095);
var state_12155__$1 = (function (){var statearr_12200 = state_12155;
(statearr_12200[(25)] = inst_12114__$1);

return statearr_12200;
})();
if(inst_12114__$1){
var statearr_12201_12269 = state_12155__$1;
(statearr_12201_12269[(1)] = (33));

} else {
var statearr_12202_12270 = state_12155__$1;
(statearr_12202_12270[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (25))){
var inst_12098 = (state_12155[(10)]);
var inst_12097 = (state_12155[(21)]);
var inst_12100 = (inst_12098 < inst_12097);
var inst_12101 = inst_12100;
var state_12155__$1 = state_12155;
if(cljs.core.truth_(inst_12101)){
var statearr_12203_12271 = state_12155__$1;
(statearr_12203_12271[(1)] = (27));

} else {
var statearr_12204_12272 = state_12155__$1;
(statearr_12204_12272[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (34))){
var state_12155__$1 = state_12155;
var statearr_12205_12273 = state_12155__$1;
(statearr_12205_12273[(2)] = null);

(statearr_12205_12273[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (17))){
var state_12155__$1 = state_12155;
var statearr_12206_12274 = state_12155__$1;
(statearr_12206_12274[(2)] = null);

(statearr_12206_12274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (3))){
var inst_12153 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12155__$1,inst_12153);
} else {
if((state_val_12156 === (12))){
var inst_12082 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12207_12275 = state_12155__$1;
(statearr_12207_12275[(2)] = inst_12082);

(statearr_12207_12275[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (2))){
var state_12155__$1 = state_12155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12155__$1,(4),ch);
} else {
if((state_val_12156 === (23))){
var state_12155__$1 = state_12155;
var statearr_12208_12276 = state_12155__$1;
(statearr_12208_12276[(2)] = null);

(statearr_12208_12276[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (35))){
var inst_12137 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12209_12277 = state_12155__$1;
(statearr_12209_12277[(2)] = inst_12137);

(statearr_12209_12277[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (19))){
var inst_12056 = (state_12155[(7)]);
var inst_12060 = cljs.core.chunk_first.call(null,inst_12056);
var inst_12061 = cljs.core.chunk_rest.call(null,inst_12056);
var inst_12062 = cljs.core.count.call(null,inst_12060);
var inst_12036 = inst_12061;
var inst_12037 = inst_12060;
var inst_12038 = inst_12062;
var inst_12039 = (0);
var state_12155__$1 = (function (){var statearr_12210 = state_12155;
(statearr_12210[(13)] = inst_12036);

(statearr_12210[(14)] = inst_12038);

(statearr_12210[(16)] = inst_12039);

(statearr_12210[(17)] = inst_12037);

return statearr_12210;
})();
var statearr_12211_12278 = state_12155__$1;
(statearr_12211_12278[(2)] = null);

(statearr_12211_12278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (11))){
var inst_12036 = (state_12155[(13)]);
var inst_12056 = (state_12155[(7)]);
var inst_12056__$1 = cljs.core.seq.call(null,inst_12036);
var state_12155__$1 = (function (){var statearr_12212 = state_12155;
(statearr_12212[(7)] = inst_12056__$1);

return statearr_12212;
})();
if(inst_12056__$1){
var statearr_12213_12279 = state_12155__$1;
(statearr_12213_12279[(1)] = (16));

} else {
var statearr_12214_12280 = state_12155__$1;
(statearr_12214_12280[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (9))){
var inst_12084 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12215_12281 = state_12155__$1;
(statearr_12215_12281[(2)] = inst_12084);

(statearr_12215_12281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (5))){
var inst_12034 = cljs.core.deref.call(null,cs);
var inst_12035 = cljs.core.seq.call(null,inst_12034);
var inst_12036 = inst_12035;
var inst_12037 = null;
var inst_12038 = (0);
var inst_12039 = (0);
var state_12155__$1 = (function (){var statearr_12216 = state_12155;
(statearr_12216[(13)] = inst_12036);

(statearr_12216[(14)] = inst_12038);

(statearr_12216[(16)] = inst_12039);

(statearr_12216[(17)] = inst_12037);

return statearr_12216;
})();
var statearr_12217_12282 = state_12155__$1;
(statearr_12217_12282[(2)] = null);

(statearr_12217_12282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (14))){
var state_12155__$1 = state_12155;
var statearr_12218_12283 = state_12155__$1;
(statearr_12218_12283[(2)] = null);

(statearr_12218_12283[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (45))){
var inst_12145 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12219_12284 = state_12155__$1;
(statearr_12219_12284[(2)] = inst_12145);

(statearr_12219_12284[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (26))){
var inst_12087 = (state_12155[(29)]);
var inst_12141 = (state_12155[(2)]);
var inst_12142 = cljs.core.seq.call(null,inst_12087);
var state_12155__$1 = (function (){var statearr_12220 = state_12155;
(statearr_12220[(31)] = inst_12141);

return statearr_12220;
})();
if(inst_12142){
var statearr_12221_12285 = state_12155__$1;
(statearr_12221_12285[(1)] = (42));

} else {
var statearr_12222_12286 = state_12155__$1;
(statearr_12222_12286[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (16))){
var inst_12056 = (state_12155[(7)]);
var inst_12058 = cljs.core.chunked_seq_QMARK_.call(null,inst_12056);
var state_12155__$1 = state_12155;
if(inst_12058){
var statearr_12223_12287 = state_12155__$1;
(statearr_12223_12287[(1)] = (19));

} else {
var statearr_12224_12288 = state_12155__$1;
(statearr_12224_12288[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (38))){
var inst_12134 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12225_12289 = state_12155__$1;
(statearr_12225_12289[(2)] = inst_12134);

(statearr_12225_12289[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (30))){
var state_12155__$1 = state_12155;
var statearr_12226_12290 = state_12155__$1;
(statearr_12226_12290[(2)] = null);

(statearr_12226_12290[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (10))){
var inst_12039 = (state_12155[(16)]);
var inst_12037 = (state_12155[(17)]);
var inst_12045 = cljs.core._nth.call(null,inst_12037,inst_12039);
var inst_12046 = cljs.core.nth.call(null,inst_12045,(0),null);
var inst_12047 = cljs.core.nth.call(null,inst_12045,(1),null);
var state_12155__$1 = (function (){var statearr_12227 = state_12155;
(statearr_12227[(26)] = inst_12046);

return statearr_12227;
})();
if(cljs.core.truth_(inst_12047)){
var statearr_12228_12291 = state_12155__$1;
(statearr_12228_12291[(1)] = (13));

} else {
var statearr_12229_12292 = state_12155__$1;
(statearr_12229_12292[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (18))){
var inst_12080 = (state_12155[(2)]);
var state_12155__$1 = state_12155;
var statearr_12230_12293 = state_12155__$1;
(statearr_12230_12293[(2)] = inst_12080);

(statearr_12230_12293[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (42))){
var state_12155__$1 = state_12155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12155__$1,(45),dchan);
} else {
if((state_val_12156 === (37))){
var inst_12123 = (state_12155[(23)]);
var inst_12114 = (state_12155[(25)]);
var inst_12027 = (state_12155[(12)]);
var inst_12123__$1 = cljs.core.first.call(null,inst_12114);
var inst_12124 = cljs.core.async.put_BANG_.call(null,inst_12123__$1,inst_12027,done);
var state_12155__$1 = (function (){var statearr_12231 = state_12155;
(statearr_12231[(23)] = inst_12123__$1);

return statearr_12231;
})();
if(cljs.core.truth_(inst_12124)){
var statearr_12232_12294 = state_12155__$1;
(statearr_12232_12294[(1)] = (39));

} else {
var statearr_12233_12295 = state_12155__$1;
(statearr_12233_12295[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12156 === (8))){
var inst_12038 = (state_12155[(14)]);
var inst_12039 = (state_12155[(16)]);
var inst_12041 = (inst_12039 < inst_12038);
var inst_12042 = inst_12041;
var state_12155__$1 = state_12155;
if(cljs.core.truth_(inst_12042)){
var statearr_12234_12296 = state_12155__$1;
(statearr_12234_12296[(1)] = (10));

} else {
var statearr_12235_12297 = state_12155__$1;
(statearr_12235_12297[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12243,cs,m,dchan,dctr,done))
;
return ((function (switch__6741__auto__,c__6803__auto___12243,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__6742__auto__ = null;
var cljs$core$async$mult_$_state_machine__6742__auto____0 = (function (){
var statearr_12239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12239[(0)] = cljs$core$async$mult_$_state_machine__6742__auto__);

(statearr_12239[(1)] = (1));

return statearr_12239;
});
var cljs$core$async$mult_$_state_machine__6742__auto____1 = (function (state_12155){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12240){if((e12240 instanceof Object)){
var ex__6745__auto__ = e12240;
var statearr_12241_12298 = state_12155;
(statearr_12241_12298[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12299 = state_12155;
state_12155 = G__12299;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__6742__auto__ = function(state_12155){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__6742__auto____1.call(this,state_12155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__6742__auto____0;
cljs$core$async$mult_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__6742__auto____1;
return cljs$core$async$mult_$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12243,cs,m,dchan,dctr,done))
})();
var state__6805__auto__ = (function (){var statearr_12242 = f__6804__auto__.call(null);
(statearr_12242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12243);

return statearr_12242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12243,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__12301 = arguments.length;
switch (G__12301) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj12304 = {};
return obj12304;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4287__auto__ = m;
if(and__4287__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4935__auto__ = (((m == null))?null:m);
return (function (){var or__4299__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5339__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5339__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12309){
var map__12310 = p__12309;
var map__12310__$1 = ((cljs.core.seq_QMARK_.call(null,map__12310))?cljs.core.apply.call(null,cljs.core.hash_map,map__12310):map__12310);
var opts = map__12310__$1;
var statearr_12311_12314 = state;
(statearr_12311_12314[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__12310,map__12310__$1,opts){
return (function (val){
var statearr_12312_12315 = state;
(statearr_12312_12315[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12310,map__12310__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_12313_12316 = state;
(statearr_12313_12316[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12305){
var G__12306 = cljs.core.first.call(null,seq12305);
var seq12305__$1 = cljs.core.next.call(null,seq12305);
var G__12307 = cljs.core.first.call(null,seq12305__$1);
var seq12305__$2 = cljs.core.next.call(null,seq12305__$1);
var G__12308 = cljs.core.first.call(null,seq12305__$2);
var seq12305__$3 = cljs.core.next.call(null,seq12305__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12306,G__12307,G__12308,seq12305__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t12436 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12436 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12437){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12437 = meta12437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12438,meta12437__$1){
var self__ = this;
var _12438__$1 = this;
return (new cljs.core.async.t12436(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12437__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12438){
var self__ = this;
var _12438__$1 = this;
return self__.meta12437;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t12436.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t12436.cljs$lang$type = true;

cljs.core.async.t12436.cljs$lang$ctorStr = "cljs.core.async/t12436";

cljs.core.async.t12436.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12436");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t12436 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t12436(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12437){
return (new cljs.core.async.t12436(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12437));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t12436(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6803__auto___12555 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12508){
var state_val_12509 = (state_12508[(1)]);
if((state_val_12509 === (7))){
var inst_12452 = (state_12508[(7)]);
var inst_12457 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12452);
var state_12508__$1 = state_12508;
var statearr_12510_12556 = state_12508__$1;
(statearr_12510_12556[(2)] = inst_12457);

(statearr_12510_12556[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (20))){
var inst_12467 = (state_12508[(8)]);
var state_12508__$1 = state_12508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12508__$1,(23),out,inst_12467);
} else {
if((state_val_12509 === (1))){
var inst_12442 = (state_12508[(9)]);
var inst_12442__$1 = calc_state.call(null);
var inst_12443 = cljs.core.seq_QMARK_.call(null,inst_12442__$1);
var state_12508__$1 = (function (){var statearr_12511 = state_12508;
(statearr_12511[(9)] = inst_12442__$1);

return statearr_12511;
})();
if(inst_12443){
var statearr_12512_12557 = state_12508__$1;
(statearr_12512_12557[(1)] = (2));

} else {
var statearr_12513_12558 = state_12508__$1;
(statearr_12513_12558[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (24))){
var inst_12460 = (state_12508[(10)]);
var inst_12452 = inst_12460;
var state_12508__$1 = (function (){var statearr_12514 = state_12508;
(statearr_12514[(7)] = inst_12452);

return statearr_12514;
})();
var statearr_12515_12559 = state_12508__$1;
(statearr_12515_12559[(2)] = null);

(statearr_12515_12559[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (4))){
var inst_12442 = (state_12508[(9)]);
var inst_12448 = (state_12508[(2)]);
var inst_12449 = cljs.core.get.call(null,inst_12448,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12450 = cljs.core.get.call(null,inst_12448,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12451 = cljs.core.get.call(null,inst_12448,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12452 = inst_12442;
var state_12508__$1 = (function (){var statearr_12516 = state_12508;
(statearr_12516[(11)] = inst_12451);

(statearr_12516[(12)] = inst_12449);

(statearr_12516[(13)] = inst_12450);

(statearr_12516[(7)] = inst_12452);

return statearr_12516;
})();
var statearr_12517_12560 = state_12508__$1;
(statearr_12517_12560[(2)] = null);

(statearr_12517_12560[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (15))){
var state_12508__$1 = state_12508;
var statearr_12518_12561 = state_12508__$1;
(statearr_12518_12561[(2)] = null);

(statearr_12518_12561[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (21))){
var inst_12460 = (state_12508[(10)]);
var inst_12452 = inst_12460;
var state_12508__$1 = (function (){var statearr_12519 = state_12508;
(statearr_12519[(7)] = inst_12452);

return statearr_12519;
})();
var statearr_12520_12562 = state_12508__$1;
(statearr_12520_12562[(2)] = null);

(statearr_12520_12562[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (13))){
var inst_12504 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
var statearr_12521_12563 = state_12508__$1;
(statearr_12521_12563[(2)] = inst_12504);

(statearr_12521_12563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (22))){
var inst_12502 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
var statearr_12522_12564 = state_12508__$1;
(statearr_12522_12564[(2)] = inst_12502);

(statearr_12522_12564[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (6))){
var inst_12506 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12508__$1,inst_12506);
} else {
if((state_val_12509 === (25))){
var state_12508__$1 = state_12508;
var statearr_12523_12565 = state_12508__$1;
(statearr_12523_12565[(2)] = null);

(statearr_12523_12565[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (17))){
var inst_12482 = (state_12508[(14)]);
var state_12508__$1 = state_12508;
var statearr_12524_12566 = state_12508__$1;
(statearr_12524_12566[(2)] = inst_12482);

(statearr_12524_12566[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (3))){
var inst_12442 = (state_12508[(9)]);
var state_12508__$1 = state_12508;
var statearr_12525_12567 = state_12508__$1;
(statearr_12525_12567[(2)] = inst_12442);

(statearr_12525_12567[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (12))){
var inst_12461 = (state_12508[(15)]);
var inst_12482 = (state_12508[(14)]);
var inst_12468 = (state_12508[(16)]);
var inst_12482__$1 = inst_12461.call(null,inst_12468);
var state_12508__$1 = (function (){var statearr_12526 = state_12508;
(statearr_12526[(14)] = inst_12482__$1);

return statearr_12526;
})();
if(cljs.core.truth_(inst_12482__$1)){
var statearr_12527_12568 = state_12508__$1;
(statearr_12527_12568[(1)] = (17));

} else {
var statearr_12528_12569 = state_12508__$1;
(statearr_12528_12569[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (2))){
var inst_12442 = (state_12508[(9)]);
var inst_12445 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12442);
var state_12508__$1 = state_12508;
var statearr_12529_12570 = state_12508__$1;
(statearr_12529_12570[(2)] = inst_12445);

(statearr_12529_12570[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (23))){
var inst_12493 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
if(cljs.core.truth_(inst_12493)){
var statearr_12530_12571 = state_12508__$1;
(statearr_12530_12571[(1)] = (24));

} else {
var statearr_12531_12572 = state_12508__$1;
(statearr_12531_12572[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (19))){
var inst_12490 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
if(cljs.core.truth_(inst_12490)){
var statearr_12532_12573 = state_12508__$1;
(statearr_12532_12573[(1)] = (20));

} else {
var statearr_12533_12574 = state_12508__$1;
(statearr_12533_12574[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (11))){
var inst_12467 = (state_12508[(8)]);
var inst_12473 = (inst_12467 == null);
var state_12508__$1 = state_12508;
if(cljs.core.truth_(inst_12473)){
var statearr_12534_12575 = state_12508__$1;
(statearr_12534_12575[(1)] = (14));

} else {
var statearr_12535_12576 = state_12508__$1;
(statearr_12535_12576[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (9))){
var inst_12460 = (state_12508[(10)]);
var inst_12460__$1 = (state_12508[(2)]);
var inst_12461 = cljs.core.get.call(null,inst_12460__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12462 = cljs.core.get.call(null,inst_12460__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12463 = cljs.core.get.call(null,inst_12460__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12508__$1 = (function (){var statearr_12536 = state_12508;
(statearr_12536[(10)] = inst_12460__$1);

(statearr_12536[(15)] = inst_12461);

(statearr_12536[(17)] = inst_12462);

return statearr_12536;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12508__$1,(10),inst_12463);
} else {
if((state_val_12509 === (5))){
var inst_12452 = (state_12508[(7)]);
var inst_12455 = cljs.core.seq_QMARK_.call(null,inst_12452);
var state_12508__$1 = state_12508;
if(inst_12455){
var statearr_12537_12577 = state_12508__$1;
(statearr_12537_12577[(1)] = (7));

} else {
var statearr_12538_12578 = state_12508__$1;
(statearr_12538_12578[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (14))){
var inst_12468 = (state_12508[(16)]);
var inst_12475 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12468);
var state_12508__$1 = state_12508;
var statearr_12539_12579 = state_12508__$1;
(statearr_12539_12579[(2)] = inst_12475);

(statearr_12539_12579[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (26))){
var inst_12498 = (state_12508[(2)]);
var state_12508__$1 = state_12508;
var statearr_12540_12580 = state_12508__$1;
(statearr_12540_12580[(2)] = inst_12498);

(statearr_12540_12580[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (16))){
var inst_12478 = (state_12508[(2)]);
var inst_12479 = calc_state.call(null);
var inst_12452 = inst_12479;
var state_12508__$1 = (function (){var statearr_12541 = state_12508;
(statearr_12541[(18)] = inst_12478);

(statearr_12541[(7)] = inst_12452);

return statearr_12541;
})();
var statearr_12542_12581 = state_12508__$1;
(statearr_12542_12581[(2)] = null);

(statearr_12542_12581[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (10))){
var inst_12467 = (state_12508[(8)]);
var inst_12468 = (state_12508[(16)]);
var inst_12466 = (state_12508[(2)]);
var inst_12467__$1 = cljs.core.nth.call(null,inst_12466,(0),null);
var inst_12468__$1 = cljs.core.nth.call(null,inst_12466,(1),null);
var inst_12469 = (inst_12467__$1 == null);
var inst_12470 = cljs.core._EQ_.call(null,inst_12468__$1,change);
var inst_12471 = (inst_12469) || (inst_12470);
var state_12508__$1 = (function (){var statearr_12543 = state_12508;
(statearr_12543[(8)] = inst_12467__$1);

(statearr_12543[(16)] = inst_12468__$1);

return statearr_12543;
})();
if(cljs.core.truth_(inst_12471)){
var statearr_12544_12582 = state_12508__$1;
(statearr_12544_12582[(1)] = (11));

} else {
var statearr_12545_12583 = state_12508__$1;
(statearr_12545_12583[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (18))){
var inst_12461 = (state_12508[(15)]);
var inst_12462 = (state_12508[(17)]);
var inst_12468 = (state_12508[(16)]);
var inst_12485 = cljs.core.empty_QMARK_.call(null,inst_12461);
var inst_12486 = inst_12462.call(null,inst_12468);
var inst_12487 = cljs.core.not.call(null,inst_12486);
var inst_12488 = (inst_12485) && (inst_12487);
var state_12508__$1 = state_12508;
var statearr_12546_12584 = state_12508__$1;
(statearr_12546_12584[(2)] = inst_12488);

(statearr_12546_12584[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12509 === (8))){
var inst_12452 = (state_12508[(7)]);
var state_12508__$1 = state_12508;
var statearr_12547_12585 = state_12508__$1;
(statearr_12547_12585[(2)] = inst_12452);

(statearr_12547_12585[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__6741__auto__,c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__6742__auto__ = null;
var cljs$core$async$mix_$_state_machine__6742__auto____0 = (function (){
var statearr_12551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12551[(0)] = cljs$core$async$mix_$_state_machine__6742__auto__);

(statearr_12551[(1)] = (1));

return statearr_12551;
});
var cljs$core$async$mix_$_state_machine__6742__auto____1 = (function (state_12508){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12552){if((e12552 instanceof Object)){
var ex__6745__auto__ = e12552;
var statearr_12553_12586 = state_12508;
(statearr_12553_12586[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12587 = state_12508;
state_12508 = G__12587;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__6742__auto__ = function(state_12508){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__6742__auto____1.call(this,state_12508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__6742__auto____0;
cljs$core$async$mix_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__6742__auto____1;
return cljs$core$async$mix_$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__6805__auto__ = (function (){var statearr_12554 = f__6804__auto__.call(null);
(statearr_12554[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12555);

return statearr_12554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12555,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj12589 = {};
return obj12589;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4287__auto__ = p;
if(and__4287__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4287__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4935__auto__ = (((p == null))?null:p);
return (function (){var or__4299__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4287__auto__ = p;
if(and__4287__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4287__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4935__auto__ = (((p == null))?null:p);
return (function (){var or__4299__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__12591 = arguments.length;
switch (G__12591) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4287__auto__ = p;
if(and__4287__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4287__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4935__auto__ = (((p == null))?null:p);
return (function (){var or__4299__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4287__auto__ = p;
if(and__4287__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4287__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4935__auto__ = (((p == null))?null:p);
return (function (){var or__4299__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4935__auto__)]);
if(or__4299__auto__){
return or__4299__auto__;
} else {
var or__4299__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4299__auto____$1){
return or__4299__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__12595 = arguments.length;
switch (G__12595) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4299__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4299__auto__,mults){
return (function (p1__12593_SHARP_){
if(cljs.core.truth_(p1__12593_SHARP_.call(null,topic))){
return p1__12593_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12593_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4299__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t12596 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12596 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12597){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12597 = meta12597;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12596.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12598,meta12597__$1){
var self__ = this;
var _12598__$1 = this;
return (new cljs.core.async.t12596(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12597__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12598){
var self__ = this;
var _12598__$1 = this;
return self__.meta12597;
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t12596.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t12596.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t12596.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t12596.cljs$lang$type = true;

cljs.core.async.t12596.cljs$lang$ctorStr = "cljs.core.async/t12596";

cljs.core.async.t12596.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12596");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t12596 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t12596(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12597){
return (new cljs.core.async.t12596(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12597));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t12596(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__6803__auto___12719 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12719,mults,ensure_mult,p){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12719,mults,ensure_mult,p){
return (function (state_12670){
var state_val_12671 = (state_12670[(1)]);
if((state_val_12671 === (7))){
var inst_12666 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12672_12720 = state_12670__$1;
(statearr_12672_12720[(2)] = inst_12666);

(statearr_12672_12720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (20))){
var state_12670__$1 = state_12670;
var statearr_12673_12721 = state_12670__$1;
(statearr_12673_12721[(2)] = null);

(statearr_12673_12721[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (1))){
var state_12670__$1 = state_12670;
var statearr_12674_12722 = state_12670__$1;
(statearr_12674_12722[(2)] = null);

(statearr_12674_12722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (24))){
var inst_12649 = (state_12670[(7)]);
var inst_12658 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12649);
var state_12670__$1 = state_12670;
var statearr_12675_12723 = state_12670__$1;
(statearr_12675_12723[(2)] = inst_12658);

(statearr_12675_12723[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (4))){
var inst_12601 = (state_12670[(8)]);
var inst_12601__$1 = (state_12670[(2)]);
var inst_12602 = (inst_12601__$1 == null);
var state_12670__$1 = (function (){var statearr_12676 = state_12670;
(statearr_12676[(8)] = inst_12601__$1);

return statearr_12676;
})();
if(cljs.core.truth_(inst_12602)){
var statearr_12677_12724 = state_12670__$1;
(statearr_12677_12724[(1)] = (5));

} else {
var statearr_12678_12725 = state_12670__$1;
(statearr_12678_12725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (15))){
var inst_12643 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12679_12726 = state_12670__$1;
(statearr_12679_12726[(2)] = inst_12643);

(statearr_12679_12726[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (21))){
var inst_12663 = (state_12670[(2)]);
var state_12670__$1 = (function (){var statearr_12680 = state_12670;
(statearr_12680[(9)] = inst_12663);

return statearr_12680;
})();
var statearr_12681_12727 = state_12670__$1;
(statearr_12681_12727[(2)] = null);

(statearr_12681_12727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (13))){
var inst_12625 = (state_12670[(10)]);
var inst_12627 = cljs.core.chunked_seq_QMARK_.call(null,inst_12625);
var state_12670__$1 = state_12670;
if(inst_12627){
var statearr_12682_12728 = state_12670__$1;
(statearr_12682_12728[(1)] = (16));

} else {
var statearr_12683_12729 = state_12670__$1;
(statearr_12683_12729[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (22))){
var inst_12655 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
if(cljs.core.truth_(inst_12655)){
var statearr_12684_12730 = state_12670__$1;
(statearr_12684_12730[(1)] = (23));

} else {
var statearr_12685_12731 = state_12670__$1;
(statearr_12685_12731[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (6))){
var inst_12601 = (state_12670[(8)]);
var inst_12649 = (state_12670[(7)]);
var inst_12651 = (state_12670[(11)]);
var inst_12649__$1 = topic_fn.call(null,inst_12601);
var inst_12650 = cljs.core.deref.call(null,mults);
var inst_12651__$1 = cljs.core.get.call(null,inst_12650,inst_12649__$1);
var state_12670__$1 = (function (){var statearr_12686 = state_12670;
(statearr_12686[(7)] = inst_12649__$1);

(statearr_12686[(11)] = inst_12651__$1);

return statearr_12686;
})();
if(cljs.core.truth_(inst_12651__$1)){
var statearr_12687_12732 = state_12670__$1;
(statearr_12687_12732[(1)] = (19));

} else {
var statearr_12688_12733 = state_12670__$1;
(statearr_12688_12733[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (25))){
var inst_12660 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12689_12734 = state_12670__$1;
(statearr_12689_12734[(2)] = inst_12660);

(statearr_12689_12734[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (17))){
var inst_12625 = (state_12670[(10)]);
var inst_12634 = cljs.core.first.call(null,inst_12625);
var inst_12635 = cljs.core.async.muxch_STAR_.call(null,inst_12634);
var inst_12636 = cljs.core.async.close_BANG_.call(null,inst_12635);
var inst_12637 = cljs.core.next.call(null,inst_12625);
var inst_12611 = inst_12637;
var inst_12612 = null;
var inst_12613 = (0);
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12690 = state_12670;
(statearr_12690[(12)] = inst_12613);

(statearr_12690[(13)] = inst_12614);

(statearr_12690[(14)] = inst_12636);

(statearr_12690[(15)] = inst_12611);

(statearr_12690[(16)] = inst_12612);

return statearr_12690;
})();
var statearr_12691_12735 = state_12670__$1;
(statearr_12691_12735[(2)] = null);

(statearr_12691_12735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (3))){
var inst_12668 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12670__$1,inst_12668);
} else {
if((state_val_12671 === (12))){
var inst_12645 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12692_12736 = state_12670__$1;
(statearr_12692_12736[(2)] = inst_12645);

(statearr_12692_12736[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (2))){
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12670__$1,(4),ch);
} else {
if((state_val_12671 === (23))){
var state_12670__$1 = state_12670;
var statearr_12693_12737 = state_12670__$1;
(statearr_12693_12737[(2)] = null);

(statearr_12693_12737[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (19))){
var inst_12601 = (state_12670[(8)]);
var inst_12651 = (state_12670[(11)]);
var inst_12653 = cljs.core.async.muxch_STAR_.call(null,inst_12651);
var state_12670__$1 = state_12670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12670__$1,(22),inst_12653,inst_12601);
} else {
if((state_val_12671 === (11))){
var inst_12611 = (state_12670[(15)]);
var inst_12625 = (state_12670[(10)]);
var inst_12625__$1 = cljs.core.seq.call(null,inst_12611);
var state_12670__$1 = (function (){var statearr_12694 = state_12670;
(statearr_12694[(10)] = inst_12625__$1);

return statearr_12694;
})();
if(inst_12625__$1){
var statearr_12695_12738 = state_12670__$1;
(statearr_12695_12738[(1)] = (13));

} else {
var statearr_12696_12739 = state_12670__$1;
(statearr_12696_12739[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (9))){
var inst_12647 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12697_12740 = state_12670__$1;
(statearr_12697_12740[(2)] = inst_12647);

(statearr_12697_12740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (5))){
var inst_12608 = cljs.core.deref.call(null,mults);
var inst_12609 = cljs.core.vals.call(null,inst_12608);
var inst_12610 = cljs.core.seq.call(null,inst_12609);
var inst_12611 = inst_12610;
var inst_12612 = null;
var inst_12613 = (0);
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12698 = state_12670;
(statearr_12698[(12)] = inst_12613);

(statearr_12698[(13)] = inst_12614);

(statearr_12698[(15)] = inst_12611);

(statearr_12698[(16)] = inst_12612);

return statearr_12698;
})();
var statearr_12699_12741 = state_12670__$1;
(statearr_12699_12741[(2)] = null);

(statearr_12699_12741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (14))){
var state_12670__$1 = state_12670;
var statearr_12703_12742 = state_12670__$1;
(statearr_12703_12742[(2)] = null);

(statearr_12703_12742[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (16))){
var inst_12625 = (state_12670[(10)]);
var inst_12629 = cljs.core.chunk_first.call(null,inst_12625);
var inst_12630 = cljs.core.chunk_rest.call(null,inst_12625);
var inst_12631 = cljs.core.count.call(null,inst_12629);
var inst_12611 = inst_12630;
var inst_12612 = inst_12629;
var inst_12613 = inst_12631;
var inst_12614 = (0);
var state_12670__$1 = (function (){var statearr_12704 = state_12670;
(statearr_12704[(12)] = inst_12613);

(statearr_12704[(13)] = inst_12614);

(statearr_12704[(15)] = inst_12611);

(statearr_12704[(16)] = inst_12612);

return statearr_12704;
})();
var statearr_12705_12743 = state_12670__$1;
(statearr_12705_12743[(2)] = null);

(statearr_12705_12743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (10))){
var inst_12613 = (state_12670[(12)]);
var inst_12614 = (state_12670[(13)]);
var inst_12611 = (state_12670[(15)]);
var inst_12612 = (state_12670[(16)]);
var inst_12619 = cljs.core._nth.call(null,inst_12612,inst_12614);
var inst_12620 = cljs.core.async.muxch_STAR_.call(null,inst_12619);
var inst_12621 = cljs.core.async.close_BANG_.call(null,inst_12620);
var inst_12622 = (inst_12614 + (1));
var tmp12700 = inst_12613;
var tmp12701 = inst_12611;
var tmp12702 = inst_12612;
var inst_12611__$1 = tmp12701;
var inst_12612__$1 = tmp12702;
var inst_12613__$1 = tmp12700;
var inst_12614__$1 = inst_12622;
var state_12670__$1 = (function (){var statearr_12706 = state_12670;
(statearr_12706[(12)] = inst_12613__$1);

(statearr_12706[(13)] = inst_12614__$1);

(statearr_12706[(17)] = inst_12621);

(statearr_12706[(15)] = inst_12611__$1);

(statearr_12706[(16)] = inst_12612__$1);

return statearr_12706;
})();
var statearr_12707_12744 = state_12670__$1;
(statearr_12707_12744[(2)] = null);

(statearr_12707_12744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (18))){
var inst_12640 = (state_12670[(2)]);
var state_12670__$1 = state_12670;
var statearr_12708_12745 = state_12670__$1;
(statearr_12708_12745[(2)] = inst_12640);

(statearr_12708_12745[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12671 === (8))){
var inst_12613 = (state_12670[(12)]);
var inst_12614 = (state_12670[(13)]);
var inst_12616 = (inst_12614 < inst_12613);
var inst_12617 = inst_12616;
var state_12670__$1 = state_12670;
if(cljs.core.truth_(inst_12617)){
var statearr_12709_12746 = state_12670__$1;
(statearr_12709_12746[(1)] = (10));

} else {
var statearr_12710_12747 = state_12670__$1;
(statearr_12710_12747[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12719,mults,ensure_mult,p))
;
return ((function (switch__6741__auto__,c__6803__auto___12719,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_12714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12714[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_12714[(1)] = (1));

return statearr_12714;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_12670){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12715){if((e12715 instanceof Object)){
var ex__6745__auto__ = e12715;
var statearr_12716_12748 = state_12670;
(statearr_12716_12748[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12749 = state_12670;
state_12670 = G__12749;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_12670){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_12670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12719,mults,ensure_mult,p))
})();
var state__6805__auto__ = (function (){var statearr_12717 = f__6804__auto__.call(null);
(statearr_12717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12719);

return statearr_12717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12719,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__12751 = arguments.length;
switch (G__12751) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__12754 = arguments.length;
switch (G__12754) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__12757 = arguments.length;
switch (G__12757) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__6803__auto___12827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12796){
var state_val_12797 = (state_12796[(1)]);
if((state_val_12797 === (7))){
var state_12796__$1 = state_12796;
var statearr_12798_12828 = state_12796__$1;
(statearr_12798_12828[(2)] = null);

(statearr_12798_12828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (1))){
var state_12796__$1 = state_12796;
var statearr_12799_12829 = state_12796__$1;
(statearr_12799_12829[(2)] = null);

(statearr_12799_12829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (4))){
var inst_12760 = (state_12796[(7)]);
var inst_12762 = (inst_12760 < cnt);
var state_12796__$1 = state_12796;
if(cljs.core.truth_(inst_12762)){
var statearr_12800_12830 = state_12796__$1;
(statearr_12800_12830[(1)] = (6));

} else {
var statearr_12801_12831 = state_12796__$1;
(statearr_12801_12831[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (15))){
var inst_12792 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12802_12832 = state_12796__$1;
(statearr_12802_12832[(2)] = inst_12792);

(statearr_12802_12832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (13))){
var inst_12785 = cljs.core.async.close_BANG_.call(null,out);
var state_12796__$1 = state_12796;
var statearr_12803_12833 = state_12796__$1;
(statearr_12803_12833[(2)] = inst_12785);

(statearr_12803_12833[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (6))){
var state_12796__$1 = state_12796;
var statearr_12804_12834 = state_12796__$1;
(statearr_12804_12834[(2)] = null);

(statearr_12804_12834[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (3))){
var inst_12794 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12796__$1,inst_12794);
} else {
if((state_val_12797 === (12))){
var inst_12782 = (state_12796[(8)]);
var inst_12782__$1 = (state_12796[(2)]);
var inst_12783 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12782__$1);
var state_12796__$1 = (function (){var statearr_12805 = state_12796;
(statearr_12805[(8)] = inst_12782__$1);

return statearr_12805;
})();
if(cljs.core.truth_(inst_12783)){
var statearr_12806_12835 = state_12796__$1;
(statearr_12806_12835[(1)] = (13));

} else {
var statearr_12807_12836 = state_12796__$1;
(statearr_12807_12836[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (2))){
var inst_12759 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12760 = (0);
var state_12796__$1 = (function (){var statearr_12808 = state_12796;
(statearr_12808[(7)] = inst_12760);

(statearr_12808[(9)] = inst_12759);

return statearr_12808;
})();
var statearr_12809_12837 = state_12796__$1;
(statearr_12809_12837[(2)] = null);

(statearr_12809_12837[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (11))){
var inst_12760 = (state_12796[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12796,(10),Object,null,(9));
var inst_12769 = chs__$1.call(null,inst_12760);
var inst_12770 = done.call(null,inst_12760);
var inst_12771 = cljs.core.async.take_BANG_.call(null,inst_12769,inst_12770);
var state_12796__$1 = state_12796;
var statearr_12810_12838 = state_12796__$1;
(statearr_12810_12838[(2)] = inst_12771);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12796__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (9))){
var inst_12760 = (state_12796[(7)]);
var inst_12773 = (state_12796[(2)]);
var inst_12774 = (inst_12760 + (1));
var inst_12760__$1 = inst_12774;
var state_12796__$1 = (function (){var statearr_12811 = state_12796;
(statearr_12811[(10)] = inst_12773);

(statearr_12811[(7)] = inst_12760__$1);

return statearr_12811;
})();
var statearr_12812_12839 = state_12796__$1;
(statearr_12812_12839[(2)] = null);

(statearr_12812_12839[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (5))){
var inst_12780 = (state_12796[(2)]);
var state_12796__$1 = (function (){var statearr_12813 = state_12796;
(statearr_12813[(11)] = inst_12780);

return statearr_12813;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12796__$1,(12),dchan);
} else {
if((state_val_12797 === (14))){
var inst_12782 = (state_12796[(8)]);
var inst_12787 = cljs.core.apply.call(null,f,inst_12782);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12796__$1,(16),out,inst_12787);
} else {
if((state_val_12797 === (16))){
var inst_12789 = (state_12796[(2)]);
var state_12796__$1 = (function (){var statearr_12814 = state_12796;
(statearr_12814[(12)] = inst_12789);

return statearr_12814;
})();
var statearr_12815_12840 = state_12796__$1;
(statearr_12815_12840[(2)] = null);

(statearr_12815_12840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (10))){
var inst_12764 = (state_12796[(2)]);
var inst_12765 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12796__$1 = (function (){var statearr_12816 = state_12796;
(statearr_12816[(13)] = inst_12764);

return statearr_12816;
})();
var statearr_12817_12841 = state_12796__$1;
(statearr_12817_12841[(2)] = inst_12765);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12796__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (8))){
var inst_12778 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12818_12842 = state_12796__$1;
(statearr_12818_12842[(2)] = inst_12778);

(statearr_12818_12842[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__6741__auto__,c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_12822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12822[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_12822[(1)] = (1));

return statearr_12822;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_12796){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12823){if((e12823 instanceof Object)){
var ex__6745__auto__ = e12823;
var statearr_12824_12843 = state_12796;
(statearr_12824_12843[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12823;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12844 = state_12796;
state_12796 = G__12844;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_12796){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_12796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__6805__auto__ = (function (){var statearr_12825 = f__6804__auto__.call(null);
(statearr_12825[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12827);

return statearr_12825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12827,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__12847 = arguments.length;
switch (G__12847) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___12902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12902,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12902,out){
return (function (state_12877){
var state_val_12878 = (state_12877[(1)]);
if((state_val_12878 === (7))){
var inst_12856 = (state_12877[(7)]);
var inst_12857 = (state_12877[(8)]);
var inst_12856__$1 = (state_12877[(2)]);
var inst_12857__$1 = cljs.core.nth.call(null,inst_12856__$1,(0),null);
var inst_12858 = cljs.core.nth.call(null,inst_12856__$1,(1),null);
var inst_12859 = (inst_12857__$1 == null);
var state_12877__$1 = (function (){var statearr_12879 = state_12877;
(statearr_12879[(7)] = inst_12856__$1);

(statearr_12879[(8)] = inst_12857__$1);

(statearr_12879[(9)] = inst_12858);

return statearr_12879;
})();
if(cljs.core.truth_(inst_12859)){
var statearr_12880_12903 = state_12877__$1;
(statearr_12880_12903[(1)] = (8));

} else {
var statearr_12881_12904 = state_12877__$1;
(statearr_12881_12904[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (1))){
var inst_12848 = cljs.core.vec.call(null,chs);
var inst_12849 = inst_12848;
var state_12877__$1 = (function (){var statearr_12882 = state_12877;
(statearr_12882[(10)] = inst_12849);

return statearr_12882;
})();
var statearr_12883_12905 = state_12877__$1;
(statearr_12883_12905[(2)] = null);

(statearr_12883_12905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (4))){
var inst_12849 = (state_12877[(10)]);
var state_12877__$1 = state_12877;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12877__$1,(7),inst_12849);
} else {
if((state_val_12878 === (6))){
var inst_12873 = (state_12877[(2)]);
var state_12877__$1 = state_12877;
var statearr_12884_12906 = state_12877__$1;
(statearr_12884_12906[(2)] = inst_12873);

(statearr_12884_12906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (3))){
var inst_12875 = (state_12877[(2)]);
var state_12877__$1 = state_12877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12877__$1,inst_12875);
} else {
if((state_val_12878 === (2))){
var inst_12849 = (state_12877[(10)]);
var inst_12851 = cljs.core.count.call(null,inst_12849);
var inst_12852 = (inst_12851 > (0));
var state_12877__$1 = state_12877;
if(cljs.core.truth_(inst_12852)){
var statearr_12886_12907 = state_12877__$1;
(statearr_12886_12907[(1)] = (4));

} else {
var statearr_12887_12908 = state_12877__$1;
(statearr_12887_12908[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (11))){
var inst_12849 = (state_12877[(10)]);
var inst_12866 = (state_12877[(2)]);
var tmp12885 = inst_12849;
var inst_12849__$1 = tmp12885;
var state_12877__$1 = (function (){var statearr_12888 = state_12877;
(statearr_12888[(10)] = inst_12849__$1);

(statearr_12888[(11)] = inst_12866);

return statearr_12888;
})();
var statearr_12889_12909 = state_12877__$1;
(statearr_12889_12909[(2)] = null);

(statearr_12889_12909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (9))){
var inst_12857 = (state_12877[(8)]);
var state_12877__$1 = state_12877;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12877__$1,(11),out,inst_12857);
} else {
if((state_val_12878 === (5))){
var inst_12871 = cljs.core.async.close_BANG_.call(null,out);
var state_12877__$1 = state_12877;
var statearr_12890_12910 = state_12877__$1;
(statearr_12890_12910[(2)] = inst_12871);

(statearr_12890_12910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (10))){
var inst_12869 = (state_12877[(2)]);
var state_12877__$1 = state_12877;
var statearr_12891_12911 = state_12877__$1;
(statearr_12891_12911[(2)] = inst_12869);

(statearr_12891_12911[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12878 === (8))){
var inst_12856 = (state_12877[(7)]);
var inst_12849 = (state_12877[(10)]);
var inst_12857 = (state_12877[(8)]);
var inst_12858 = (state_12877[(9)]);
var inst_12861 = (function (){var cs = inst_12849;
var vec__12854 = inst_12856;
var v = inst_12857;
var c = inst_12858;
return ((function (cs,vec__12854,v,c,inst_12856,inst_12849,inst_12857,inst_12858,state_val_12878,c__6803__auto___12902,out){
return (function (p1__12845_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12845_SHARP_);
});
;})(cs,vec__12854,v,c,inst_12856,inst_12849,inst_12857,inst_12858,state_val_12878,c__6803__auto___12902,out))
})();
var inst_12862 = cljs.core.filterv.call(null,inst_12861,inst_12849);
var inst_12849__$1 = inst_12862;
var state_12877__$1 = (function (){var statearr_12892 = state_12877;
(statearr_12892[(10)] = inst_12849__$1);

return statearr_12892;
})();
var statearr_12893_12912 = state_12877__$1;
(statearr_12893_12912[(2)] = null);

(statearr_12893_12912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12902,out))
;
return ((function (switch__6741__auto__,c__6803__auto___12902,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_12897 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12897[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_12897[(1)] = (1));

return statearr_12897;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_12877){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12898){if((e12898 instanceof Object)){
var ex__6745__auto__ = e12898;
var statearr_12899_12913 = state_12877;
(statearr_12899_12913[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12914 = state_12877;
state_12877 = G__12914;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_12877){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_12877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12902,out))
})();
var state__6805__auto__ = (function (){var statearr_12900 = f__6804__auto__.call(null);
(statearr_12900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12902);

return statearr_12900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12902,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__12916 = arguments.length;
switch (G__12916) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___12964 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___12964,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___12964,out){
return (function (state_12940){
var state_val_12941 = (state_12940[(1)]);
if((state_val_12941 === (7))){
var inst_12922 = (state_12940[(7)]);
var inst_12922__$1 = (state_12940[(2)]);
var inst_12923 = (inst_12922__$1 == null);
var inst_12924 = cljs.core.not.call(null,inst_12923);
var state_12940__$1 = (function (){var statearr_12942 = state_12940;
(statearr_12942[(7)] = inst_12922__$1);

return statearr_12942;
})();
if(inst_12924){
var statearr_12943_12965 = state_12940__$1;
(statearr_12943_12965[(1)] = (8));

} else {
var statearr_12944_12966 = state_12940__$1;
(statearr_12944_12966[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (1))){
var inst_12917 = (0);
var state_12940__$1 = (function (){var statearr_12945 = state_12940;
(statearr_12945[(8)] = inst_12917);

return statearr_12945;
})();
var statearr_12946_12967 = state_12940__$1;
(statearr_12946_12967[(2)] = null);

(statearr_12946_12967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (4))){
var state_12940__$1 = state_12940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12940__$1,(7),ch);
} else {
if((state_val_12941 === (6))){
var inst_12935 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
var statearr_12947_12968 = state_12940__$1;
(statearr_12947_12968[(2)] = inst_12935);

(statearr_12947_12968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (3))){
var inst_12937 = (state_12940[(2)]);
var inst_12938 = cljs.core.async.close_BANG_.call(null,out);
var state_12940__$1 = (function (){var statearr_12948 = state_12940;
(statearr_12948[(9)] = inst_12937);

return statearr_12948;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12940__$1,inst_12938);
} else {
if((state_val_12941 === (2))){
var inst_12917 = (state_12940[(8)]);
var inst_12919 = (inst_12917 < n);
var state_12940__$1 = state_12940;
if(cljs.core.truth_(inst_12919)){
var statearr_12949_12969 = state_12940__$1;
(statearr_12949_12969[(1)] = (4));

} else {
var statearr_12950_12970 = state_12940__$1;
(statearr_12950_12970[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (11))){
var inst_12917 = (state_12940[(8)]);
var inst_12927 = (state_12940[(2)]);
var inst_12928 = (inst_12917 + (1));
var inst_12917__$1 = inst_12928;
var state_12940__$1 = (function (){var statearr_12951 = state_12940;
(statearr_12951[(10)] = inst_12927);

(statearr_12951[(8)] = inst_12917__$1);

return statearr_12951;
})();
var statearr_12952_12971 = state_12940__$1;
(statearr_12952_12971[(2)] = null);

(statearr_12952_12971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (9))){
var state_12940__$1 = state_12940;
var statearr_12953_12972 = state_12940__$1;
(statearr_12953_12972[(2)] = null);

(statearr_12953_12972[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (5))){
var state_12940__$1 = state_12940;
var statearr_12954_12973 = state_12940__$1;
(statearr_12954_12973[(2)] = null);

(statearr_12954_12973[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (10))){
var inst_12932 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
var statearr_12955_12974 = state_12940__$1;
(statearr_12955_12974[(2)] = inst_12932);

(statearr_12955_12974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (8))){
var inst_12922 = (state_12940[(7)]);
var state_12940__$1 = state_12940;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12940__$1,(11),out,inst_12922);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___12964,out))
;
return ((function (switch__6741__auto__,c__6803__auto___12964,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_12959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12959[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_12959[(1)] = (1));

return statearr_12959;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_12940){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_12940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e12960){if((e12960 instanceof Object)){
var ex__6745__auto__ = e12960;
var statearr_12961_12975 = state_12940;
(statearr_12961_12975[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12976 = state_12940;
state_12940 = G__12976;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_12940){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_12940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___12964,out))
})();
var state__6805__auto__ = (function (){var statearr_12962 = f__6804__auto__.call(null);
(statearr_12962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___12964);

return statearr_12962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___12964,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t12984 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12984 = (function (map_LT_,f,ch,meta12985){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta12985 = meta12985;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12984.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12986,meta12985__$1){
var self__ = this;
var _12986__$1 = this;
return (new cljs.core.async.t12984(self__.map_LT_,self__.f,self__.ch,meta12985__$1));
});

cljs.core.async.t12984.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12986){
var self__ = this;
var _12986__$1 = this;
return self__.meta12985;
});

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t12987 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12987 = (function (map_LT_,f,ch,meta12985,_,fn1,meta12988){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta12985 = meta12985;
this._ = _;
this.fn1 = fn1;
this.meta12988 = meta12988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_12989,meta12988__$1){
var self__ = this;
var _12989__$1 = this;
return (new cljs.core.async.t12987(self__.map_LT_,self__.f,self__.ch,self__.meta12985,self__._,self__.fn1,meta12988__$1));
});})(___$1))
;

cljs.core.async.t12987.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_12989){
var self__ = this;
var _12989__$1 = this;
return self__.meta12988;
});})(___$1))
;

cljs.core.async.t12987.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12987.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t12987.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t12987.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__12977_SHARP_){
return f1.call(null,(((p1__12977_SHARP_ == null))?null:self__.f.call(null,p1__12977_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t12987.cljs$lang$type = true;

cljs.core.async.t12987.cljs$lang$ctorStr = "cljs.core.async/t12987";

cljs.core.async.t12987.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12987");
});})(___$1))
;

cljs.core.async.__GT_t12987 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t12987(map_LT___$1,f__$1,ch__$1,meta12985__$1,___$2,fn1__$1,meta12988){
return (new cljs.core.async.t12987(map_LT___$1,f__$1,ch__$1,meta12985__$1,___$2,fn1__$1,meta12988));
});})(___$1))
;

}

return (new cljs.core.async.t12987(self__.map_LT_,self__.f,self__.ch,self__.meta12985,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4287__auto__ = ret;
if(cljs.core.truth_(and__4287__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4287__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t12984.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t12984.cljs$lang$type = true;

cljs.core.async.t12984.cljs$lang$ctorStr = "cljs.core.async/t12984";

cljs.core.async.t12984.cljs$lang$ctorPrWriter = (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12984");
});

cljs.core.async.__GT_t12984 = (function cljs$core$async$map_LT__$___GT_t12984(map_LT___$1,f__$1,ch__$1,meta12985){
return (new cljs.core.async.t12984(map_LT___$1,f__$1,ch__$1,meta12985));
});

}

return (new cljs.core.async.t12984(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t12993 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12993 = (function (map_GT_,f,ch,meta12994){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta12994 = meta12994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12995,meta12994__$1){
var self__ = this;
var _12995__$1 = this;
return (new cljs.core.async.t12993(self__.map_GT_,self__.f,self__.ch,meta12994__$1));
});

cljs.core.async.t12993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12995){
var self__ = this;
var _12995__$1 = this;
return self__.meta12994;
});

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t12993.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t12993.cljs$lang$type = true;

cljs.core.async.t12993.cljs$lang$ctorStr = "cljs.core.async/t12993";

cljs.core.async.t12993.cljs$lang$ctorPrWriter = (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12993");
});

cljs.core.async.__GT_t12993 = (function cljs$core$async$map_GT__$___GT_t12993(map_GT___$1,f__$1,ch__$1,meta12994){
return (new cljs.core.async.t12993(map_GT___$1,f__$1,ch__$1,meta12994));
});

}

return (new cljs.core.async.t12993(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t12999 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12999 = (function (filter_GT_,p,ch,meta13000){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13000 = meta13000;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t12999.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13001,meta13000__$1){
var self__ = this;
var _13001__$1 = this;
return (new cljs.core.async.t12999(self__.filter_GT_,self__.p,self__.ch,meta13000__$1));
});

cljs.core.async.t12999.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13001){
var self__ = this;
var _13001__$1 = this;
return self__.meta13000;
});

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t12999.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t12999.cljs$lang$type = true;

cljs.core.async.t12999.cljs$lang$ctorStr = "cljs.core.async/t12999";

cljs.core.async.t12999.cljs$lang$ctorPrWriter = (function (this__4878__auto__,writer__4879__auto__,opt__4880__auto__){
return cljs.core._write.call(null,writer__4879__auto__,"cljs.core.async/t12999");
});

cljs.core.async.__GT_t12999 = (function cljs$core$async$filter_GT__$___GT_t12999(filter_GT___$1,p__$1,ch__$1,meta13000){
return (new cljs.core.async.t12999(filter_GT___$1,p__$1,ch__$1,meta13000));
});

}

return (new cljs.core.async.t12999(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__13003 = arguments.length;
switch (G__13003) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___13046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___13046,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___13046,out){
return (function (state_13024){
var state_val_13025 = (state_13024[(1)]);
if((state_val_13025 === (7))){
var inst_13020 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
var statearr_13026_13047 = state_13024__$1;
(statearr_13026_13047[(2)] = inst_13020);

(statearr_13026_13047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (1))){
var state_13024__$1 = state_13024;
var statearr_13027_13048 = state_13024__$1;
(statearr_13027_13048[(2)] = null);

(statearr_13027_13048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (4))){
var inst_13006 = (state_13024[(7)]);
var inst_13006__$1 = (state_13024[(2)]);
var inst_13007 = (inst_13006__$1 == null);
var state_13024__$1 = (function (){var statearr_13028 = state_13024;
(statearr_13028[(7)] = inst_13006__$1);

return statearr_13028;
})();
if(cljs.core.truth_(inst_13007)){
var statearr_13029_13049 = state_13024__$1;
(statearr_13029_13049[(1)] = (5));

} else {
var statearr_13030_13050 = state_13024__$1;
(statearr_13030_13050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (6))){
var inst_13006 = (state_13024[(7)]);
var inst_13011 = p.call(null,inst_13006);
var state_13024__$1 = state_13024;
if(cljs.core.truth_(inst_13011)){
var statearr_13031_13051 = state_13024__$1;
(statearr_13031_13051[(1)] = (8));

} else {
var statearr_13032_13052 = state_13024__$1;
(statearr_13032_13052[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (3))){
var inst_13022 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13024__$1,inst_13022);
} else {
if((state_val_13025 === (2))){
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13024__$1,(4),ch);
} else {
if((state_val_13025 === (11))){
var inst_13014 = (state_13024[(2)]);
var state_13024__$1 = state_13024;
var statearr_13033_13053 = state_13024__$1;
(statearr_13033_13053[(2)] = inst_13014);

(statearr_13033_13053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (9))){
var state_13024__$1 = state_13024;
var statearr_13034_13054 = state_13024__$1;
(statearr_13034_13054[(2)] = null);

(statearr_13034_13054[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (5))){
var inst_13009 = cljs.core.async.close_BANG_.call(null,out);
var state_13024__$1 = state_13024;
var statearr_13035_13055 = state_13024__$1;
(statearr_13035_13055[(2)] = inst_13009);

(statearr_13035_13055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (10))){
var inst_13017 = (state_13024[(2)]);
var state_13024__$1 = (function (){var statearr_13036 = state_13024;
(statearr_13036[(8)] = inst_13017);

return statearr_13036;
})();
var statearr_13037_13056 = state_13024__$1;
(statearr_13037_13056[(2)] = null);

(statearr_13037_13056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13025 === (8))){
var inst_13006 = (state_13024[(7)]);
var state_13024__$1 = state_13024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13024__$1,(11),out,inst_13006);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___13046,out))
;
return ((function (switch__6741__auto__,c__6803__auto___13046,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_13041 = [null,null,null,null,null,null,null,null,null];
(statearr_13041[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_13041[(1)] = (1));

return statearr_13041;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_13024){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_13024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e13042){if((e13042 instanceof Object)){
var ex__6745__auto__ = e13042;
var statearr_13043_13057 = state_13024;
(statearr_13043_13057[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13042;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13058 = state_13024;
state_13024 = G__13058;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_13024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_13024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___13046,out))
})();
var state__6805__auto__ = (function (){var statearr_13044 = f__6804__auto__.call(null);
(statearr_13044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___13046);

return statearr_13044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___13046,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__13060 = arguments.length;
switch (G__13060) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__6803__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto__){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto__){
return (function (state_13227){
var state_val_13228 = (state_13227[(1)]);
if((state_val_13228 === (7))){
var inst_13223 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
var statearr_13229_13270 = state_13227__$1;
(statearr_13229_13270[(2)] = inst_13223);

(statearr_13229_13270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (20))){
var inst_13193 = (state_13227[(7)]);
var inst_13204 = (state_13227[(2)]);
var inst_13205 = cljs.core.next.call(null,inst_13193);
var inst_13179 = inst_13205;
var inst_13180 = null;
var inst_13181 = (0);
var inst_13182 = (0);
var state_13227__$1 = (function (){var statearr_13230 = state_13227;
(statearr_13230[(8)] = inst_13204);

(statearr_13230[(9)] = inst_13179);

(statearr_13230[(10)] = inst_13180);

(statearr_13230[(11)] = inst_13182);

(statearr_13230[(12)] = inst_13181);

return statearr_13230;
})();
var statearr_13231_13271 = state_13227__$1;
(statearr_13231_13271[(2)] = null);

(statearr_13231_13271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (1))){
var state_13227__$1 = state_13227;
var statearr_13232_13272 = state_13227__$1;
(statearr_13232_13272[(2)] = null);

(statearr_13232_13272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (4))){
var inst_13168 = (state_13227[(13)]);
var inst_13168__$1 = (state_13227[(2)]);
var inst_13169 = (inst_13168__$1 == null);
var state_13227__$1 = (function (){var statearr_13233 = state_13227;
(statearr_13233[(13)] = inst_13168__$1);

return statearr_13233;
})();
if(cljs.core.truth_(inst_13169)){
var statearr_13234_13273 = state_13227__$1;
(statearr_13234_13273[(1)] = (5));

} else {
var statearr_13235_13274 = state_13227__$1;
(statearr_13235_13274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (15))){
var state_13227__$1 = state_13227;
var statearr_13239_13275 = state_13227__$1;
(statearr_13239_13275[(2)] = null);

(statearr_13239_13275[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (21))){
var state_13227__$1 = state_13227;
var statearr_13240_13276 = state_13227__$1;
(statearr_13240_13276[(2)] = null);

(statearr_13240_13276[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (13))){
var inst_13179 = (state_13227[(9)]);
var inst_13180 = (state_13227[(10)]);
var inst_13182 = (state_13227[(11)]);
var inst_13181 = (state_13227[(12)]);
var inst_13189 = (state_13227[(2)]);
var inst_13190 = (inst_13182 + (1));
var tmp13236 = inst_13179;
var tmp13237 = inst_13180;
var tmp13238 = inst_13181;
var inst_13179__$1 = tmp13236;
var inst_13180__$1 = tmp13237;
var inst_13181__$1 = tmp13238;
var inst_13182__$1 = inst_13190;
var state_13227__$1 = (function (){var statearr_13241 = state_13227;
(statearr_13241[(14)] = inst_13189);

(statearr_13241[(9)] = inst_13179__$1);

(statearr_13241[(10)] = inst_13180__$1);

(statearr_13241[(11)] = inst_13182__$1);

(statearr_13241[(12)] = inst_13181__$1);

return statearr_13241;
})();
var statearr_13242_13277 = state_13227__$1;
(statearr_13242_13277[(2)] = null);

(statearr_13242_13277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (22))){
var state_13227__$1 = state_13227;
var statearr_13243_13278 = state_13227__$1;
(statearr_13243_13278[(2)] = null);

(statearr_13243_13278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (6))){
var inst_13168 = (state_13227[(13)]);
var inst_13177 = f.call(null,inst_13168);
var inst_13178 = cljs.core.seq.call(null,inst_13177);
var inst_13179 = inst_13178;
var inst_13180 = null;
var inst_13181 = (0);
var inst_13182 = (0);
var state_13227__$1 = (function (){var statearr_13244 = state_13227;
(statearr_13244[(9)] = inst_13179);

(statearr_13244[(10)] = inst_13180);

(statearr_13244[(11)] = inst_13182);

(statearr_13244[(12)] = inst_13181);

return statearr_13244;
})();
var statearr_13245_13279 = state_13227__$1;
(statearr_13245_13279[(2)] = null);

(statearr_13245_13279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (17))){
var inst_13193 = (state_13227[(7)]);
var inst_13197 = cljs.core.chunk_first.call(null,inst_13193);
var inst_13198 = cljs.core.chunk_rest.call(null,inst_13193);
var inst_13199 = cljs.core.count.call(null,inst_13197);
var inst_13179 = inst_13198;
var inst_13180 = inst_13197;
var inst_13181 = inst_13199;
var inst_13182 = (0);
var state_13227__$1 = (function (){var statearr_13246 = state_13227;
(statearr_13246[(9)] = inst_13179);

(statearr_13246[(10)] = inst_13180);

(statearr_13246[(11)] = inst_13182);

(statearr_13246[(12)] = inst_13181);

return statearr_13246;
})();
var statearr_13247_13280 = state_13227__$1;
(statearr_13247_13280[(2)] = null);

(statearr_13247_13280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (3))){
var inst_13225 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13227__$1,inst_13225);
} else {
if((state_val_13228 === (12))){
var inst_13213 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
var statearr_13248_13281 = state_13227__$1;
(statearr_13248_13281[(2)] = inst_13213);

(statearr_13248_13281[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (2))){
var state_13227__$1 = state_13227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13227__$1,(4),in$);
} else {
if((state_val_13228 === (23))){
var inst_13221 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
var statearr_13249_13282 = state_13227__$1;
(statearr_13249_13282[(2)] = inst_13221);

(statearr_13249_13282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (19))){
var inst_13208 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
var statearr_13250_13283 = state_13227__$1;
(statearr_13250_13283[(2)] = inst_13208);

(statearr_13250_13283[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (11))){
var inst_13179 = (state_13227[(9)]);
var inst_13193 = (state_13227[(7)]);
var inst_13193__$1 = cljs.core.seq.call(null,inst_13179);
var state_13227__$1 = (function (){var statearr_13251 = state_13227;
(statearr_13251[(7)] = inst_13193__$1);

return statearr_13251;
})();
if(inst_13193__$1){
var statearr_13252_13284 = state_13227__$1;
(statearr_13252_13284[(1)] = (14));

} else {
var statearr_13253_13285 = state_13227__$1;
(statearr_13253_13285[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (9))){
var inst_13215 = (state_13227[(2)]);
var inst_13216 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13227__$1 = (function (){var statearr_13254 = state_13227;
(statearr_13254[(15)] = inst_13215);

return statearr_13254;
})();
if(cljs.core.truth_(inst_13216)){
var statearr_13255_13286 = state_13227__$1;
(statearr_13255_13286[(1)] = (21));

} else {
var statearr_13256_13287 = state_13227__$1;
(statearr_13256_13287[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (5))){
var inst_13171 = cljs.core.async.close_BANG_.call(null,out);
var state_13227__$1 = state_13227;
var statearr_13257_13288 = state_13227__$1;
(statearr_13257_13288[(2)] = inst_13171);

(statearr_13257_13288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (14))){
var inst_13193 = (state_13227[(7)]);
var inst_13195 = cljs.core.chunked_seq_QMARK_.call(null,inst_13193);
var state_13227__$1 = state_13227;
if(inst_13195){
var statearr_13258_13289 = state_13227__$1;
(statearr_13258_13289[(1)] = (17));

} else {
var statearr_13259_13290 = state_13227__$1;
(statearr_13259_13290[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (16))){
var inst_13211 = (state_13227[(2)]);
var state_13227__$1 = state_13227;
var statearr_13260_13291 = state_13227__$1;
(statearr_13260_13291[(2)] = inst_13211);

(statearr_13260_13291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13228 === (10))){
var inst_13180 = (state_13227[(10)]);
var inst_13182 = (state_13227[(11)]);
var inst_13187 = cljs.core._nth.call(null,inst_13180,inst_13182);
var state_13227__$1 = state_13227;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13227__$1,(13),out,inst_13187);
} else {
if((state_val_13228 === (18))){
var inst_13193 = (state_13227[(7)]);
var inst_13202 = cljs.core.first.call(null,inst_13193);
var state_13227__$1 = state_13227;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13227__$1,(20),out,inst_13202);
} else {
if((state_val_13228 === (8))){
var inst_13182 = (state_13227[(11)]);
var inst_13181 = (state_13227[(12)]);
var inst_13184 = (inst_13182 < inst_13181);
var inst_13185 = inst_13184;
var state_13227__$1 = state_13227;
if(cljs.core.truth_(inst_13185)){
var statearr_13261_13292 = state_13227__$1;
(statearr_13261_13292[(1)] = (10));

} else {
var statearr_13262_13293 = state_13227__$1;
(statearr_13262_13293[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto__))
;
return ((function (switch__6741__auto__,c__6803__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____0 = (function (){
var statearr_13266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13266[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__);

(statearr_13266[(1)] = (1));

return statearr_13266;
});
var cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____1 = (function (state_13227){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_13227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e13267){if((e13267 instanceof Object)){
var ex__6745__auto__ = e13267;
var statearr_13268_13294 = state_13227;
(statearr_13268_13294[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13227);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13295 = state_13227;
state_13227 = G__13295;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__ = function(state_13227){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____1.call(this,state_13227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__6742__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto__))
})();
var state__6805__auto__ = (function (){var statearr_13269 = f__6804__auto__.call(null);
(statearr_13269[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto__);

return statearr_13269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto__))
);

return c__6803__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__13297 = arguments.length;
switch (G__13297) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__13300 = arguments.length;
switch (G__13300) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__13303 = arguments.length;
switch (G__13303) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___13353 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___13353,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___13353,out){
return (function (state_13327){
var state_val_13328 = (state_13327[(1)]);
if((state_val_13328 === (7))){
var inst_13322 = (state_13327[(2)]);
var state_13327__$1 = state_13327;
var statearr_13329_13354 = state_13327__$1;
(statearr_13329_13354[(2)] = inst_13322);

(statearr_13329_13354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (1))){
var inst_13304 = null;
var state_13327__$1 = (function (){var statearr_13330 = state_13327;
(statearr_13330[(7)] = inst_13304);

return statearr_13330;
})();
var statearr_13331_13355 = state_13327__$1;
(statearr_13331_13355[(2)] = null);

(statearr_13331_13355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (4))){
var inst_13307 = (state_13327[(8)]);
var inst_13307__$1 = (state_13327[(2)]);
var inst_13308 = (inst_13307__$1 == null);
var inst_13309 = cljs.core.not.call(null,inst_13308);
var state_13327__$1 = (function (){var statearr_13332 = state_13327;
(statearr_13332[(8)] = inst_13307__$1);

return statearr_13332;
})();
if(inst_13309){
var statearr_13333_13356 = state_13327__$1;
(statearr_13333_13356[(1)] = (5));

} else {
var statearr_13334_13357 = state_13327__$1;
(statearr_13334_13357[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (6))){
var state_13327__$1 = state_13327;
var statearr_13335_13358 = state_13327__$1;
(statearr_13335_13358[(2)] = null);

(statearr_13335_13358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (3))){
var inst_13324 = (state_13327[(2)]);
var inst_13325 = cljs.core.async.close_BANG_.call(null,out);
var state_13327__$1 = (function (){var statearr_13336 = state_13327;
(statearr_13336[(9)] = inst_13324);

return statearr_13336;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13327__$1,inst_13325);
} else {
if((state_val_13328 === (2))){
var state_13327__$1 = state_13327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13327__$1,(4),ch);
} else {
if((state_val_13328 === (11))){
var inst_13307 = (state_13327[(8)]);
var inst_13316 = (state_13327[(2)]);
var inst_13304 = inst_13307;
var state_13327__$1 = (function (){var statearr_13337 = state_13327;
(statearr_13337[(7)] = inst_13304);

(statearr_13337[(10)] = inst_13316);

return statearr_13337;
})();
var statearr_13338_13359 = state_13327__$1;
(statearr_13338_13359[(2)] = null);

(statearr_13338_13359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (9))){
var inst_13307 = (state_13327[(8)]);
var state_13327__$1 = state_13327;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13327__$1,(11),out,inst_13307);
} else {
if((state_val_13328 === (5))){
var inst_13307 = (state_13327[(8)]);
var inst_13304 = (state_13327[(7)]);
var inst_13311 = cljs.core._EQ_.call(null,inst_13307,inst_13304);
var state_13327__$1 = state_13327;
if(inst_13311){
var statearr_13340_13360 = state_13327__$1;
(statearr_13340_13360[(1)] = (8));

} else {
var statearr_13341_13361 = state_13327__$1;
(statearr_13341_13361[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (10))){
var inst_13319 = (state_13327[(2)]);
var state_13327__$1 = state_13327;
var statearr_13342_13362 = state_13327__$1;
(statearr_13342_13362[(2)] = inst_13319);

(statearr_13342_13362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13328 === (8))){
var inst_13304 = (state_13327[(7)]);
var tmp13339 = inst_13304;
var inst_13304__$1 = tmp13339;
var state_13327__$1 = (function (){var statearr_13343 = state_13327;
(statearr_13343[(7)] = inst_13304__$1);

return statearr_13343;
})();
var statearr_13344_13363 = state_13327__$1;
(statearr_13344_13363[(2)] = null);

(statearr_13344_13363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___13353,out))
;
return ((function (switch__6741__auto__,c__6803__auto___13353,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_13348 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13348[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_13348[(1)] = (1));

return statearr_13348;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_13327){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_13327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e13349){if((e13349 instanceof Object)){
var ex__6745__auto__ = e13349;
var statearr_13350_13364 = state_13327;
(statearr_13350_13364[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13365 = state_13327;
state_13327 = G__13365;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_13327){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_13327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___13353,out))
})();
var state__6805__auto__ = (function (){var statearr_13351 = f__6804__auto__.call(null);
(statearr_13351[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___13353);

return statearr_13351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___13353,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__13367 = arguments.length;
switch (G__13367) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___13436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___13436,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___13436,out){
return (function (state_13405){
var state_val_13406 = (state_13405[(1)]);
if((state_val_13406 === (7))){
var inst_13401 = (state_13405[(2)]);
var state_13405__$1 = state_13405;
var statearr_13407_13437 = state_13405__$1;
(statearr_13407_13437[(2)] = inst_13401);

(statearr_13407_13437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (1))){
var inst_13368 = (new Array(n));
var inst_13369 = inst_13368;
var inst_13370 = (0);
var state_13405__$1 = (function (){var statearr_13408 = state_13405;
(statearr_13408[(7)] = inst_13369);

(statearr_13408[(8)] = inst_13370);

return statearr_13408;
})();
var statearr_13409_13438 = state_13405__$1;
(statearr_13409_13438[(2)] = null);

(statearr_13409_13438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (4))){
var inst_13373 = (state_13405[(9)]);
var inst_13373__$1 = (state_13405[(2)]);
var inst_13374 = (inst_13373__$1 == null);
var inst_13375 = cljs.core.not.call(null,inst_13374);
var state_13405__$1 = (function (){var statearr_13410 = state_13405;
(statearr_13410[(9)] = inst_13373__$1);

return statearr_13410;
})();
if(inst_13375){
var statearr_13411_13439 = state_13405__$1;
(statearr_13411_13439[(1)] = (5));

} else {
var statearr_13412_13440 = state_13405__$1;
(statearr_13412_13440[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (15))){
var inst_13395 = (state_13405[(2)]);
var state_13405__$1 = state_13405;
var statearr_13413_13441 = state_13405__$1;
(statearr_13413_13441[(2)] = inst_13395);

(statearr_13413_13441[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (13))){
var state_13405__$1 = state_13405;
var statearr_13414_13442 = state_13405__$1;
(statearr_13414_13442[(2)] = null);

(statearr_13414_13442[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (6))){
var inst_13370 = (state_13405[(8)]);
var inst_13391 = (inst_13370 > (0));
var state_13405__$1 = state_13405;
if(cljs.core.truth_(inst_13391)){
var statearr_13415_13443 = state_13405__$1;
(statearr_13415_13443[(1)] = (12));

} else {
var statearr_13416_13444 = state_13405__$1;
(statearr_13416_13444[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (3))){
var inst_13403 = (state_13405[(2)]);
var state_13405__$1 = state_13405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13405__$1,inst_13403);
} else {
if((state_val_13406 === (12))){
var inst_13369 = (state_13405[(7)]);
var inst_13393 = cljs.core.vec.call(null,inst_13369);
var state_13405__$1 = state_13405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13405__$1,(15),out,inst_13393);
} else {
if((state_val_13406 === (2))){
var state_13405__$1 = state_13405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13405__$1,(4),ch);
} else {
if((state_val_13406 === (11))){
var inst_13385 = (state_13405[(2)]);
var inst_13386 = (new Array(n));
var inst_13369 = inst_13386;
var inst_13370 = (0);
var state_13405__$1 = (function (){var statearr_13417 = state_13405;
(statearr_13417[(7)] = inst_13369);

(statearr_13417[(10)] = inst_13385);

(statearr_13417[(8)] = inst_13370);

return statearr_13417;
})();
var statearr_13418_13445 = state_13405__$1;
(statearr_13418_13445[(2)] = null);

(statearr_13418_13445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (9))){
var inst_13369 = (state_13405[(7)]);
var inst_13383 = cljs.core.vec.call(null,inst_13369);
var state_13405__$1 = state_13405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13405__$1,(11),out,inst_13383);
} else {
if((state_val_13406 === (5))){
var inst_13369 = (state_13405[(7)]);
var inst_13378 = (state_13405[(11)]);
var inst_13370 = (state_13405[(8)]);
var inst_13373 = (state_13405[(9)]);
var inst_13377 = (inst_13369[inst_13370] = inst_13373);
var inst_13378__$1 = (inst_13370 + (1));
var inst_13379 = (inst_13378__$1 < n);
var state_13405__$1 = (function (){var statearr_13419 = state_13405;
(statearr_13419[(12)] = inst_13377);

(statearr_13419[(11)] = inst_13378__$1);

return statearr_13419;
})();
if(cljs.core.truth_(inst_13379)){
var statearr_13420_13446 = state_13405__$1;
(statearr_13420_13446[(1)] = (8));

} else {
var statearr_13421_13447 = state_13405__$1;
(statearr_13421_13447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (14))){
var inst_13398 = (state_13405[(2)]);
var inst_13399 = cljs.core.async.close_BANG_.call(null,out);
var state_13405__$1 = (function (){var statearr_13423 = state_13405;
(statearr_13423[(13)] = inst_13398);

return statearr_13423;
})();
var statearr_13424_13448 = state_13405__$1;
(statearr_13424_13448[(2)] = inst_13399);

(statearr_13424_13448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (10))){
var inst_13389 = (state_13405[(2)]);
var state_13405__$1 = state_13405;
var statearr_13425_13449 = state_13405__$1;
(statearr_13425_13449[(2)] = inst_13389);

(statearr_13425_13449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13406 === (8))){
var inst_13369 = (state_13405[(7)]);
var inst_13378 = (state_13405[(11)]);
var tmp13422 = inst_13369;
var inst_13369__$1 = tmp13422;
var inst_13370 = inst_13378;
var state_13405__$1 = (function (){var statearr_13426 = state_13405;
(statearr_13426[(7)] = inst_13369__$1);

(statearr_13426[(8)] = inst_13370);

return statearr_13426;
})();
var statearr_13427_13450 = state_13405__$1;
(statearr_13427_13450[(2)] = null);

(statearr_13427_13450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___13436,out))
;
return ((function (switch__6741__auto__,c__6803__auto___13436,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_13431 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13431[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_13431[(1)] = (1));

return statearr_13431;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_13405){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_13405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e13432){if((e13432 instanceof Object)){
var ex__6745__auto__ = e13432;
var statearr_13433_13451 = state_13405;
(statearr_13433_13451[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13432;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13452 = state_13405;
state_13405 = G__13452;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_13405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_13405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___13436,out))
})();
var state__6805__auto__ = (function (){var statearr_13434 = f__6804__auto__.call(null);
(statearr_13434[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___13436);

return statearr_13434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___13436,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__13454 = arguments.length;
switch (G__13454) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__6803__auto___13527 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___13527,out){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___13527,out){
return (function (state_13496){
var state_val_13497 = (state_13496[(1)]);
if((state_val_13497 === (7))){
var inst_13492 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13498_13528 = state_13496__$1;
(statearr_13498_13528[(2)] = inst_13492);

(statearr_13498_13528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (1))){
var inst_13455 = [];
var inst_13456 = inst_13455;
var inst_13457 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13496__$1 = (function (){var statearr_13499 = state_13496;
(statearr_13499[(7)] = inst_13456);

(statearr_13499[(8)] = inst_13457);

return statearr_13499;
})();
var statearr_13500_13529 = state_13496__$1;
(statearr_13500_13529[(2)] = null);

(statearr_13500_13529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (4))){
var inst_13460 = (state_13496[(9)]);
var inst_13460__$1 = (state_13496[(2)]);
var inst_13461 = (inst_13460__$1 == null);
var inst_13462 = cljs.core.not.call(null,inst_13461);
var state_13496__$1 = (function (){var statearr_13501 = state_13496;
(statearr_13501[(9)] = inst_13460__$1);

return statearr_13501;
})();
if(inst_13462){
var statearr_13502_13530 = state_13496__$1;
(statearr_13502_13530[(1)] = (5));

} else {
var statearr_13503_13531 = state_13496__$1;
(statearr_13503_13531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (15))){
var inst_13486 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13504_13532 = state_13496__$1;
(statearr_13504_13532[(2)] = inst_13486);

(statearr_13504_13532[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (13))){
var state_13496__$1 = state_13496;
var statearr_13505_13533 = state_13496__$1;
(statearr_13505_13533[(2)] = null);

(statearr_13505_13533[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (6))){
var inst_13456 = (state_13496[(7)]);
var inst_13481 = inst_13456.length;
var inst_13482 = (inst_13481 > (0));
var state_13496__$1 = state_13496;
if(cljs.core.truth_(inst_13482)){
var statearr_13506_13534 = state_13496__$1;
(statearr_13506_13534[(1)] = (12));

} else {
var statearr_13507_13535 = state_13496__$1;
(statearr_13507_13535[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (3))){
var inst_13494 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13496__$1,inst_13494);
} else {
if((state_val_13497 === (12))){
var inst_13456 = (state_13496[(7)]);
var inst_13484 = cljs.core.vec.call(null,inst_13456);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13496__$1,(15),out,inst_13484);
} else {
if((state_val_13497 === (2))){
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13496__$1,(4),ch);
} else {
if((state_val_13497 === (11))){
var inst_13460 = (state_13496[(9)]);
var inst_13464 = (state_13496[(10)]);
var inst_13474 = (state_13496[(2)]);
var inst_13475 = [];
var inst_13476 = inst_13475.push(inst_13460);
var inst_13456 = inst_13475;
var inst_13457 = inst_13464;
var state_13496__$1 = (function (){var statearr_13508 = state_13496;
(statearr_13508[(7)] = inst_13456);

(statearr_13508[(11)] = inst_13474);

(statearr_13508[(8)] = inst_13457);

(statearr_13508[(12)] = inst_13476);

return statearr_13508;
})();
var statearr_13509_13536 = state_13496__$1;
(statearr_13509_13536[(2)] = null);

(statearr_13509_13536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (9))){
var inst_13456 = (state_13496[(7)]);
var inst_13472 = cljs.core.vec.call(null,inst_13456);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13496__$1,(11),out,inst_13472);
} else {
if((state_val_13497 === (5))){
var inst_13460 = (state_13496[(9)]);
var inst_13464 = (state_13496[(10)]);
var inst_13457 = (state_13496[(8)]);
var inst_13464__$1 = f.call(null,inst_13460);
var inst_13465 = cljs.core._EQ_.call(null,inst_13464__$1,inst_13457);
var inst_13466 = cljs.core.keyword_identical_QMARK_.call(null,inst_13457,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13467 = (inst_13465) || (inst_13466);
var state_13496__$1 = (function (){var statearr_13510 = state_13496;
(statearr_13510[(10)] = inst_13464__$1);

return statearr_13510;
})();
if(cljs.core.truth_(inst_13467)){
var statearr_13511_13537 = state_13496__$1;
(statearr_13511_13537[(1)] = (8));

} else {
var statearr_13512_13538 = state_13496__$1;
(statearr_13512_13538[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (14))){
var inst_13489 = (state_13496[(2)]);
var inst_13490 = cljs.core.async.close_BANG_.call(null,out);
var state_13496__$1 = (function (){var statearr_13514 = state_13496;
(statearr_13514[(13)] = inst_13489);

return statearr_13514;
})();
var statearr_13515_13539 = state_13496__$1;
(statearr_13515_13539[(2)] = inst_13490);

(statearr_13515_13539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (10))){
var inst_13479 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13516_13540 = state_13496__$1;
(statearr_13516_13540[(2)] = inst_13479);

(statearr_13516_13540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (8))){
var inst_13456 = (state_13496[(7)]);
var inst_13460 = (state_13496[(9)]);
var inst_13464 = (state_13496[(10)]);
var inst_13469 = inst_13456.push(inst_13460);
var tmp13513 = inst_13456;
var inst_13456__$1 = tmp13513;
var inst_13457 = inst_13464;
var state_13496__$1 = (function (){var statearr_13517 = state_13496;
(statearr_13517[(7)] = inst_13456__$1);

(statearr_13517[(14)] = inst_13469);

(statearr_13517[(8)] = inst_13457);

return statearr_13517;
})();
var statearr_13518_13541 = state_13496__$1;
(statearr_13518_13541[(2)] = null);

(statearr_13518_13541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__6803__auto___13527,out))
;
return ((function (switch__6741__auto__,c__6803__auto___13527,out){
return (function() {
var cljs$core$async$state_machine__6742__auto__ = null;
var cljs$core$async$state_machine__6742__auto____0 = (function (){
var statearr_13522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13522[(0)] = cljs$core$async$state_machine__6742__auto__);

(statearr_13522[(1)] = (1));

return statearr_13522;
});
var cljs$core$async$state_machine__6742__auto____1 = (function (state_13496){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_13496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e13523){if((e13523 instanceof Object)){
var ex__6745__auto__ = e13523;
var statearr_13524_13542 = state_13496;
(statearr_13524_13542[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13523;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13543 = state_13496;
state_13496 = G__13543;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs$core$async$state_machine__6742__auto__ = function(state_13496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__6742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__6742__auto____1.call(this,state_13496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__6742__auto____0;
cljs$core$async$state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__6742__auto____1;
return cljs$core$async$state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___13527,out))
})();
var state__6805__auto__ = (function (){var statearr_13525 = f__6804__auto__.call(null);
(statearr_13525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___13527);

return statearr_13525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___13527,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map