// Compiled by ClojureScript 0.0-3211 {}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = cljs.core.deref.call(null,cljs_http.core.pending_requests).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_.call(null,channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.call(null,xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__10850 = cljs.core.seq.call(null,cljs.core.map.call(null,cljs_http.util.camelize,cljs.core.keys.call(null,headers)));
var chunk__10855 = null;
var count__10856 = (0);
var i__10857 = (0);
while(true){
if((i__10857 < count__10856)){
var h_name = cljs.core._nth.call(null,chunk__10855,i__10857);
var seq__10858_10862 = cljs.core.seq.call(null,cljs.core.vals.call(null,headers));
var chunk__10859_10863 = null;
var count__10860_10864 = (0);
var i__10861_10865 = (0);
while(true){
if((i__10861_10865 < count__10860_10864)){
var h_val_10866 = cljs.core._nth.call(null,chunk__10859_10863,i__10861_10865);
xhr.headers.set(h_name,h_val_10866);

var G__10867 = seq__10858_10862;
var G__10868 = chunk__10859_10863;
var G__10869 = count__10860_10864;
var G__10870 = (i__10861_10865 + (1));
seq__10858_10862 = G__10867;
chunk__10859_10863 = G__10868;
count__10860_10864 = G__10869;
i__10861_10865 = G__10870;
continue;
} else {
var temp__4657__auto___10871 = cljs.core.seq.call(null,seq__10858_10862);
if(temp__4657__auto___10871){
var seq__10858_10872__$1 = temp__4657__auto___10871;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10858_10872__$1)){
var c__5084__auto___10873 = cljs.core.chunk_first.call(null,seq__10858_10872__$1);
var G__10874 = cljs.core.chunk_rest.call(null,seq__10858_10872__$1);
var G__10875 = c__5084__auto___10873;
var G__10876 = cljs.core.count.call(null,c__5084__auto___10873);
var G__10877 = (0);
seq__10858_10862 = G__10874;
chunk__10859_10863 = G__10875;
count__10860_10864 = G__10876;
i__10861_10865 = G__10877;
continue;
} else {
var h_val_10878 = cljs.core.first.call(null,seq__10858_10872__$1);
xhr.headers.set(h_name,h_val_10878);

var G__10879 = cljs.core.next.call(null,seq__10858_10872__$1);
var G__10880 = null;
var G__10881 = (0);
var G__10882 = (0);
seq__10858_10862 = G__10879;
chunk__10859_10863 = G__10880;
count__10860_10864 = G__10881;
i__10861_10865 = G__10882;
continue;
}
} else {
}
}
break;
}

var G__10883 = seq__10850;
var G__10884 = chunk__10855;
var G__10885 = count__10856;
var G__10886 = (i__10857 + (1));
seq__10850 = G__10883;
chunk__10855 = G__10884;
count__10856 = G__10885;
i__10857 = G__10886;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__10850);
if(temp__4657__auto__){
var seq__10850__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10850__$1)){
var c__5084__auto__ = cljs.core.chunk_first.call(null,seq__10850__$1);
var G__10887 = cljs.core.chunk_rest.call(null,seq__10850__$1);
var G__10888 = c__5084__auto__;
var G__10889 = cljs.core.count.call(null,c__5084__auto__);
var G__10890 = (0);
seq__10850 = G__10887;
chunk__10855 = G__10888;
count__10856 = G__10889;
i__10857 = G__10890;
continue;
} else {
var h_name = cljs.core.first.call(null,seq__10850__$1);
var seq__10851_10891 = cljs.core.seq.call(null,cljs.core.vals.call(null,headers));
var chunk__10852_10892 = null;
var count__10853_10893 = (0);
var i__10854_10894 = (0);
while(true){
if((i__10854_10894 < count__10853_10893)){
var h_val_10895 = cljs.core._nth.call(null,chunk__10852_10892,i__10854_10894);
xhr.headers.set(h_name,h_val_10895);

var G__10896 = seq__10851_10891;
var G__10897 = chunk__10852_10892;
var G__10898 = count__10853_10893;
var G__10899 = (i__10854_10894 + (1));
seq__10851_10891 = G__10896;
chunk__10852_10892 = G__10897;
count__10853_10893 = G__10898;
i__10854_10894 = G__10899;
continue;
} else {
var temp__4657__auto___10900__$1 = cljs.core.seq.call(null,seq__10851_10891);
if(temp__4657__auto___10900__$1){
var seq__10851_10901__$1 = temp__4657__auto___10900__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10851_10901__$1)){
var c__5084__auto___10902 = cljs.core.chunk_first.call(null,seq__10851_10901__$1);
var G__10903 = cljs.core.chunk_rest.call(null,seq__10851_10901__$1);
var G__10904 = c__5084__auto___10902;
var G__10905 = cljs.core.count.call(null,c__5084__auto___10902);
var G__10906 = (0);
seq__10851_10891 = G__10903;
chunk__10852_10892 = G__10904;
count__10853_10893 = G__10905;
i__10854_10894 = G__10906;
continue;
} else {
var h_val_10907 = cljs.core.first.call(null,seq__10851_10901__$1);
xhr.headers.set(h_name,h_val_10907);

var G__10908 = cljs.core.next.call(null,seq__10851_10901__$1);
var G__10909 = null;
var G__10910 = (0);
var G__10911 = (0);
seq__10851_10891 = G__10908;
chunk__10852_10892 = G__10909;
count__10853_10893 = G__10910;
i__10854_10894 = G__10911;
continue;
}
} else {
}
}
break;
}

var G__10912 = cljs.core.next.call(null,seq__10850__$1);
var G__10913 = null;
var G__10914 = (0);
var G__10915 = (0);
seq__10850 = G__10912;
chunk__10855 = G__10913;
count__10856 = G__10914;
i__10857 = G__10915;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__10917 = response_type;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__10917)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"blob","blob",1636965233),G__10917)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"document","document",-1329188687),G__10917)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),G__10917)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),G__10917)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.call(null,null,G__10917)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__10918){
var map__10921 = p__10918;
var map__10921__$1 = ((cljs.core.seq_QMARK_.call(null,map__10921))?cljs.core.apply.call(null,cljs.core.hash_map,map__10921):map__10921);
var request = map__10921__$1;
var with_credentials_QMARK_ = cljs.core.get.call(null,map__10921__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.call(null,map__10921__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.call(null,map__10921__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4299__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__10922 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_.call(null,G__10922,default_headers);

cljs_http.core.apply_response_type_BANG_.call(null,G__10922,response_type);

G__10922.setTimeoutInterval(timeout);

G__10922.setWithCredentials(send_credentials);

return G__10922;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__10923){
var map__10949 = p__10923;
var map__10949__$1 = ((cljs.core.seq_QMARK_.call(null,map__10949))?cljs.core.apply.call(null,cljs.core.hash_map,map__10949):map__10949);
var request = map__10949__$1;
var request_method = cljs.core.get.call(null,map__10949__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__10949__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__10949__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.call(null,map__10949__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.call(null,map__10949__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var channel = cljs.core.async.chan.call(null);
var request_url = cljs_http.util.build_url.call(null,request);
var method = cljs.core.name.call(null,(function (){var or__4299__auto__ = request_method;
if(cljs.core.truth_(or__4299__auto__)){
return or__4299__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers.call(null,headers);
var xhr__$1 = cljs_http.core.build_xhr.call(null,request);
cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers.call(null,target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),cljs_http.core.error_kw.call(null,target.getLastErrorCode()),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if(cljs.core.not.call(null,cljs_http.core.aborted_QMARK_.call(null,xhr__$1))){
cljs.core.async.put_BANG_.call(null,channel,response);
} else {
}

cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_.call(null,cancel);
} else {
}

return cljs.core.async.close_BANG_.call(null,channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__6803__auto___10974 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_10960){
var state_val_10961 = (state_10960[(1)]);
if((state_val_10961 === (1))){
var state_10960__$1 = state_10960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10960__$1,(2),cancel);
} else {
if((state_val_10961 === (2))){
var inst_10951 = (state_10960[(2)]);
var inst_10952 = xhr__$1.isComplete();
var inst_10953 = cljs.core.not.call(null,inst_10952);
var state_10960__$1 = (function (){var statearr_10962 = state_10960;
(statearr_10962[(7)] = inst_10951);

return statearr_10962;
})();
if(inst_10953){
var statearr_10963_10975 = state_10960__$1;
(statearr_10963_10975[(1)] = (3));

} else {
var statearr_10964_10976 = state_10960__$1;
(statearr_10964_10976[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10961 === (3))){
var inst_10955 = xhr__$1.abort();
var state_10960__$1 = state_10960;
var statearr_10965_10977 = state_10960__$1;
(statearr_10965_10977[(2)] = inst_10955);

(statearr_10965_10977[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10961 === (4))){
var state_10960__$1 = state_10960;
var statearr_10966_10978 = state_10960__$1;
(statearr_10966_10978[(2)] = null);

(statearr_10966_10978[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10961 === (5))){
var inst_10958 = (state_10960[(2)]);
var state_10960__$1 = state_10960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10960__$1,inst_10958);
} else {
return null;
}
}
}
}
}
});})(c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__6741__auto__,c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__6742__auto__ = null;
var cljs_http$core$xhr_$_state_machine__6742__auto____0 = (function (){
var statearr_10970 = [null,null,null,null,null,null,null,null];
(statearr_10970[(0)] = cljs_http$core$xhr_$_state_machine__6742__auto__);

(statearr_10970[(1)] = (1));

return statearr_10970;
});
var cljs_http$core$xhr_$_state_machine__6742__auto____1 = (function (state_10960){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_10960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e10971){if((e10971 instanceof Object)){
var ex__6745__auto__ = e10971;
var statearr_10972_10979 = state_10960;
(statearr_10972_10979[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10980 = state_10960;
state_10960 = G__10980;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__6742__auto__ = function(state_10960){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__6742__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__6742__auto____1.call(this,state_10960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__6742__auto____0;
cljs_http$core$xhr_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__6742__auto____1;
return cljs_http$core$xhr_$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__6805__auto__ = (function (){var statearr_10973 = f__6804__auto__.call(null);
(statearr_10973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___10974);

return statearr_10973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___10974,channel,request_url,method,headers__$1,xhr__$1,map__10949,map__10949__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__10981){
var map__10997 = p__10981;
var map__10997__$1 = ((cljs.core.seq_QMARK_.call(null,map__10997))?cljs.core.apply.call(null,cljs.core.hash_map,map__10997):map__10997);
var request = map__10997__$1;
var timeout = cljs.core.get.call(null,map__10997__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.call(null,map__10997__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.call(null,map__10997__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var channel = cljs.core.async.chan.call(null);
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url.call(null,request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_11012 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.call(null,data,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)], null);
cljs.core.async.put_BANG_.call(null,channel,response);

cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_.call(null,cancel);
} else {
}

return cljs.core.async.close_BANG_.call(null,channel);
});})(channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_.call(null,cancel);
} else {
}

return cljs.core.async.close_BANG_.call(null,channel);
});})(channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.call(null,cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp__$1,new cljs.core.Keyword(null,"request","request",1772954723),req_11012], null));

if(cljs.core.truth_(cancel)){
var c__6803__auto___11013 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel){
return (function (){
var f__6804__auto__ = (function (){var switch__6741__auto__ = ((function (c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel){
return (function (state_11002){
var state_val_11003 = (state_11002[(1)]);
if((state_val_11003 === (1))){
var state_11002__$1 = state_11002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11002__$1,(2),cancel);
} else {
if((state_val_11003 === (2))){
var inst_10999 = (state_11002[(2)]);
var inst_11000 = jsonp__$1.cancel(req_11012);
var state_11002__$1 = (function (){var statearr_11004 = state_11002;
(statearr_11004[(7)] = inst_10999);

return statearr_11004;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11002__$1,inst_11000);
} else {
return null;
}
}
});})(c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__6741__auto__,c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__6742__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__6742__auto____0 = (function (){
var statearr_11008 = [null,null,null,null,null,null,null,null];
(statearr_11008[(0)] = cljs_http$core$jsonp_$_state_machine__6742__auto__);

(statearr_11008[(1)] = (1));

return statearr_11008;
});
var cljs_http$core$jsonp_$_state_machine__6742__auto____1 = (function (state_11002){
while(true){
var ret_value__6743__auto__ = (function (){try{while(true){
var result__6744__auto__ = switch__6741__auto__.call(null,state_11002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__6744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__6744__auto__;
}
break;
}
}catch (e11009){if((e11009 instanceof Object)){
var ex__6745__auto__ = e11009;
var statearr_11010_11014 = state_11002;
(statearr_11010_11014[(5)] = ex__6745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__6743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11015 = state_11002;
state_11002 = G__11015;
continue;
} else {
return ret_value__6743__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__6742__auto__ = function(state_11002){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__6742__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__6742__auto____1.call(this,state_11002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__6742__auto____0;
cljs_http$core$jsonp_$_state_machine__6742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__6742__auto____1;
return cljs_http$core$jsonp_$_state_machine__6742__auto__;
})()
;})(switch__6741__auto__,c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel))
})();
var state__6805__auto__ = (function (){var statearr_11011 = f__6804__auto__.call(null);
(statearr_11011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__6803__auto___11013);

return statearr_11011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__6805__auto__);
});})(c__6803__auto___11013,req_11012,channel,jsonp__$1,map__10997,map__10997__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__11016){
var map__11018 = p__11016;
var map__11018__$1 = ((cljs.core.seq_QMARK_.call(null,map__11018))?cljs.core.apply.call(null,cljs.core.hash_map,map__11018):map__11018);
var request__$1 = map__11018__$1;
var request_method = cljs.core.get.call(null,map__11018__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.call(null,request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp.call(null,request__$1);
} else {
return cljs_http.core.xhr.call(null,request__$1);
}
});

//# sourceMappingURL=core.js.map