// Copyright 2008 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview list of native country and language names.
 *
 * Warning: this file is automatically generated from CLDR.
 * Please contact i18n team or change the script and regenerate data.
 * Code location: http://go/generate_js_native_names.py
 *
 */


/**
 * Namespace for native country and lanugage names
 */
goog.provide('goog.locale.nativeNameConstants');

/**
 * Native country and language names
 * @const {!Object<string, !Object<string, string>>}
 */

/* ~!@# genmethods.NativeDictAsJson() #@!~ */
goog.locale.nativeNameConstants = {
  'COUNTRY': {
    'AD': 'Andorra',
    'AE': '\u0627\u0644\u0627\u0645\u0627\u0631\u0627\u062a \u0627' +
        '\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644' +
        '\u0645\u062a\u062d\u062f\u0629',
    'AF': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646',
    'AG': 'Antigua and Barbuda',
    'AI': 'Anguilla',
    'AL': 'Shqip\u00ebria',
    'AM': '\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576\u056b ' +
        '\u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578' +
        '\u0582\u0569\u056b\u0582\u0576',
    'AN': 'Nederlandse Antillen',
    'AO': 'Angola',
    'AQ': 'Antarctica',
    'AR': 'Argentina',
    'AS': 'American Samoa',
    'AT': '\u00d6sterreich',
    'AU': 'Australia',
    'AW': 'Aruba',
    'AX': '\u00c5land',
    'AZ': 'Az\u0259rbaycan',
    'BA': 'Bosna i Hercegovina',
    'BB': 'Barbados',
    'BD': '\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6',
    'BE': 'Belgi\u00eb',
    'BF': 'Burkina Faso',
    'BG': '\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f',
    'BH': '\u0627\u0644\u0628\u062d\u0631\u064a\u0646',
    'BI': 'Burundi',
    'BJ': 'B\u00e9nin',
    'BM': 'Bermuda',
    'BN': 'Brunei',
    'BO': 'Bolivia',
    'BR': 'Brasil',
    'BS': 'Bahamas',
    'BT': '\u092d\u0942\u091f\u093e\u0928',
    'BV': 'Bouvet Island',
    'BW': 'Botswana',
    'BY': '\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
    'BZ': 'Belize',
    'CA': 'Canada',
    'CC': 'Cocos (Keeling) Islands',
    'CD': 'R\u00e9publique d\u00e9mocratique du Congo',
    'CF': 'R\u00e9publique centrafricaine',
    'CG': 'Congo',
    'CH': 'Schweiz',
    'CI': 'C\u00f4te d\u2019Ivoire',
    'CK': 'Cook Islands',
    'CL': 'Chile',
    'CM': 'Cameroun',
    'CN': '\u4e2d\u56fd',
    'CO': 'Colombia',
    'CR': 'Costa Rica',
    'CS': 'Serbia and Montenegro',
    'CU': 'Cuba',
    'CV': 'Cabo Verde',
    'CX': 'Christmas Island',
    'CY': '\u039a\u03cd\u03c0\u03c1\u03bf\u03c2',
    'CZ': '\u010cesk\u00e1 republika',
    'DD': 'East Germany',
    'DE': 'Deutschland',
    'DJ': 'Jabuuti',
    'DK': 'Danmark',
    'DM': 'Dominica',
    'DO': 'Rep\u00fablica Dominicana',
    'DZ': '\u0627\u0644\u062c\u0632\u0627\u0626\u0631',
    'EC': 'Ecuador',
    'EE': 'Eesti',
    'EG': '\u0645\u0635\u0631',
    'EH': '\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644' +
        '\u063a\u0631\u0628\u064a\u0629',
    'ER': '\u0627\u0631\u064a\u062a\u0631\u064a\u0627',
    'ES': 'Espa\u00f1a',
    'ET': '\u12a2\u1275\u12ee\u1335\u12eb',
    'FI': 'Suomi',
    'FJ': '\u092b\u093f\u091c\u0940',
    'FK': 'Falkland Islands',
    'FM': 'Micronesia',
    'FO': 'F\u00f8royar',
    'FR': 'France',
    'FX': 'Metropolitan France',
    'GA': 'Gabon',
    'GB': 'United Kingdom',
    'GD': 'Grenada',
    'GE': '\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da' +
        '\u10dd',
    'GF': 'Guyane fran\u00e7aise',
    'GG': 'Guernsey',
    'GH': 'Ghana',
    'GI': 'Gibraltar',
    'GL': 'Kalaallit Nunaat',
    'GM': 'Gambia',
    'GN': 'Guin\u00e9e',
    'GP': 'Guadeloupe',
    'GQ': 'Guin\u00e9e \u00e9quatoriale',
    'GR': '\u0395\u03bb\u03bb\u03ac\u03b4\u03b1',
    'GS': 'South Georgia and the South Sandwich Islands',
    'GT': 'Guatemala',
    'GU': 'Guam',
    'GW': 'Guin\u00e9 Bissau',
    'GY': 'Guyana',
    'HK': '\u9999\u6e2f',
    'HM': 'Heard Island and McDonald Islands',
    'HN': 'Honduras',
    'HR': 'Hrvatska',
    'HT': 'Ha\u00efti',
    'HU': 'Magyarorsz\u00e1g',
    'ID': 'Indonesia',
    'IE': 'Ireland',
    'IL': '\u05d9\u05e9\u05e8\u05d0\u05dc',
    'IM': 'Isle of Man',
    'IN': '\u092d\u093e\u0930\u0924',
    'IO': 'British Indian Ocean Territory',
    'IQ': '\u0627\u0644\u0639\u0631\u0627\u0642',
    'IR': '\u0627\u06cc\u0631\u0627\u0646',
    'IS': '\u00cdsland',
    'IT': 'Italia',
    'JE': 'Jersey',
    'JM': 'Jamaica',
    'JO': '\u0627\u0644\u0623\u0631\u062f\u0646',
    'JP': '\u65e5\u672c',
    'KE': 'Kenya',
    'KG': '\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430' +
        '\u043d',
    'KH': '\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6',
    'KI': 'Kiribati',
    'KM': '\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631',
    'KN': 'Saint Kitts and Nevis',
    'KP': '\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc ' +
        '\uacf5\ud654\uad6d',
    'KR': '\ub300\ud55c\ubbfc\uad6d',
    'KW': '\u0627\u0644\u0643\u0648\u064a\u062a',
    'KY': 'Cayman Islands',
    'KZ': '\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d',
    'LA': '\u0e25\u0e32\u0e27',
    'LB': '\u0644\u0628\u0646\u0627\u0646',
    'LC': 'Saint Lucia',
    'LI': 'Liechtenstein',
    'LK': '\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8',
    'LR': 'Liberia',
    'LS': 'Lesotho',
    'LT': 'Lietuva',
    'LU': 'Luxembourg',
    'LV': 'Latvija',
    'LY': '\u0644\u064a\u0628\u064a\u0627',
    'MA': '\u0627\u0644\u0645\u063a\u0631\u0628',
    'MC': 'Monaco',
    'MD': 'Moldova, Republica',
    'ME': '\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430',
    'MG': 'Madagascar',
    'MH': 'Marshall Islands',
    'MK': '\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458' +
        '\u0430',
    'ML': '\u0645\u0627\u0644\u064a',
    'MM': 'Myanmar',
    'MN': '\u8499\u53e4',
    'MO': '\u6fb3\u95e8',
    'MP': 'Northern Mariana Islands',
    'MQ': 'Martinique',
    'MR': '\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627',
    'MS': 'Montserrat',
    'MT': 'Malta',
    'MU': 'Mauritius',
    'MV': 'Maldives',
    'MW': 'Malawi',
    'MX': 'M\u00e9xico',
    'MY': 'Malaysia',
    'MZ': 'Mo\u00e7ambique',
    'NA': 'Namibia',
    'NC': 'Nouvelle-Cal\u00e9donie',
    'NE': 'Niger',
    'NF': 'Norfolk Island',
    'NG': 'Nigeria',
    'NI': 'Nicaragua',
    'NL': 'Nederland',
    'NO': 'Norge',
    'NP': '\u0928\u0947\u092a\u093e\u0932',
    'NR': 'Nauru',
    'NT': 'Neutral Zone',
    'NU': 'Niue',
    'NZ': 'New Zealand',
    'OM': '\u0639\u0645\u0627\u0646',
    'PA': 'Panam\u00e1',
    'PE': 'Per\u00fa',
    'PF': 'Polyn\u00e9sie fran\u00e7aise',
    'PG': 'Papua New Guinea',
    'PH': 'Philippines',
    'PK': '\u067e\u0627\u06a9\u0633\u062a\u0627\u0646',
    'PL': 'Polska',
    'PM': 'Saint-Pierre-et-Miquelon',
    'PN': 'Pitcairn',
    'PR': 'Puerto Rico',
    'PS': '\u0641\u0644\u0633\u0637\u064a\u0646',
    'PT': 'Portugal',
    'PW': 'Palau',
    'PY': 'Paraguay',
    'QA': '\u0642\u0637\u0631',
    'QO': 'Outlying Oceania',
    'QU': 'European Union',
    'RE': 'R\u00e9union',
    'RO': 'Rom\u00e2nia',
    'RS': '\u0421\u0440\u0431\u0438\u0458\u0430',
    'RU': '\u0420\u043e\u0441\u0441\u0438\u044f',
    'RW': 'Rwanda',
    'SA': '\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644' +
        '\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633' +
        '\u0639\u0648\u062f\u064a\u0629',
    'SB': 'Solomon Islands',
    'SC': 'Seychelles',
    'SD': '\u0627\u0644\u0633\u0648\u062f\u0627\u0646',
    'SE': 'Sverige',
    'SG': '\u65b0\u52a0\u5761',
    'SH': 'Saint Helena',
    'SI': 'Slovenija',
    'SJ': 'Svalbard og Jan Mayen',
    'SK': 'Slovensk\u00e1 republika',
    'SL': 'Sierra Leone',
    'SM': 'San Marino',
    'SN': 'S\u00e9n\u00e9gal',
    'SO': 'Somali',
    'SR': 'Suriname',
    'ST': 'S\u00e3o Tom\u00e9 e Pr\u00edncipe',
    'SU': 'Union of Soviet Socialist Republics',
    'SV': 'El Salvador',
    'SY': '\u0633\u0648\u0631\u064a\u0627',
    'SZ': 'Swaziland',
    'TC': 'Turks and Caicos Islands',
    'TD': '\u062a\u0634\u0627\u062f',
    'TF': 'French Southern Territories',
    'TG': 'Togo',
    'TH': '\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17\u0e22',
    'TJ': '\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646',
    'TK': 'Tokelau',
    'TL': 'Timor Leste',
    'TM': '\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441' +
        '\u0442\u0430\u043d',
    'TN': '\u062a\u0648\u0646\u0633',
    'TO': 'Tonga',
    'TR': 'T\u00fcrkiye',
    'TT': 'Trinidad y Tobago',
    'TV': 'Tuvalu',
    'TW': '\u53f0\u6e7e',
    'TZ': 'Tanzania',
    'UA': '\u0423\u043a\u0440\u0430\u0457\u043d\u0430',
    'UG': 'Uganda',
    'UM': 'United States Minor Outlying Islands',
    'US': 'United States',
    'UY': 'Uruguay',
    'UZ': '\u040e\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e' +
        '\u043d',
    'VA': 'Vaticano',
    'VC': 'Saint Vincent and the Grenadines',
    'VE': 'Venezuela',
    'VG': 'British Virgin Islands',
    'VI': 'U.S. Virgin Islands',
    'VN': 'Vi\u1ec7t Nam',
    'VU': 'Vanuatu',
    'WF': 'Wallis-et-Futuna',
    'WS': 'Samoa',
    'YD': 'People\'s Democratic Republic of Yemen',
    'YE': '\u0627\u0644\u064a\u0645\u0646',
    'YT': 'Mayotte',
    'ZA': 'South Africa',
    'ZM': 'Zambia',
    'ZW': 'Zimbabwe',
    'ZZ': 'Unknown or Invalid Region',
    'aa_DJ': 'Jabuuti',
    'aa_ER': '\u00c9rythr\u00e9e',
    'aa_ER_SAAHO': '\u00c9rythr\u00e9e',
    'aa_ET': 'Itoophiyaa',
    'af_NA': 'Namibi\u00eb',
    'af_ZA': 'Suid-Afrika',
    'ak_GH': 'Ghana',
    'am_ET': '\u12a2\u1275\u12ee\u1335\u12eb',
    'ar_AE': '\u0627\u0644\u0627\u0645\u0627\u0631\u0627\u062a ' +
        '\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627' +
        '\u0644\u0645\u062a\u062d\u062f\u0629',
    'ar_BH': '\u0627\u0644\u0628\u062d\u0631\u064a\u0646',
    'ar_DJ': '\u062c\u064a\u0628\u0648\u062a\u064a',
    'ar_DZ': '\u0627\u0644\u062c\u0632\u0627\u0626\u0631',
    'ar_EG': '\u0645\u0635\u0631',
    'ar_EH': '\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627' +
        '\u0644\u063a\u0631\u0628\u064a\u0629',
    'ar_ER': '\u0627\u0631\u064a\u062a\u0631\u064a\u0627',
    'ar_IL': '\u0627\u0633\u0631\u0627\u0626\u064a\u0644',
    'ar_IQ': '\u0627\u0644\u0639\u0631\u0627\u0642',
    'ar_JO': '\u0627\u0644\u0623\u0631\u062f\u0646',
    'ar_KM': '\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631',
    'ar_KW': '\u0627\u0644\u0643\u0648\u064a\u062a',
    'ar_LB': '\u0644\u0628\u0646\u0627\u0646',
    'ar_LY': '\u0644\u064a\u0628\u064a\u0627',
    'ar_MA': '\u0627\u0644\u0645\u063a\u0631\u0628',
    'ar_MR': '\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a' +
        '\u0627',
    'ar_OM': '\u0639\u0645\u0627\u0646',
    'ar_PS': '\u0641\u0644\u0633\u0637\u064a\u0646',
    'ar_QA': '\u0642\u0637\u0631',
    'ar_SA': '\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627' +
        '\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644' +
        '\u0633\u0639\u0648\u062f\u064a\u0629',
    'ar_SD': '\u0627\u0644\u0633\u0648\u062f\u0627\u0646',
    'ar_SY': '\u0633\u0648\u0631\u064a\u0627',
    'ar_TD': '\u062a\u0634\u0627\u062f',
    'ar_TN': '\u062a\u0648\u0646\u0633',
    'ar_YE': '\u0627\u0644\u064a\u0645\u0646',
    'as_IN': '\u09ad\u09be\u09f0\u09a4',
    'ay_BO': 'Bolivia',
    'az_AZ': 'Az\u0259rbaycan',
    'az_Cyrl_AZ': '\u0410\u0437\u04d9\u0440\u0431\u0430\u0458' +
        '\u04b9\u0430\u043d',
    'az_Latn_AZ': 'Azerbaycan',
    'be_BY': '\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
    'bg_BG': '\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f',
    'bi_VU': 'Vanuatu',
    'bn_BD': '\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6',
    'bn_IN': '\u09ad\u09be\u09b0\u09a4',
    'bo_CN': '\u0f62\u0f92\u0fb1\u0f0b\u0f53\u0f42',
    'bo_IN': '\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62\u0f0b',
    'bs_BA': 'Bosna i Hercegovina',
    'byn_ER': '\u12a4\u122d\u1275\u122b',
    'ca_AD': 'Andorra',
    'ca_ES': 'Espanya',
    'cch_NG': 'Nigeria',
    'ch_GU': 'Guam',
    'chk_FM': 'Micronesia',
    'cop_Arab_EG': '\u0645\u0635\u0631',
    'cop_Arab_US': '\u0627\u0644\u0648\u0644\u0627\u064a\u0627' +
        '\u062a \u0627\u0644\u0645\u062a\u062d\u062f' +
        '\u0629 \u0627\u0644\u0623\u0645\u0631\u064a' +
        '\u0643\u064a\u0629',
    'cop_EG': '\u0645\u0635\u0631',
    'cop_US': '\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a ' +
        '\u0627\u0644\u0645\u062a\u062d\u062f\u0629 \u0627' +
        '\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629',
    'cs_CZ': '\u010cesk\u00e1 republika',
    'cy_GB': 'Prydain Fawr',
    'da_DK': 'Danmark',
    'da_GL': 'Gr\u00f8nland',
    'de_AT': '\u00d6sterreich',
    'de_BE': 'Belgien',
    'de_CH': 'Schweiz',
    'de_DE': 'Deutschland',
    'de_LI': 'Liechtenstein',
    'de_LU': 'Luxemburg',
    'dv_MV': 'Maldives',
    'dz_BT': 'Bhutan',
    'ee_GH': 'Ghana',
    'ee_TG': 'Togo',
    'efi_NG': 'Nigeria',
    'el_CY': '\u039a\u03cd\u03c0\u03c1\u03bf\u03c2',
    'el_GR': '\u0395\u03bb\u03bb\u03ac\u03b4\u03b1',
    'en_AG': 'Antigua and Barbuda',
    'en_AI': 'Anguilla',
    'en_AS': 'American Samoa',
    'en_AU': 'Australia',
    'en_BB': 'Barbados',
    'en_BE': 'Belgium',
    'en_BM': 'Bermuda',
    'en_BS': 'Bahamas',
    'en_BW': 'Botswana',
    'en_BZ': 'Belize',
    'en_CA': 'Canada',
    'en_CC': 'Cocos Islands',
    'en_CK': 'Cook Islands',
    'en_CM': 'Cameroon',
    'en_CX': 'Christmas Island',
    'en_DM': 'Dominica',
    'en_FJ': 'Fiji',
    'en_FK': 'Falkland Islands',
    'en_FM': 'Micronesia',
    'en_GB': 'United Kingdom',
    'en_GD': 'Grenada',
    'en_GG': 'Guernsey',
    'en_GH': 'Ghana',
    'en_GI': 'Gibraltar',
    'en_GM': 'Gambia',
    'en_GU': 'Guam',
    'en_GY': 'Guyana',
    'en_HK': 'Hong Kong',
    'en_HN': 'Honduras',
    'en_IE': 'Ireland',
    'en_IM': 'Isle of Man',
    'en_IN': 'India',
    'en_JE': 'Jersey',
    'en_JM': 'Jamaica',
    'en_KE': 'Kenya',
    'en_KI': 'Kiribati',
    'en_KN': 'Saint Kitts and Nevis',
    'en_KY': 'Cayman Islands',
    'en_LC': 'Saint Lucia',
    'en_LR': 'Liberia',
    'en_LS': 'Lesotho',
    'en_MH': 'Marshall Islands',
    'en_MP': 'Northern Mariana Islands',
    'en_MS': 'Montserrat',
    'en_MT': 'Malta',
    'en_MU': 'Mauritius',
    'en_MW': 'Malawi',
    'en_NA': 'Namibia',
    'en_NF': 'Norfolk Island',
    'en_NG': 'Nigeria',
    'en_NR': 'Nauru',
    'en_NU': 'Niue',
    'en_NZ': 'New Zealand',
    'en_PG': 'Papua New Guinea',
    'en_PH': 'Philippines',
    'en_PK': 'Pakistan',
    'en_PN': 'Pitcairn',
    'en_PR': 'Puerto Rico',
    'en_RW': 'Rwanda',
    'en_SB': 'Solomon Islands',
    'en_SC': 'Seychelles',
    'en_SG': 'Singapore',
    'en_SH': 'Saint Helena',
    'en_SL': 'Sierra Leone',
    'en_SZ': 'Swaziland',
    'en_TC': 'Turks and Caicos Islands',
    'en_TK': 'Tokelau',
    'en_TO': 'Tonga',
    'en_TT': 'Trinidad and Tobago',
    'en_TV': 'Tuvalu',
    'en_TZ': 'Tanzania',
    'en_UG': 'Uganda',
    'en_UM': 'United States Minor Outlying Islands',
    'en_US': 'United States',
    'en_US_POSIX': 'United States',
    'en_VC': 'Saint Vincent and the Grenadines',
    'en_VG': 'British Virgin Islands',
    'en_VI': 'U.S. Virgin Islands',
    'en_VU': 'Vanuatu',
    'en_WS': 'Samoa',
    'en_ZA': 'South Africa',
    'en_ZM': 'Zambia',
    'en_ZW': 'Zimbabwe',
    'es_AR': 'Argentina',
    'es_BO': 'Bolivia',
    'es_CL': 'Chile',
    'es_CO': 'Colombia',
    'es_CR': 'Costa Rica',
    'es_CU': 'Cuba',
    'es_DO': 'Rep\u00fablica Dominicana',
    'es_EC': 'Ecuador',
    'es_ES': 'Espa\u00f1a',
    'es_GQ': 'Guinea Ecuatorial',
    'es_GT': 'Guatemala',
    'es_HN': 'Honduras',
    'es_MX': 'M\u00e9xico',
    'es_NI': 'Nicaragua',
    'es_PA': 'Panam\u00e1',
    'es_PE': 'Per\u00fa',
    'es_PH': 'Filipinas',
    'es_PR': 'Puerto Rico',
    'es_PY': 'Paraguay',
    'es_SV': 'El Salvador',
    'es_US': 'Estados Unidos',
    'es_UY': 'Uruguay',
    'es_VE': 'Venezuela',
    'et_EE': 'Eesti',
    'eu_ES': 'Espainia',
    'fa_AF': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627' +
        '\u0646',
    'fa_IR': '\u0627\u06cc\u0631\u0627\u0646',
    'fi_FI': 'Suomi',
    'fil_PH': 'Philippines',
    'fj_FJ': 'Fiji',
    'fo_FO': 'F\u00f8royar',
    'fr_BE': 'Belgique',
    'fr_BF': 'Burkina Faso',
    'fr_BI': 'Burundi',
    'fr_BJ': 'B\u00e9nin',
    'fr_CA': 'Canada',
    'fr_CD': 'R\u00e9publique d\u00e9mocratique du Congo',
    'fr_CF': 'R\u00e9publique centrafricaine',
    'fr_CG': 'Congo',
    'fr_CH': 'Suisse',
    'fr_CI': 'C\u00f4te d\u2019Ivoire',
    'fr_CM': 'Cameroun',
    'fr_DJ': 'Djibouti',
    'fr_DZ': 'Alg\u00e9rie',
    'fr_FR': 'France',
    'fr_GA': 'Gabon',
    'fr_GF': 'Guyane fran\u00e7aise',
    'fr_GN': 'Guin\u00e9e',
    'fr_GP': 'Guadeloupe',
    'fr_GQ': 'Guin\u00e9e \u00e9quatoriale',
    'fr_HT': 'Ha\u00efti',
    'fr_KM': 'Comores',
    'fr_LU': 'Luxembourg',
    'fr_MA': 'Maroc',
    'fr_MC': 'Monaco',
    'fr_MG': 'Madagascar',
    'fr_ML': 'Mali',
    'fr_MQ': 'Martinique',
    'fr_MU': 'Maurice',
    'fr_NC': 'Nouvelle-Cal\u00e9donie',
    'fr_NE': 'Niger',
    'fr_PF': 'Polyn\u00e9sie fran\u00e7aise',
    'fr_PM': 'Saint-Pierre-et-Miquelon',
    'fr_RE': 'R\u00e9union',
    'fr_RW': 'Rwanda',
    'fr_SC': 'Seychelles',
    'fr_SN': 'S\u00e9n\u00e9gal',
    'fr_SY': 'Syrie',
    'fr_TD': 'Tchad',
    'fr_TG': 'Togo',
    'fr_TN': 'Tunisie',
    'fr_VU': 'Vanuatu',
    'fr_WF': 'Wallis-et-Futuna',
    'fr_YT': 'Mayotte',
    'fur_IT': 'Italia',
    'ga_IE': '\u00c9ire',
    'gaa_GH': 'Ghana',
    'gez_ER': '\u12a4\u122d\u1275\u122b',
    'gez_ET': '\u12a2\u1275\u12ee\u1335\u12eb',
    'gil_KI': 'Kiribati',
    'gl_ES': 'Espa\u00f1a',
    'gn_PY': 'Paraguay',
    'gu_IN': '\u0aad\u0abe\u0ab0\u0aa4',
    'gv_GB': 'Rywvaneth Unys',
    'ha_Arab_NG': '\u0646\u064a\u062c\u064a\u0631\u064a\u0627',
    'ha_GH': '\u063a\u0627\u0646\u0627',
    'ha_Latn_GH': 'Ghana',
    'ha_Latn_NE': 'Niger',
    'ha_Latn_NG': 'Nig\u00e9ria',
    'ha_NE': '\u0627\u0644\u0646\u064a\u062c\u0631',
    'ha_NG': '\u0646\u064a\u062c\u064a\u0631\u064a\u0627',
    'haw_US': '\u02bbAmelika Hui P\u016b \u02bbIa',
    'he_IL': '\u05d9\u05e9\u05e8\u05d0\u05dc',
    'hi_IN': '\u092d\u093e\u0930\u0924',
    'ho_PG': 'Papua New Guinea',
    'hr_BA': 'Bosna i Hercegovina',
    'hr_HR': 'Hrvatska',
    'ht_HT': 'Ha\u00efti',
    'hu_HU': 'Magyarorsz\u00e1g',
    'hy_AM': '\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576' +
        '\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565' +
        '\u057f\u0578\u0582\u0569\u056b\u0582\u0576',
    'hy_AM_REVISED': '\u0540\u0561\u0575\u0561\u057d\u057f\u0561' +
        '\u0576\u056b \u0540\u0561\u0576\u0580\u0561' +
        '\u057a\u0565\u057f\u0578\u0582\u0569\u056b' +
        '\u0582\u0576',
    'id_ID': 'Indonesia',
    'ig_NG': 'Nigeria',
    'ii_CN': '\ua34f\ua1e9',
    'is_IS': '\u00cdsland',
    'it_CH': 'Svizzera',
    'it_IT': 'Italia',
    'it_SM': 'San Marino',
    'ja_JP': '\u65e5\u672c',
    'ka_GE': '\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4' +
        '\u10da\u10dd',
    'kaj_NG': 'Nigeria',
    'kam_KE': 'Kenya',
    'kcg_NG': 'Nigeria',
    'kfo_NG': 'Nig\u00e9ria',
    'kk_KZ': '\u049a\u0430\u0437\u0430\u049b\u0441\u0442\u0430' +
        '\u043d',
    'kl_GL': 'Kalaallit Nunaat',
    'km_KH': '\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6',
    'kn_IN': '\u0cad\u0cbe\u0cb0\u0ca4',
    'ko_KP': '\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc ' +
        '\uacf5\ud654\uad6d',
    'ko_KR': '\ub300\ud55c\ubbfc\uad6d',
    'kok_IN': '\u092d\u093e\u0930\u0924',
    'kos_FM': 'Micronesia',
    'kpe_GN': 'Guin\u00e9e',
    'kpe_LR': 'Lib\u00e9ria',
    'ks_IN': '\u092d\u093e\u0930\u0924',
    'ku_IQ': 'Irak',
    'ku_IR': '\u0130ran',
    'ku_Latn_IQ': 'Irak',
    'ku_Latn_IR': '\u0130ran',
    'ku_Latn_SY': 'Suriye',
    'ku_Latn_TR': 'T\u00fcrkiye',
    'ku_SY': 'Suriye',
    'ku_TR': 'T\u00fcrkiye',
    'kw_GB': 'Rywvaneth Unys',
    'ky_Cyrl_KG': '\u041a\u044b\u0440\u0433\u044b\u0437\u0441' +
        '\u0442\u0430\u043d',
    'ky_KG': 'K\u0131rg\u0131zistan',
    'la_VA': 'Vaticano',
    'lb_LU': 'Luxembourg',
    'ln_CD': 'R\u00e9publique d\u00e9mocratique du Congo',
    'ln_CG': 'Kongo',
    'lo_LA': 'Laos',
    'lt_LT': 'Lietuva',
    'lv_LV': 'Latvija',
    'mg_MG': 'Madagascar',
    'mh_MH': 'Marshall Islands',
    'mi_NZ': 'New Zealand',
    'mk_MK': '\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438' +
        '\u0458\u0430',
    'ml_IN': '\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f',
    'mn_Cyrl_MN': '\u041c\u043e\u043d\u0433\u043e\u043b\u0438' +
        '\u044f',
    'mn_MN': '\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f',
    'mr_IN': '\u092d\u093e\u0930\u0924',
    'ms_BN': 'Brunei',
    'ms_MY': 'Malaysia',
    'ms_SG': 'Singapura',
    'mt_MT': 'Malta',
    'my_MM': 'Myanmar',
    'na_NR': 'Nauru',
    'nb_NO': 'Norge',
    'nb_SJ': 'Svalbard og Jan Mayen',
    'ne_NP': '\u0928\u0947\u092a\u093e\u0932',
    'niu_NU': 'Niue',
    'nl_AN': 'Nederlandse Antillen',
    'nl_AW': 'Aruba',
    'nl_BE': 'Belgi\u00eb',
    'nl_NL': 'Nederland',
    'nl_SR': 'Suriname',
    'nn_NO': 'Noreg',
    'nr_ZA': 'South Africa',
    'nso_ZA': 'South Africa',
    'ny_MW': 'Malawi',
    'om_ET': 'Itoophiyaa',
    'om_KE': 'Keeniyaa',
    'or_IN': '\u0b2d\u0b3e\u0b30\u0b24',
    'pa_Arab_PK': '\u067e\u0627\u06a9\u0633\u062a\u0627\u0646',
    'pa_Guru_IN': '\u0a2d\u0a3e\u0a30\u0a24',
    'pa_IN': '\u0a2d\u0a3e\u0a30\u0a24',
    'pa_PK': '\u067e\u0627\u06a9\u0633\u062a\u0627\u0646',
    'pap_AN': 'Nederlandse Antillen',
    'pau_PW': 'Palau',
    'pl_PL': 'Polska',
    'pon_FM': 'Micronesia',
    'ps_AF': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627' +
        '\u0646',
    'pt_AO': 'Angola',
    'pt_BR': 'Brasil',
    'pt_CV': 'Cabo Verde',
    'pt_GW': 'Guin\u00e9 Bissau',
    'pt_MZ': 'Mo\u00e7ambique',
    'pt_PT': 'Portugal',
    'pt_ST': 'S\u00e3o Tom\u00e9 e Pr\u00edncipe',
    'pt_TL': 'Timor Leste',
    'qu_BO': 'Bolivia',
    'qu_PE': 'Per\u00fa',
    'rm_CH': 'Schweiz',
    'rn_BI': 'Burundi',
    'ro_MD': 'Moldova, Republica',
    'ro_RO': 'Rom\u00e2nia',
    'ru_BY': '\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
    'ru_KG': '\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442' +
        '\u0430\u043d',
    'ru_KZ': '\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430' +
        '\u043d',
    'ru_RU': '\u0420\u043e\u0441\u0441\u0438\u044f',
    'ru_UA': '\u0423\u043a\u0440\u0430\u0438\u043d\u0430',
    'rw_RW': 'Rwanda',
    'sa_IN': '\u092d\u093e\u0930\u0924',
    'sd_Deva_IN': '\u092d\u093e\u0930\u0924',
    'sd_IN': '\u092d\u093e\u0930\u0924',
    'se_FI': 'Finland',
    'se_NO': 'Norge',
    'sg_CF': 'R\u00e9publique centrafricaine',
    'sh_BA': 'Bosnia and Herzegovina',
    'sh_CS': 'Serbia and Montenegro',
    'si_LK': 'Sri Lanka',
    'sid_ET': 'Itoophiyaa',
    'sk_SK': 'Slovensk\u00e1 republika',
    'sl_SI': 'Slovenija',
    'sm_AS': 'American Samoa',
    'sm_WS': 'Samoa',
    'so_DJ': 'Jabuuti',
    'so_ET': 'Itoobiya',
    'so_KE': 'Kiiniya',
    'so_SO': 'Soomaaliya',
    'sq_AL': 'Shqip\u00ebria',
    'sr_BA': '\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435' +
        '\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d' +
        '\u0430',
    'sr_CS': '\u0421\u0440\u0431\u0438\u0458\u0430 \u0438 \u0426' +
        '\u0440\u043d\u0430 \u0413\u043e\u0440\u0430',
    'sr_Cyrl_BA': '\u0411\u043e\u0441\u043d\u0438\u044f',
    'sr_Cyrl_CS': '\u0421\u0435\u0440\u0431\u0438\u044f \u0438 ' +
        '\u0427\u0435\u0440\u043d\u043e\u0433\u043e' +
        '\u0440\u0438\u044f',
    'sr_Cyrl_ME': '\u0427\u0435\u0440\u043d\u043e\u0433\u043e' +
        '\u0440\u0438\u044f',
    'sr_Cyrl_RS': '\u0421\u0435\u0440\u0431\u0438\u044f',
    'sr_Latn_BA': 'Bosna i Hercegovina',
    'sr_Latn_CS': 'Srbija i Crna Gora',
    'sr_Latn_ME': 'Crna Gora',
    'sr_Latn_RS': 'Srbija',
    'sr_ME': '\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430',
    'sr_RS': '\u0421\u0440\u0431\u0438\u0458\u0430',
    'ss_SZ': 'Swaziland',
    'ss_ZA': 'South Africa',
    'st_LS': 'Lesotho',
    'st_ZA': 'South Africa',
    'su_ID': 'Indonesia',
    'sv_AX': '\u00c5land',
    'sv_FI': 'Finland',
    'sv_SE': 'Sverige',
    'sw_KE': 'Kenya',
    'sw_TZ': 'Tanzania',
    'sw_UG': 'Uganda',
    'swb_KM': '\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631',
    'syr_SY': 'Syria',
    'ta_IN': '\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe',
    'ta_LK': '\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8',
    'ta_SG': '\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa' +
        '\u0bc2\u0bb0\u0bcd',
    'te_IN': '\u0c2d\u0c3e\u0c30\u0c24 \u0c26\u0c47\u0c33\u0c02',
    'tet_TL': 'Timor Leste',
    'tg_Cyrl_TJ': '\u0422\u0430\u0434\u0436\u0438\u043a\u0438' +
        '\u0441\u0442\u0430\u043d',
    'tg_TJ': '\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646',
    'th_TH': '\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17' +
        '\u0e22',
    'ti_ER': '\u12a4\u122d\u1275\u122b',
    'ti_ET': '\u12a2\u1275\u12ee\u1335\u12eb',
    'tig_ER': '\u12a4\u122d\u1275\u122b',
    'tk_TM': '\u062a\u0631\u06a9\u0645\u0646\u0633\u062a\u0627' +
        '\u0646',
    'tkl_TK': 'Tokelau',
    'tn_BW': 'Botswana',
    'tn_ZA': 'South Africa',
    'to_TO': 'Tonga',
    'tpi_PG': 'Papua New Guinea',
    'tr_CY': 'G\u00fcney K\u0131br\u0131s Rum Kesimi',
    'tr_TR': 'T\u00fcrkiye',
    'ts_ZA': 'South Africa',
    'tt_RU': '\u0420\u043e\u0441\u0441\u0438\u044f',
    'tvl_TV': 'Tuvalu',
    'ty_PF': 'Polyn\u00e9sie fran\u00e7aise',
    'uk_UA': '\u0423\u043a\u0440\u0430\u0457\u043d\u0430',
    'uli_FM': 'Micronesia',
    'und_ZZ': 'Unknown or Invalid Region',
    'ur_IN': '\u0628\u06be\u0627\u0631\u062a',
    'ur_PK': '\u067e\u0627\u06a9\u0633\u062a\u0627\u0646',
    'uz_AF': 'Afganistan',
    'uz_Arab_AF': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a' +
        '\u0627\u0646',
    'uz_Cyrl_UZ': '\u0423\u0437\u0431\u0435\u043a\u0438\u0441' +
        '\u0442\u0430\u043d',
    'uz_Latn_UZ': 'O\u02bfzbekiston',
    'uz_UZ': '\u040e\u0437\u0431\u0435\u043a\u0438\u0441\u0442' +
        '\u043e\u043d',
    've_ZA': 'South Africa',
    'vi_VN': 'Vi\u1ec7t Nam',
    'wal_ET': '\u12a2\u1275\u12ee\u1335\u12eb',
    'wo_Arab_SN': '\u0627\u0644\u0633\u0646\u063a\u0627\u0644',
    'wo_Latn_SN': 'S\u00e9n\u00e9gal',
    'wo_SN': 'S\u00e9n\u00e9gal',
    'xh_ZA': 'South Africa',
    'yap_FM': 'Micronesia',
    'yo_NG': 'Nigeria',
    'zh_CN': '\u4e2d\u56fd',
    'zh_HK': '\u9999\u6e2f',
    'zh_Hans_CN': '\u4e2d\u56fd',
    'zh_Hans_SG': '\u65b0\u52a0\u5761',
    'zh_Hant_HK': '\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u570b' +
        '\u9999\u6e2f\u7279\u5225\u884c\u653f\u5340',
    'zh_Hant_MO': '\u6fb3\u9580',
    'zh_Hant_TW': '\u81fa\u7063',
    'zh_MO': '\u6fb3\u95e8',
    'zh_SG': '\u65b0\u52a0\u5761',
    'zh_TW': '\u53f0\u6e7e',
    'zu_ZA': 'South Africa'
  },
  'LANGUAGE': {
    'aa': 'afar',
    'ab': '\u0430\u0431\u0445\u0430\u0437\u0441\u043a\u0438\u0439',
    'ace': 'Aceh',
    'ach': 'Acoli',
    'ada': 'Adangme',
    'ady': '\u0430\u0434\u044b\u0433\u0435\u0439\u0441\u043a' +
        '\u0438\u0439',
    'ae': 'Avestan',
    'af': 'Afrikaans',
    'afa': 'Afro-Asiatic Language',
    'afh': 'Afrihili',
    'ain': 'Ainu',
    'ak': 'Akan',
    'akk': 'Akkadian',
    'ale': 'Aleut',
    'alg': 'Algonquian Language',
    'alt': 'Southern Altai',
    'am': '\u12a0\u121b\u122d\u129b',
    'an': 'Aragonese',
    'ang': 'Old English',
    'anp': 'Angika',
    'apa': 'Apache Language',
    'ar': '\u0627\u0644\u0639\u0631\u0628\u064a\u0629',
    'arc': 'Aramaic',
    'arn': 'Araucanian',
    'arp': 'Arapaho',
    'art': 'Artificial Language',
    'arw': 'Arawak',
    'as': '\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be',
    'ast': 'asturiano',
    'ath': 'Athapascan Language',
    'aus': 'Australian Language',
    'av': '\u0430\u0432\u0430\u0440\u0441\u043a\u0438\u0439',
    'awa': 'Awadhi',
    'ay': 'aimara',
    'az': 'az\u0259rbaycanca',
    'az_Arab': '\u062a\u0631\u06a9\u06cc \u0622\u0630\u0631\u0628' +
        '\u0627\u06cc\u062c\u0627\u0646\u06cc',
    'az_Cyrl': '\u0410\u0437\u04d9\u0440\u0431\u0430\u0458\u04b9' +
        '\u0430\u043d',
    'az_Latn': 'Azerice',
    'ba': '\u0431\u0430\u0448\u043a\u0438\u0440\u0441\u043a\u0438' +
        '\u0439',
    'bad': 'Banda',
    'bai': 'Bamileke Language',
    'bal': '\u0628\u0644\u0648\u0686\u06cc',
    'ban': 'Balin',
    'bas': 'Basa',
    'bat': 'Baltic Language',
    'be': '\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430' +
        '\u044f',
    'bej': 'Beja',
    'bem': 'Bemba',
    'ber': 'Berber',
    'bg': '\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438',
    'bh': '\u092c\u093f\u0939\u093e\u0930\u0940',
    'bho': 'Bhojpuri',
    'bi': 'bichelamar ; bislama',
    'bik': 'Bikol',
    'bin': 'Bini',
    'bla': 'Siksika',
    'bm': 'bambara',
    'bn': '\u09ac\u09be\u0982\u09b2\u09be',
    'bnt': 'Bantu',
    'bo': '\u0f54\u0f7c\u0f51\u0f0b\u0f66\u0f90\u0f51\u0f0b',
    'br': 'breton',
    'bra': 'Braj',
    'bs': 'Bosanski',
    'btk': 'Batak',
    'bua': 'Buriat',
    'bug': 'Bugis',
    'byn': '\u1265\u120a\u1295',
    'ca': 'catal\u00e0',
    'cad': 'Caddo',
    'cai': 'Central American Indian Language',
    'car': 'Carib',
    'cau': 'Caucasian Language',
    'cch': 'Atsam',
    'ce': '\u0447\u0435\u0447\u0435\u043d\u0441\u043a\u0438\u0439',
    'ceb': 'Cebuano',
    'cel': 'Celtic Language',
    'ch': 'Chamorro',
    'chb': 'Chibcha',
    'chg': 'Chagatai',
    'chk': 'Chuukese',
    'chm': '\u043c\u0430\u0440\u0438\u0439\u0441\u043a\u0438' +
        '\u0439 (\u0447\u0435\u0440\u0435\u043c\u0438\u0441' +
        '\u0441\u043a\u0438\u0439)',
    'chn': 'Chinook Jargon',
    'cho': 'Choctaw',
    'chp': 'Chipewyan',
    'chr': 'Cherokee',
    'chy': 'Cheyenne',
    'cmc': 'Chamic Language',
    'co': 'corse',
    'cop': '\u0642\u0628\u0637\u064a\u0629',
    'cop_Arab': '\u0642\u0628\u0637\u064a\u0629',
    'cpe': 'English-based Creole or Pidgin',
    'cpf': 'French-based Creole or Pidgin',
    'cpp': 'Portuguese-based Creole or Pidgin',
    'cr': 'Cree',
    'crh': 'Crimean Turkish',
    'crp': 'Creole or Pidgin',
    'cs': '\u010de\u0161tina',
    'csb': 'Kashubian',
    'cu': 'Church Slavic',
    'cus': 'Cushitic Language',
    'cv': '\u0447\u0443\u0432\u0430\u0448\u0441\u043a\u0438\u0439',
    'cy': 'Cymraeg',
    'da': 'dansk',
    'dak': 'Dakota',
    'dar': '\u0434\u0430\u0440\u0433\u0432\u0430',
    'day': 'Dayak',
    'de': 'Deutsch',
    'del': 'Delaware',
    'den': 'Slave',
    'dgr': 'Dogrib',
    'din': 'Dinka',
    'doi': '\u0627\u0644\u062f\u0648\u062c\u0631\u0649',
    'dra': 'Dravidian Language',
    'dsb': 'Lower Sorbian',
    'dua': 'Duala',
    'dum': 'Middle Dutch',
    'dv': 'Divehi',
    'dyu': 'dioula',
    'dz': '\u0f62\u0fab\u0f7c\u0f44\u0f0b\u0f41',
    'ee': 'Ewe',
    'efi': 'Efik',
    'egy': 'Ancient Egyptian',
    'eka': 'Ekajuk',
    'el': '\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac',
    'elx': 'Elamite',
    'en': 'English',
    'enm': 'Middle English',
    'eo': 'esperanto',
    'es': 'espa\u00f1ol',
    'et': 'eesti',
    'eu': 'euskara',
    'ewo': 'Ewondo',
    'fa': '\u0641\u0627\u0631\u0633\u06cc',
    'fan': 'fang',
    'fat': 'Fanti',
    'ff': 'Fulah',
    'fi': 'suomi',
    'fil': 'Filipino',
    'fiu': 'Finno-Ugrian Language',
    'fj': 'Fijian',
    'fo': 'f\u00f8royskt',
    'fon': 'Fon',
    'fr': 'fran\u00e7ais',
    'frm': 'Middle French',
    'fro': 'Old French',
    'frr': 'Northern Frisian',
    'frs': 'Eastern Frisian',
    'fur': 'friulano',
    'fy': 'Fries',
    'ga': 'Gaeilge',
    'gaa': 'Ga',
    'gay': 'Gayo',
    'gba': 'Gbaya',
    'gd': 'Scottish Gaelic',
    'gem': 'Germanic Language',
    'gez': '\u130d\u12d5\u12dd\u129b',
    'gil': 'Gilbertese',
    'gl': 'galego',
    'gmh': 'Middle High German',
    'gn': 'guaran\u00ed',
    'goh': 'Old High German',
    'gon': 'Gondi',
    'gor': 'Gorontalo',
    'got': 'Gothic',
    'grb': 'Grebo',
    'grc': '\u0391\u03c1\u03c7\u03b1\u03af\u03b1 \u0395\u03bb' +
        '\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac',
    'gsw': 'Schweizerdeutsch',
    'gu': '\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0',
    'gv': 'Gaelg',
    'gwi': 'Gwich\u02bcin',
    'ha': '\u0627\u0644\u0647\u0648\u0633\u0627',
    'ha_Arab': '\u0627\u0644\u0647\u0648\u0633\u0627',
    'ha_Latn': 'haoussa',
    'hai': 'Haida',
    'haw': '\u02bb\u014dlelo Hawai\u02bbi',
    'he': '\u05e2\u05d1\u05e8\u05d9\u05ea',
    'hi': '\u0939\u093f\u0902\u0926\u0940',
    'hil': 'Hiligaynon',
    'him': 'Himachali',
    'hit': 'Hittite',
    'hmn': 'Hmong',
    'ho': 'Hiri Motu',
    'hr': 'hrvatski',
    'hsb': 'Upper Sorbian',
    'ht': 'ha\u00eftien',
    'hu': 'magyar',
    'hup': 'Hupa',
    'hy': '\u0540\u0561\u0575\u0565\u0580\u0567\u0576',
    'hz': 'Herero',
    'ia': 'interlingvao',
    'iba': 'Iban',
    'id': 'Bahasa Indonesia',
    'ie': 'Interlingue',
    'ig': 'Igbo',
    'ii': '\ua188\ua320\ua259',
    'ijo': 'Ijo',
    'ik': 'Inupiaq',
    'ilo': 'Iloko',
    'inc': 'Indic Language',
    'ine': 'Indo-European Language',
    'inh': '\u0438\u043d\u0433\u0443\u0448\u0441\u043a\u0438' +
        '\u0439',
    'io': 'Ido',
    'ira': 'Iranian Language',
    'iro': 'Iroquoian Language',
    'is': '\u00edslenska',
    'it': 'italiano',
    'iu': 'Inuktitut',
    'ja': '\u65e5\u672c\u8a9e',
    'jbo': 'Lojban',
    'jpr': 'Judeo-Persian',
    'jrb': 'Judeo-Arabic',
    'jv': 'Jawa',
    'ka': '\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8',
    'kaa': '\u043a\u0430\u0440\u0430\u043a\u0430\u043b\u043f' +
        '\u0430\u043a\u0441\u043a\u0438\u0439',
    'kab': 'kabyle',
    'kac': 'Kachin',
    'kaj': 'Jju',
    'kam': 'Kamba',
    'kar': 'Karen',
    'kaw': 'Kawi',
    'kbd': '\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d' +
        '\u0441\u043a\u0438\u0439',
    'kcg': 'Tyap',
    'kfo': 'koro',
    'kg': 'Kongo',
    'kha': 'Khasi',
    'khi': 'Khoisan Language',
    'kho': 'Khotanese',
    'ki': 'Kikuyu',
    'kj': 'Kuanyama',
    'kk': '\u049a\u0430\u0437\u0430\u049b',
    'kl': 'kalaallisut',
    'km': '\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a',
    'kmb': 'quimbundo',
    'kn': '\u0c95\u0ca8\u0ccd\u0ca8\u0ca1',
    'ko': '\ud55c\uad6d\uc5b4',
    'kok': '\u0915\u094b\u0902\u0915\u0923\u0940',
    'kos': 'Kosraean',
    'kpe': 'kpell\u00e9',
    'kr': 'Kanuri',
    'krc': '\u043a\u0430\u0440\u0430\u0447\u0430\u0435\u0432' +
        '\u043e-\u0431\u0430\u043b\u043a\u0430\u0440\u0441' +
        '\u043a\u0438\u0439',
    'krl': '\u043a\u0430\u0440\u0435\u043b\u044c\u0441\u043a' +
        '\u0438\u0439',
    'kro': 'Kru',
    'kru': 'Kurukh',
    'ks': '\u0915\u093e\u0936\u094d\u092e\u093f\u0930\u0940',
    'ku': 'K\u00fcrt\u00e7e',
    'ku_Arab': '\u0627\u0644\u0643\u0631\u062f\u064a\u0629',
    'ku_Latn': 'K\u00fcrt\u00e7e',
    'kum': '\u043a\u0443\u043c\u044b\u043a\u0441\u043a\u0438' +
        '\u0439',
    'kut': 'Kutenai',
    'kv': 'Komi',
    'kw': 'kernewek',
    'ky': 'K\u0131rg\u0131zca',
    'ky_Arab': '\u0627\u0644\u0642\u064a\u0631\u063a\u0633\u062a' +
        '\u0627\u0646\u064a\u0629',
    'ky_Cyrl': '\u043a\u0438\u0440\u0433\u0438\u0437\u0441\u043a' +
        '\u0438\u0439',
    'la': 'latino',
    'lad': '\u05dc\u05d3\u05d9\u05e0\u05d5',
    'lah': '\u0644\u0627\u0647\u0646\u062f\u0627',
    'lam': 'Lamba',
    'lb': 'luxembourgeois',
    'lez': '\u043b\u0435\u0437\u0433\u0438\u043d\u0441\u043a' +
        '\u0438\u0439',
    'lg': 'Ganda',
    'li': 'Limburgs',
    'ln': 'lingala',
    'lo': 'Lao',
    'lol': 'mongo',
    'loz': 'Lozi',
    'lt': 'lietuvi\u0173',
    'lu': 'luba-katanga',
    'lua': 'luba-lulua',
    'lui': 'Luiseno',
    'lun': 'Lunda',
    'luo': 'Luo',
    'lus': 'Lushai',
    'lv': 'latvie\u0161u',
    'mad': 'Madura',
    'mag': 'Magahi',
    'mai': 'Maithili',
    'mak': 'Makassar',
    'man': 'Mandingo',
    'map': 'Austronesian',
    'mas': 'Masai',
    'mdf': '\u043c\u043e\u043a\u0448\u0430',
    'mdr': 'Mandar',
    'men': 'Mende',
    'mg': 'malgache',
    'mga': 'Middle Irish',
    'mh': 'Marshallese',
    'mi': 'Maori',
    'mic': 'Micmac',
    'min': 'Minangkabau',
    'mis': 'Miscellaneous Language',
    'mk': '\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a' +
        '\u0438',
    'mkh': 'Mon-Khmer Language',
    'ml': '\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02',
    'mn': '\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a' +
        '\u0438\u0439',
    'mn_Cyrl': '\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441' +
        '\u043a\u0438\u0439',
    'mn_Mong': '\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441' +
        '\u043a\u0438\u0439',
    'mnc': 'Manchu',
    'mni': 'Manipuri',
    'mno': 'Manobo Language',
    'mo': 'Moldavian',
    'moh': 'Mohawk',
    'mos': 'mor\u00e9 ; mossi',
    'mr': '\u092e\u0930\u093e\u0920\u0940',
    'ms': 'Bahasa Melayu',
    'mt': 'Malti',
    'mul': 'Multiple Languages',
    'mun': 'Munda Language',
    'mus': 'Creek',
    'mwl': 'Mirandese',
    'mwr': 'Marwari',
    'my': 'Burmese',
    'myn': 'Mayan Language',
    'myv': '\u044d\u0440\u0437\u044f',
    'na': 'Nauru',
    'nah': 'Nahuatl',
    'nai': 'North American Indian Language',
    'nap': 'napoletano',
    'nb': 'norsk bokm\u00e5l',
    'nd': 'North Ndebele',
    'nds': 'Low German',
    'ne': '\u0928\u0947\u092a\u093e\u0932\u0940',
    'new': 'Newari',
    'ng': 'Ndonga',
    'nia': 'Nias',
    'nic': 'Niger-Kordofanian Language',
    'niu': 'Niuean',
    'nl': 'Nederlands',
    'nn': 'nynorsk',
    'no': 'Norwegian',
    'nog': '\u043d\u043e\u0433\u0430\u0439\u0441\u043a\u0438' +
        '\u0439',
    'non': 'Old Norse',
    'nqo': 'N\u2019Ko',
    'nr': 'South Ndebele',
    'nso': 'Northern Sotho',
    'nub': 'Nubian Language',
    'nv': 'Navajo',
    'nwc': 'Classical Newari',
    'ny': 'nianja; chicheua; cheua',
    'nym': 'Nyamwezi',
    'nyn': 'Nyankole',
    'nyo': 'Nyoro',
    'nzi': 'Nzima',
    'oc': 'occitan',
    'oj': 'Ojibwa',
    'om': 'Oromoo',
    'or': '\u0b13\u0b21\u0b3c\u0b3f\u0b06',
    'os': '\u043e\u0441\u0435\u0442\u0438\u043d\u0441\u043a\u0438' +
        '\u0439',
    'osa': 'Osage',
    'ota': 'Ottoman Turkish',
    'oto': 'Otomian Language',
    'pa': '\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40',
    'pa_Arab': '\u067e\u0646\u062c\u0627\u0628',
    'pa_Guru': '\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40',
    'paa': 'Papuan Language',
    'pag': 'Pangasinan',
    'pal': 'Pahlavi',
    'pam': 'Pampanga',
    'pap': 'Papiamento',
    'pau': 'Palauan',
    'peo': 'Old Persian',
    'phi': 'Philippine Language',
    'phn': 'Phoenician',
    'pi': '\u0e1a\u0e32\u0e25\u0e35',
    'pl': 'polski',
    'pon': 'Pohnpeian',
    'pra': 'Prakrit Language',
    'pro': 'Old Proven\u00e7al',
    'ps': '\u067e\u069a\u062a\u0648',
    'pt': 'portugu\u00eas',
    'qu': 'quechua',
    'raj': 'Rajasthani',
    'rap': 'Rapanui',
    'rar': 'Rarotongan',
    'rm': 'R\u00e4toromanisch',
    'rn': 'roundi',
    'ro': 'rom\u00e2n\u0103',
    'roa': 'Romance Language',
    'rom': 'Romany',
    'ru': '\u0440\u0443\u0441\u0441\u043a\u0438\u0439',
    'rup': 'Aromanian',
    'rw': 'rwanda',
    'sa': '\u0938\u0902\u0938\u094d\u0915\u0943\u0924 \u092d' +
        '\u093e\u0937\u093e',
    'sad': 'Sandawe',
    'sah': '\u044f\u043a\u0443\u0442\u0441\u043a\u0438\u0439',
    'sai': 'South American Indian Language',
    'sal': 'Salishan Language',
    'sam': '\u05d0\u05e8\u05de\u05d9\u05ea \u05e9\u05d5\u05de' +
        '\u05e8\u05d5\u05e0\u05d9\u05ea',
    'sas': 'Sasak',
    'sat': 'Santali',
    'sc': 'Sardinian',
    'scn': 'siciliano',
    'sco': 'Scots',
    'sd': '\u0938\u093f\u0928\u094d\u0927\u0940',
    'sd_Arab': '\u0633\u0646\u062f\u06cc',
    'sd_Deva': '\u0938\u093f\u0928\u094d\u0927\u0940',
    'se': 'nordsamiska',
    'sel': '\u0441\u0435\u043b\u044c\u043a\u0443\u043f\u0441' +
        '\u043a\u0438\u0439',
    'sem': 'Semitic Language',
    'sg': 'sangho',
    'sga': 'Old Irish',
    'sgn': 'Sign Language',
    'sh': 'Serbo-Croatian',
    'shn': 'Shan',
    'si': 'Sinhalese',
    'sid': 'Sidamo',
    'sio': 'Siouan Language',
    'sit': 'Sino-Tibetan Language',
    'sk': 'slovensk\u00fd',
    'sl': 'sloven\u0161\u010dina',
    'sla': 'Slavic Language',
    'sm': 'Samoan',
    'sma': 'sydsamiska',
    'smi': 'Sami Language',
    'smj': 'lulesamiska',
    'smn': 'Inari Sami',
    'sms': 'Skolt Sami',
    'sn': 'Shona',
    'snk': 'sonink\u00e9',
    'so': 'Soomaali',
    'sog': 'Sogdien',
    'son': 'Songhai',
    'sq': 'shqipe',
    'sr': '\u0421\u0440\u043f\u0441\u043a\u0438',
    'sr_Cyrl': '\u0441\u0435\u0440\u0431\u0441\u043a\u0438\u0439',
    'sr_Latn': 'Srpski',
    'srn': 'Sranantongo',
    'srr': 's\u00e9r\u00e8re',
    'ss': 'Swati',
    'ssa': 'Nilo-Saharan Language',
    'st': 'Sesotho',
    'su': 'Sundan',
    'suk': 'Sukuma',
    'sus': 'soussou',
    'sux': 'Sumerian',
    'sv': 'svenska',
    'sw': 'Kiswahili',
    'syc': 'Classical Syriac',
    'syr': 'Syriac',
    'ta': '\u0ba4\u0bae\u0bbf\u0bb4\u0bcd',
    'tai': 'Tai Language',
    'te': '\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41',
    'tem': 'Timne',
    'ter': 'Tereno',
    'tet': 't\u00e9tum',
    'tg': '\u062a\u0627\u062c\u06a9',
    'tg_Arab': '\u062a\u0627\u062c\u06a9',
    'tg_Cyrl': '\u0442\u0430\u0434\u0436\u0438\u043a\u0441\u043a' +
        '\u0438\u0439',
    'th': '\u0e44\u0e17\u0e22',
    'ti': '\u1275\u130d\u122d\u129b',
    'tig': '\u1275\u130d\u1228',
    'tiv': 'Tiv',
    'tk': '\u062a\u0631\u06a9\u0645\u0646\u06cc',
    'tkl': 'Tokelau',
    'tl': 'Tagalog',
    'tlh': 'Klingon',
    'tli': 'Tlingit',
    'tmh': 'tamacheq',
    'tn': 'Tswana',
    'to': 'Tonga',
    'tog': 'Nyasa Tonga',
    'tpi': 'Tok Pisin',
    'tr': 'T\u00fcrk\u00e7e',
    'ts': 'Tsonga',
    'tsi': 'Tsimshian',
    'tt': '\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439',
    'tum': 'Tumbuka',
    'tup': 'Tupi Language',
    'tut': '\u0430\u043b\u0442\u0430\u0439\u0441\u043a\u0438' +
        '\u0435 (\u0434\u0440\u0443\u0433\u0438\u0435)',
    'tvl': 'Tuvalu',
    'tw': 'Twi',
    'ty': 'tahitien',
    'tyv': '\u0442\u0443\u0432\u0438\u043d\u0441\u043a\u0438' +
        '\u0439',
    'udm': '\u0443\u0434\u043c\u0443\u0440\u0442\u0441\u043a' +
        '\u0438\u0439',
    'ug': '\u0443\u0439\u0433\u0443\u0440\u0441\u043a\u0438\u0439',
    'uga': 'Ugaritic',
    'uk': '\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a' +
        '\u0430',
    'umb': 'umbundu',
    'und': 'English',
    'ur': '\u0627\u0631\u062f\u0648',
    'uz': '\u040e\u0437\u0431\u0435\u043a',
    'uz_Arab': '\u0627\u06c9\u0632\u0628\u06d0\u06a9',
    'uz_Cyrl': '\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0438' +
        '\u0439',
    'uz_Latn': 'o\'zbekcha',
    'vai': 'Vai',
    've': 'Venda',
    'vi': 'Ti\u1ebfng Vi\u1ec7t',
    'vo': 'volapuko',
    'vot': 'Votic',
    'wa': 'Wallonisch',
    'wak': 'Wakashan Language',
    'wal': 'Walamo',
    'war': 'Waray',
    'was': 'Washo',
    'wen': 'Sorbian Language',
    'wo': 'wolof',
    'wo_Arab': '\u0627\u0644\u0648\u0644\u0648\u0641',
    'wo_Latn': 'wolof',
    'xal': '\u043a\u0430\u043b\u043c\u044b\u0446\u043a\u0438' +
        '\u0439',
    'xh': 'Xhosa',
    'yao': 'iao',
    'yap': 'Yapese',
    'yi': '\u05d9\u05d9\u05d3\u05d9\u05e9',
    'yo': 'Yoruba',
    'ypk': 'Yupik Language',
    'za': 'Zhuang',
    'zap': 'Zapotec',
    'zen': 'Zenaga',
    'zh': '\u4e2d\u6587',
    'zh_Hans': '\u4e2d\u6587',
    'zh_Hant': '\u4e2d\u6587',
    'znd': 'Zande',
    'zu': 'Zulu',
    'zun': 'Zuni',
    'zxx': 'No linguistic content',
    'zza': 'Zaza'
  }
};
/* ~!@# END #@!~ */
