// Copyright 2008 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Default list of locale specific country and language names.
 *
 * Warning: this file is automatically generated from CLDR.
 * File generated from CLDR ver. 27.0.1
 * Please contact i18n team or change the script and regenerate data.
 * Code location: http://go/generate_js_lang_country_constants
 *
 */

/**
 * Namespace for locale specific country and lanugage names
 */

goog.provide('goog.locale.defaultLocaleNameConstants');

/**
 * Default list of locale specific country and language names
 */

goog.locale.defaultLocaleNameConstants = {
  'COUNTRY': {
    '001': 'World',
    '002': 'Africa',
    '003': 'North America',
    '005': 'South America',
    '009': 'Oceania',
    '011': 'Western Africa',
    '013': 'Central America',
    '014': 'Eastern Africa',
    '015': 'Northern Africa',
    '017': 'Middle Africa',
    '018': 'Southern Africa',
    '019': 'Americas',
    '021': 'Northern America',
    '029': 'Caribbean',
    '030': 'Eastern Asia',
    '034': 'Southern Asia',
    '035': 'Southeast Asia',
    '039': 'Southern Europe',
    '053': 'Australasia',
    '054': 'Melanesia',
    '057': 'Micronesian Region',
    '061': 'Polynesia',
    '142': 'Asia',
    '143': 'Central Asia',
    '145': 'Western Asia',
    '150': 'Europe',
    '151': 'Eastern Europe',
    '154': 'Northern Europe',
    '155': 'Western Europe',
    '419': 'Latin America',
    'AC': 'Ascension Island',
    'AD': 'Andorra',
    'AE': 'United Arab Emirates',
    'AF': 'Afghanistan',
    'AG': 'Antigua & Barbuda',
    'AI': 'Anguilla',
    'AL': 'Albania',
    'AM': 'Armenia',
    'AN': 'Netherlands Antilles',
    'AO': 'Angola',
    'AQ': 'Antarctica',
    'AR': 'Argentina',
    'AS': 'American Samoa',
    'AT': 'Austria',
    'AU': 'Australia',
    'AW': 'Aruba',
    'AX': '\u00c5land Islands',
    'AZ': 'Azerbaijan',
    'BA': 'Bosnia & Herzegovina',
    'BB': 'Barbados',
    'BD': 'Bangladesh',
    'BE': 'Belgium',
    'BF': 'Burkina Faso',
    'BG': 'Bulgaria',
    'BH': 'Bahrain',
    'BI': 'Burundi',
    'BJ': 'Benin',
    'BL': 'St. Barth\u00e9lemy',
    'BM': 'Bermuda',
    'BN': 'Brunei',
    'BO': 'Bolivia',
    'BQ': 'Caribbean Netherlands',
    'BR': 'Brazil',
    'BS': 'Bahamas',
    'BT': 'Bhutan',
    'BV': 'Bouvet Island',
    'BW': 'Botswana',
    'BY': 'Belarus',
    'BZ': 'Belize',
    'CA': 'Canada',
    'CC': 'Cocos (Keeling) Islands',
    'CD': 'Congo (DRC)',
    'CF': 'Central African Republic',
    'CG': 'Congo (Republic)',
    'CH': 'Switzerland',
    'CI': 'C\u00f4te d\u2019Ivoire',
    'CK': 'Cook Islands',
    'CL': 'Chile',
    'CM': 'Cameroon',
    'CN': 'China',
    'CO': 'Colombia',
    'CP': 'Clipperton Island',
    'CR': 'Costa Rica',
    'CU': 'Cuba',
    'CV': 'Cape Verde',
    'CW': 'Cura\u00e7ao',
    'CX': 'Christmas Island',
    'CY': 'Cyprus',
    'CZ': 'Czech Republic',
    'DE': 'Germany',
    'DG': 'Diego Garcia',
    'DJ': 'Djibouti',
    'DK': 'Denmark',
    'DM': 'Dominica',
    'DO': 'Dominican Republic',
    'DZ': 'Algeria',
    'EA': 'Ceuta & Melilla',
    'EC': 'Ecuador',
    'EE': 'Estonia',
    'EG': 'Egypt',
    'EH': 'Western Sahara',
    'ER': 'Eritrea',
    'ES': 'Spain',
    'ET': 'Ethiopia',
    'EU': 'European Union',
    'FI': 'Finland',
    'FJ': 'Fiji',
    'FK': 'Falkland Islands (Islas Malvinas)',
    'FM': 'Micronesia',
    'FO': 'Faroe Islands',
    'FR': 'France',
    'GA': 'Gabon',
    'GB': 'United Kingdom',
    'GD': 'Grenada',
    'GE': 'Georgia',
    'GF': 'French Guiana',
    'GG': 'Guernsey',
    'GH': 'Ghana',
    'GI': 'Gibraltar',
    'GL': 'Greenland',
    'GM': 'Gambia',
    'GN': 'Guinea',
    'GP': 'Guadeloupe',
    'GQ': 'Equatorial Guinea',
    'GR': 'Greece',
    'GS': 'South Georgia & South Sandwich Islands',
    'GT': 'Guatemala',
    'GU': 'Guam',
    'GW': 'Guinea-Bissau',
    'GY': 'Guyana',
    'HK': 'Hong Kong',
    'HM': 'Heard & McDonald Islands',
    'HN': 'Honduras',
    'HR': 'Croatia',
    'HT': 'Haiti',
    'HU': 'Hungary',
    'IC': 'Canary Islands',
    'ID': 'Indonesia',
    'IE': 'Ireland',
    'IL': 'Israel',
    'IM': 'Isle of Man',
    'IN': 'India',
    'IO': 'British Indian Ocean Territory',
    'IQ': 'Iraq',
    'IR': 'Iran',
    'IS': 'Iceland',
    'IT': 'Italy',
    'JE': 'Jersey',
    'JM': 'Jamaica',
    'JO': 'Jordan',
    'JP': 'Japan',
    'KE': 'Kenya',
    'KG': 'Kyrgyzstan',
    'KH': 'Cambodia',
    'KI': 'Kiribati',
    'KM': 'Comoros',
    'KN': 'St. Kitts & Nevis',
    'KP': 'North Korea',
    'KR': 'South Korea',
    'KW': 'Kuwait',
    'KY': 'Cayman Islands',
    'KZ': 'Kazakhstan',
    'LA': 'Laos',
    'LB': 'Lebanon',
    'LC': 'St. Lucia',
    'LI': 'Liechtenstein',
    'LK': 'Sri Lanka',
    'LR': 'Liberia',
    'LS': 'Lesotho',
    'LT': 'Lithuania',
    'LU': 'Luxembourg',
    'LV': 'Latvia',
    'LY': 'Libya',
    'MA': 'Morocco',
    'MC': 'Monaco',
    'MD': 'Moldova',
    'ME': 'Montenegro',
    'MF': 'St. Martin',
    'MG': 'Madagascar',
    'MH': 'Marshall Islands',
    'MK': 'Macedonia (FYROM)',
    'ML': 'Mali',
    'MM': 'Myanmar (Burma)',
    'MN': 'Mongolia',
    'MO': 'Macau',
    'MP': 'Northern Mariana Islands',
    'MQ': 'Martinique',
    'MR': 'Mauritania',
    'MS': 'Montserrat',
    'MT': 'Malta',
    'MU': 'Mauritius',
    'MV': 'Maldives',
    'MW': 'Malawi',
    'MX': 'Mexico',
    'MY': 'Malaysia',
    'MZ': 'Mozambique',
    'NA': 'Namibia',
    'NC': 'New Caledonia',
    'NE': 'Niger',
    'NF': 'Norfolk Island',
    'NG': 'Nigeria',
    'NI': 'Nicaragua',
    'NL': 'Netherlands',
    'NO': 'Norway',
    'NP': 'Nepal',
    'NR': 'Nauru',
    'NU': 'Niue',
    'NZ': 'New Zealand',
    'OM': 'Oman',
    'PA': 'Panama',
    'PE': 'Peru',
    'PF': 'French Polynesia',
    'PG': 'Papua New Guinea',
    'PH': 'Philippines',
    'PK': 'Pakistan',
    'PL': 'Poland',
    'PM': 'St. Pierre & Miquelon',
    'PN': 'Pitcairn Islands',
    'PR': 'Puerto Rico',
    'PS': 'Palestine',
    'PT': 'Portugal',
    'PW': 'Palau',
    'PY': 'Paraguay',
    'QA': 'Qatar',
    'QO': 'Outlying Oceania',
    'RE': 'R\u00e9union',
    'RO': 'Romania',
    'RS': 'Serbia',
    'RU': 'Russia',
    'RW': 'Rwanda',
    'SA': 'Saudi Arabia',
    'SB': 'Solomon Islands',
    'SC': 'Seychelles',
    'SD': 'Sudan',
    'SE': 'Sweden',
    'SG': 'Singapore',
    'SH': 'St. Helena',
    'SI': 'Slovenia',
    'SJ': 'Svalbard & Jan Mayen',
    'SK': 'Slovakia',
    'SL': 'Sierra Leone',
    'SM': 'San Marino',
    'SN': 'Senegal',
    'SO': 'Somalia',
    'SR': 'Suriname',
    'SS': 'South Sudan',
    'ST': 'S\u00e3o Tom\u00e9 & Pr\u00edncipe',
    'SV': 'El Salvador',
    'SX': 'Sint Maarten',
    'SY': 'Syria',
    'SZ': 'Swaziland',
    'TA': 'Tristan da Cunha',
    'TC': 'Turks & Caicos Islands',
    'TD': 'Chad',
    'TF': 'French Southern Territories',
    'TG': 'Togo',
    'TH': 'Thailand',
    'TJ': 'Tajikistan',
    'TK': 'Tokelau',
    'TL': 'Timor-Leste',
    'TM': 'Turkmenistan',
    'TN': 'Tunisia',
    'TO': 'Tonga',
    'TR': 'Turkey',
    'TT': 'Trinidad & Tobago',
    'TV': 'Tuvalu',
    'TW': 'Taiwan',
    'TZ': 'Tanzania',
    'UA': 'Ukraine',
    'UG': 'Uganda',
    'UM': 'U.S. Outlying Islands',
    'US': 'United States',
    'UY': 'Uruguay',
    'UZ': 'Uzbekistan',
    'VA': 'Vatican City',
    'VC': 'St. Vincent & Grenadines',
    'VE': 'Venezuela',
    'VG': 'British Virgin Islands',
    'VI': 'U.S. Virgin Islands',
    'VN': 'Vietnam',
    'VU': 'Vanuatu',
    'WF': 'Wallis & Futuna',
    'WS': 'Samoa',
    'XK': 'Kosovo',
    'YE': 'Yemen',
    'YT': 'Mayotte',
    'ZA': 'South Africa',
    'ZM': 'Zambia',
    'ZW': 'Zimbabwe',
    'ZZ': 'Unknown Region'
  },
  'LANGUAGE': {
    'aa': 'Afar',
    'ab': 'Abkhazian',
    'ace': 'Achinese',
    'ach': 'Acoli',
    'ada': 'Adangme',
    'ady': 'Adyghe',
    'ae': 'Avestan',
    'aeb': 'Tunisian Arabic',
    'af': 'Afrikaans',
    'afh': 'Afrihili',
    'agq': 'Aghem',
    'ain': 'Ainu',
    'ak': 'Akan',
    'akk': 'Akkadian',
    'akz': 'Alabama',
    'ale': 'Aleut',
    'aln': 'Gheg Albanian',
    'alt': 'Southern Altai',
    'am': 'Amharic',
    'an': 'Aragonese',
    'ang': 'Old English',
    'anp': 'Angika',
    'ar': 'Arabic',
    'ar_001': 'Modern Standard Arabic',
    'arc': 'Aramaic',
    'arn': 'Mapuche',
    'aro': 'Araona',
    'arp': 'Arapaho',
    'arq': 'Algerian Arabic',
    'arw': 'Arawak',
    'ary': 'Moroccan Arabic',
    'arz': 'Egyptian Arabic',
    'as': 'Assamese',
    'asa': 'Asu',
    'ase': 'American Sign Language',
    'ast': 'Asturian',
    'av': 'Avaric',
    'avk': 'Kotava',
    'awa': 'Awadhi',
    'ay': 'Aymara',
    'az': 'Azerbaijani',
    'azb': 'South Azerbaijani',
    'ba': 'Bashkir',
    'bal': 'Baluchi',
    'ban': 'Balinese',
    'bar': 'Bavarian',
    'bas': 'Basaa',
    'bax': 'Bamun',
    'bbc': 'Batak Toba',
    'bbj': 'Ghomala',
    'be': 'Belarusian',
    'bej': 'Beja',
    'bem': 'Bemba',
    'bew': 'Betawi',
    'bez': 'Bena',
    'bfd': 'Bafut',
    'bfq': 'Badaga',
    'bg': 'Bulgarian',
    'bho': 'Bhojpuri',
    'bi': 'Bislama',
    'bik': 'Bikol',
    'bin': 'Bini',
    'bjn': 'Banjar',
    'bkm': 'Kom',
    'bla': 'Siksika',
    'bm': 'Bambara',
    'bn': 'Bengali',
    'bo': 'Tibetan',
    'bpy': 'Bishnupriya',
    'bqi': 'Bakhtiari',
    'br': 'Breton',
    'bra': 'Braj',
    'brh': 'Brahui',
    'brx': 'Bodo',
    'bs': 'Bosnian',
    'bss': 'Akoose',
    'bua': 'Buriat',
    'bug': 'Buginese',
    'bum': 'Bulu',
    'byn': 'Blin',
    'byv': 'Medumba',
    'ca': 'Catalan',
    'cad': 'Caddo',
    'car': 'Carib',
    'cay': 'Cayuga',
    'cch': 'Atsam',
    'ce': 'Chechen',
    'ceb': 'Cebuano',
    'cgg': 'Chiga',
    'ch': 'Chamorro',
    'chb': 'Chibcha',
    'chg': 'Chagatai',
    'chk': 'Chuukese',
    'chm': 'Mari',
    'chn': 'Chinook Jargon',
    'cho': 'Choctaw',
    'chp': 'Chipewyan',
    'chr': 'Cherokee',
    'chy': 'Cheyenne',
    'ckb': 'Central Kurdish',
    'co': 'Corsican',
    'cop': 'Coptic',
    'cps': 'Capiznon',
    'cr': 'Cree',
    'crh': 'Crimean Turkish',
    'cs': 'Czech',
    'csb': 'Kashubian',
    'cu': 'Church Slavic',
    'cv': 'Chuvash',
    'cy': 'Welsh',
    'da': 'Danish',
    'dak': 'Dakota',
    'dar': 'Dargwa',
    'dav': 'Taita',
    'de': 'German',
    'de_AT': 'Austrian German',
    'de_CH': 'Swiss High German',
    'del': 'Delaware',
    'den': 'Slave',
    'dgr': 'Dogrib',
    'din': 'Dinka',
    'dje': 'Zarma',
    'doi': 'Dogri',
    'dsb': 'Lower Sorbian',
    'dtp': 'Central Dusun',
    'dua': 'Duala',
    'dum': 'Middle Dutch',
    'dv': 'Divehi',
    'dyo': 'Jola-Fonyi',
    'dyu': 'Dyula',
    'dz': 'Dzongkha',
    'dzg': 'Dazaga',
    'ebu': 'Embu',
    'ee': 'Ewe',
    'efi': 'Efik',
    'egl': 'Emilian',
    'egy': 'Ancient Egyptian',
    'eka': 'Ekajuk',
    'el': 'Greek',
    'elx': 'Elamite',
    'en': 'English',
    'en_AU': 'Australian English',
    'en_CA': 'Canadian English',
    'en_GB': 'British English',
    'en_US': 'American English',
    'enm': 'Middle English',
    'eo': 'Esperanto',
    'es': 'Spanish',
    'es_419': 'Latin American Spanish',
    'es_ES': 'European Spanish',
    'es_MX': 'Mexican Spanish',
    'esu': 'Central Yupik',
    'et': 'Estonian',
    'eu': 'Basque',
    'ewo': 'Ewondo',
    'ext': 'Extremaduran',
    'fa': 'Persian',
    'fan': 'Fang',
    'fat': 'Fanti',
    'ff': 'Fulah',
    'fi': 'Finnish',
    'fil': 'Filipino',
    'fit': 'Tornedalen Finnish',
    'fj': 'Fijian',
    'fo': 'Faroese',
    'fon': 'Fon',
    'fr': 'French',
    'fr_CA': 'Canadian French',
    'fr_CH': 'Swiss French',
    'frc': 'Cajun French',
    'frm': 'Middle French',
    'fro': 'Old French',
    'frp': 'Arpitan',
    'frr': 'Northern Frisian',
    'frs': 'Eastern Frisian',
    'fur': 'Friulian',
    'fy': 'Western Frisian',
    'ga': 'Irish',
    'gaa': 'Ga',
    'gag': 'Gagauz',
    'gan': 'Gan Chinese',
    'gay': 'Gayo',
    'gba': 'Gbaya',
    'gbz': 'Zoroastrian Dari',
    'gd': 'Scottish Gaelic',
    'gez': 'Geez',
    'gil': 'Gilbertese',
    'gl': 'Galician',
    'glk': 'Gilaki',
    'gmh': 'Middle High German',
    'gn': 'Guarani',
    'goh': 'Old High German',
    'gom': 'Goan Konkani',
    'gon': 'Gondi',
    'gor': 'Gorontalo',
    'got': 'Gothic',
    'grb': 'Grebo',
    'grc': 'Ancient Greek',
    'gsw': 'Swiss German',
    'gu': 'Gujarati',
    'guc': 'Wayuu',
    'gur': 'Frafra',
    'guz': 'Gusii',
    'gv': 'Manx',
    'gwi': 'Gwich\u02bcin',
    'ha': 'Hausa',
    'hai': 'Haida',
    'hak': 'Hakka Chinese',
    'haw': 'Hawaiian',
    'he': 'Hebrew',
    'hi': 'Hindi',
    'hif': 'Fiji Hindi',
    'hil': 'Hiligaynon',
    'hit': 'Hittite',
    'hmn': 'Hmong',
    'ho': 'Hiri Motu',
    'hr': 'Croatian',
    'hsb': 'Upper Sorbian',
    'hsn': 'Xiang Chinese',
    'ht': 'Haitian',
    'hu': 'Hungarian',
    'hup': 'Hupa',
    'hy': 'Armenian',
    'hz': 'Herero',
    'ia': 'Interlingua',
    'iba': 'Iban',
    'ibb': 'Ibibio',
    'id': 'Indonesian',
    'ie': 'Interlingue',
    'ig': 'Igbo',
    'ii': 'Sichuan Yi',
    'ik': 'Inupiaq',
    'ilo': 'Iloko',
    'in': 'Indonesian',
    'inh': 'Ingush',
    'io': 'Ido',
    'is': 'Icelandic',
    'it': 'Italian',
    'iu': 'Inuktitut',
    'iw': 'Hebrew',
    'izh': 'Ingrian',
    'ja': 'Japanese',
    'jam': 'Jamaican Creole English',
    'jbo': 'Lojban',
    'jgo': 'Ngomba',
    'jmc': 'Machame',
    'jpr': 'Judeo-Persian',
    'jrb': 'Judeo-Arabic',
    'jut': 'Jutish',
    'jv': 'Javanese',
    'ka': 'Georgian',
    'kaa': 'Kara-Kalpak',
    'kab': 'Kabyle',
    'kac': 'Kachin',
    'kaj': 'Jju',
    'kam': 'Kamba',
    'kaw': 'Kawi',
    'kbd': 'Kabardian',
    'kbl': 'Kanembu',
    'kcg': 'Tyap',
    'kde': 'Makonde',
    'kea': 'Kabuverdianu',
    'ken': 'Kenyang',
    'kfo': 'Koro',
    'kg': 'Kongo',
    'kgp': 'Kaingang',
    'kha': 'Khasi',
    'kho': 'Khotanese',
    'khq': 'Koyra Chiini',
    'khw': 'Khowar',
    'ki': 'Kikuyu',
    'kiu': 'Kirmanjki',
    'kj': 'Kuanyama',
    'kk': 'Kazakh',
    'kkj': 'Kako',
    'kl': 'Kalaallisut',
    'kln': 'Kalenjin',
    'km': 'Khmer',
    'kmb': 'Kimbundu',
    'kn': 'Kannada',
    'ko': 'Korean',
    'koi': 'Komi-Permyak',
    'kok': 'Konkani',
    'kos': 'Kosraean',
    'kpe': 'Kpelle',
    'kr': 'Kanuri',
    'krc': 'Karachay-Balkar',
    'kri': 'Krio',
    'krj': 'Kinaray-a',
    'krl': 'Karelian',
    'kru': 'Kurukh',
    'ks': 'Kashmiri',
    'ksb': 'Shambala',
    'ksf': 'Bafia',
    'ksh': 'Colognian',
    'ku': 'Kurdish',
    'kum': 'Kumyk',
    'kut': 'Kutenai',
    'kv': 'Komi',
    'kw': 'Cornish',
    'ky': 'Kyrgyz',
    'la': 'Latin',
    'lad': 'Ladino',
    'lag': 'Langi',
    'lah': 'Lahnda',
    'lam': 'Lamba',
    'lb': 'Luxembourgish',
    'lez': 'Lezghian',
    'lfn': 'Lingua Franca Nova',
    'lg': 'Ganda',
    'li': 'Limburgish',
    'lij': 'Ligurian',
    'liv': 'Livonian',
    'lkt': 'Lakota',
    'lmo': 'Lombard',
    'ln': 'Lingala',
    'lo': 'Lao',
    'lol': 'Mongo',
    'loz': 'Lozi',
    'lt': 'Lithuanian',
    'ltg': 'Latgalian',
    'lu': 'Luba-Katanga',
    'lua': 'Luba-Lulua',
    'lui': 'Luiseno',
    'lun': 'Lunda',
    'luo': 'Luo',
    'lus': 'Mizo',
    'luy': 'Luyia',
    'lv': 'Latvian',
    'lzh': 'Literary Chinese',
    'lzz': 'Laz',
    'mad': 'Madurese',
    'maf': 'Mafa',
    'mag': 'Magahi',
    'mai': 'Maithili',
    'mak': 'Makasar',
    'man': 'Mandingo',
    'mas': 'Masai',
    'mde': 'Maba',
    'mdf': 'Moksha',
    'mdr': 'Mandar',
    'men': 'Mende',
    'mer': 'Meru',
    'mfe': 'Morisyen',
    'mg': 'Malagasy',
    'mga': 'Middle Irish',
    'mgh': 'Makhuwa-Meetto',
    'mgo': 'Meta\u02bc',
    'mh': 'Marshallese',
    'mi': 'Maori',
    'mic': 'Micmac',
    'min': 'Minangkabau',
    'mk': 'Macedonian',
    'ml': 'Malayalam',
    'mn': 'Mongolian',
    'mnc': 'Manchu',
    'mni': 'Manipuri',
    'moh': 'Mohawk',
    'mos': 'Mossi',
    'mr': 'Marathi',
    'mrj': 'Western Mari',
    'ms': 'Malay',
    'mt': 'Maltese',
    'mua': 'Mundang',
    'mul': 'Multiple Languages',
    'mus': 'Creek',
    'mwl': 'Mirandese',
    'mwr': 'Marwari',
    'mwv': 'Mentawai',
    'my': 'Burmese',
    'mye': 'Myene',
    'myv': 'Erzya',
    'mzn': 'Mazanderani',
    'na': 'Nauru',
    'nan': 'Min Nan Chinese',
    'nap': 'Neapolitan',
    'naq': 'Nama',
    'nb': 'Norwegian Bokm\u00e5l',
    'nd': 'North Ndebele',
    'nds': 'Low German',
    'ne': 'Nepali',
    'new': 'Newari',
    'ng': 'Ndonga',
    'nia': 'Nias',
    'niu': 'Niuean',
    'njo': 'Ao Naga',
    'nl': 'Dutch',
    'nl_BE': 'Flemish',
    'nmg': 'Kwasio',
    'nn': 'Norwegian Nynorsk',
    'nnh': 'Ngiemboon',
    'no': 'Norwegian',
    'nog': 'Nogai',
    'non': 'Old Norse',
    'nov': 'Novial',
    'nqo': 'N\u02bcKo',
    'nr': 'South Ndebele',
    'nso': 'Northern Sotho',
    'nus': 'Nuer',
    'nv': 'Navajo',
    'nwc': 'Classical Newari',
    'ny': 'Nyanja',
    'nym': 'Nyamwezi',
    'nyn': 'Nyankole',
    'nyo': 'Nyoro',
    'nzi': 'Nzima',
    'oc': 'Occitan',
    'oj': 'Ojibwa',
    'om': 'Oromo',
    'or': 'Oriya',
    'os': 'Ossetic',
    'osa': 'Osage',
    'ota': 'Ottoman Turkish',
    'pa': 'Punjabi',
    'pag': 'Pangasinan',
    'pal': 'Pahlavi',
    'pam': 'Pampanga',
    'pap': 'Papiamento',
    'pau': 'Palauan',
    'pcd': 'Picard',
    'pdc': 'Pennsylvania German',
    'pdt': 'Plautdietsch',
    'peo': 'Old Persian',
    'pfl': 'Palatine German',
    'phn': 'Phoenician',
    'pi': 'Pali',
    'pl': 'Polish',
    'pms': 'Piedmontese',
    'pnt': 'Pontic',
    'pon': 'Pohnpeian',
    'prg': 'Prussian',
    'pro': 'Old Proven\u00e7al',
    'ps': 'Pashto',
    'pt': 'Portuguese',
    'pt_BR': 'Brazilian Portuguese',
    'pt_PT': 'European Portuguese',
    'qu': 'Quechua',
    'quc': 'K\u02bciche\u02bc',
    'qug': 'Chimborazo Highland Quichua',
    'raj': 'Rajasthani',
    'rap': 'Rapanui',
    'rar': 'Rarotongan',
    'rgn': 'Romagnol',
    'rif': 'Riffian',
    'rm': 'Romansh',
    'rn': 'Rundi',
    'ro': 'Romanian',
    'ro_MD': 'Moldavian',
    'rof': 'Rombo',
    'rom': 'Romany',
    'root': 'Root',
    'rtm': 'Rotuman',
    'ru': 'Russian',
    'rue': 'Rusyn',
    'rug': 'Roviana',
    'rup': 'Aromanian',
    'rw': 'Kinyarwanda',
    'rwk': 'Rwa',
    'sa': 'Sanskrit',
    'sad': 'Sandawe',
    'sah': 'Sakha',
    'sam': 'Samaritan Aramaic',
    'saq': 'Samburu',
    'sas': 'Sasak',
    'sat': 'Santali',
    'saz': 'Saurashtra',
    'sba': 'Ngambay',
    'sbp': 'Sangu',
    'sc': 'Sardinian',
    'scn': 'Sicilian',
    'sco': 'Scots',
    'sd': 'Sindhi',
    'sdc': 'Sassarese Sardinian',
    'se': 'Northern Sami',
    'see': 'Seneca',
    'seh': 'Sena',
    'sei': 'Seri',
    'sel': 'Selkup',
    'ses': 'Koyraboro Senni',
    'sg': 'Sango',
    'sga': 'Old Irish',
    'sgs': 'Samogitian',
    'sh': 'Serbo-Croatian',
    'shi': 'Tachelhit',
    'shn': 'Shan',
    'shu': 'Chadian Arabic',
    'si': 'Sinhala',
    'sid': 'Sidamo',
    'sk': 'Slovak',
    'sl': 'Slovenian',
    'sli': 'Lower Silesian',
    'sly': 'Selayar',
    'sm': 'Samoan',
    'sma': 'Southern Sami',
    'smj': 'Lule Sami',
    'smn': 'Inari Sami',
    'sms': 'Skolt Sami',
    'sn': 'Shona',
    'snk': 'Soninke',
    'so': 'Somali',
    'sog': 'Sogdien',
    'sq': 'Albanian',
    'sr': 'Serbian',
    'srn': 'Sranan Tongo',
    'srr': 'Serer',
    'ss': 'Swati',
    'ssy': 'Saho',
    'st': 'Southern Sotho',
    'stq': 'Saterland Frisian',
    'su': 'Sundanese',
    'suk': 'Sukuma',
    'sus': 'Susu',
    'sux': 'Sumerian',
    'sv': 'Swedish',
    'sw': 'Swahili',
    'swb': 'Comorian',
    'swc': 'Congo Swahili',
    'syc': 'Classical Syriac',
    'syr': 'Syriac',
    'szl': 'Silesian',
    'ta': 'Tamil',
    'tcy': 'Tulu',
    'te': 'Telugu',
    'tem': 'Timne',
    'teo': 'Teso',
    'ter': 'Tereno',
    'tet': 'Tetum',
    'tg': 'Tajik',
    'th': 'Thai',
    'ti': 'Tigrinya',
    'tig': 'Tigre',
    'tiv': 'Tiv',
    'tk': 'Turkmen',
    'tkl': 'Tokelau',
    'tkr': 'Tsakhur',
    'tl': 'Tagalog',
    'tlh': 'Klingon',
    'tli': 'Tlingit',
    'tly': 'Talysh',
    'tmh': 'Tamashek',
    'tn': 'Tswana',
    'to': 'Tongan',
    'tog': 'Nyasa Tonga',
    'tpi': 'Tok Pisin',
    'tr': 'Turkish',
    'tru': 'Turoyo',
    'trv': 'Taroko',
    'ts': 'Tsonga',
    'tsd': 'Tsakonian',
    'tsi': 'Tsimshian',
    'tt': 'Tatar',
    'ttt': 'Muslim Tat',
    'tum': 'Tumbuka',
    'tvl': 'Tuvalu',
    'tw': 'Twi',
    'twq': 'Tasawaq',
    'ty': 'Tahitian',
    'tyv': 'Tuvinian',
    'tzm': 'Central Atlas Tamazight',
    'udm': 'Udmurt',
    'ug': 'Uyghur',
    'uga': 'Ugaritic',
    'uk': 'Ukrainian',
    'umb': 'Umbundu',
    'und': 'Unknown Language',
    'ur': 'Urdu',
    'uz': 'Uzbek',
    'vai': 'Vai',
    've': 'Venda',
    'vec': 'Venetian',
    'vep': 'Veps',
    'vi': 'Vietnamese',
    'vls': 'West Flemish',
    'vmf': 'Main-Franconian',
    'vo': 'Volap\u00fck',
    'vot': 'Votic',
    'vro': 'V\u00f5ro',
    'vun': 'Vunjo',
    'wa': 'Walloon',
    'wae': 'Walser',
    'wal': 'Wolaytta',
    'war': 'Waray',
    'was': 'Washo',
    'wbp': 'Warlpiri',
    'wo': 'Wolof',
    'wuu': 'Wu Chinese',
    'xal': 'Kalmyk',
    'xh': 'Xhosa',
    'xmf': 'Mingrelian',
    'xog': 'Soga',
    'yao': 'Yao',
    'yap': 'Yapese',
    'yav': 'Yangben',
    'ybb': 'Yemba',
    'yi': 'Yiddish',
    'yo': 'Yoruba',
    'yrl': 'Nheengatu',
    'yue': 'Cantonese',
    'za': 'Zhuang',
    'zap': 'Zapotec',
    'zbl': 'Blissymbols',
    'zea': 'Zeelandic',
    'zen': 'Zenaga',
    'zgh': 'Standard Moroccan Tamazight',
    'zh': 'Chinese',
    'zh_Hans': 'Simplified Chinese',
    'zh_Hant': 'Traditional Chinese',
    'zu': 'Zulu',
    'zun': 'Zuni',
    'zxx': 'No linguistic content',
    'zza': 'Zaza'
  }
};
