/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Interner;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.artifacts.dsl.ParsedModuleStringNotation;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.catalog.parser.StrictVersionParser;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class DependencyStringNotationConverter<T>
implements NotationConverter<String, T> {
    private final Instantiator instantiator;
    private final Class<T> wantedType;
    private final Interner<String> stringInterner;
    private final StrictVersionParser strictVersionParser;

    public DependencyStringNotationConverter(Instantiator instantiator, Class<T> wantedType, Interner<String> stringInterner) {
        this.instantiator = instantiator;
        this.wantedType = wantedType;
        this.stringInterner = stringInterner;
        this.strictVersionParser = new StrictVersionParser(stringInterner);
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String or CharSequence values").example("'org.gradle:gradle-core:1.0'");
    }

    public void convert(String notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        result.converted(this.createDependencyFromString(notation));
    }

    private T createDependencyFromString(String notation) {
        ParsedModuleStringNotation parsedNotation = this.splitModuleFromExtension(notation);
        StrictVersionParser.RichVersion version = this.strictVersionParser.parse(parsedNotation.getVersion());
        Object moduleDependency = this.instantiator.newInstance(this.wantedType, new Object[]{this.stringInterner.intern((Object)parsedNotation.getGroup()), this.stringInterner.intern((Object)parsedNotation.getName()), this.stringInterner.intern((Object)version.require)});
        this.maybeEnrichVersion(version, moduleDependency);
        if (moduleDependency instanceof ExternalDependency) {
            ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)moduleDependency, parsedNotation.getArtifactType(), parsedNotation.getClassifier());
        }
        return (T)moduleDependency;
    }

    private void maybeEnrichVersion(StrictVersionParser.RichVersion version, T moduleDependency) {
        if (version.strictly != null) {
            Action versionAction = v -> {
                v.strictly(version.strictly);
                if (!version.prefer.isEmpty()) {
                    v.prefer(version.prefer);
                }
            };
            if (moduleDependency instanceof ExternalDependency) {
                ((ExternalDependency)moduleDependency).version(versionAction);
            }
            if (moduleDependency instanceof DependencyConstraint) {
                ((DependencyConstraint)moduleDependency).version(versionAction);
            }
        }
    }

    private ParsedModuleStringNotation splitModuleFromExtension(String notation) {
        int idx = notation.lastIndexOf(64);
        if (idx == -1 || ClientModule.class.isAssignableFrom(this.wantedType)) {
            return new ParsedModuleStringNotation(notation, null);
        }
        int versionIndx = notation.lastIndexOf(58);
        if (versionIndx < idx) {
            return new ParsedModuleStringNotation(notation.substring(0, idx), notation.substring(idx + 1));
        }
        return new ParsedModuleStringNotation(notation, null);
    }
}

