/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassVersionSwitch {
    static final int[] jVersions = new int[]{0, 196653, 46, 47, 48, 49, 50, 51, 52, 53};

    public static void main(String ... args) throws IOException {
        int version;
        if (args.length < 3) {
            System.out.println("Usage: clz-version-switch version old.jar new.jar");
            System.exit(1);
        }
        if ((version = Integer.parseInt(args[0])) < 1 || version > 9) {
            throw new RuntimeException("version not support yet!");
        }
        File old = new File(args[1]);
        File n = new File(args[2]);
        byte[] buff = new byte[51200];
        final int jVersion = jVersions[version];
        try (ZipFile zip = new ZipFile(old);
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(n));){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                zos.putNextEntry(new ZipEntry(zipEntry.getName()));
                if (!zipEntry.isDirectory()) {
                    try (InputStream is = zip.getInputStream(zipEntry);){
                        if (zipEntry.getName().endsWith(".class")) {
                            ClassReader cr = new ClassReader(is);
                            ClassWriter cw = new ClassWriter(0);
                            ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)cw){

                                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                    super.visit(jVersion, access, name, signature, superName, interfaces);
                                }
                            };
                            cr.accept(cv, 12);
                            zos.write(cw.toByteArray());
                        } else {
                            int c = is.read(buff);
                            while (c > 0) {
                                zos.write(buff, 0, c);
                                c = is.read(buff);
                            }
                        }
                    }
                }
                zos.closeEntry();
            }
        }
    }
}

