/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class IntellitracProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression(".+,").optional().number("(d+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+.?d*),").number("(-?d+.?d*),").number("(d+),").number("(d+),").number("(d+),").number("(d+),?").number("(d+.d+)?,?").number("(d+.d+)?,?").groupBegin().number("d{14},d+,").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").groupEnd("?").any().compile();

    public IntellitracProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        return switch (value) {
            case 164 -> "geofenceEnter";
            case 165 -> "geofenceExit";
            case 168, 169 -> "lowPower";
            case 170 -> "powerOff";
            case 176 -> "powerRestored";
            case 180 -> "fallDown";
            case 225 -> "jamming";
            case 995 -> "sos";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(true);
        position.setLongitude(parser.nextDouble());
        position.setLatitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.setAltitude(parser.nextDouble());
        position.set("sat", parser.nextInt());
        int event = parser.nextInt();
        position.addAlarm(this.decodeAlarm(event));
        position.set("event", event);
        position.set("input", parser.nextInt());
        position.set("output", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("adc2", parser.nextDouble());
        if (parser.hasNext(10)) {
            position.set("obdSpeed", parser.nextInt());
            position.set("rpm", parser.nextInt());
            position.set("coolant", parser.nextInt());
            position.set("fuel", parser.nextInt());
            position.set("fuelConsumption", parser.nextInt());
            position.set("temp1", parser.nextInt());
            position.set("chargerPressure", parser.nextInt());
            position.set("tpl", parser.nextInt());
            position.set("axleWeight", parser.nextInt());
            position.set("obdOdometer", parser.nextInt());
        }
        return position;
    }
}

