/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;

public class ByteArrays {
    private static final ByteArrays INSTANCE = new ByteArrays();
    private Arrays arrays = Arrays.instance();
    Failures failures = Failures.instance();

    public static ByteArrays instance() {
        return INSTANCE;
    }

    ByteArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ByteArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, byte[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, byte[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, byte[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info, byte[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, byte[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info, byte[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info, byte[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertContains(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertContains(AssertionInfo info, byte[] actual, byte value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertContains(AssertionInfo info, byte[] actual, int value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, (byte)value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, byte value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, int value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, (byte)value, index);
    }

    public void assertContainsOnly(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsOnly(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertContainsExactly(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertContainsOnlyOnce(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertContainsSequence(AssertionInfo info, byte[] actual, byte[] sequence2) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence2);
    }

    public void assertContainsSequence(AssertionInfo info, byte[] actual, int[] sequence2) {
        this.arrays.assertContainsSequence(info, this.failures, actual, this.toByteArray(sequence2));
    }

    public void assertContainsSubsequence(AssertionInfo info, byte[] actual, byte[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, byte[] actual, int[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, this.toByteArray(subsequence));
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, int[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, this.toByteArray(values));
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, byte[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, byte[] actual, byte[] sequence2) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence2);
    }

    public void assertStartsWith(AssertionInfo info, byte[] actual, int[] sequence2) {
        this.arrays.assertStartsWith(info, this.failures, actual, this.toByteArray(sequence2));
    }

    public void assertEndsWith(AssertionInfo info, byte[] actual, byte[] sequence2) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence2);
    }

    public void assertEndsWith(AssertionInfo info, byte[] actual, int[] sequence2) {
        this.arrays.assertEndsWith(info, this.failures, actual, this.toByteArray(sequence2));
    }

    public void assertIsSorted(AssertionInfo info, byte[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, byte[] actual, Comparator<? super Byte> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public byte[] toByteArray(int[] ints) {
        if (ints == null) {
            return null;
        }
        byte[] bytes = new byte[ints.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)ints[i2];
        }
        return bytes;
    }

    public void assertContainsAnyOf(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsAnyOf(info, this.failures, actual, values);
    }
}

