/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStatLevel;
import org.opensearch.ml.stats.MLStatsInput;

public class MLStatsNodesRequest
extends BaseNodesRequest<MLStatsNodesRequest> {
    private MLStatsInput mlStatsInput;
    private Set<String> hiddenModelIds = Collections.emptySet();

    public MLStatsNodesRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.mlStatsInput = new MLStatsInput(in);
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.hiddenModelIds = in.readSet(StreamInput::readString);
        }
    }

    public MLStatsNodesRequest(String[] nodeIds, MLStatsInput mlStatsInput) {
        super(nodeIds);
        this.mlStatsInput = mlStatsInput;
    }

    public MLStatsNodesRequest(DiscoveryNode ... nodes) {
        super(nodes);
        this.mlStatsInput = new MLStatsInput();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        this.mlStatsInput.writeTo(out);
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeCollection(this.hiddenModelIds, StreamOutput::writeString);
        }
    }

    public void addNodeLevelStats(Set<MLNodeLevelStat> stats) {
        this.mlStatsInput.getTargetStatLevels().add(MLStatLevel.NODE);
        this.mlStatsInput.getNodeLevelStats().addAll(stats);
    }

    @Generated
    public MLStatsInput getMlStatsInput() {
        return this.mlStatsInput;
    }

    @Generated
    public Set<String> getHiddenModelIds() {
        return this.hiddenModelIds;
    }

    @Generated
    public void setHiddenModelIds(Set<String> hiddenModelIds) {
        this.hiddenModelIds = hiddenModelIds;
    }
}

