/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.action.memorycontainer.memory.FactSearchResult;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;
import org.opensearch.ml.utils.MemorySearchQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class MemorySearchService {
    @Generated
    private static final Logger log = LogManager.getLogger(MemorySearchService.class);
    private final Client client;

    public MemorySearchService(Client client) {
        this.client = client;
    }

    public void searchSimilarFactsForSession(List<String> facts, String sessionId, String indexName, MemoryStorageConfig storageConfig, ActionListener<List<FactSearchResult>> listener) {
        if (sessionId == null || facts.isEmpty()) {
            log.debug("Skipping fact search: facts count={}", (Object)facts.size());
            listener.onResponse(new ArrayList());
            return;
        }
        ArrayList<FactSearchResult> allResults = new ArrayList<FactSearchResult>();
        int maxInferSize = storageConfig != null && storageConfig.getMaxInferSize() != null ? storageConfig.getMaxInferSize() : 5;
        List<String> factsToProcess = facts.size() > maxInferSize ? facts.subList(0, maxInferSize) : facts;
        this.searchFactsSequentially(factsToProcess, 0, sessionId, indexName, storageConfig, maxInferSize, allResults, listener);
    }

    private void searchFactsSequentially(List<String> facts, int currentIndex, String sessionId, String indexName, MemoryStorageConfig storageConfig, int maxInferSize, List<FactSearchResult> allResults, ActionListener<List<FactSearchResult>> listener) {
        if (currentIndex >= facts.size()) {
            listener.onResponse(allResults);
            return;
        }
        String fact = facts.get(currentIndex);
        try {
            XContentBuilder queryBuilder = MemorySearchQueryBuilder.buildFactSearchQuery(fact, sessionId, storageConfig);
            String queryJson = queryBuilder.toString();
            log.debug("Searching for similar facts with query: {}", (Object)queryJson);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryJson));
            searchSourceBuilder.size(maxInferSize);
            searchSourceBuilder.fetchSource(new String[]{"memory"}, null);
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{indexName}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(response -> {
                for (SearchHit hit : response.getHits().getHits()) {
                    Map sourceMap = hit.getSourceAsMap();
                    String memory = (String)sourceMap.get("memory");
                    if (memory == null) continue;
                    allResults.add(new FactSearchResult(hit.getId(), memory, hit.getScore()));
                }
                log.debug("Found {} similar facts for: {}", (Object)response.getHits().getHits().length, (Object)fact);
                this.searchFactsSequentially(facts, currentIndex + 1, sessionId, indexName, storageConfig, maxInferSize, allResults, listener);
            }, e -> {
                log.error("Failed to search for similar facts for: {}", (Object)fact, e);
                this.searchFactsSequentially(facts, currentIndex + 1, sessionId, indexName, storageConfig, maxInferSize, allResults, listener);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to build search query for fact: {}", (Object)fact, (Object)e2);
            this.searchFactsSequentially(facts, currentIndex + 1, sessionId, indexName, storageConfig, maxInferSize, allResults, listener);
        }
    }
}

