/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RolloverResponse
extends AcknowledgedResponseBase
implements ToCopyableBuilder<Builder, RolloverResponse> {
    @Nonnull
    private final Map<String, Boolean> conditions;
    private final boolean dryRun;
    @Nonnull
    private final String newIndex;
    @Nonnull
    private final String oldIndex;
    private final boolean rolledOver;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<RolloverResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverResponse::setupRolloverResponseDeserializer);

    private RolloverResponse(Builder builder) {
        super(builder);
        this.conditions = ApiTypeHelper.unmodifiableRequired(builder.conditions, (Object)this, "conditions");
        this.dryRun = ApiTypeHelper.requireNonNull(builder.dryRun, this, "dryRun");
        this.newIndex = ApiTypeHelper.requireNonNull(builder.newIndex, this, "newIndex");
        this.oldIndex = ApiTypeHelper.requireNonNull(builder.oldIndex, this, "oldIndex");
        this.rolledOver = ApiTypeHelper.requireNonNull(builder.rolledOver, this, "rolledOver");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static RolloverResponse of(Function<Builder, ObjectBuilder<RolloverResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Boolean> conditions() {
        return this.conditions;
    }

    public final boolean dryRun() {
        return this.dryRun;
    }

    @Nonnull
    public final String newIndex() {
        return this.newIndex;
    }

    @Nonnull
    public final String oldIndex() {
        return this.oldIndex;
    }

    public final boolean rolledOver() {
        return this.rolledOver;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("conditions");
        generator.writeStartObject();
        for (Map.Entry<String, Boolean> item0 : this.conditions.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().booleanValue());
        }
        generator.writeEnd();
        generator.writeKey("dry_run");
        generator.write(this.dryRun);
        generator.writeKey("new_index");
        generator.write(this.newIndex);
        generator.writeKey("old_index");
        generator.write(this.oldIndex);
        generator.writeKey("rolled_over");
        generator.write(this.rolledOver);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRolloverResponseDeserializer(ObjectDeserializer<Builder> op) {
        RolloverResponse.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::conditions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "conditions");
        op.add(Builder::dryRun, JsonpDeserializer.booleanDeserializer(), "dry_run");
        op.add(Builder::newIndex, JsonpDeserializer.stringDeserializer(), "new_index");
        op.add(Builder::oldIndex, JsonpDeserializer.stringDeserializer(), "old_index");
        op.add(Builder::rolledOver, JsonpDeserializer.booleanDeserializer(), "rolled_over");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.conditions.hashCode();
        result = 31 * result + Boolean.hashCode(this.dryRun);
        result = 31 * result + this.newIndex.hashCode();
        result = 31 * result + this.oldIndex.hashCode();
        result = 31 * result + Boolean.hashCode(this.rolledOver);
        result = 31 * result + Boolean.hashCode(this.shardsAcknowledged);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloverResponse other = (RolloverResponse)o;
        return this.conditions.equals(other.conditions) && this.dryRun == other.dryRun && this.newIndex.equals(other.newIndex) && this.oldIndex.equals(other.oldIndex) && this.rolledOver == other.rolledOver && this.shardsAcknowledged == other.shardsAcknowledged;
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RolloverResponse> {
        private Map<String, Boolean> conditions;
        private Boolean dryRun;
        private String newIndex;
        private String oldIndex;
        private Boolean rolledOver;
        private Boolean shardsAcknowledged;

        public Builder() {
        }

        private Builder(RolloverResponse o) {
            super(o);
            this.conditions = Builder._mapCopy(o.conditions);
            this.dryRun = o.dryRun;
            this.newIndex = o.newIndex;
            this.oldIndex = o.oldIndex;
            this.rolledOver = o.rolledOver;
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        private Builder(Builder o) {
            super(o);
            this.conditions = Builder._mapCopy(o.conditions);
            this.dryRun = o.dryRun;
            this.newIndex = o.newIndex;
            this.oldIndex = o.oldIndex;
            this.rolledOver = o.rolledOver;
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder conditions(Map<String, Boolean> map) {
            this.conditions = Builder._mapPutAll(this.conditions, map);
            return this;
        }

        @Nonnull
        public final Builder conditions(String key, Boolean value) {
            this.conditions = Builder._mapPut(this.conditions, key, value);
            return this;
        }

        @Nonnull
        public final Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public final Builder newIndex(String value) {
            this.newIndex = value;
            return this;
        }

        @Nonnull
        public final Builder oldIndex(String value) {
            this.oldIndex = value;
            return this;
        }

        @Nonnull
        public final Builder rolledOver(boolean value) {
            this.rolledOver = value;
            return this;
        }

        @Nonnull
        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        @Nonnull
        public RolloverResponse build() {
            this._checkSingleUse();
            return new RolloverResponse(this);
        }
    }
}

