/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.internal.TrailingSignatureAlgorithm;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.cryptography.materialproviders.model.EncryptedDataKey;

public class EncryptionMaterialsHandler {
    EncryptionMaterials materials;
    software.amazon.cryptography.materialproviders.model.EncryptionMaterials mplMaterials;

    public EncryptionMaterialsHandler(EncryptionMaterials materials) {
        this.materials = materials;
    }

    public EncryptionMaterialsHandler(software.amazon.cryptography.materialproviders.model.EncryptionMaterials mplMaterials) {
        this.mplMaterials = mplMaterials;
    }

    public CryptoAlgorithm getAlgorithm() {
        if (this.materials != null) {
            return this.materials.getAlgorithm();
        }
        return CryptoAlgorithm.valueOf(this.mplMaterials.algorithmSuite().id().ESDK().name());
    }

    public Map<String, String> getEncryptionContext() {
        if (this.materials != null) {
            return this.materials.getEncryptionContext();
        }
        return this.mplMaterials.encryptionContext();
    }

    public List<KeyBlob> getEncryptedDataKeys() {
        if (this.materials != null) {
            return this.materials.getEncryptedDataKeys();
        }
        List edks = this.mplMaterials.encryptedDataKeys();
        ArrayList<KeyBlob> keyBlobs = new ArrayList<KeyBlob>(edks.size());
        for (EncryptedDataKey edk : edks) {
            keyBlobs.add(new KeyBlob(edk.keyProviderId(), edk.keyProviderInfo().array(), edk.ciphertext().array()));
        }
        return keyBlobs;
    }

    public SecretKey getCleartextDataKey() {
        if (this.materials != null) {
            return this.materials.getCleartextDataKey();
        }
        byte[] cacheDataKey = this.mplMaterials.plaintextDataKey().array();
        CryptoAlgorithm cryptoAlgorithm = CryptoAlgorithm.valueOf(this.mplMaterials.algorithmSuite().id().ESDK().name());
        return new SecretKeySpec(cacheDataKey, 0, cacheDataKey.length, cryptoAlgorithm.getDataKeyAlgo());
    }

    public PrivateKey getTrailingSignatureKey() {
        if (this.materials != null) {
            return this.materials.getTrailingSignatureKey();
        }
        if (this.mplMaterials.signingKey() == null) {
            return null;
        }
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(this.mplMaterials.algorithmSuite()).privateKeyFromByteBuffer(this.mplMaterials.signingKey());
    }

    public List<String> getRequiredEncryptionContextKeys() {
        if (this.materials != null) {
            return Collections.emptyList();
        }
        return this.mplMaterials.requiredEncryptionContextKeys();
    }

    public List<MasterKey> getMasterKeys() {
        if (this.materials != null) {
            return this.materials.getMasterKeys();
        }
        return Collections.emptyList();
    }
}

