/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class VersionInfo {
    public static final String USER_AGENT_PREFIX = "AwsCrypto/";
    public static final String UNKNOWN_VERSION = "unknown";

    public static String loadUserAgent() {
        return USER_AGENT_PREFIX + VersionInfo.versionNumber();
    }

    public static String apiName() {
        return USER_AGENT_PREFIX.substring(0, USER_AGENT_PREFIX.length() - 1);
    }

    public static String versionNumber() {
        try {
            String maybeVersion;
            Properties properties = new Properties();
            ClassLoader loader = VersionInfo.class.getClassLoader();
            Enumeration<URL> urls = loader.getResources("project.properties");
            if (urls == null) {
                return UNKNOWN_VERSION;
            }
            while (urls.hasMoreElements()) {
                URL thisURL = urls.nextElement();
                if (!thisURL.getPath().contains("aws-encryption-sdk-java")) continue;
                properties.load(thisURL.openStream());
                break;
            }
            if ((maybeVersion = properties.getProperty("esdkVersion")) == null) {
                return UNKNOWN_VERSION;
            }
            return maybeVersion;
        }
        catch (IOException ex) {
            return UNKNOWN_VERSION;
        }
    }
}

