/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.List;
import java.util.stream.Collectors;

public class CollectionOfErrors
extends RuntimeException {
    private final List<RuntimeException> list;

    protected CollectionOfErrors(BuilderImpl builder) {
        super(CollectionOfErrors.messageFromBuilder(builder), builder.cause());
        this.list = builder.list();
    }

    private static String messageFromBuilder(Builder builder) {
        if (builder.message() != null) {
            return builder.message();
        }
        if (builder.cause() != null) {
            return builder.cause().getMessage();
        }
        return null;
    }

    public String message() {
        return this.getMessage();
    }

    public Throwable cause() {
        return this.getCause();
    }

    public List<RuntimeException> list() {
        return this.list;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String message;
        protected Throwable cause;
        protected List<RuntimeException> list;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CollectionOfErrors model) {
            this.cause = model.getCause();
            this.message = model.getMessage();
            this.list = model.list();
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public Throwable cause() {
            return this.cause;
        }

        @Override
        public Builder list(List<RuntimeException> list) {
            this.list = list;
            return this;
        }

        @Override
        public List<RuntimeException> list() {
            return this.list;
        }

        @Override
        public CollectionOfErrors build() {
            if (this.list != null && !this.list.isEmpty()) {
                this.message = this.message + " String representation of Exceptions in list.\n" + this.list.stream().map(ex -> ex.getClass().getSimpleName() + ": " + ex.getMessage()).collect(Collectors.joining("\n"));
            }
            return new CollectionOfErrors(this);
        }
    }

    public static interface Builder {
        public Builder message(String var1);

        public String message();

        public Builder cause(Throwable var1);

        public Throwable cause();

        public Builder list(List<RuntimeException> var1);

        public List<RuntimeException> list();

        public CollectionOfErrors build();
    }
}

