/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.data.columnar.extractors.SimpleFieldExtractor;

public class DoubleExtractor
extends SimpleFieldExtractor<Double> {
    private static final Logger logger = Logger.getLogger(DoubleExtractor.class.getName());

    public DoubleExtractor(String fieldName) {
        super(fieldName);
    }

    public DoubleExtractor(String fieldName, String metadataName) {
        super(fieldName, metadataName);
    }

    private DoubleExtractor() {
    }

    @Override
    public Class<Double> getValueType() {
        return Double.class;
    }

    @Override
    protected Optional<Double> extractField(String value) {
        try {
            double f = Double.parseDouble(value);
            return Optional.of(f);
        }
        catch (NumberFormatException e) {
            logger.warning("Failed to parse value for field " + this.fieldName + ", expected a double, got " + value);
            return Optional.empty();
        }
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldExtractor");
    }
}

