/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.jobscheduler;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.securityanalytics.threatIntel.action.ThreatIntelIndicesResponse;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.TIFJobParameter;
import org.opensearch.securityanalytics.threatIntel.service.DetectorThreatIntelService;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobParameterService;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobUpdateService;
import org.opensearch.threadpool.ThreadPool;

public class TIFJobRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(TIFJobRunner.class);
    private static TIFJobRunner INSTANCE;
    private ClusterService clusterService;
    private TIFJobUpdateService jobSchedulerUpdateService;
    private TIFJobParameterService jobSchedulerParameterService;
    private TIFLockService lockService;
    private boolean initialized;
    private ThreadPool threadPool;
    private DetectorThreatIntelService detectorThreatIntelService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIFJobRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<TIFJobRunner> clazz = TIFJobRunner.class;
        synchronized (TIFJobRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new TIFJobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    private TIFJobRunner() {
    }

    public void initialize(ClusterService clusterService, TIFJobUpdateService jobSchedulerUpdateService, TIFJobParameterService jobSchedulerParameterService, TIFLockService threatIntelLockService, ThreadPool threadPool, DetectorThreatIntelService detectorThreatIntelService) {
        this.clusterService = clusterService;
        this.jobSchedulerUpdateService = jobSchedulerUpdateService;
        this.jobSchedulerParameterService = jobSchedulerParameterService;
        this.lockService = threatIntelLockService;
        this.threadPool = threadPool;
        this.initialized = true;
        this.detectorThreatIntelService = detectorThreatIntelService;
    }

    public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
        if (!this.initialized) {
            throw new AssertionError((Object)"This instance is not initialized");
        }
        log.info("Update job started for a job parameter[{}]", (Object)jobParameter.getName());
        if (!(jobParameter instanceof TIFJobParameter)) {
            log.error("Illegal state exception: job parameter is not instance of Job Scheduler Parameter");
            throw new IllegalStateException("job parameter is not instance of Job Scheduler Parameter, type: " + jobParameter.getClass().getCanonicalName());
        }
        this.threadPool.generic().submit(this.updateJobRunner(jobParameter));
    }

    protected Runnable updateJobRunner(ScheduledJobParameter jobParameter) {
        return () -> this.lockService.acquireLock(jobParameter.getName(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> this.updateJobParameter(jobParameter, this.lockService.getRenewLockRunnable(new AtomicReference<LockModel>((LockModel)lock)), (ActionListener<Void>)ActionListener.wrap(r -> this.lockService.releaseLock((LockModel)lock, (ActionListener<Boolean>)ActionListener.wrap(response -> log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId()), ex -> log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), jobParameter.getName()), (Throwable)ex))), e -> {
            log.error("Failed to update job parameter " + jobParameter.getName(), (Throwable)e);
            this.lockService.releaseLock((LockModel)lock, (ActionListener<Boolean>)ActionListener.wrap(response -> log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId()), ex -> log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), jobParameter.getName()), (Throwable)ex)));
        })), e -> log.error("Failed to update. Another processor is holding a lock for job parameter[{}]", (Object)jobParameter.getName())));
    }

    protected void updateJobParameter(ScheduledJobParameter jobParameter, Runnable renewLock, ActionListener<Void> listener) {
        this.jobSchedulerParameterService.getJobParameter(jobParameter.getName(), (ActionListener<TIFJobParameter>)ActionListener.wrap(jobSchedulerParameter -> {
            if (jobSchedulerParameter == null) {
                log.info("Job parameter[{}] does not exist", (Object)jobParameter.getName());
                return;
            }
            if (!TIFJobState.AVAILABLE.equals((Object)jobSchedulerParameter.getState())) {
                log.error("Invalid jobSchedulerParameter state. Expecting {} but received {}", (Object)TIFJobState.AVAILABLE, (Object)jobSchedulerParameter.getState());
                jobSchedulerParameter.disable();
                jobSchedulerParameter.getUpdateStats().setLastFailedAt(Instant.now());
                this.jobSchedulerParameterService.updateJobSchedulerParameter((TIFJobParameter)jobSchedulerParameter, (ActionListener<ThreatIntelIndicesResponse>)ActionListener.wrap(r -> {}, e -> log.error("Failed to update job scheduler parameter in Threat intel feed update job")));
            }
            final ArrayList<String> oldIndices = new ArrayList<String>(jobSchedulerParameter.getIndices());
            this.jobSchedulerUpdateService.createThreatIntelFeedData((TIFJobParameter)jobSchedulerParameter, renewLock, new ActionListener<ThreatIntelIndicesResponse>(this){
                final /* synthetic */ TIFJobRunner this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(ThreatIntelIndicesResponse response) {
                    if (response.isAcknowledged().booleanValue()) {
                        List<String> newFeedIndices = response.getIndices();
                        this.this$0.jobSchedulerUpdateService.deleteAllTifdIndices(oldIndices, newFeedIndices);
                        if (!newFeedIndices.isEmpty()) {
                            this.this$0.detectorThreatIntelService.updateDetectorsWithLatestThreatIntelRules();
                        }
                    } else {
                        log.error("Failed to update jobSchedulerParameter for {}", (Object)jobSchedulerParameter.getName());
                        jobSchedulerParameter.getUpdateStats().setLastFailedAt(Instant.now());
                        this.this$0.jobSchedulerParameterService.updateJobSchedulerParameter(jobSchedulerParameter, (ActionListener<ThreatIntelIndicesResponse>)ActionListener.wrap(r -> {}, e -> log.error("Failed to update job scheduler parameter in Threat intel feed update job")));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Failed to update jobSchedulerParameter for {}", (Object)jobSchedulerParameter.getName(), (Object)e);
                    jobSchedulerParameter.getUpdateStats().setLastFailedAt(Instant.now());
                    this.this$0.jobSchedulerParameterService.updateJobSchedulerParameter(jobSchedulerParameter, (ActionListener<ThreatIntelIndicesResponse>)ActionListener.wrap(r -> {}, ex -> log.error("Failed to update job scheduler parameter in Threat intel feed update job")));
                }
            });
            listener.onResponse(null);
        }, e -> listener.onFailure(e)));
    }
}

