/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.transport;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.ModulesBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.lang.PPLLangSpec;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.plugin.config.OpenSearchPluginModule;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.ppl.PPLService;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.CsvResponseFormatter;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.RawResponseFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;
import org.opensearch.sql.protocol.response.format.SimpleJsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.VisualizationResponseFormatter;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class TransportPPLQueryAction
extends HandledTransportAction<ActionRequest, TransportPPLQueryResponse> {
    private final Injector injector;
    private final Supplier<Boolean> pplEnabled;

    @Inject
    public TransportPPLQueryAction(TransportService transportService, ActionFilters actionFilters, NodeClient client, ClusterService clusterService, DataSourceServiceImpl dataSourceService, Settings clusterSettings) {
        super("cluster:admin/opensearch/ppl", transportService, actionFilters, TransportPPLQueryRequest::new);
        ModulesBuilder modules = new ModulesBuilder();
        modules.add(new Module[]{new OpenSearchPluginModule()});
        modules.add(new Module[]{b -> {
            b.bind(NodeClient.class).toInstance((Object)client);
            b.bind(org.opensearch.sql.common.setting.Settings.class).toInstance((Object)new OpenSearchSettings(clusterService.getClusterSettings()));
            b.bind(DataSourceService.class).toInstance((Object)dataSourceService);
        }});
        this.injector = modules.createInjector();
        this.pplEnabled = () -> (Boolean)BaseRestHandler.MULTI_ALLOW_EXPLICIT_INDEX.get(clusterSettings) != false && (Boolean)((org.opensearch.sql.common.setting.Settings)this.injector.getInstance(org.opensearch.sql.common.setting.Settings.class)).getSettingValue(Settings.Key.PPL_ENABLED) != false;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<TransportPPLQueryResponse> listener) {
        if (!this.pplEnabled.get().booleanValue()) {
            listener.onFailure((Exception)new IllegalAccessException("Either plugins.ppl.enabled or rest.action.multi.allow_explicit_index setting is false"));
            return;
        }
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_COUNT_TOTAL).increment();
        QueryContext.addRequestId();
        PPLService pplService = SecurityAccess.doPrivileged(() -> (PPLService)this.injector.getInstance(PPLService.class));
        TransportPPLQueryRequest transportRequest = TransportPPLQueryRequest.fromActionRequest(request);
        PPLQueryRequest transformedRequest = transportRequest.toPPLQueryRequest();
        if (transformedRequest.isExplainRequest()) {
            pplService.explain(transformedRequest, this.createExplainResponseListener(listener));
        } else {
            pplService.execute(transformedRequest, this.createListener(transformedRequest, listener), this.createExplainResponseListener(listener));
        }
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final ActionListener<TransportPPLQueryResponse> listener) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            @Override
            public void onResponse(ExecutionEngine.ExplainResponse response) {
                String responseContent = new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(this, JsonResponseFormatter.Style.PRETTY){

                    @Override
                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                }.format(response);
                listener.onResponse((Object)new TransportPPLQueryResponse(responseContent));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createListener(PPLQueryRequest pplRequest, final ActionListener<TransportPPLQueryResponse> listener) {
        Format format = this.format(pplRequest);
        final ResponseFormatter<QueryResult> formatter = format.equals((Object)Format.CSV) ? new CsvResponseFormatter(pplRequest.sanitize()) : (format.equals((Object)Format.RAW) ? new RawResponseFormatter() : (format.equals((Object)Format.VIZ) ? new VisualizationResponseFormatter(pplRequest.style()) : new SimpleJsonResponseFormatter(JsonResponseFormatter.Style.PRETTY)));
        return new ResponseListener<ExecutionEngine.QueryResponse>(){

            @Override
            public void onResponse(ExecutionEngine.QueryResponse response) {
                String responseContent = formatter.format(new QueryResult(response.getSchema(), response.getResults(), response.getCursor(), PPLLangSpec.PPL_SPEC));
                listener.onResponse((Object)new TransportPPLQueryResponse(responseContent));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private Format format(PPLQueryRequest pplRequest) {
        String format = pplRequest.getFormat();
        Optional<Format> optionalFormat = Format.of(format);
        if (optionalFormat.isPresent()) {
            return optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", format));
    }
}

