/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query;

import org.opensearch.action.ActionType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.sql.legacy.domain.Delete;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.SqlElasticDeleteByQueryRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

public class DeleteQueryAction
extends QueryAction {
    private final Delete delete;
    private DeleteByQueryRequestBuilder request;

    public DeleteQueryAction(Client client, Delete delete) {
        super(client, delete);
        this.delete = delete;
    }

    @Override
    public SqlElasticDeleteByQueryRequestBuilder explain() throws SqlParseException {
        this.request = new DeleteByQueryRequestBuilder((OpenSearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE);
        this.setIndicesAndTypes();
        this.setWhere(this.delete.getWhere());
        SqlElasticDeleteByQueryRequestBuilder deleteByQueryRequestBuilder = new SqlElasticDeleteByQueryRequestBuilder(this.request);
        return deleteByQueryRequestBuilder;
    }

    private void setIndicesAndTypes() {
        DeleteByQueryRequest innerRequest = (DeleteByQueryRequest)this.request.request();
        innerRequest.indices(this.query.getIndexArr());
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder whereQuery = QueryMaker.explain(where);
            this.request.filter((QueryBuilder)whereQuery);
        } else {
            this.request.filter((QueryBuilder)QueryBuilders.matchAllQuery());
        }
    }
}

