/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.model;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class DataSourceType {
    public static final DataSourceType PROMETHEUS = new DataSourceType("PROMETHEUS");
    public static final DataSourceType OPENSEARCH = new DataSourceType("OPENSEARCH");
    public static final DataSourceType S3GLUE = new DataSourceType("S3GLUE");
    public static final DataSourceType SECURITY_LAKE = new DataSourceType("SECURITY_LAKE");
    private static final Map<String, DataSourceType> knownValues = new HashMap<String, DataSourceType>();
    private final String name;

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static void register(DataSourceType ... dataSourceTypes) {
        for (DataSourceType type : dataSourceTypes) {
            String upperCaseName = type.name().toUpperCase();
            if (knownValues.containsKey(upperCaseName)) {
                throw new IllegalArgumentException("DataSourceType with name " + type.name() + " already exists");
            }
            knownValues.put(type.name().toUpperCase(), type);
        }
    }

    public static DataSourceType fromString(String name) {
        String upperCaseName = name.toUpperCase();
        if (knownValues.containsKey(upperCaseName)) {
            return knownValues.get(upperCaseName);
        }
        throw new IllegalArgumentException("No DataSourceType with name " + name + " found");
    }

    @Generated
    public DataSourceType(String name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceType)) {
            return false;
        }
        DataSourceType other = (DataSourceType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    static {
        DataSourceType.register(PROMETHEUS, OPENSEARCH, S3GLUE, SECURITY_LAKE);
    }
}

