/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning.neuralnet;

import ciir.umass.edu.learning.neuralnet.LogiFunction;
import ciir.umass.edu.learning.neuralnet.PropParameter;
import ciir.umass.edu.learning.neuralnet.Synapse;
import ciir.umass.edu.learning.neuralnet.TransferFunction;
import java.util.ArrayList;
import java.util.List;

public class Neuron {
    public static double momentum = 0.9;
    public static double learningRate = 0.001;
    protected TransferFunction tfunc = new LogiFunction();
    protected double output = 0.0;
    protected List<Double> outputs = null;
    protected double delta_i = 0.0;
    protected double[] deltas_j = null;
    protected List<Synapse> inLinks = new ArrayList<Synapse>();
    protected List<Synapse> outLinks = new ArrayList<Synapse>();

    public Neuron() {
        this.outputs = new ArrayList<Double>();
    }

    public double getOutput() {
        return this.output;
    }

    public double getOutput(int k) {
        return this.outputs.get(k);
    }

    public List<Synapse> getInLinks() {
        return this.inLinks;
    }

    public List<Synapse> getOutLinks() {
        return this.outLinks;
    }

    public void setOutput(double output) {
        this.output = output;
    }

    public void addOutput(double output) {
        this.outputs.add(output);
    }

    public void computeOutput() {
        Synapse s = null;
        double wsum = 0.0;
        for (int j = 0; j < this.inLinks.size(); ++j) {
            s = this.inLinks.get(j);
            wsum += s.getSource().getOutput() * s.getWeight();
        }
        this.output = this.tfunc.compute(wsum);
    }

    public void computeOutput(int i) {
        Synapse s = null;
        double wsum = 0.0;
        for (int j = 0; j < this.inLinks.size(); ++j) {
            s = this.inLinks.get(j);
            wsum += s.getSource().getOutput(i) * s.getWeight();
        }
        this.output = this.tfunc.compute(wsum);
        this.outputs.add(this.output);
    }

    public void clearOutputs() {
        this.outputs.clear();
    }

    public void computeDelta(PropParameter param) {
        int[][] pairMap = param.pairMap;
        int current = param.current;
        this.delta_i = 0.0;
        this.deltas_j = new double[pairMap[current].length];
        for (int k = 0; k < pairMap[current].length; ++k) {
            int j = pairMap[current][k];
            float weight = 1.0f;
            double pij = 0.0;
            if (param.pairWeight == null) {
                weight = 1.0f;
                pij = 1.0 / (1.0 + Math.exp(this.outputs.get(current) - this.outputs.get(j)));
            } else {
                weight = param.pairWeight[current][k];
                pij = (double)param.targetValue[current][k] - 1.0 / (1.0 + Math.exp(-(this.outputs.get(current) - this.outputs.get(j))));
            }
            double lambda = (double)weight * pij;
            this.delta_i += lambda;
            this.deltas_j[k] = lambda * this.tfunc.computeDerivative(this.outputs.get(j));
        }
        this.delta_i *= this.tfunc.computeDerivative(this.outputs.get(current));
    }

    public void updateDelta(PropParameter param) {
        int[][] pairMap = param.pairMap;
        float[][] pairWeight = param.pairWeight;
        int current = param.current;
        this.delta_i = 0.0;
        this.deltas_j = new double[pairMap[current].length];
        for (int k = 0; k < pairMap[current].length; ++k) {
            int j = pairMap[current][k];
            float weight = pairWeight != null ? pairWeight[current][k] : 1.0f;
            double errorSum = 0.0;
            for (int l = 0; l < this.outLinks.size(); ++l) {
                Synapse s = this.outLinks.get(l);
                errorSum += s.getTarget().deltas_j[k] * s.weight;
                if (k != 0) continue;
                this.delta_i += s.getTarget().delta_i * s.weight;
            }
            if (k == 0) {
                this.delta_i *= (double)weight * this.tfunc.computeDerivative(this.outputs.get(current));
            }
            this.deltas_j[k] = errorSum * (double)weight * this.tfunc.computeDerivative(this.outputs.get(j));
        }
    }

    public void updateWeight(PropParameter param) {
        Synapse s = null;
        for (int k = 0; k < this.inLinks.size(); ++k) {
            s = this.inLinks.get(k);
            double sum_j = 0.0;
            for (int l = 0; l < this.deltas_j.length; ++l) {
                sum_j += this.deltas_j[l] * s.getSource().getOutput(param.pairMap[param.current][l]);
            }
            double dw = learningRate * (this.delta_i * s.getSource().getOutput(param.current) - sum_j);
            s.setWeightAdjustment(dw);
            s.updateWeight();
        }
    }
}

