/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.features;

import ciir.umass.edu.features.Normalizer;
import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.RankList;
import java.util.Arrays;

public class ZScoreNormalizor
extends Normalizer {
    @Override
    public void normalize(RankList rl) {
        if (rl.size() == 0) {
            System.out.println("Error in ZScoreNormalizor::normalize(): The input ranked list is empty");
            System.exit(1);
        }
        int nFeature = DataPoint.getFeatureCount();
        double[] means = new double[nFeature];
        Arrays.fill(means, 0.0);
        for (int i = 0; i < rl.size(); ++i) {
            DataPoint dp = rl.get(i);
            for (int j = 1; j <= nFeature; ++j) {
                int n = j - 1;
                means[n] = means[n] + (double)dp.getFeatureValue(j);
            }
        }
        for (int j = 1; j <= nFeature; ++j) {
            double x;
            DataPoint p;
            int i;
            means[j - 1] = means[j - 1] / (double)rl.size();
            double std = 0.0;
            for (i = 0; i < rl.size(); ++i) {
                p = rl.get(i);
                x = (double)p.getFeatureValue(j) - means[j - 1];
                std += x * x;
            }
            if (!((std = Math.sqrt(std / (double)(rl.size() - 1))) > 0.0)) continue;
            for (i = 0; i < rl.size(); ++i) {
                p = rl.get(i);
                x = ((double)p.getFeatureValue(j) - means[j - 1]) / std;
                p.setFeatureValue(j, (float)x);
            }
        }
    }

    @Override
    public void normalize(RankList rl, int[] fids) {
        if (rl.size() == 0) {
            System.out.println("Error in ZScoreNormalizor::normalize(): The input ranked list is empty");
            System.exit(1);
        }
        fids = this.removeDuplicateFeatures(fids);
        double[] means = new double[fids.length];
        Arrays.fill(means, 0.0);
        for (int i = 0; i < rl.size(); ++i) {
            DataPoint dp = rl.get(i);
            for (int j = 0; j < fids.length; ++j) {
                int n = j;
                means[n] = means[n] + (double)dp.getFeatureValue(fids[j]);
            }
        }
        for (int j = 0; j < fids.length; ++j) {
            double x;
            DataPoint p;
            int i;
            means[j] = means[j] / (double)rl.size();
            double std = 0.0;
            for (i = 0; i < rl.size(); ++i) {
                p = rl.get(i);
                x = (double)p.getFeatureValue(fids[j]) - means[j];
                std += x * x;
            }
            if (!((std = Math.sqrt(std / (double)(rl.size() - 1))) > 0.0)) continue;
            for (i = 0; i < rl.size(); ++i) {
                p = rl.get(i);
                x = ((double)p.getFeatureValue(fids[j]) - means[j]) / std;
                p.setFeatureValue(fids[j], (float)x);
            }
        }
    }

    @Override
    public String name() {
        return "zscore";
    }
}

