/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class AccumulatorContext$
implements Logging {
    public static final AccumulatorContext$ MODULE$ = new AccumulatorContext$();
    private static final ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals;
    private static final AtomicLong nextId;
    private static final Some<Object> someOfMinusOne;
    private static final Some<Object> someOfZero;
    private static final String SQL_ACCUM_IDENTIFIER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        originals = new ConcurrentHashMap();
        nextId = new AtomicLong(0L);
        someOfMinusOne = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
        someOfZero = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        SQL_ACCUM_IDENTIFIER = "sql";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals() {
        return originals;
    }

    public long newId() {
        return nextId.getAndIncrement();
    }

    public int numAccums() {
        return this.originals().size();
    }

    public void register(AccumulatorV2<?, ?> a) {
        this.originals().putIfAbsent(BoxesRunTime.boxToLong((long)a.id()), new WeakReference(a));
    }

    public void remove(long id) {
        this.originals().remove(BoxesRunTime.boxToLong((long)id));
    }

    public Option<AccumulatorV2<?, ?>> get(long id) {
        None$ none$;
        WeakReference<AccumulatorV2<?, ?>> ref = this.originals().get(BoxesRunTime.boxToLong((long)id));
        if (ref == null) {
            none$ = None$.MODULE$;
        } else {
            AccumulatorV2 acc = (AccumulatorV2)ref.get();
            if (acc == null) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Attempted to access garbage collected accumulator ").append(id).toString());
            }
            none$ = Option$.MODULE$.apply((Object)acc);
        }
        return none$;
    }

    public void clear() {
        this.originals().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> internOption(Option<Object> value) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = value;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)0L), (Object)object)) {
                return someOfZero;
            }
        }
        if (!bl) return value;
        Object object = some.value();
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)object)) return value;
        return someOfMinusOne;
    }

    public String SQL_ACCUM_IDENTIFIER() {
        return SQL_ACCUM_IDENTIFIER;
    }

    private AccumulatorContext$() {
    }
}

