/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.model.SearchParams;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.searchrelevance.transport.experiment.GetExperimentAction;
import org.opensearch.searchrelevance.utils.ParserUtils;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetExperimentAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestGetExperimentAction.class);
    private static final String GET_EXPERIMENT_ACTION = "get_experiment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return GET_EXPERIMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_search_relevance/experiments", "id")), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/experiments"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        String experimentId = request.param("id");
        String queryText = request.param("query_text");
        if (experimentId != null && !experimentId.isEmpty()) {
            OpenSearchDocRequest getRequest = new OpenSearchDocRequest(experimentId);
            return this.executeGetRequest(client, getRequest);
        }
        SearchParams searchParams = ParserUtils.parseSearchParams(request);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(searchParams.getSize()).sort(searchParams.getSortField(), searchParams.getSortOrder());
        OpenSearchDocRequest getRequest = new OpenSearchDocRequest(searchSourceBuilder);
        return this.executeGetRequest(client, getRequest);
    }

    private BaseRestHandler.RestChannelConsumer executeGetRequest(NodeClient client, OpenSearchDocRequest request) {
        return channel -> client.execute((ActionType)GetExperimentAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<SearchResponse>(){
            final /* synthetic */ RestGetExperimentAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    RestStatus status = response.status();
                    channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (IOException ex) {
                    this.this$0.logger.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestGetExperimentAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

