/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;

public abstract class AbstractUpdatePipelineStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(AbstractUpdatePipelineStep.class);
    private final ClusterAdminClient clusterAdminClient;

    protected AbstractUpdatePipelineStep(Client client) {
        this.clusterAdminClient = client.admin().cluster();
    }

    public abstract void executePutPipelineRequest(String var1, BytesReference var2, ClusterAdminClient var3, ActionListener<AcknowledgedResponse> var4);

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        final PlainActionFuture createPipelineFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("pipeline_id", "configurations");
        Set<String> optionalKeys = Set.of("model_id");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            final String pipelineId = (String)inputs.get("pipeline_id");
            String configurations = (String)inputs.get("configurations");
            String transformedJsonStringForStringArray = ParseUtils.removingBackslashesAndQuotesInArrayInJsonString(configurations);
            byte[] byteArr = transformedJsonStringForStringArray.getBytes(StandardCharsets.UTF_8);
            BytesArray configurationsBytes = new BytesArray(byteArr);
            final String pipelineToBeCreated = this.getName();
            ActionListener<AcknowledgedResponse> putPipelineActionListener = new ActionListener<AcknowledgedResponse>(this){
                final /* synthetic */ AbstractUpdatePipelineStep this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.this$0.getName());
                    logger.info("Successfully updated resource: {}", (Object)pipelineId);
                    createPipelineFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, pipelineId), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                }

                public void onFailure(Exception ex) {
                    Exception e = WorkflowStepException.getSafeException(ex);
                    String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed step {}", (Object)pipelineToBeCreated).getFormattedMessage() : e.getMessage();
                    logger.error(errorMessage, (Throwable)e);
                    createPipelineFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                }
            };
            this.executePutPipelineRequest(pipelineId, (BytesReference)configurationsBytes, this.clusterAdminClient, putPipelineActionListener);
        }
        catch (FlowFrameworkException e) {
            createPipelineFuture.onFailure((Exception)((Object)e));
        }
        return createPipelineFuture;
    }
}

