/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.CreateTableAsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableConstraintStep;
import org.jooq.CreateTableFinalStep;
import org.jooq.CreateTableOnCommitStep;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.ConstraintImpl;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class CreateTableImpl<R extends Record>
extends AbstractQuery
implements CreateTableAsStep<R>,
CreateTableColumnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private final Table<?> table;
    private Select<?> select;
    private final List<Field<?>> columnFields;
    private final List<DataType<?>> columnTypes;
    private final List<Constraint> constraints;
    private final boolean temporary;
    private final boolean ifNotExists;
    private OnCommit onCommit;

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.columnFields = new ArrayList();
        this.columnTypes = new ArrayList();
        this.constraints = new ArrayList<Constraint>();
    }

    @Override
    public final CreateTableOnCommitStep as(Select<? extends R> s) {
        this.select = s;
        return this;
    }

    @Override
    public final CreateTableColumnStep column(Field<?> field) {
        return this.column(field, field.getDataType());
    }

    @Override
    public final CreateTableColumnStep columns(Field<?> ... fields) {
        return this.columns(Arrays.asList(fields));
    }

    @Override
    public final CreateTableColumnStep columns(Collection<? extends Field<?>> fields) {
        for (Field<?> field : fields) {
            this.column(field);
        }
        return this;
    }

    @Override
    public final <T> CreateTableColumnStep column(Field<T> field, DataType<T> type) {
        this.columnFields.add(field);
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableColumnStep column(Name field, DataType<?> type) {
        this.columnFields.add(DSL.field(field, type));
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableColumnStep column(String field, DataType<?> type) {
        return this.column(DSL.name(field), type);
    }

    @Override
    public final CreateTableConstraintStep constraint(Constraint c) {
        return this.constraints(Arrays.asList(c));
    }

    @Override
    public final CreateTableConstraintStep constraints(Constraint ... c) {
        return this.constraints(Arrays.asList(c));
    }

    @Override
    public final CreateTableConstraintStep constraints(Collection<? extends Constraint> c) {
        this.constraints.addAll(c);
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitDeleteRows() {
        this.onCommit = OnCommit.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitPreserveRows() {
        this.onCommit = OnCommit.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableFinalStep onCommitDrop() {
        this.onCommit = OnCommit.DROP;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_TABLE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_TABLE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            ctx.start(Clause.CREATE_TABLE);
            this.toSQLCreateTableName(ctx);
            ctx.sql('(').start(Clause.CREATE_TABLE_COLUMNS).formatIndentStart().formatNewLine();
            Field<?> identity = null;
            boolean qualify = ctx.qualify();
            ctx.qualify(false);
            for (int i = 0; i < this.columnFields.size(); ++i) {
                DataType<?> type = this.columnTypes.get(i);
                if (identity == null && type.identity()) {
                    identity = this.columnFields.get(i);
                }
                ctx.visit(this.columnFields.get(i)).sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, type);
                if (i >= this.columnFields.size() - 1) continue;
                ctx.sql(',').formatSeparator();
            }
            ctx.qualify(qualify);
            ctx.end(Clause.CREATE_TABLE_COLUMNS).start(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.constraints.isEmpty()) {
                for (Constraint constraint : this.constraints) {
                    if (ctx.family() == SQLDialect.SQLITE && this.matchingPrimaryKey(constraint, identity)) continue;
                    ctx.sql(',').formatSeparator().visit(constraint);
                }
            }
            ctx.end(Clause.CREATE_TABLE_CONSTRAINTS).formatIndentEnd().formatNewLine().sql(')');
            this.toSQLOnCommit(ctx);
            ctx.end(Clause.CREATE_TABLE);
        }
    }

    private final boolean matchingPrimaryKey(Constraint constraint, Field<?> identity) {
        if (constraint instanceof ConstraintImpl) {
            return ((ConstraintImpl)constraint).matchingPrimaryKey(identity);
        }
        return false;
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        this.toSQLCreateTableName(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().visit(Keywords.K_AS);
        if (Arrays.asList(SQLDialect.HSQLDB).contains((Object)ctx.family())) {
            ctx.sql(" (").formatIndentStart().formatNewLine();
        } else {
            ctx.formatSeparator();
        }
        ctx.start(Clause.CREATE_TABLE_AS).visit(this.select).end(Clause.CREATE_TABLE_AS);
        if (Arrays.asList(SQLDialect.HSQLDB).contains((Object)ctx.family())) {
            ctx.formatIndentEnd().formatNewLine().sql(')');
            if (ctx.family() == SQLDialect.HSQLDB) {
                ctx.sql(' ').visit(Keywords.K_WITH_DATA);
            }
        }
        ctx.end(Clause.CREATE_TABLE);
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).visit(Keywords.K_CREATE).sql(' ');
        if (this.temporary) {
            if (Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES).contains((Object)ctx.family())) {
                ctx.visit(Keywords.K_TEMPORARY).sql(' ');
            } else {
                ctx.visit(Keywords.K_GLOBAL_TEMPORARY).sql(' ');
            }
        }
        ctx.visit(Keywords.K_TABLE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DELETE_ROWS);
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_PRESERVE_ROWS);
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DROP);
                }
            }
        }
    }

    private final void acceptSelectInto(Context<?> ctx) {
        ctx.data((Object)Tools.DataKey.DATA_SELECT_INTO_TABLE, this.table);
        ctx.visit(this.select);
        ctx.data().remove((Object)Tools.DataKey.DATA_SELECT_INTO_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private static enum OnCommit {
        DELETE_ROWS,
        PRESERVE_ROWS,
        DROP;

    }
}

