/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public final class KeyUri {
    private static final int MAX_PORT_NO = 65535;
    private final String uri;
    private final byte[] address;
    private final int port;
    private final int hash;

    public KeyUri(String requestUri, byte[] address, int port) {
        if (requestUri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be an unsigned 16 bit int");
        }
        this.uri = requestUri;
        this.address = address;
        this.port = port;
        this.hash = (port * 31 + requestUri.hashCode()) * 31 + Arrays.hashCode(address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyUri other = (KeyUri)obj;
        if (!Arrays.equals(this.address, other.address)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("KeyUri[");
        b.append(this.uri);
        b.append(", ").append(Utils.toHexString(this.address)).append(":").append(this.port).append("]");
        return b.toString();
    }

    private static String getUri(Request request) {
        if (request == null) {
            throw new NullPointerException("request must not be null");
        }
        return request.getScheme() + ":" + request.getOptions().getUriString();
    }

    public static KeyUri fromInboundResponse(Request request, Response response) {
        if (response == null) {
            throw new NullPointerException("response must not be null");
        }
        InetSocketAddress address = response.getSourceContext().getPeerAddress();
        return new KeyUri(KeyUri.getUri(request), address.getAddress().getAddress(), address.getPort());
    }

    public static KeyUri fromOutboundResponse(Request request, Response response) {
        if (response == null) {
            throw new NullPointerException("response must not be null");
        }
        InetSocketAddress address = response.getDestinationContext().getPeerAddress();
        return new KeyUri(KeyUri.getUri(request), address.getAddress().getAddress(), address.getPort());
    }

    public static KeyUri fromInboundRequest(Request request) {
        String uri = KeyUri.getUri(request);
        InetSocketAddress address = request.getSourceContext().getPeerAddress();
        return new KeyUri(uri, address.getAddress().getAddress(), address.getPort());
    }

    public static KeyUri fromOutboundRequest(Request request) {
        String uri = KeyUri.getUri(request);
        InetSocketAddress address = request.getDestinationContext().getPeerAddress();
        return new KeyUri(uri, address.getAddress().getAddress(), address.getPort());
    }
}

