/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.validator.Messages;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.Validator;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private Validation[] validations;
    private boolean validatingAll;
    private boolean concatenatingErrors;
    private String concatenationSeparator;

    public void allocate(int nrValidations) {
        this.validations = new Validation[nrValidations];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        int nrCalcs = XMLHandler.countNodes((Node)stepnode, (String)"validator_field");
        this.allocate(nrCalcs);
        this.validatingAll = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"validate_all"));
        this.concatenatingErrors = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"concat_errors"));
        this.concatenationSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"concat_separator");
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"validator_field", (int)i);
            this.validations[i] = new Validation(calcnode);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(XMLHandler.addTagValue((String)"validate_all", (boolean)this.validatingAll));
        retval.append(XMLHandler.addTagValue((String)"concat_errors", (boolean)this.concatenatingErrors));
        retval.append(XMLHandler.addTagValue((String)"concat_separator", (String)this.concatenationSeparator));
        if (this.validations != null) {
            for (int i = 0; i < this.validations.length; ++i) {
                retval.append("       ").append(this.validations[i].getXML()).append(Const.CR);
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ValidatorMeta m = (ValidatorMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public Object clone() {
        ValidatorMeta retval = (ValidatorMeta)super.clone();
        if (this.validations != null) {
            retval.allocate(this.validations.length);
            for (int i = 0; i < this.validations.length; ++i) {
                retval.validations[i] = this.validations[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.validations = new Validation[0];
        this.concatenationSeparator = "|";
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        int nrValidationFields = rep.countNrStepAttributes(id_step, "validator_field_name");
        this.allocate(nrValidationFields);
        this.validatingAll = rep.getStepAttributeBoolean(id_step, "validate_all");
        this.concatenatingErrors = rep.getStepAttributeBoolean(id_step, "concat_errors");
        this.concatenationSeparator = rep.getStepAttributeString(id_step, "concat_separator");
        for (int i = 0; i < nrValidationFields; ++i) {
            this.validations[i] = new Validation(rep, id_step, i);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "validate_all", this.validatingAll);
        rep.saveStepAttribute(id_transformation, id_step, "concat_errors", this.concatenatingErrors);
        rep.saveStepAttribute(id_transformation, id_step, "concat_separator", this.concatenationSeparator);
        for (int i = 0; i < this.validations.length; ++i) {
            this.validations[i].saveRep(rep, id_transformation, id_step, i);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("ValidatorMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("ValidatorMeta.CheckResult.FieldsReceived", "" + prev.size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("ValidatorMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ValidatorMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Validator(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ValidatorData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public Validation[] getValidations() {
        return this.validations;
    }

    public void setValidations(Validation[] validations) {
        this.validations = validations;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (Validation validation : this.validations) {
            validation.setSourcingStep(StepMeta.findStep(steps, validation.getSourcingStepName()));
        }
    }

    @Override
    public String[] getInfoSteps() {
        ArrayList<String> infoSteps = new ArrayList<String>();
        for (Validation validation : this.validations) {
            String stepname;
            if (validation.getSourcingStep() == null || infoSteps.contains(stepname = validation.getSourcingStep().getName())) continue;
            infoSteps.add(stepname);
        }
        if (infoSteps.isEmpty()) {
            return null;
        }
        return infoSteps.toArray(new String[infoSteps.size()]);
    }

    public boolean isValidatingAll() {
        return this.validatingAll;
    }

    public void setValidatingAll(boolean validatingAll) {
        this.validatingAll = validatingAll;
    }

    public boolean isConcatenatingErrors() {
        return this.concatenatingErrors;
    }

    public void setConcatenatingErrors(boolean concatenatingErrors) {
        this.concatenatingErrors = concatenatingErrors;
    }

    public String getConcatenationSeparator() {
        return this.concatenationSeparator;
    }

    public void setConcatenationSeparator(String concatenationSeparator) {
        this.concatenationSeparator = concatenationSeparator;
    }
}

