/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.AbstractKeyword;
import com.networknt.schema.keyword.AbstractKeywordValidator;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;

public class AnnotationKeyword
extends AbstractKeyword {
    public AnnotationKeyword(String keyword) {
        super(keyword);
    }

    @Override
    public KeywordValidator newValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        return new Validator(schemaLocation, schemaNode, parentSchema, schemaContext, this);
    }

    private static final class Validator
    extends AbstractKeywordValidator {
        public Validator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext, Keyword keyword) {
            super(keyword, schemaNode, schemaLocation);
        }

        @Override
        public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
            Object value;
            if (this.collectAnnotations(executionContext) && (value = this.getAnnotationValue(this.getSchemaNode())) != null) {
                this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(value));
            }
        }

        private Object getAnnotationValue(JsonNode schemaNode) {
            if (schemaNode.isTextual()) {
                return schemaNode.textValue();
            }
            if (schemaNode.isNumber()) {
                return schemaNode.numberValue();
            }
            if (schemaNode.isObject()) {
                return schemaNode;
            }
            return null;
        }
    }
}

