/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.ConcurrentModificationException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.MapFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractMap;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.OpenHashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;

public class OpenHashMap<Key, Value>
extends AbstractMap<Key, Value>
implements StrictOptimizedIterableOps<Tuple2<Key, Value>, Iterable, OpenHashMap<Key, Value>>,
DefaultSerializable {
    public int scala$collection$mutable$OpenHashMap$$mask;
    public OpenEntry<Key, Value>[] scala$collection$mutable$OpenHashMap$$table;
    private int _size;
    private int deleted;
    public int scala$collection$mutable$OpenHashMap$$modCount;

    public static <K, V> OpenHashMap<K, V> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return OpenHashMap$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <K, V> Builder<Tuple2<K, V>, OpenHashMap<K, V>> newBuilder() {
        return OpenHashMap$.MODULE$.newBuilder();
    }

    public static int nextPositivePowerOfTwo(int n) {
        return OpenHashMap$.MODULE$.nextPositivePowerOfTwo(n);
    }

    public OpenHashMap(int initialSize) {
        StrictOptimizedIterableOps.$init$(this);
        DefaultSerializable.$init$(this);
        int actualInitialSize = OpenHashMap$.MODULE$.nextPositivePowerOfTwo(initialSize);
        this.scala$collection$mutable$OpenHashMap$$mask = actualInitialSize - 1;
        this.scala$collection$mutable$OpenHashMap$$table = new OpenEntry[actualInitialSize];
        this._size = 0;
        this.deleted = 0;
        this.scala$collection$mutable$OpenHashMap$$modCount = 0;
    }

    @Override
    public Tuple2<OpenHashMap<Key, Value>, OpenHashMap<Key, Value>> partition(Function1<Tuple2<Key, Value>, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<OpenHashMap<Key, Value>, OpenHashMap<Key, Value>> span(Function1<Tuple2<Key, Value>, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<Key, Value>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Tuple2<Key, Value>, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Tuple2<Key, Value>, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Tuple2<Key, Value>, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Tuple2<Key, Value>, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Tuple2<Key, Value>, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Tuple2<Key, Value>, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Tuple2<Key, Value>, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    public OpenHashMap() {
        this(8);
    }

    @Override
    public MapFactory<OpenHashMap> mapFactory() {
        return OpenHashMap$.MODULE$;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    private void size_$eq(int s) {
        this._size = s;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    public int hashOf(Key key) {
        int h = Statics.anyHash(key);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private void growTable() {
        int oldSize = this.scala$collection$mutable$OpenHashMap$$mask + 1;
        int newSize = 4 * oldSize;
        OpenEntry<Key, Value>[] oldTable = this.scala$collection$mutable$OpenHashMap$$table;
        this.scala$collection$mutable$OpenHashMap$$table = new OpenEntry[newSize];
        this.scala$collection$mutable$OpenHashMap$$mask = newSize - 1;
        Object object = Predef$.MODULE$.refArrayOps(oldTable);
        ArrayOps$.MODULE$.foreach$extension(object, entry -> {
            if (entry != null) {
                Option option = entry.value();
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    this.scala$collection$mutable$OpenHashMap$$table[this.findIndex(entry.key(), (int)entry.hash())] = entry;
                    return;
                }
            }
        });
        this.deleted = 0;
    }

    private int findIndex(Key key, int hash) {
        int index = hash & this.scala$collection$mutable$OpenHashMap$$mask;
        int j = 0;
        int firstDeletedIndex = -1;
        OpenEntry<Key, Value> entry = this.scala$collection$mutable$OpenHashMap$$table[index];
        while (entry != null) {
            if (entry.hash() == hash && BoxesRunTime.equals(entry.key(), key)) {
                Option<Value> option = entry.value();
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    return index;
                }
            }
            if (firstDeletedIndex == -1) {
                Option<Value> option = entry.value();
                None$ none$ = None$.MODULE$;
                if (!(option != null ? !option.equals(none$) : none$ != null)) {
                    firstDeletedIndex = index;
                }
            }
            index = index + ++j & this.scala$collection$mutable$OpenHashMap$$mask;
            entry = this.scala$collection$mutable$OpenHashMap$$table[index];
        }
        if (firstDeletedIndex == -1) {
            return index;
        }
        return firstDeletedIndex;
    }

    @Override
    public void update(Key key, Value value) {
        this.put(key, value);
    }

    public OpenHashMap<Key, Value> addOne(Tuple2<Key, Value> kv) {
        this.put(kv._1(), kv._2());
        return this;
    }

    public OpenHashMap<Key, Value> subtractOne(Key key) {
        this.remove(key);
        return this;
    }

    @Override
    public Option<Value> put(Key key, Value value) {
        return this.put(key, this.hashOf(key), value);
    }

    private Option<Value> put(Key key, int hash, Value value) {
        int index;
        OpenEntry<Key, Value> entry;
        if (2 * (this.size() + this.deleted) > this.scala$collection$mutable$OpenHashMap$$mask) {
            this.growTable();
        }
        if ((entry = this.scala$collection$mutable$OpenHashMap$$table[index = this.findIndex(key, hash)]) == null) {
            this.scala$collection$mutable$OpenHashMap$$table[index] = new OpenEntry<Key, Value>(key, hash, Some$.MODULE$.apply(value));
            ++this.scala$collection$mutable$OpenHashMap$$modCount;
            this.size_$eq(this.size() + 1);
            return None$.MODULE$;
        }
        Option<Value> res = entry.value();
        Option<Value> option = entry.value();
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            entry.key_$eq(key);
            entry.hash_$eq(hash);
            this.size_$eq(this.size() + 1);
            --this.deleted;
            ++this.scala$collection$mutable$OpenHashMap$$modCount;
        }
        entry.value_$eq(Some$.MODULE$.apply(value));
        return res;
    }

    private void deleteSlot(OpenEntry<Key, Value> entry) {
        entry.key_$eq(null);
        entry.hash_$eq(0);
        entry.value_$eq(None$.MODULE$);
        this.size_$eq(this.size() - 1);
        ++this.deleted;
    }

    @Override
    public Option<Value> remove(Key key) {
        OpenEntry<Key, Value> entry = this.scala$collection$mutable$OpenHashMap$$table[this.findIndex(key, this.hashOf(key))];
        if (entry != null) {
            Option<Value> option = entry.value();
            None$ none$ = None$.MODULE$;
            if (option == null ? none$ != null : !option.equals(none$)) {
                Option<Value> res = entry.value();
                this.deleteSlot(entry);
                return res;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Value> get(Key key) {
        int hash = this.hashOf(key);
        int index = hash & this.scala$collection$mutable$OpenHashMap$$mask;
        OpenEntry<Key, Value> entry = this.scala$collection$mutable$OpenHashMap$$table[index];
        int j = 0;
        while (entry != null) {
            if (entry.hash() == hash && BoxesRunTime.equals(entry.key(), key)) {
                return entry.value();
            }
            index = index + ++j & this.scala$collection$mutable$OpenHashMap$$mask;
            entry = this.scala$collection$mutable$OpenHashMap$$table[index];
        }
        return None$.MODULE$;
    }

    @Override
    public Iterator<Tuple2<Key, Value>> iterator() {
        return new OpenHashMapIterator<Tuple2<Key, Value>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Tuple2 nextResult(OpenEntry node) {
                return Tuple2$.MODULE$.apply(node.key(), node.value().get());
            }
        };
    }

    @Override
    public Iterator<Key> keysIterator() {
        return new OpenHashMapIterator<Key>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object nextResult(OpenEntry node) {
                return node.key();
            }
        };
    }

    @Override
    public Iterator<Value> valuesIterator() {
        return new OpenHashMapIterator<Value>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object nextResult(OpenEntry node) {
                return node.value().get();
            }
        };
    }

    @Override
    public OpenHashMap<Key, Value> clone() {
        OpenHashMap it = new OpenHashMap();
        this.foreachUndeletedEntry(entry -> it.put(entry.key(), entry.hash(), entry.value().get()));
        return it;
    }

    @Override
    public <U> void foreach(Function1<Tuple2<Key, Value>, U> f) {
        int startModCount = this.scala$collection$mutable$OpenHashMap$$modCount;
        this.foreachUndeletedEntry(entry -> {
            if (this.scala$collection$mutable$OpenHashMap$$modCount != startModCount) {
                throw new ConcurrentModificationException();
            }
            f.apply(Tuple2$.MODULE$.apply(entry.key(), entry.value().get()));
        });
    }

    @Override
    public <U> void foreachEntry(Function2<Key, Value, U> f) {
        int startModCount = this.scala$collection$mutable$OpenHashMap$$modCount;
        this.foreachUndeletedEntry(entry -> {
            if (this.scala$collection$mutable$OpenHashMap$$modCount != startModCount) {
                throw new ConcurrentModificationException();
            }
            f.apply(entry.key(), entry.value().get());
        });
    }

    private void foreachUndeletedEntry(Function1<OpenEntry<Key, Value>, BoxedUnit> f) {
        Object object = Predef$.MODULE$.refArrayOps(this.scala$collection$mutable$OpenHashMap$$table);
        ArrayOps$.MODULE$.foreach$extension(object, entry -> {
            if (entry != null) {
                Option option = entry.value();
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    f.apply((OpenEntry)entry);
                    return;
                }
            }
        });
    }

    public OpenHashMap<Key, Value> mapValuesInPlace(Function2<Key, Value, Value> f) {
        this.foreachUndeletedEntry(entry -> entry.value_$eq(Some$.MODULE$.apply(f.apply(entry.key(), entry.value().get()))));
        return this;
    }

    public OpenHashMap<Key, Value> filterInPlace(Function2<Key, Value, Object> f) {
        this.foreachUndeletedEntry(entry -> {
            if (!BoxesRunTime.unboxToBoolean(f.apply(entry.key(), entry.value().get()))) {
                this.deleteSlot((OpenEntry<Key, Value>)entry);
                return;
            }
        });
        return this;
    }

    @Override
    public String stringPrefix() {
        return "OpenHashMap";
    }

    public static final class OpenEntry<Key, Value> {
        private Key key;
        private int hash;
        private Option<Value> value;

        public OpenEntry(Key key, int hash, Option<Value> value) {
            this.key = key;
            this.hash = hash;
            this.value = value;
        }

        public Key key() {
            return this.key;
        }

        public void key_$eq(Key x$1) {
            this.key = x$1;
        }

        public int hash() {
            return this.hash;
        }

        public void hash_$eq(int x$1) {
            this.hash = x$1;
        }

        public Option<Value> value() {
            return this.value;
        }

        public void value_$eq(Option<Value> x$1) {
            this.value = x$1;
        }
    }

    public abstract class OpenHashMapIterator<A>
    extends AbstractIterator<A> {
        private int index;
        private final int initialModCount;

        public OpenHashMapIterator() {
            if (OpenHashMap.this == null) {
                throw new NullPointerException();
            }
            this.index = 0;
            this.initialModCount = OpenHashMap.this.scala$collection$mutable$OpenHashMap$$modCount;
        }

        private void advance() {
            if (this.initialModCount != OpenHashMap.this.scala$collection$mutable$OpenHashMap$$modCount) {
                throw new ConcurrentModificationException();
            }
            while (this.index <= OpenHashMap.this.scala$collection$mutable$OpenHashMap$$mask) {
                if (OpenHashMap.this.scala$collection$mutable$OpenHashMap$$table[this.index] != null) {
                    Option option = OpenHashMap.this.scala$collection$mutable$OpenHashMap$$table[this.index].value();
                    None$ none$ = None$.MODULE$;
                    if (option != null ? !option.equals(none$) : none$ != null) break;
                }
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return this.index <= OpenHashMap.this.scala$collection$mutable$OpenHashMap$$mask;
        }

        @Override
        public A next() {
            this.advance();
            OpenEntry result = OpenHashMap.this.scala$collection$mutable$OpenHashMap$$table[this.index];
            ++this.index;
            return this.nextResult(result);
        }

        public abstract A nextResult(OpenEntry<Key, Value> var1);

        public final /* synthetic */ OpenHashMap scala$collection$mutable$OpenHashMap$OpenHashMapIterator$$$outer() {
            return OpenHashMap.this;
        }
    }
}

